/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.quartz.release.scheduler;

import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Marker;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00114AAC\u0006\u00011!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006C\u00034\u0001\u0011\u0005A\u0007C\u00039\u0001\u0011\u0005\u0011\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0003O\u0001\u0011\u0005q\nC\u0003Y\u0001\u0011\u0005\u0011\fC\u0003\\\u0001\u0011\u0005A\fC\u0003_\u0001\u0011%q\fC\u0003b\u0001\u0011%!MA\fSK2,\u0017m]3TG\",G-\u001e7feN+'O^5dK*\u0011A\"D\u0001\ng\u000eDW\rZ;mKJT!AD\b\u0002\u000fI,G.Z1tK*\u0011\u0001#E\u0001\u0007cV\f'\u000f\u001e>\u000b\u0005I\u0019\u0012!\u0003=me\u0016dW-Y:f\u0015\t!R#A\u0005yK\nL\u0017\r\\1cg*\ta#A\u0002d_6\u001c\u0001aE\u0002\u00013}\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0007C\u0001\u0011&\u001b\u0005\t#B\u0001\u0012$\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005!\u0013\u0001C4sSjTH.\u001a3\n\u0005\u0019\n#a\u0002'pO\u001eLgnZ\u0001\u0015g\u000eDW\rZ;mKJ4\u0015m\u0019;pef\u0014U-\u00198\u0011\u0005%\nT\"\u0001\u0016\u000b\u0005AY#B\u0001\u0017.\u0003)\u00198\r[3ek2Lgn\u001a\u0006\u0003]=\nqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002a\u0005\u0019qN]4\n\u0005IR#\u0001F*dQ\u0016$W\u000f\\3s\r\u0006\u001cGo\u001c:z\u0005\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0003k]\u0002\"A\u000e\u0001\u000e\u0003-AQa\n\u0002A\u0002!\nAbZ3u'\u000eDW\rZ;mKJ,\u0012A\u000f\t\u0003wuj\u0011\u0001\u0010\u0006\u0003!=J!A\u0010\u001f\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018\u0001C:dQ\u0016$W\u000f\\3\u0015\u0007\u0005#\u0015\n\u0005\u0002\u001b\u0005&\u00111i\u0007\u0002\u0005+:LG\u000fC\u0003F\t\u0001\u0007a)A\u0002k_\n\u0004\"aO$\n\u0005!c$!\u0003&pE\u0012+G/Y5m\u0011\u0015QE\u00011\u0001L\u0003\u001d!(/[4hKJ\u0004\"a\u000f'\n\u00055c$a\u0002+sS\u001e<WM]\u0001\u000bk:\u001c8\r[3ek2,GC\u0001)T!\tQ\u0012+\u0003\u0002S7\t9!i\\8mK\u0006t\u0007\"\u0002+\u0006\u0001\u0004)\u0016A\u00026pE.+\u0017\u0010\u0005\u0002<-&\u0011q\u000b\u0010\u0002\u0007\u0015>\u00147*Z=\u0002\rI,7/^7f)\t\t%\fC\u0003U\r\u0001\u0007Q+A\u0003qCV\u001cX\r\u0006\u0002B;\")Ak\u0002a\u0001+\u0006Q\u0011n\u001d&pEZ\u000bG.\u001b3\u0015\u0005A\u0003\u0007\"B#\t\u0001\u00041\u0015AD5t)JLwmZ3s-\u0006d\u0017\u000e\u001a\u000b\u0003!\u000eDQAS\u0005A\u0002-\u0003")
public class ReleaseSchedulerService
implements Logging {
    private final SchedulerFactoryBean schedulerFactoryBean;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleaseSchedulerService releaseSchedulerService = this;
        synchronized (releaseSchedulerService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Scheduler getScheduler() {
        return this.schedulerFactoryBean.getScheduler();
    }

    public void schedule(JobDetail job, Trigger trigger) {
        if (this.isJobValid(job) && this.isTriggerValid(trigger)) {
            TriggerKey triggerKey = trigger.getKey();
            boolean triggerExists = this.getScheduler().checkExists(triggerKey);
            if (triggerExists) {
                this.getScheduler().addJob(job, true);
                try {
                    this.getScheduler().rescheduleJob(triggerKey, trigger);
                }
                catch (ObjectAlreadyExistsException ex) {
                    this.logger().debug((Function0 & Serializable)() -> "Unexpectedly encountered existing trigger on rescheduling, assumably due to cluster race condition: " + ex.getMessage() + " - can safely be ignored");
                }
                return;
            }
            try {
                this.getScheduler().scheduleJob(job, trigger);
            }
            catch (ObjectAlreadyExistsException ex) {
                this.logger().debug((Function0 & Serializable)() -> "Unexpectedly encountered existing trigger on job scheduling, assumably due to cluster race condition: " + ex.getMessage() + " - can safely be ignored");
                this.getScheduler().rescheduleJob(triggerKey, trigger);
            }
            return;
        }
    }

    public boolean unschedule(JobKey jobKey) {
        boolean jobExists = this.getScheduler().checkExists(jobKey);
        if (jobExists) {
            return this.getScheduler().deleteJob(jobKey);
        }
        return false;
    }

    public void resume(JobKey jobKey) {
        this.getScheduler().resumeJob(jobKey);
    }

    public void pause(JobKey jobKey) {
        this.getScheduler().pauseJob(jobKey);
    }

    private boolean isJobValid(JobDetail job) {
        return job != null && job.getKey() != null;
    }

    private boolean isTriggerValid(Trigger trigger) {
        return trigger != null && trigger.getKey() != null;
    }

    public ReleaseSchedulerService(SchedulerFactoryBean schedulerFactoryBean) {
        this.schedulerFactoryBean = schedulerFactoryBean;
        Logging.$init$((Logging)this);
    }
}

