/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.quartz.events.SchedulerStartedEvent;
import com.xebialabs.xlrelease.quartz.release.scheduler.ReleaseSchedulerService;
import com.xebialabs.xlrelease.service.StuckGateDetectorSchedulerJob;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Marker;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0005\u001d4A!\u0003\u0006\u0001'!A!\u0005\u0001B\u0001B\u0003%1\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0011\u0015!\u0004\u0001\"\u00016\u0011\u001dQ\u0004A1A\u0005\u0002mBa\u0001\u0012\u0001!\u0002\u0013a\u0004bB#\u0001\u0005\u0004%\ta\u000f\u0005\u0007\r\u0002\u0001\u000b\u0011\u0002\u001f\t\u000b\u001d\u0003A\u0011\u0001%\u00035M#XoY6HCR,G)\u001a;fGR|'oU2iK\u0012,H.\u001a:\u000b\u0005-a\u0011aB:feZL7-\u001a\u0006\u0003\u001b9\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005=\u0001\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005\t\u0012aA2p[\u000e\u00011c\u0001\u0001\u00155A\u0011Q\u0003G\u0007\u0002-)\tq#A\u0003tG\u0006d\u0017-\u0003\u0002\u001a-\t1\u0011I\\=SK\u001a\u0004\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u000bMdg\r\u000e6\u000b\u0003}\t\u0001b\u001a:jujdW\rZ\u0005\u0003Cq\u0011q\u0001T8hO&tw-A\u0005yYJ\u001cuN\u001c4jOB\u0011AeJ\u0007\u0002K)\u0011a\u0005D\u0001\u0007G>tg-[4\n\u0005!*#!\u0003-me\u000e{gNZ5h\u0003]\u0011X\r\\3bg\u0016\u001c6\r[3ek2,'oU3sm&\u001cW\r\u0005\u0002,e5\tAF\u0003\u0002.]\u0005I1o\u00195fIVdWM\u001d\u0006\u0003_A\nqA]3mK\u0006\u001cXM\u0003\u00022\u0019\u00051\u0011/^1sijL!a\r\u0017\u0003/I+G.Z1tKN\u001b\u0007.\u001a3vY\u0016\u00148+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\bF\u00027qe\u0002\"a\u000e\u0001\u000e\u0003)AQAI\u0002A\u0002\rBQ!K\u0002A\u0002)\n\u0001BS(C?:\u000bU*R\u000b\u0002yA\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\u0005Y\u0006twMC\u0001B\u0003\u0011Q\u0017M^1\n\u0005\rs$AB*ue&tw-A\u0005K\u001f\n{f*Q'FA\u0005QqIU(V!~s\u0015)T#\u0002\u0017\u001d\u0013v*\u0016)`\u001d\u0006kU\tI\u0001\n_:\u001cF/\u0019:ukB$\"!\u0013'\u0011\u0005UQ\u0015BA&\u0017\u0005\u0011)f.\u001b;\t\u000b5C\u0001\u0019\u0001(\u0002\u000b\u00154XM\u001c;\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E\u0003\u0014AB3wK:$8/\u0003\u0002T!\n)2k\u00195fIVdWM]*uCJ$X\rZ#wK:$\bF\u0001\u0005V!\t1f,D\u0001X\u0015\ti\u0005L\u0003\u0002Z5\u000691m\u001c8uKb$(BA.]\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A/\u0002\u0007=\u0014x-\u0003\u0002`/\niQI^3oi2K7\u000f^3oKJD#\u0001A1\u0011\u0005\t,W\"A2\u000b\u0005\u0011T\u0016AC:uKJ,w\u000e^=qK&\u0011am\u0019\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class StuckGateDetectorScheduler
implements Logging {
    private final XlrConfig xlrConfig;
    private final ReleaseSchedulerService releaseSchedulerService;
    private final String JOB_NAME;
    private final String GROUP_NAME;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        StuckGateDetectorScheduler stuckGateDetectorScheduler = this;
        synchronized (stuckGateDetectorScheduler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public String JOB_NAME() {
        return this.JOB_NAME;
    }

    public String GROUP_NAME() {
        return this.GROUP_NAME;
    }

    @EventListener
    public void onStartup(SchedulerStartedEvent event) {
        if (event != null && event.schedulerName() != null) {
            String string = event.schedulerName();
            String string2 = "xlrQuartzScheduler";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                try {
                    JobDetail job = JobBuilder.newJob(StuckGateDetectorSchedulerJob.class).withDescription(this.JOB_NAME()).withIdentity(this.JOB_NAME(), this.GROUP_NAME()).storeDurably(true).build();
                    Trigger trigger = TriggerBuilder.newTrigger().withIdentity(this.JOB_NAME(), this.GROUP_NAME()).withDescription(this.JOB_NAME()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(this.xlrConfig.features().gateActor().unstuckInterval().toMillis()).repeatForever()).build();
                    if (this.xlrConfig.features().gateActor().enabled()) {
                        this.logger().debug((Function0 & Serializable)() -> "Scheduling stuck gate detector");
                        this.releaseSchedulerService.schedule(job, trigger);
                    } else {
                        this.releaseSchedulerService.unschedule(job.getKey());
                    }
                }
                catch (Exception e) {
                    this.logger().error((Function0 & Serializable)() -> "Error while starting " + StuckGateDetectorScheduler.class.getName() + " service", (Function0 & Serializable)() -> e);
                }
                return;
            }
        }
    }

    public StuckGateDetectorScheduler(XlrConfig xlrConfig, ReleaseSchedulerService releaseSchedulerService) {
        this.xlrConfig = xlrConfig;
        this.releaseSchedulerService = releaseSchedulerService;
        Logging.$init$((Logging)this);
        this.JOB_NAME = "STUCK_GATE_DETECTOR_JOB";
        this.GROUP_NAME = "STUCK_GATE_DETECTOR";
    }
}

