/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.DeliveryApi;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.CompleteTransition;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryOrderMode;
import com.xebialabs.xlrelease.api.v1.views.DeliveryFlowReleaseInfo;
import com.xebialabs.xlrelease.api.v1.views.DeliveryTimeline;
import com.xebialabs.xlrelease.delivery.actors.DeliveryActorService;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissionChecker;
import com.xebialabs.xlrelease.delivery.service.DeliveryExecutionService;
import com.xebialabs.xlrelease.delivery.service.DeliveryService;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.Subscriber;
import com.xebialabs.xlrelease.domain.delivery.SubscriptionResult;
import com.xebialabs.xlrelease.domain.delivery.TrackedItem;
import com.xebialabs.xlrelease.domain.delivery.TrackedItemStatus;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.utils.DeliveryUtils;
import com.xebialabs.xlrelease.repository.Page;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class DeliveryApiImpl
implements DeliveryApi {
    private final DeliveryActorService deliveryActorService;
    private final DeliveryService deliveryService;
    private final DeliveryExecutionService deliveryExecutionService;
    private final DeliveryPermissionChecker permissions;

    @Autowired
    public DeliveryApiImpl(DeliveryActorService deliveryActorService, DeliveryService deliveryService, DeliveryExecutionService deliveryExecutionService, DeliveryPermissionChecker permissions) {
        this.deliveryActorService = deliveryActorService;
        this.deliveryService = deliveryService;
        this.deliveryExecutionService = deliveryExecutionService;
        this.permissions = permissions;
    }

    @Timed
    public Delivery getDelivery(String deliveryId) {
        this.permissions.checkViewDelivery(deliveryId);
        return this.deliveryService.getDelivery(deliveryId);
    }

    @Timed
    public Delivery updateDelivery(String deliveryId, Delivery delivery) {
        this.permissions.checkEditDelivery(deliveryId);
        this.permissions.checkEditDelivery(delivery);
        delivery.setId(deliveryId);
        Delivery existingDelivery = this.deliveryService.getDelivery(deliveryId);
        delivery.setStatus(existingDelivery.getStatus());
        return this.deliveryActorService.updateDelivery(delivery);
    }

    @Timed
    public Delivery updateDelivery(Delivery delivery) {
        return this.updateDelivery(delivery.getId(), delivery);
    }

    @Timed
    public void deleteDelivery(String deliveryId) {
        this.permissions.checkEditDelivery(deliveryId);
        this.deliveryActorService.deleteDelivery(deliveryId);
    }

    @Timed
    public List<Delivery> searchDeliveries(DeliveryFilters deliveryFilters, Long page, Long resultsPerPage, DeliveryOrderMode orderBy) {
        Checks.checkArgument((resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        if (null == deliveryFilters) {
            deliveryFilters = new DeliveryFilters();
        }
        return this.deliveryService.search((AbstractDeliveryFilters)deliveryFilters, Page.parse(Optional.ofNullable(page), Optional.ofNullable(resultsPerPage), Optional.empty()), orderBy);
    }

    @Timed
    public List<Delivery> searchDeliveries(DeliveryFilters deliveryFilters, @Nullable DeliveryOrderMode orderBy) {
        return this.searchDeliveries(deliveryFilters, 0L, 100L, orderBy);
    }

    @Timed
    public List<Delivery> searchDeliveries(DeliveryFilters deliveryFilters) {
        return this.searchDeliveries(deliveryFilters, null);
    }

    @Timed
    public DeliveryTimeline getDeliveryTimeline(String deliveryId) {
        this.permissions.checkViewDelivery(deliveryId);
        return this.deliveryService.getTimeline(deliveryId, DateTime.now());
    }

    @Timed
    public List<DeliveryFlowReleaseInfo> getReleases(String deliveryId) {
        this.permissions.checkViewDelivery(deliveryId);
        return this.deliveryService.getReleases(deliveryId);
    }

    @Timed
    public SubscriptionResult registerSubscriber(String deliveryId, Subscriber subscriber) {
        this.permissions.checkViewDelivery(deliveryId);
        return this.deliveryActorService.registerSubscriber(deliveryId, subscriber);
    }

    @Timed
    public TrackedItem createTrackedItem(String deliveryId, TrackedItem item) {
        this.permissions.checkEditTrackedItemOnDelivery(deliveryId);
        return this.deliveryActorService.createTrackedItem(deliveryId, item);
    }

    @Timed
    public List<TrackedItem> getTrackedItems(String deliveryId) {
        this.permissions.checkViewDelivery(deliveryId);
        return this.deliveryExecutionService.getTrackedItems(deliveryId);
    }

    @Timed
    public TrackedItem updateTrackedItem(String itemId, TrackedItem item) {
        item.setId(itemId);
        String deliveryId = DeliveryUtils.deliveryIdFrom((String)itemId);
        this.permissions.checkEditTrackedItemOnDelivery(deliveryId);
        return this.deliveryActorService.updateTrackedItem(deliveryId, item);
    }

    @Timed
    public TrackedItem updateTrackedItem(TrackedItem item) {
        return this.updateTrackedItem(item.getId(), item);
    }

    @Timed
    public void deleteTrackedItem(String itemId) {
        String deliveryId = DeliveryUtils.deliveryIdFrom((String)itemId);
        this.permissions.checkEditTrackedItemOnDelivery(deliveryId);
        this.deliveryActorService.deleteTrackedItem(deliveryId, itemId);
    }

    @Timed
    public void descopeTrackedItem(String itemId) {
        String deliveryId = DeliveryUtils.deliveryIdFrom((String)itemId);
        this.permissions.checkEditTrackedItemOnDelivery(deliveryId);
        this.deliveryActorService.descopeTrackedItem(deliveryId, itemId);
    }

    @Timed
    public void rescopeTrackedItem(String itemId) {
        String deliveryId = DeliveryUtils.deliveryIdFrom((String)itemId);
        this.permissions.checkEditTrackedItemOnDelivery(deliveryId);
        this.deliveryActorService.rescopeTrackedItem(deliveryId, itemId);
    }

    @Timed
    public void completeTrackedItem(String stageId, String itemId) {
        String deliveryId = DeliveryUtils.deliveryIdFrom((String)stageId);
        this.markTrackedItemsInStage(deliveryId, stageId, Collections.singletonList(itemId), TrackedItemStatus.READY, false, null);
    }

    @Timed
    public void skipTrackedItem(String stageId, String itemId) {
        String deliveryId = DeliveryUtils.deliveryIdFrom((String)stageId);
        this.permissions.checkEditTrackedItemOnDelivery(deliveryId);
        this.deliveryActorService.skipTrackedItem(deliveryId, stageId, itemId);
    }

    @Timed
    public void registerTrackedItems(String deliveryId, List<String> itemIdOrTitles, String fromReleaseId) {
        this.permissions.checkEditTrackedItemOnDelivery(deliveryId);
        this.deliveryActorService.registerTrackedItems(deliveryId, itemIdOrTitles, fromReleaseId);
    }

    @Timed
    public List<TrackedItem> markTrackedItemsInStage(String deliveryId, String stageIdOrTitle, List<String> itemIdOrTitles, TrackedItemStatus status, boolean precedingStages, String releaseId) {
        this.permissions.checkEditTrackedItemOnDelivery(deliveryId);
        return this.deliveryActorService.markTrackedItemsInStage(deliveryId, stageIdOrTitle, itemIdOrTitles, status, precedingStages, releaseId);
    }

    @Timed
    public void completeStage(String stageId) {
        String deliveryId = DeliveryUtils.deliveryIdFrom((String)stageId);
        this.permissions.checkEditDelivery(deliveryId);
        this.deliveryActorService.completeStage(deliveryId, stageId);
    }

    @Timed
    public void reopenStage(String stageId) {
        String deliveryId = DeliveryUtils.deliveryIdFrom((String)stageId);
        this.permissions.checkEditDelivery(deliveryId);
        this.deliveryActorService.reopenStage(deliveryId, stageId);
    }

    @Timed
    public Transition updateTransition(String transitionId, Transition transition) {
        transition.setId(transitionId);
        String deliveryId = DeliveryUtils.deliveryIdFrom((String)transitionId);
        this.permissions.checkEditDelivery(deliveryId);
        Checks.checkNotNull((Object)transition, (String)"Transition");
        transition.checkRestrictions();
        return this.deliveryActorService.updateTransition(deliveryId, transition);
    }

    @Timed
    public Transition updateTransition(Transition transition) {
        return this.updateTransition(transition.getId(), transition);
    }

    @Timed
    public void completeTransition(String transitionId, CompleteTransition completeTransition) {
        String deliveryId = DeliveryUtils.deliveryIdFrom((String)transitionId);
        this.permissions.checkEditDelivery(deliveryId);
        this.deliveryActorService.completeTransition(deliveryId, transitionId, completeTransition);
    }
}

