/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.xlrelease.builder.CustomScriptTaskBuilder;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.builder.TaskBuilder;
import com.xebialabs.xlrelease.delivery.DeliveryTestUtils;
import com.xebialabs.xlrelease.delivery.DeliveryTestUtils$FindOrCreateStrategy$;
import com.xebialabs.xlrelease.delivery.DeliveryTestUtils$TestCiIdService$;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.DeliveryStatus;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.StageStatus;
import com.xebialabs.xlrelease.domain.delivery.TrackedItemStatus;
import com.xebialabs.xlrelease.domain.delivery.Transition;
import com.xebialabs.xlrelease.domain.delivery.condition.ItemsCompletionCondition;
import com.xebialabs.xlrelease.domain.delivery.condition.TimeCondition;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.Ids;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import org.joda.time.DateTime;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class DeliveryTestUtils$ {
    public static final DeliveryTestUtils$ MODULE$ = new DeliveryTestUtils$();
    private static final DeliveryObjectFactory factory = new DeliveryObjectFactory(DeliveryTestUtils$TestCiIdService$.MODULE$);

    public DeliveryObjectFactory factory() {
        return factory;
    }

    public Delivery fromGraph(String drawing) {
        return new DeliveryTestUtils.DeliveryDrawing(drawing).toDelivery();
    }

    /*
     * WARNING - void declaration
     */
    public Delivery delivery(String title, String folderId) {
        void var3_3;
        Delivery delivery = this.emptyDelivery(title);
        delivery.setFolderId(folderId);
        this.stubStages(delivery);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Delivery emptyDelivery(String title) {
        void var2_2;
        Delivery delivery = (Delivery)this.factory().newCiWithId("Deliveries", ClassTag$.MODULE$.apply(Delivery.class));
        delivery.setTitle(title);
        delivery.setStartDate(new Date());
        delivery.setEndDate(new DateTime().plusDays(5).toDate());
        delivery.updateDuration();
        return var2_2;
    }

    public void stubStages(Delivery delivery) {
        package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Stage[]{new Stage("Feature in Dev"), new Stage("Feature in QA"), new Stage("Feature in Pre-Prod"), new Stage("Feature in Prod")})).foreach((Function1 & Serializable)stage -> {
            DeliveryTestUtils$.$anonfun$stubStages$1(delivery, stage);
            return BoxedUnit.UNIT;
        });
    }

    public void stubTransitions(Delivery delivery, Condition condition) {
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(delivery.getStages()).asScala().take(delivery.getStages().size() - 1)).foreach((Function1 & Serializable)stage -> {
            DeliveryTestUtils$.$anonfun$stubTransitions$1(condition, stage);
            return BoxedUnit.UNIT;
        });
    }

    public Condition stubTransitions$default$2() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void stubTransitionsWithTimeCondition(Delivery delivery) {
        void var3_3;
        Date tomorrow = Date.from(LocalDate.now().plusDays(1L).atStartOfDay(ZoneId.systemDefault()).toInstant());
        TimeCondition condition = new TimeCondition();
        condition.setFixedDate(tomorrow);
        this.stubTransitions(delivery, (Condition)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void stubTransitionsWithItemsCondition(Delivery delivery) {
        void var2_2;
        ItemsCompletionCondition condition = new ItemsCompletionCondition();
        condition.setIgnoreDescoped(true);
        condition.setStatuses(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])TrackedItemStatus.DONE_STATUSES), (Function1 & Serializable)x$3 -> x$3.value(), ClassTag$.MODULE$.apply(String.class))).toList()).asJava());
        this.stubTransitions(delivery, (Condition)var2_2);
    }

    public Delivery generatePattern(String title, String folderId, int duration, boolean shouldStubStages) {
        Delivery pattern;
        block0: {
            pattern = (Delivery)this.factory().newCiWithId("Deliveries", ClassTag$.MODULE$.apply(Delivery.class));
            pattern.setTitle(title);
            pattern.setStatus(DeliveryStatus.TEMPLATE);
            pattern.setPlannedDuration(Predef$.MODULE$.int2Integer(duration));
            pattern.setFolderId(folderId);
            if (!shouldStubStages) break block0;
            this.stubStages(pattern);
        }
        return pattern;
    }

    public int generatePattern$default$3() {
        return 0;
    }

    public boolean generatePattern$default$4() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Stage generateStage(String patternId) {
        void var2_2;
        Stage stage = (Stage)this.factory().newCiWithId(patternId, ClassTag$.MODULE$.apply(Stage.class));
        stage.setTitle(Ids.getName((String)stage.getId()));
        stage.setStatus(StageStatus.OPEN);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Transition generateTransition(String stageId) {
        void var2_2;
        Transition transition = (Transition)this.factory().newCiWithId(stageId, ClassTag$.MODULE$.apply(Transition.class));
        transition.setTitle(Ids.getName((String)transition.getId()));
        return var2_2;
    }

    public Release release(String title, Option<String> folderId) {
        return ReleaseBuilder.newRelease().withScriptUsername("admin").withScriptUserPassword("admin").withId(this.factory().createUniqueId((String)folderId.getOrElse((Function0 & Serializable)() -> Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName()), ClassTag$.MODULE$.apply(Release.class))).withTitle(title).build();
    }

    public Option<String> release$default$2() {
        return None$.MODULE$;
    }

    public CustomScriptTask findOrCreateDeliveryTask(String idAndTitle, String patternId, Enumeration.Value searchStrategy, String titlePattern, String selectionStrategy, boolean fallback, String title, Date startDate, Date endDate, String deliveryIdOutVar) {
        String outVar = deliveryIdOutVar != null ? new StringBuilder(3).append("${").append(deliveryIdOutVar).append("}").toString() : null;
        return this.generateDeliveryTask("FindOrCreateDelivery", idAndTitle, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"patternId"), (Object)patternId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"searchStrategy"), (Object)searchStrategy.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nameFilter"), (Object)titlePattern), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"selectionStrategy"), (Object)selectionStrategy), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fallback"), (Object)Boolean.toString(fallback)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"title"), (Object)title), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"startDate"), (Object)startDate), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"endDate"), (Object)endDate)}))), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deliveryId"), (Object)outVar)}))), this.generateDeliveryTask$default$5());
    }

    public Enumeration.Value findOrCreateDeliveryTask$default$3() {
        return DeliveryTestUtils$FindOrCreateStrategy$.MODULE$.Latest();
    }

    public String findOrCreateDeliveryTask$default$4() {
        return null;
    }

    public String findOrCreateDeliveryTask$default$5() {
        return "Use latest result";
    }

    public boolean findOrCreateDeliveryTask$default$6() {
        return false;
    }

    public String findOrCreateDeliveryTask$default$7() {
        return null;
    }

    public Date findOrCreateDeliveryTask$default$8() {
        return null;
    }

    public Date findOrCreateDeliveryTask$default$9() {
        return null;
    }

    public String findOrCreateDeliveryTask$default$10() {
        return null;
    }

    public CustomScriptTask createDeliveryTask(String idAndTitle, String patternId, String title, Date startDate, Date endDate, String deliveryIdOutVar) {
        return this.generateDeliveryTask("CreateDelivery", idAndTitle, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"patternId"), (Object)patternId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"title"), (Object)title), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"startDate"), (Object)startDate), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"endDate"), (Object)endDate)}))), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deliveryId"), (Object)deliveryIdOutVar)}))), this.generateDeliveryTask$default$5());
    }

    public String createDeliveryTask$default$3() {
        return null;
    }

    public Date createDeliveryTask$default$4() {
        return null;
    }

    public Date createDeliveryTask$default$5() {
        return null;
    }

    public String createDeliveryTask$default$6() {
        return null;
    }

    public CustomScriptTask findDeliveryTask(String idAndTitle, String trackedItemsTitlePattern, String deliveryTitlePattern, String selectionStrategy, String deliveryIdOutVar) {
        String outVar = deliveryIdOutVar != null ? new StringBuilder(3).append("${").append(deliveryIdOutVar).append("}").toString() : null;
        return this.generateDeliveryTask("FindDelivery", idAndTitle, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"itemsFilter"), (Object)trackedItemsTitlePattern), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nameFilter"), (Object)deliveryTitlePattern), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"selectionStrategy"), (Object)selectionStrategy)}))), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deliveryId"), (Object)outVar)}))), this.generateDeliveryTask$default$5());
    }

    public String findDeliveryTask$default$2() {
        return null;
    }

    public String findDeliveryTask$default$3() {
        return null;
    }

    public String findDeliveryTask$default$4() {
        return "Use latest result";
    }

    public String findDeliveryTask$default$5() {
        return null;
    }

    public CustomScriptTask registerTrackedItemsTask(String idAndTitle, String deliveryId, scala.collection.immutable.Seq<String> trackedItems) {
        return this.registerTrackedItemsTask(idAndTitle, deliveryId, (Either<String, scala.collection.immutable.Seq<String>>)package$.MODULE$.Right().apply(trackedItems));
    }

    public CustomScriptTask registerTrackedItemsTask(String idAndTitle, String deliveryId, Either<String, scala.collection.immutable.Seq<String>> trackedItems) {
        CustomScriptTask customScriptTask;
        Either<String, scala.collection.immutable.Seq<String>> either = trackedItems;
        if (either instanceof Left) {
            Left left = (Left)either;
            String listVariable = (String)left.value();
            String x$1 = "RegisterTrackedItems";
            String x$2 = idAndTitle;
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deliveryId"), (Object)deliveryId)}));
            Map x$4 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pythonScript.trackedItems"), (Object)new StringBuilder(3).append("${").append(listVariable).append("}").toString())}));
            Map<String, Object> x$5 = this.generateDeliveryTask$default$4();
            customScriptTask = this.generateDeliveryTask("RegisterTrackedItems", x$2, (Map<String, Object>)x$3, x$5, (Map<String, String>)x$4);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            scala.collection.immutable.Seq itemList = (scala.collection.immutable.Seq)right.value();
            customScriptTask = this.generateDeliveryTask("RegisterTrackedItems", idAndTitle, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deliveryId"), (Object)deliveryId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"trackedItems"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)itemList).asJava())}))), this.generateDeliveryTask$default$4(), this.generateDeliveryTask$default$5());
        } else {
            throw new MatchError(either);
        }
        return customScriptTask;
    }

    public CustomScriptTask markTrackedItemTask(String idAndTitle, String deliveryId, String stageId, scala.collection.immutable.Seq<String> trackedItems, TrackedItemStatus status, boolean precedingStages) {
        return this.markTrackedItemTask(idAndTitle, deliveryId, stageId, (Either<String, scala.collection.immutable.Seq<String>>)package$.MODULE$.Right().apply(trackedItems), status, precedingStages);
    }

    public CustomScriptTask markTrackedItemTask(String idAndTitle, String deliveryId, String stage, Either<String, scala.collection.immutable.Seq<String>> trackedItems, TrackedItemStatus status, boolean precedingStages) {
        CustomScriptTask customScriptTask;
        Either<String, scala.collection.immutable.Seq<String>> either = trackedItems;
        if (either instanceof Left) {
            Left left = (Left)either;
            String listVariable = (String)left.value();
            String x$1 = "MarkTrackedItems";
            String x$2 = idAndTitle;
            Map x$3 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deliveryId"), (Object)deliveryId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stage"), (Object)stage), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"status"), (Object)status.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precedingStages"), (Object)Boolean.toString(precedingStages))}));
            Map x$4 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pythonScript.trackedItems"), (Object)new StringBuilder(3).append("${").append(listVariable).append("}").toString())}));
            Map<String, Object> x$5 = this.generateDeliveryTask$default$4();
            customScriptTask = this.generateDeliveryTask("MarkTrackedItems", x$2, (Map<String, Object>)x$3, x$5, (Map<String, String>)x$4);
        } else if (either instanceof Right) {
            Right right = (Right)either;
            scala.collection.immutable.Seq itemList = (scala.collection.immutable.Seq)right.value();
            customScriptTask = this.generateDeliveryTask("MarkTrackedItems", idAndTitle, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deliveryId"), (Object)deliveryId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stage"), (Object)stage), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"status"), (Object)status.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"trackedItems"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)itemList).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"precedingStages"), (Object)Boolean.toString(precedingStages))}))), this.generateDeliveryTask$default$4(), this.generateDeliveryTask$default$5());
        } else {
            throw new MatchError(either);
        }
        return customScriptTask;
    }

    public TrackedItemStatus markTrackedItemTask$default$5() {
        return TrackedItemStatus.READY;
    }

    public boolean markTrackedItemTask$default$6() {
        return false;
    }

    public CustomScriptTask waitForTrackedItemsTask(String idAndTitle, String deliveryId, scala.collection.immutable.Seq<String> items, String stage, TrackedItemStatus status) {
        return this.generateDeliveryTask("WaitForTrackedItems", idAndTitle, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deliveryId"), (Object)deliveryId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"trackedItems"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava(items).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stage"), (Object)stage), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"status"), (Object)status.toString())}))), this.generateDeliveryTask$default$4(), this.generateDeliveryTask$default$5());
    }

    public TrackedItemStatus waitForTrackedItemsTask$default$5() {
        return TrackedItemStatus.READY;
    }

    public CustomScriptTask waitForStageTask(String idAndTitle, String deliveryId, String stage) {
        return this.generateDeliveryTask("WaitForStage", idAndTitle, (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deliveryId"), (Object)deliveryId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stage"), (Object)stage)}))), this.generateDeliveryTask$default$4(), this.generateDeliveryTask$default$5());
    }

    public CustomScriptTask generateDeliveryTask(String type, String idAndTitle, Map<String, Object> inputParameters, Map<String, Object> outputProperties, Map<String, String> variableMapping) {
        return ((CustomScriptTaskBuilder)((CustomScriptTaskBuilder)TaskBuilder.newCustomScript((String)new StringBuilder(9).append("delivery.").append(type).toString()).withIdAndTitle(idAndTitle)).withInputParameters(CollectionConverters$.MODULE$.MapHasAsJava(inputParameters).asJava()).withOutputProperties(CollectionConverters$.MODULE$.MapHasAsJava(outputProperties).asJava()).withVariableMapping(CollectionConverters$.MODULE$.MapHasAsJava(variableMapping).asJava())).build();
    }

    public Map<String, Object> generateDeliveryTask$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    public Map<String, String> generateDeliveryTask$default$5() {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ void $anonfun$stubStages$1(Delivery delivery$1, Stage stage) {
        stage.setId(MODULE$.factory().stageId(delivery$1.getId()));
        delivery$1.addStage(stage);
    }

    public static final /* synthetic */ void $anonfun$stubTransitions$1(Condition condition$1, Stage stage) {
        block0: {
            Transition transition = (Transition)MODULE$.factory().newCiWithId(stage.getId(), ClassTag$.MODULE$.apply(Transition.class));
            transition.setTitle(new StringBuilder(9).append("Wait for ").append(stage.getTitle()).toString());
            stage.setTransition(transition);
            if (condition$1 == null) break block0;
            Condition copy = (Condition)CiCloneHelper.cloneCi((ConfigurationItem)condition$1);
            copy.getAllConditions().forEach(x$2 -> x$2.setId(MODULE$.factory().conditionId(transition.getId())));
            transition.addCondition(copy);
        }
    }

    private DeliveryTestUtils$() {
    }
}

