import React, { ReactElement } from 'react';
import { ReactWrapper } from 'enzyme';
import { stringPropertyMock } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/__mocks__/property.mock';
import { taskMock } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/__mocks__/task.mock';
import { mountWithTheme } from '../../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { PropertiesEnum, TaskInputCommonProps } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/types';
import { InputWithScalar } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/input-with-scalar/input-with-scalar.component';
import { EnumOnlyOnSearch, OnlyOnSearch, TextOnlyOnSearch } from './only-on-search.component';
import { InputWithEnum } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/input-with-enum/input-with-enum.component';

describe('only on search components', () => {
    const task = {
        ...taskMock,
        inputProperties: {
            string: 'Folder2',
            searchStrategy: {
                value: 'Search by criteria',
                variable: null,
            },
        },
    };
    const onChange = jest.fn();
    let wrapper: ReactWrapper;

    const defaultProps: TaskInputCommonProps = {
        task,
        property: stringPropertyMock,
        propertiesEnum: PropertiesEnum.InputProperties,
        disabled: false,
        expanded: false,
        onChange,
    };

    const getOnlyOnSearch = () => wrapper.find(OnlyOnSearch);
    const getInputWithScalar = () => wrapper.find(InputWithScalar);
    const getInputWithEnum = () => wrapper.find(InputWithEnum);

    const mount = (component: ReactElement) => {
        wrapper = mountWithTheme(component);
    };

    describe('OnlyOnSearch', () => {
        it('should show children if task has "Search by criteria"', () => {
            mount(
                <OnlyOnSearch task={task}>
                    <h1>Hi</h1>
                </OnlyOnSearch>,
            );
            expect(wrapper).toIncludeText('Hi');
        });

        it('should not show children if task has "Latest delivery from pattern"', () => {
            const taskWithoutSearch = {
                ...task,
                inputProperties: {
                    searchStrategy: {
                        value: 'Latest delivery from pattern',
                        variable: null,
                    },
                },
            };
            mount(
                <OnlyOnSearch task={taskWithoutSearch}>
                    <h1>Hi</h1>
                </OnlyOnSearch>,
            );
            expect(wrapper).not.toIncludeText('Hi');
        });
    });

    describe('TextOnlyOnSearch', () => {
        it('should wrap properly other components', () => {
            mount(<TextOnlyOnSearch {...defaultProps} />);
            const onlyOnSearch = getOnlyOnSearch();
            const inputWithScalar = getInputWithScalar();
            expect(onlyOnSearch).toExist();
            expect(onlyOnSearch.props()).toMatchObject(defaultProps);
            expect(inputWithScalar).toExist();
            expect(inputWithScalar.props()).toMatchObject(defaultProps);
            expect(inputWithScalar.props().type).toBe('text');
        });
    });

    describe('EnumOnlyOnSearch', () => {
        it('should wrap properly other components', () => {
            mount(<EnumOnlyOnSearch {...defaultProps} />);
            const onlyOnSearch = getOnlyOnSearch();
            const inputWithEnum = getInputWithEnum();
            expect(onlyOnSearch).toExist();
            expect(onlyOnSearch.props()).toMatchObject(defaultProps);
            expect(inputWithEnum).toExist();
            expect(inputWithEnum.props()).toMatchObject(defaultProps);
        });
    });
});
