import React, { useState } from 'react';
import { DotSwitch, DotTypography } from '@digital-ai/dot-components';
import { TaskInputCommonProps } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/types';
import { TaskInputPropertiesVariableOrValue } from '../../../../../../../../../../../core/xlr-ui/app/types';
import { getPropertyFromInputProperties } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/helper/task.helper';
import '../../../../../../../../../../../core/xlr-ui/app/styles/xlrelease/disabled-with-default-color.less';

export const Fallback = ({ disabled, onChange, property, task }: TaskInputCommonProps) => {
    const [checked, setChecked] = useState<boolean>(
        ((getPropertyFromInputProperties(task, property.name) as TaskInputPropertiesVariableOrValue).value as boolean) || false,
    );

    const handleSwitchChange = (isChecked: boolean) => {
        setChecked(isChecked);
        onChange({ value: isChecked, variable: null });
    };

    return (
        <div className="task-input-property">
            <div className="input-switch-wrapper disabled-with-default-color">
                <DotSwitch
                    checked={checked}
                    className="input-switch"
                    disabled={disabled}
                    label={property.label}
                    onChange={(e) => handleSwitchChange(e.target.checked)}
                />
                <DotTypography className="input-description" variant="body2">
                    {property.description}
                </DotTypography>
            </div>
        </div>
    );
};
