/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.security;

import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryPatternService;
import com.xebialabs.xlrelease.delivery.service.DeliveryService;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.utils.DeliveryUtils$;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.security.authentication.AuthenticationService;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001\u0002\u000f\u001e\u0001!B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!Aa\b\u0001B\u0001B\u0003%q\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u0015\u0001\b\u0001\"\u0001t\u0011\u0015a\b\u0001\"\u0001~\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!1A\u0010\u0001C\u0001\u0003\u000fAq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002\u0014\u0001!\t!!\u0006\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0002bBA\u0010\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003[\u0001A\u0011AA\u0018\u0011\u001d\ti\u0003\u0001C\u0001\u0003gAq!a\u000e\u0001\t\u0013\tI\u0004C\u0004\u0002>\u0001!I!a\u0010\t\u000f\u0005\r\u0003\u0001\"\u0003\u0002F!9\u0011\u0011\n\u0001\u0005\n\u0005-\u0003bBA(\u0001\u0011%\u0011\u0011\u000b\u0005\b\u0003+\u0002A\u0011BA,\u0011\u001d\t9\b\u0001C\u0005\u0003sBq!!\"\u0001\t\u0013\t9\tC\u0004\u0002\u000e\u0002!I!a$\u00033\u0011+G.\u001b<fef\u0004VM]7jgNLwN\\\"iK\u000e\\WM\u001d\u0006\u0003=}\t\u0001b]3dkJLG/\u001f\u0006\u0003A\u0005\n\u0001\u0002Z3mSZ,'/\u001f\u0006\u0003E\r\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u0011*\u0013!\u0003=fE&\fG.\u00192t\u0015\u00051\u0013aA2p[\u000e\u00011C\u0001\u0001*!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fM\u0006)\u0012-\u001e;iK:$\u0018nY1uS>t7+\u001a:wS\u000e,\u0007CA\u00196\u001b\u0005\u0011$BA\u001a5\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:T!AH\u0011\n\u0005Y\u0012$!F!vi\",g\u000e^5dCRLwN\\*feZL7-Z\u0001\u0017I\u0016d\u0017N^3ssB\u000bG\u000f^3s]N+'O^5dKB\u0011\u0011\bP\u0007\u0002u)\u00111hH\u0001\bg\u0016\u0014h/[2f\u0013\ti$H\u0001\fEK2Lg/\u001a:z!\u0006$H/\u001a:o'\u0016\u0014h/[2f\u0003=!W\r\\5wKJL8+\u001a:wS\u000e,\u0007CA\u001dA\u0013\t\t%HA\bEK2Lg/\u001a:z'\u0016\u0014h/[2f\u0003-\u0001XM]7jgNLwN\\:\u0011\u0005\u0011+U\"\u0001\u001b\n\u0005\u0019#$!\u0005)fe6L7o]5p]\u000eCWmY6fe\u00061A(\u001b8jiz\"R!S&M\u001b:\u0003\"A\u0013\u0001\u000e\u0003uAQaL\u0003A\u0002ABQaN\u0003A\u0002aBQAP\u0003A\u0002}BQAQ\u0003A\u0002\rC#!\u0002)\u0011\u0005EcV\"\u0001*\u000b\u0005M#\u0016AC1o]>$\u0018\r^5p]*\u0011QKV\u0001\bM\u0006\u001cGo\u001c:z\u0015\t9\u0006,A\u0003cK\u0006t7O\u0003\u0002Z5\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001\\\u0003\ry'oZ\u0005\u0003;J\u0013\u0011\"Q;u_^L'/\u001a3\u0002\u0013\rDWmY6WS\u0016<HC\u00011d!\tQ\u0013-\u0003\u0002cW\t!QK\\5u\u0011\u0015!g\u00011\u0001f\u0003)!W\r\\5wKJL\u0018\n\u001a\t\u0003M6t!aZ6\u0011\u0005!\\S\"A5\u000b\u0005)<\u0013A\u0002\u001fs_>$h(\u0003\u0002mW\u00051\u0001K]3eK\u001aL!A\\8\u0003\rM#(/\u001b8h\u0015\ta7&A\tdQ\u0016\u001c7NV5fo\u0012+G.\u001b<fef$\"\u0001\u0019:\t\u000b\u0011<\u0001\u0019A3\u0015\u0005\u0001$\b\"\u0002\u0011\t\u0001\u0004)\bC\u0001<{\u001b\u00059(B\u0001\u0011y\u0015\tI\u0018%\u0001\u0004e_6\f\u0017N\\\u0005\u0003w^\u0014\u0001\u0002R3mSZ,'/_\u0001\u0012G\",7m[#eSR$U\r\\5wKJLHC\u00011\u007f\u0011\u0015!\u0017\u00021\u0001f\u0003e\u0019\u0007.Z2l\u000b\u0012LG\u000fR3mSZ,'/_(o\u0007J,\u0017\r^3\u0015\u0007\u0001\f\u0019\u0001\u0003\u0004\u0002\u0006)\u0001\r!Z\u0001\tM>dG-\u001a:JIR\u0019\u0001-!\u0003\t\u000b\u0001Z\u0001\u0019A;\u0002-\rDWmY6FI&$H)\u001a7jm\u0016\u0014\u0018p\u0015;bO\u0016$2\u0001YA\b\u0011\u0019\t\t\u0002\u0004a\u0001K\u000691\u000f^1hK&#\u0017AH2iK\u000e\\W\tZ5u)J\f7m[3e\u0013R,Wn\u00148EK2Lg/\u001a:z)\r\u0001\u0017q\u0003\u0005\u0006I6\u0001\r!Z\u0001\u001cG\",7m[#eSR$&/Y2lK\u0012LE/Z7P]N#\u0018mZ3\u0015\u0007\u0001\fi\u0002\u0003\u0004\u0002\u00129\u0001\r!Z\u0001\u0019G\",7m\u001b,jK^$U\r\\5wKJL\b+\u0019;uKJtGc\u00011\u0002$!1\u0011QE\bA\u0002\u0015\f\u0011\u0002]1ui\u0016\u0014h.\u00133\u0015\u0007\u0001\fI\u0003\u0003\u0004\u0002,A\u0001\r!^\u0001\ba\u0006$H/\u001a:o\u0003a\u0019\u0007.Z2l\u000b\u0012LG\u000fR3mSZ,'/\u001f)biR,'O\u001c\u000b\u0004A\u0006E\u0002BBA\u0013#\u0001\u0007Q\rF\u0002a\u0003kAa!a\u000b\u0013\u0001\u0004)\u0018!G2iK\u000e\\g+[3x\t\u0016d\u0017N^3ss>sgi\u001c7eKJ$2\u0001YA\u001e\u0011\u0019\t)a\u0005a\u0001K\u0006I2\r[3dW\u0016#\u0017\u000e\u001e#fY&4XM]=P]\u001a{G\u000eZ3s)\r\u0001\u0017\u0011\t\u0005\u0007\u0003\u000b!\u0002\u0019A3\u00029\rDWmY6FI&$HK]1dW\u0016$\u0017\n^3n\u001f:4u\u000e\u001c3feR\u0019\u0001-a\u0012\t\r\u0005\u0015Q\u00031\u0001f\u0003\u0001\u001a\u0007.Z2l-&,w\u000fR3mSZ,'/\u001f)biR,'O\\(o\r>dG-\u001a:\u0015\u0007\u0001\fi\u0005\u0003\u0004\u0002\u0006Y\u0001\r!Z\u0001!G\",7m[#eSR$U\r\\5wKJL\b+\u0019;uKJtwJ\u001c$pY\u0012,'\u000fF\u0002a\u0003'Ba!!\u0002\u0018\u0001\u0004)\u0017AD2iK\u000e\\W\tZ5u'R\fw-\u001a\u000b\u0006A\u0006e\u00131\f\u0005\u0007\u0003#A\u0002\u0019A3\t\u000f\u0005u\u0003\u00041\u0001\u0002`\u0005\u0019\u0002/\u001a:nSN\u001c\u0018n\u001c8t)>4VM]5gsB)!&!\u0019\u0002f%\u0019\u00111M\u0016\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0003\u0002h\u0005MTBAA5\u0015\u0011\tY'!\u001c\u0002\u0015A,'/\\5tg&|gNC\u0002\u001f\u0003_R1!!\u001d$\u0003!!W\r\u001d7ps&$\u0018\u0002BA;\u0003S\u0012!\u0002U3s[&\u001c8/[8o\u00035A\u0017m]*uC\u001e,wj\u001e8feR1\u00111PAA\u0003\u0007\u00032AKA?\u0013\r\tyh\u000b\u0002\b\u0005>|G.Z1o\u0011\u0015!\u0017\u00041\u0001f\u0011\u0019\t\t\"\u0007a\u0001K\u000692\r[3dWB+'/\\5tg&|gn\u00148G_2$WM\u001d\u000b\u0006A\u0006%\u00151\u0012\u0005\u0007\u0003\u000bQ\u0002\u0019A3\t\u000f\u0005u#\u00041\u0001\u0002`\u0005)\u0002.Y:QKJl\u0017n]:j_:|eNR8mI\u0016\u0014HCBA>\u0003#\u000b\u0019\n\u0003\u0004\u0002\u0006m\u0001\r!\u001a\u0005\b\u0003;Z\u0002\u0019AA0Q\r\u0001\u0011q\u0013\t\u0005\u00033\u000by*\u0004\u0002\u0002\u001c*\u0019\u0011Q\u0014-\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002\"\u0006m%!C\"p[B|g.\u001a8u\u0001")
public class DeliveryPermissionChecker {
    private final DeliveryPatternService deliveryPatternService;
    private final DeliveryService deliveryService;
    private final PermissionChecker permissions;

    public void checkView(String deliveryId) {
        Delivery delivery = this.deliveryService.getDeliveryOrPattern(deliveryId);
        if (delivery.isTemplate()) {
            this.checkViewDeliveryPattern(delivery);
            return;
        }
        this.checkViewDelivery(delivery);
    }

    public void checkViewDelivery(String deliveryId) {
        String folderId = this.deliveryService.getFolderId(deliveryId);
        this.checkViewDeliveryOnFolder(folderId);
    }

    public void checkViewDelivery(Delivery delivery) {
        String folderId = delivery.getFolderId();
        this.checkViewDeliveryOnFolder(folderId);
    }

    public void checkEditDelivery(String deliveryId) {
        String folderId = this.deliveryService.getFolderId(deliveryId);
        this.checkEditDeliveryOnFolder(folderId);
    }

    public void checkEditDeliveryOnCreate(String folderId) {
        this.checkEditDeliveryOnFolder(folderId);
    }

    public void checkEditDelivery(Delivery delivery) {
        this.checkEditDeliveryOnFolder(delivery.getFolderId());
    }

    public void checkEditDeliveryStage(String stageId) {
        this.checkEditStage(stageId, (Seq<Permission>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Permission[]{XLReleasePermissions.EDIT_RELEASE_DELIVERY}));
    }

    public void checkEditTrackedItemOnDelivery(String deliveryId) {
        String folderId = this.deliveryService.getFolderId(deliveryId);
        this.checkEditTrackedItemOnFolder(folderId);
    }

    public void checkEditTrackedItemOnStage(String stageId) {
        this.checkEditStage(stageId, DeliveryPermissions$.MODULE$.EDIT_DELIVERY_TRACKED_ITEM_PERMISSION_SET());
    }

    public void checkViewDeliveryPattern(String patternId) {
        String folderId = this.deliveryPatternService.getFolderId(patternId);
        this.checkViewDeliveryPatternOnFolder(folderId);
    }

    public void checkViewDeliveryPattern(Delivery pattern) {
        String folderId = pattern.getFolderId();
        this.checkViewDeliveryPatternOnFolder(folderId);
    }

    public void checkEditDeliveryPattern(String patternId) {
        String folderId = this.deliveryPatternService.getFolderId(patternId);
        this.checkEditDeliveryPatternOnFolder(folderId);
    }

    public void checkEditDeliveryPattern(Delivery pattern) {
        String folderId = pattern.getFolderId();
        this.checkEditDeliveryPatternOnFolder(folderId);
    }

    private void checkViewDeliveryOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PERMISSION_SET());
    }

    private void checkEditDeliveryOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.EDIT_DELIVERY_PERMISSION_SET());
    }

    private void checkEditTrackedItemOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.EDIT_DELIVERY_TRACKED_ITEM_PERMISSION_SET());
    }

    private void checkViewDeliveryPatternOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PATTERN_PERMISSION_SET());
    }

    private void checkEditDeliveryPatternOnFolder(String folderId) {
        this.checkPermissionOnFolder(folderId, DeliveryPermissions$.MODULE$.EDIT_DELIVERY_PATTERN_PERMISSION_SET());
    }

    private void checkEditStage(String stageId, Seq<Permission> permissionsToVerify) {
        String deliveryId = DeliveryUtils$.MODULE$.deliveryIdFrom(stageId);
        String folderId = this.deliveryPatternService.getFolderId(deliveryId);
        if (!this.hasPermissionOnFolder(folderId, permissionsToVerify) && !this.hasStageOwner(deliveryId, stageId)) {
            throw PermissionDeniedException.withMessage((String)("You do not have " + permissionsToVerify.mkString(" or ") + " permission or ownership on stage " + stageId));
        }
    }

    private boolean hasStageOwner(String deliveryId, String stageId) {
        Delivery delivery = this.deliveryService.getDeliveryOrPattern(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        return stage.isOwner(Permissions.getAuthenticatedUserName()) || stage.hasTeam() && this.permissions.isMemberOrRoleOf(delivery.getFolderId(), stage.getTeam());
    }

    private void checkPermissionOnFolder(String folderId, Seq<Permission> permissionsToVerify) {
        this.permissions.checkAny(folderId, permissionsToVerify);
    }

    private boolean hasPermissionOnFolder(String folderId, Seq<Permission> permissionsToVerify) {
        return ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])permissionsToVerify.toArray(ClassTag$.MODULE$.apply(Permission.class))), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)this.permissions.hasPermission(x$1, folderId)));
    }

    @Autowired
    public DeliveryPermissionChecker(AuthenticationService authenticationService, DeliveryPatternService deliveryPatternService, DeliveryService deliveryService, PermissionChecker permissions) {
        this.deliveryPatternService = deliveryPatternService;
        this.deliveryService = deliveryService;
        this.permissions = permissions;
    }
}

