import React, { ReactElement } from 'react';
import { ReactWrapper } from 'enzyme';
import { stringPropertyMock } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/__mocks__/property.mock';
import { taskMock } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/__mocks__/task.mock';
import { mountWithStoreAndTheme } from '../../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { FolderWithVariables } from './folder.component';
import { DateOnlyOnFallbackWithVariables, FolderOnlyOnFallbackWithVariables, OnlyOnFallback, TextOnlyOnFallback } from './only-on-fallback.component';
import { PropertiesEnum, TaskInputCommonProps } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/types';
import { InputWithVariables } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/input-with-variables/input-with-variables.component';
import { InputWithScalar } from '../../../../../../../../../../../core/xlr-ui/app/features/tasks/components/rails/config/components/input-with-scalar/input-with-scalar.component';

describe('fallback components', () => {
    const state = {
        taskDrawer: {
            allVariables: [{ key: 'var' }],
        },
        folders: {
            folders: [
                { id: 'Folder1', title: 'Folder One' },
                { id: 'Folder2', title: 'Folder Two' },
            ],
        },
    };
    const task = {
        ...taskMock,
        inputProperties: {
            string: 'Folder2',
        },
    };
    const onChange = jest.fn();
    const dispatch = jest.fn();
    let wrapper: ReactWrapper;

    const taskWithFallback = { ...task, inputProperties: { fallback: { value: true, variable: null }, string: {} } };
    const taskWithFallbackAndFolder = {
        ...task,
        inputProperties: { fallback: { value: true, variable: null }, string: 'Folder2' },
    };

    const defaultProps: TaskInputCommonProps = {
        task: taskWithFallback,
        propertiesEnum: PropertiesEnum.InputProperties,
        property: stringPropertyMock,
        disabled: false,
        expanded: false,
        onChange,
    };

    const getOnlyOnFallback = () => wrapper.find(OnlyOnFallback);
    const getFolderWithVariables = () => wrapper.find(FolderWithVariables);
    const getInputWithScalar = () => wrapper.find(InputWithScalar);
    const getInputWithVariables = () => wrapper.find(InputWithVariables);

    const mount = (component: ReactElement) => {
        wrapper = mountWithStoreAndTheme(component, dispatch, state);
    };

    describe('OnlyOnFallback', () => {
        it('should show children if task fallback is enabled', () => {
            mount(
                <OnlyOnFallback task={taskWithFallback}>
                    <h1>Hi</h1>
                </OnlyOnFallback>,
            );
            expect(wrapper).toIncludeText('Hi');
        });

        it('should not show children if task fallback is disabled', () => {
            const taskWithoutFallback = { ...task, inputProperties: { fallback: { value: false, variable: null } } };
            mount(
                <OnlyOnFallback task={taskWithoutFallback}>
                    <h1>Hi</h1>
                </OnlyOnFallback>,
            );
            expect(wrapper).not.toIncludeText('Hi');
        });
    });

    describe('FolderOnlyOnFallbackWithVariables', () => {
        it('should wrap properly other components', () => {
            const props = {
                ...defaultProps,
                task: taskWithFallbackAndFolder,
            };
            mount(<FolderOnlyOnFallbackWithVariables {...props} />);
            const fallback = getOnlyOnFallback();
            const folderWithVariables = getFolderWithVariables();
            expect(fallback).toExist();
            expect(fallback.props()).toMatchObject(defaultProps);
            expect(folderWithVariables).toExist();
            expect(folderWithVariables.props()).toMatchObject(defaultProps);
        });
    });

    describe('TextOnlyOnFallback', () => {
        it('should wrap properly other components', () => {
            mount(<TextOnlyOnFallback {...defaultProps} />);
            const fallback = getOnlyOnFallback();
            const inputWithScalar = getInputWithScalar();
            expect(fallback).toExist();
            expect(fallback.props()).toMatchObject(defaultProps);
            expect(inputWithScalar).toExist();
            expect(inputWithScalar.props()).toMatchObject(defaultProps);
            expect(inputWithScalar.props().type).toBe('text');
        });
    });

    describe('DateOnlyOnFallbackWithVariables', () => {
        beforeEach(() => {
            mount(<DateOnlyOnFallbackWithVariables {...defaultProps} />);
        });

        it('should wrap properly other components', () => {
            const fallback = getOnlyOnFallback();
            const inputWithVariables = getInputWithVariables();
            const inputWithScalar = getInputWithScalar();
            expect(fallback).toExist();
            expect(fallback.props()).toMatchObject(defaultProps);
            expect(inputWithVariables).toExist();
            expect(inputWithVariables.props()).toMatchObject(defaultProps);
            expect(inputWithScalar).toExist();
            expect(inputWithScalar.props()).toMatchObject(defaultProps);
            expect(inputWithScalar.props().type).toBe('datetime-local');
        });
        it('should handle variables events', () => {
            const inputWithVariablesProps = getInputWithVariables().props();
            expect(inputWithVariablesProps.variables).toMatchObject([
                {
                    key: 'var',
                },
            ]);
            inputWithVariablesProps.onNewVariableAdd?.('myVar', 'xlrelease.StringVariable');
            expect(dispatch).toHaveBeenCalledWith({
                payload: {
                    propertiesEnum: PropertiesEnum.InputProperties,
                    propertyName: stringPropertyMock.name,
                    taskValue: { value: undefined, variable: '${myVar}' },
                    variableName: 'myVar',
                    variableType: 'xlrelease.StringVariable',
                },
                type: 'propertiesForm/createReleaseVariableAndUpdateTask',
            });
        });
    });
});
