/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.v1.forms.CreateDelivery;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryOrderMode;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryPatternFilters;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.domain.DeliveryStatus;
import com.xebialabs.xlrelease.delivery.domain.Stage;
import com.xebialabs.xlrelease.delivery.domain.StageStatus;
import com.xebialabs.xlrelease.delivery.domain.TrackedItem;
import com.xebialabs.xlrelease.delivery.domain.Transition;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.StageCreated;
import com.xebialabs.xlrelease.delivery.events.StageRemoved;
import com.xebialabs.xlrelease.delivery.events.StageUpdated;
import com.xebialabs.xlrelease.delivery.events.TransitionCreated;
import com.xebialabs.xlrelease.delivery.events.TransitionRemoved;
import com.xebialabs.xlrelease.delivery.events.TransitionUpdated;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryServiceUtils;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Buffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@Service
@ScalaSignature(bytes="\u0006\u0001\r}b\u0001\u0002\u00180\u0001iB\u0001\"\u0012\u0001\u0003\u0006\u0004%\tA\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u000f\"Aa\n\u0001BC\u0002\u0013\u0005q\n\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003Q\u0011!1\u0006A!b\u0001\n\u00039\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tI\u0002\u0011)\u0019!C\u0001K\"AA\u000e\u0001B\u0001B\u0003%a\r\u0003\u0005n\u0001\t\u0015\r\u0011\"\u0001o\u0011!\u0011\bA!A!\u0002\u0013y\u0007\u0002C:\u0001\u0005\u000b\u0007I\u0011\u0001;\t\u0011u\u0004!\u0011!Q\u0001\nUD\u0001B \u0001\u0003\u0006\u0004%\ta \u0005\u000b\u0003\u001b\u0001!\u0011!Q\u0001\n\u0005\u0005\u0001bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\b\u0003\u0007\u0002A\u0011AA#\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007Cq!a#\u0001\t\u0003\ti\tC\u0004\u0002 \u0002!\t!!)\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\"9\u00111\u0017\u0001\u0005\u0002\u0005U\u0006bBA_\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0003\u0017\u0004A\u0011AAg\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003+Dq!a=\u0001\t\u0003\t)\u0010C\u0004\u0003\u001e\u0001!\tAa\b\t\u000f\t5\u0002\u0001\"\u0001\u00030!9!\u0011\n\u0001\u0005\u0002\t-\u0003b\u0002B*\u0001\u0011\u0005!Q\u000b\u0005\b\u0005?\u0002A\u0011\u0001B1\u0011\u001d\u0011y\u0007\u0001C\u0001\u0005cBqAa\u001f\u0001\t\u0003\u0011i\bC\u0004\u0003\u0006\u0002!\tAa\"\t\u000f\tE\u0005\u0001\"\u0003\u0003\u0014\"9!q\u0013\u0001\u0005\n\te\u0005b\u0002BO\u0001\u0011%!q\u0014\u0005\n\u0005w\u0003\u0011\u0013!C\u0005\u0005{CqA!5\u0001\t\u0013\u0011\u0019\u000eC\u0004\u0003Z\u0002!IAa7\t\u000f\t}\u0007\u0001\"\u0003\u0003b\"I!\u0011\u001e\u0001\u0012\u0002\u0013%!1\u001e\u0005\b\u0005_\u0004A\u0011\u0002By\u0011\u001d\u0019)\u0003\u0001C)\u0007O\u0011a\u0003R3mSZ,'/\u001f)biR,'O\\*feZL7-\u001a\u0006\u0003aE\nqa]3sm&\u001cWM\u0003\u00023g\u0005AA-\u001a7jm\u0016\u0014\u0018P\u0003\u00025k\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003m]\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003a\n1aY8n\u0007\u0001\u00192\u0001A\u001eB!\tat(D\u0001>\u0015\u0005q\u0014!B:dC2\f\u0017B\u0001!>\u0005\u0019\te.\u001f*fMB\u0011!iQ\u0007\u0002_%\u0011Ai\f\u0002\u0015\t\u0016d\u0017N^3ssN+'O^5dKV#\u0018\u000e\\:\u0002%\u0011,G.\u001b<fef\u0014V\r]8tSR|'/_\u000b\u0002\u000fB\u0011\u0001jS\u0007\u0002\u0013*\u0011!*M\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001'J\u0005I!U\r\\5wKJL(+\u001a9pg&$xN]=\u0002'\u0011,G.\u001b<fef\u0014V\r]8tSR|'/\u001f\u0011\u0002#I,G.Z1tKJ+\u0007o\\:ji>\u0014\u00180F\u0001Q!\t\t6+D\u0001S\u0015\tQ5'\u0003\u0002U%\n\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0002%I,G.Z1tKJ+\u0007o\\:ji>\u0014\u0018\u0010I\u0001\u000fe\u0016dW-Y:f'\u0016\u0014h/[2f+\u0005A\u0006CA-\\\u001b\u0005Q&B\u0001\u00194\u0013\ta&L\u0001\bSK2,\u0017m]3TKJ4\u0018nY3\u0002\u001fI,G.Z1tKN+'O^5dK\u0002\n1bY5JIN+'O^5dKV\t\u0001\r\u0005\u0002ZC&\u0011!M\u0017\u0002\f\u0007&LEmU3sm&\u001cW-\u0001\u0007dS&#7+\u001a:wS\u000e,\u0007%\u0001\tbe\u000eD\u0017N^3e%\u0016dW-Y:fgV\ta\r\u0005\u0002hU6\t\u0001N\u0003\u0002jg\u0005\u0011AMY\u0005\u0003W\"\u0014\u0001#\u0011:dQ&4X\r\u001a*fY\u0016\f7/Z:\u0002#\u0005\u00148\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\b%A\u0007g_2$WM]*feZL7-Z\u000b\u0002_B\u0011\u0011\f]\u0005\u0003cj\u0013QBR8mI\u0016\u00148+\u001a:wS\u000e,\u0017A\u00044pY\u0012,'oU3sm&\u001cW\rI\u0001\fe>dWmU3sm&\u001cW-F\u0001v!\t180D\u0001x\u0015\tA\u00180\u0001\u0005tK\u000e,(/\u001b;z\u0015\tQX'\u0001\u0005eKBdw._5u\u0013\taxOA\u0006S_2,7+\u001a:wS\u000e,\u0017\u0001\u0004:pY\u0016\u001cVM\u001d<jG\u0016\u0004\u0013\u0001C3wK:$()^:\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d1'\u0001\u0004fm\u0016tGo]\u0005\u0005\u0003\u0017\t)AA\tY\u0019J+G.Z1tK\u00163XM\u001c;CkN\f\u0011\"\u001a<f]R\u0014Uo\u001d\u0011\u0002\rqJg.\u001b;?)I\t\u0019\"!\u0006\u0002\u0018\u0005e\u00111DA\u000f\u0003?\t\t#a\t\u0011\u0005\t\u0003\u0001\"B#\u0012\u0001\u00049\u0005\"\u0002(\u0012\u0001\u0004\u0001\u0006\"\u0002,\u0012\u0001\u0004A\u0006\"\u00020\u0012\u0001\u0004\u0001\u0007\"\u00023\u0012\u0001\u00041\u0007\"B7\u0012\u0001\u0004y\u0007\"B:\u0012\u0001\u0004)\bB\u0002@\u0012\u0001\u0004\t\t\u0001K\u0002\u0012\u0003O\u0001B!!\u000b\u0002@5\u0011\u00111\u0006\u0006\u0005\u0003[\ty#\u0001\u0006b]:|G/\u0019;j_:TA!!\r\u00024\u00059a-Y2u_JL(\u0002BA\u001b\u0003o\tQAY3b]NTA!!\u000f\u0002<\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002>\u0005\u0019qN]4\n\t\u0005\u0005\u00131\u0006\u0002\n\u0003V$xn^5sK\u0012\f!bZ3u!\u0006$H/\u001a:o)\u0011\t9%a\u0015\u0011\t\u0005%\u0013qJ\u0007\u0003\u0003\u0017R1!!\u00142\u0003\u0019!w.\\1j]&!\u0011\u0011KA&\u0005!!U\r\\5wKJL\bbBA+%\u0001\u0007\u0011qK\u0001\na\u0006$H/\u001a:o\u0013\u0012\u0004B!!\u0017\u0002h9!\u00111LA2!\r\ti&P\u0007\u0003\u0003?R1!!\u0019:\u0003\u0019a$o\\8u}%\u0019\u0011QM\u001f\u0002\rA\u0013X\rZ3g\u0013\u0011\tI'a\u001b\u0003\rM#(/\u001b8h\u0015\r\t)'\u0010\u0015\u0004%\u0005=\u0004\u0003BA9\u0003{j!!a\u001d\u000b\t\u00055\u0012Q\u000f\u0006\u0005\u0003o\nI(A\u0004nKR\u0014\u0018nY:\u000b\u0007\u0005mt'\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\ty(a\u001d\u0003\u000bQKW.\u001a3\u0002+\u001d,G\u000fU1ui\u0016\u0014hNQ=JI>\u0013H+\u001b;mKR!\u0011qIAC\u0011\u001d\t9i\u0005a\u0001\u0003/\n\u0001\u0003]1ui\u0016\u0014h.\u00133PeRKG\u000f\\3)\u0007M\ty'\u0001\ffq&\u001cHo\u001d)biR,'O\\,ji\"$\u0016\u000e\u001e7f)\u0019\ty)!&\u0002\u001aB\u0019A(!%\n\u0007\u0005MUHA\u0004C_>dW-\u00198\t\u000f\u0005]E\u00031\u0001\u0002X\u0005\u0011\u0011\u000e\u001a\u0005\b\u00037#\u0002\u0019AA,\u0003\u0015!\u0018\u000e\u001e7fQ\r!\u0012qN\u0001\u000eKbL7\u000f^:QCR$XM\u001d8\u0015\t\u0005=\u00151\u0015\u0005\b\u0003K+\u0002\u0019AA,\u0003)!W\r\\5wKJL\u0018\n\u001a\u0015\u0004+\u0005=\u0014!F2sK\u0006$X\rR3mSZ,'/\u001f)biR,'O\u001c\u000b\u0005\u0003\u000f\ni\u000bC\u0004\u00020Z\u0001\r!a\u0012\u0002\u000fA\fG\u000f^3s]\"\u001aa#a\u001c\u0002+U\u0004H-\u0019;f\t\u0016d\u0017N^3ssB\u000bG\u000f^3s]R!\u0011qIA\\\u0011\u001d\tIl\u0006a\u0001\u0003\u000f\nq!\u001e9eCR,G\rK\u0002\u0018\u0003_\nQ\u0003Z3mKR,G)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014h\u000e\u0006\u0003\u0002B\u0006\u001d\u0007c\u0001\u001f\u0002D&\u0019\u0011QY\u001f\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003+B\u0002\u0019AA,Q\rA\u0012qN\u0001\u0019IV\u0004H.[2bi\u0016$U\r\\5wKJL\b+\u0019;uKJtG\u0003BA$\u0003\u001fDq!!\u0016\u001a\u0001\u0004\t9\u0006K\u0002\u001a\u0003_\n\u0011d\u0019:fCR,G)\u001a7jm\u0016\u0014\u0018P\u0012:p[B\u000bG\u000f^3s]R1\u0011qIAl\u00033Dq!!\u0016\u001b\u0001\u0004\t9\u0006C\u0004\u0002\\j\u0001\r!!8\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u0005\u0003\u0002`\u00065XBAAq\u0015\u0011\t\u0019/!:\u0002\u000b\u0019|'/\\:\u000b\t\u0005\u001d\u0018\u0011^\u0001\u0003mFR1!a;4\u0003\r\t\u0007/[\u0005\u0005\u0003_\f\tO\u0001\bDe\u0016\fG/\u001a#fY&4XM]=)\u0007i\ty'\u0001\btK\u0006\u00148\r\u001b)biR,'O\\:\u0015\r\u0005](q\u0001B\t!\u0019\tIPa\u0001\u0002H5\u0011\u00111 \u0006\u0005\u0003{\fy0\u0001\u0003vi&d'B\u0001B\u0001\u0003\u0011Q\u0017M^1\n\t\t\u0015\u00111 \u0002\u0005\u0019&\u001cH\u000fC\u0004\u0003\nm\u0001\rAa\u0003\u0002\u000f\u0019LG\u000e^3sgB!\u0011q\u001cB\u0007\u0013\u0011\u0011y!!9\u0003-\u0011+G.\u001b<fef\u0004\u0016\r\u001e;fe:4\u0015\u000e\u001c;feNDqAa\u0005\u001c\u0001\u0004\u0011)\"\u0001\u0003qC\u001e,\u0007cA)\u0003\u0018%\u0019!\u0011\u0004*\u0003\tA\u000bw-\u001a\u0015\u00047\u0005=\u0014!C4fiN#\u0018mZ3t)\u0011\u0011\tC!\u000b\u0011\r\u0005e(1\u0001B\u0012!\u0011\tIE!\n\n\t\t\u001d\u00121\n\u0002\u0006'R\fw-\u001a\u0005\b\u0003+b\u0002\u0019AA,Q\ra\u0012qN\u0001\tC\u0012$7\u000b^1hKRA!1\u0005B\u0019\u0005g\u00119\u0004C\u0004\u0002Vu\u0001\r!a\u0016\t\u000f\tUR\u00041\u0001\u0003$\u0005)1\u000f^1hK\"9!\u0011H\u000fA\u0002\tm\u0012\u0001E8qi&|g.\u00197Q_NLG/[8o!\u0015a$Q\bB!\u0013\r\u0011y$\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007q\u0012\u0019%C\u0002\u0003Fu\u00121!\u00138uQ\ri\u0012qN\u0001\fkB$\u0017\r^3Ti\u0006<W\r\u0006\u0004\u0003$\t5#q\n\u0005\b\u0003+r\u0002\u0019AA,\u0011\u001d\tIL\ba\u0001\u0005GA3AHA8\u0003-!W\r\\3uKN#\u0018mZ3\u0015\r\u0005\u0005'q\u000bB-\u0011\u001d\t)f\ba\u0001\u0003/BqAa\u0017 \u0001\u0004\t9&A\u0004ti\u0006<W-\u00133)\u0007}\ty'\u0001\bhKR$&/\u00198tSRLwN\\:\u0015\t\t\r$1\u000e\t\u0007\u0003s\u0014\u0019A!\u001a\u0011\t\u0005%#qM\u0005\u0005\u0005S\nYE\u0001\u0006Ue\u0006t7/\u001b;j_:Dq!!\u0016!\u0001\u0004\t9\u0006K\u0002!\u0003_\nQ\"\u00193e)J\fgn]5uS>tGC\u0002B3\u0005g\u0012)\bC\u0004\u0002V\u0005\u0002\r!a\u0016\t\u000f\t]\u0014\u00051\u0001\u0003f\u0005QAO]1og&$\u0018n\u001c8)\u0007\u0005\ny'\u0001\tva\u0012\fG/\u001a+sC:\u001c\u0018\u000e^5p]R1!Q\rB@\u0005\u0003Cq!!\u0016#\u0001\u0004\t9\u0006C\u0004\u0002:\n\u0002\rA!\u001a)\u0007\t\ny'\u0001\teK2,G/\u001a+sC:\u001c\u0018\u000e^5p]R1\u0011\u0011\u0019BE\u0005\u0017Cq!!\u0016$\u0001\u0004\t9\u0006C\u0004\u0003\u000e\u000e\u0002\r!a\u0016\u0002\u0019Q\u0014\u0018M\\:ji&|g.\u00133)\u0007\r\ny'A\bwC2LG-\u0019;f!\u0006$H/\u001a:o)\u0011\t\tM!&\t\rI\"\u0003\u0019AA$\u00039\u0019\u0007.Z2l\u0013N\u0004\u0016\r\u001e;fe:$B!!1\u0003\u001c\"1!'\na\u0001\u0003\u000f\nQB^1mS\u0012\fG/Z*uC\u001e,G\u0003CAa\u0005C\u0013\u0019K!/\t\u000f\tUb\u00051\u0001\u0003$!9!Q\u0015\u0014A\u0002\t\u001d\u0016AB:uC\u001e,7\u000f\u0005\u0004\u0003*\nM&1\u0005\b\u0005\u0005W\u0013yK\u0004\u0003\u0002^\t5\u0016\"\u0001 \n\u0007\tEV(A\u0004qC\u000e\\\u0017mZ3\n\t\tU&q\u0017\u0002\u0004'\u0016\f(b\u0001BY{!I!\u0011\b\u0014\u0011\u0002\u0003\u0007!1H\u0001\u0018m\u0006d\u0017\u000eZ1uKN#\u0018mZ3%I\u00164\u0017-\u001e7uIM*\"Aa0+\t\tm\"\u0011Y\u0016\u0003\u0005\u0007\u0004BA!2\u0003N6\u0011!q\u0019\u0006\u0005\u0005\u0013\u0014Y-A\u0005v]\u000eDWmY6fI*\u0019\u0011QF\u001f\n\t\t='q\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u0005<bY&$\u0017\r^3Ue\u0006t7/\u001b;j_:$b!!1\u0003V\n]\u0007bBAXQ\u0001\u0007\u0011q\t\u0005\b\u0005oB\u0003\u0019\u0001B3\u00035\u0011Xm]3u\t\u0016d\u0017N^3ssR!\u0011\u0011\u0019Bo\u0011\u0019\u0011\u0014\u00061\u0001\u0002H\u0005!\u0012\r\u001c:fC\u0012LX\t_5tiN\u0014\u0015\u0010V5uY\u0016$b!a$\u0003d\n\u001d\bb\u0002BsU\u0001\u0007\u0011qK\u0001\ra\u0006$H/\u001a:o)&$H.\u001a\u0005\n\u0003+R\u0003\u0013!a\u0001\u0003/\na$\u00197sK\u0006$\u00170\u0012=jgR\u001c()\u001f+ji2,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t5(\u0006BA,\u0005\u0003\f!bZ3oKJ\fG/Z%e)\u0019\t9Fa=\u0004\"!9!Q\u001f\u0017A\u0002\t]\u0018aB2j\u00072\f7o\u001d\u0019\u0005\u0005s\u001c\u0019\u0001\u0005\u0004\u0002Z\tm(q`\u0005\u0005\u0005{\fYGA\u0003DY\u0006\u001c8\u000f\u0005\u0003\u0004\u0002\r\rA\u0002\u0001\u0003\r\u0007\u000b\u0011\u00190!A\u0001\u0002\u000b\u00051q\u0001\u0002\u0004?\u0012\n\u0014\u0003BB\u0005\u0007\u001f\u00012\u0001PB\u0006\u0013\r\u0019i!\u0010\u0002\b\u001d>$\b.\u001b8h!\u0011\u0019\tb!\b\u000e\u0005\rM!\u0002BB\u000b\u0007/\t1!\u001e3n\u0015\u0011\tYo!\u0007\u000b\u0007\rm\u00110\u0001\u0004qYV<\u0017N\\\u0005\u0005\u0007?\u0019\u0019BA\tD_:4\u0017nZ;sCRLwN\\%uK6Dqaa\t-\u0001\u0004\t9&\u0001\u0005qCJ,g\u000e^%e\u0003A\u0019\u0007.Z2l\u0013N,\u0006\u000fZ1uC\ndW\r\u0006\u0004\u0002B\u000e%2Q\u0006\u0005\b\u0007Wi\u0003\u0019AA$\u0003A)\u00070[:uS:<G)\u001a7jm\u0016\u0014\u0018\u0010C\u0005\u000405\u0002\n\u00111\u0001\u0002X\u00051\u0011m\u0019;j_:D3\u0001AB\u001a!\u0011\u0019)da\u000f\u000e\u0005\r]\"\u0002BB\u001d\u0003o\t!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0019ida\u000e\u0003\u000fM+'O^5dK\u0002")
public class DeliveryPatternService
implements DeliveryServiceUtils {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String checkIsUpdatable$default$2() {
        return DeliveryServiceUtils.checkIsUpdatable$default$2$(this);
    }

    @Override
    @Timed
    public Delivery getDeliveryOrPattern(String deliveryId) {
        return DeliveryServiceUtils.getDeliveryOrPattern$(this, deliveryId);
    }

    @Override
    @Timed
    public String getFolderId(String deliveryId) {
        return DeliveryServiceUtils.getFolderId$(this, deliveryId);
    }

    @Override
    public Delivery doUpdate(Delivery updated) {
        return DeliveryServiceUtils.doUpdate$(this, updated);
    }

    @Override
    public void doDelete(String deliveryId) {
        DeliveryServiceUtils.doDelete$(this, deliveryId);
    }

    @Override
    public void validate(Delivery delivery) {
        DeliveryServiceUtils.validate$(this, delivery);
    }

    @Override
    public void validateDelivery(Delivery delivery) {
        DeliveryServiceUtils.validateDelivery$(this, delivery);
    }

    @Override
    public void checkIsDelivery(Delivery delivery) {
        DeliveryServiceUtils.checkIsDelivery$(this, delivery);
    }

    @Override
    public Iterable<String> currentPrincipals() {
        return DeliveryServiceUtils.currentPrincipals$(this);
    }

    @Override
    public Buffer<String> currentRoleIds() {
        return DeliveryServiceUtils.currentRoleIds$(this);
    }

    @Override
    public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        DeliveryServiceUtils.computeAndUpdateDates$(this, delivery, durationOpt, startDateOpt, endDateOpt);
    }

    @Override
    public int computeAndUpdateDates$default$2() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$2$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$3() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$3$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$4() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$4$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryPatternService deliveryPatternService = this;
        synchronized (deliveryPatternService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public DeliveryRepository deliveryRepository() {
        return this.deliveryRepository;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public FolderService folderService() {
        return this.folderService;
    }

    @Override
    public RoleService roleService() {
        return this.roleService;
    }

    @Override
    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPattern(String patternId) {
        void var2_2;
        Delivery pattern = this.getDeliveryOrPattern(patternId);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPatternByIdOrTitle(String patternIdOrTitle) {
        void var2_2;
        Delivery pattern = this.deliveryRepository().getByIdOrTitle(patternIdOrTitle);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    @Timed
    public boolean existsPatternWithTitle(String id, String title) {
        return this.alreadyExistsByTitle(title, id);
    }

    @Timed
    public boolean existsPattern(String deliveryId) {
        return this.deliveryRepository().exists(deliveryId);
    }

    @Timed
    public Delivery createDeliveryPattern(Delivery pattern) {
        Checks.checkNotNull((Object)((Object)pattern), (String)"Release delivery");
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Creating new delivery pattern '").append((Object)pattern).append("'").toString());
        pattern.setStatus(DeliveryStatus.TEMPLATE);
        this.validatePattern(pattern);
        this.resetDelivery(pattern);
        if (pattern.getStages().isEmpty()) {
            Stage defaultStage = new Stage("New Stage");
            defaultStage.setId(this.generateId(Stage.class, pattern.getId()));
            pattern.addStage(defaultStage);
        }
        this.deliveryRepository().create(pattern);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(pattern));
        return pattern;
    }

    @Timed
    public Delivery updateDeliveryPattern(Delivery updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Updating delivery pattern '").append((Object)updated).append("'").toString());
        this.validatePattern(updated);
        return this.doUpdate(updated);
    }

    @Timed
    public void deleteDeliveryPattern(String patternId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Deleting release delivery pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.deliveryRepository().read(patternId);
        this.checkIsPattern(pattern);
        this.doDelete(patternId);
    }

    @Timed
    public Delivery duplicateDeliveryPattern(String patternId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Duplicating delivery pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.resetDelivery(pattern);
        int counter = 100;
        do {
            pattern.setTitle(new StringBuilder(7).append(pattern.getTitle()).append(" (Copy)").toString());
        } while (this.alreadyExistsByTitle(pattern.getTitle(), pattern.getId()) && --counter > 0);
        this.deliveryRepository().create(pattern);
        Delivery duplicatedPattern = this.deliveryRepository().read(pattern.getId());
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(duplicatedPattern));
        return duplicatedPattern;
    }

    @Timed
    public Delivery createDeliveryFromPattern(String patternId, CreateDelivery parameters) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Creating new delivery from pattern '").append(patternId).append("' with parameters '").append(parameters).append("'").toString());
        Delivery delivery = this.getPattern(patternId);
        this.resetDelivery(delivery);
        delivery.setTitle(parameters.getTitle());
        delivery.setDescription(parameters.getDescription());
        delivery.setOriginPatternId(patternId);
        this.computeAndUpdateDates(delivery, parameters.getDuration(), parameters.getStartDate(), parameters.getEndDate());
        Checks.checkArgument((delivery.getStages() != null && !delivery.getStages().isEmpty() ? 1 : 0) != 0, (String)"Cannot create delivery from pattern without stages", (Object[])new Object[0]);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService());
        Delivery startedDelivery = manager.start();
        this.validateDelivery(delivery);
        this.deliveryRepository().create(delivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(delivery));
        manager.getEvents().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            DeliveryPatternService.$anonfun$createDeliveryFromPattern$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        return startedDelivery;
    }

    @Timed
    public List<Delivery> searchPatterns(DeliveryPatternFilters filters, Page page) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.deliveryRepository().search(filters, page, DeliveryOrderMode.START_DATE, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), (Seq<Permission>)((Seq)Seq$.MODULE$.apply(DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PATTERN_PERMISSION_SET())))).asJava();
    }

    @Timed
    public List<Stage> getStages(String patternId) {
        return this.getPattern(patternId).getStages();
    }

    @Timed
    public Stage addStage(String patternId, Stage stage, Option<Object> optionalPosition) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Adding new stage '").append((Object)stage).append("' to pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Buffer stages = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala();
        this.validateStage(stage, (Seq<Stage>)stages, optionalPosition);
        stage.setId(this.generateId(Stage.class, pattern.getId()));
        stage.setStatus(StageStatus.OPEN);
        int position = BoxesRunTime.unboxToInt((Object)optionalPosition.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> stages.size()));
        pattern.addStage(stage, position);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageCreated(stage, pattern));
        return stage;
    }

    @Timed
    public Stage updateStage(String patternId, Stage updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Updating stage '").append((Object)updated).append("' on pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        this.validateStage(updated, (Seq<Stage>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala()), this.validateStage$default$3());
        Stage original = pattern.getStageByIdOrTitle(updated.getId());
        original.setTitle(updated.getTitle());
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageUpdated(updated, pattern));
        return original;
    }

    @Timed
    public void deleteStage(String patternId, String stageId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Removing stage '").append(stageId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Function1 & Serializable & scala.Serializable removeTransition = (Function1 & Serializable & scala.Serializable)stage -> {
            stage.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                DeliveryPatternService.$anonfun$deleteStage$3(pattern$2, x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
        Stage stage2 = pattern.getStageByIdOrTitle(stageId);
        removeTransition.apply((Object)new Some((Object)stage2));
        Object object = pattern.isLastStage(stage2) ? removeTransition.apply((Object)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(pattern.findPreviousStage(stage2)))) : BoxedUnit.UNIT;
        pattern.removeStage(stage2);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageRemoved(stage2, pattern));
    }

    @Timed
    public List<Transition> getTransitions(String patternId) {
        return this.getPattern(patternId).getTransitions();
    }

    @Timed
    public Transition addTransition(String patternId, Transition transition) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Adding new transition '").append((Object)transition).append("' to pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        this.validateTransition(pattern, transition);
        transition.setId(this.generateId(Transition.class, pattern.getId()));
        pattern.addTransition(transition);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionCreated(transition, pattern));
        return transition;
    }

    @Timed
    public Transition updateTransition(String patternId, Transition updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Updating transition '").append((Object)updated).append("' on pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        this.validateTransition(pattern, updated);
        Transition original = pattern.getTransitionByIdOrTitle(updated.getId());
        pattern.removeTransition(original);
        pattern.addTransition(updated);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionUpdated(updated, pattern));
        return updated;
    }

    @Timed
    public void deleteTransition(String patternId, String transitionId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Removing transition '").append(transitionId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Transition transition = pattern.getTransitionByIdOrTitle(transitionId);
        pattern.removeTransition(transition);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionRemoved(transition, pattern));
    }

    private void validatePattern(Delivery delivery) {
        this.validate(delivery);
        this.checkIsPattern(delivery);
        Checks.checkArgument((!this.alreadyExistsByTitle(delivery.getTitle(), delivery.getId()) ? 1 : 0) != 0, (String)new StringBuilder(36).append("Pattern with title '").append(delivery.getTitle()).append("' already exists").toString(), (Object[])new Object[0]);
    }

    private void checkIsPattern(Delivery delivery) {
        Checks.checkArgument((boolean)delivery.isTemplate(), (String)new StringBuilder(27).append(delivery.getId()).append(" must be a Delivery Pattern").toString(), (Object[])new Object[0]);
    }

    private void validateStage(Stage stage, Seq<Stage> stages, Option<Object> optionalPosition) {
        Checks.checkNotNull((Object)((Object)stage), (String)"Stage");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)stage.getTitle()), (String)"Stage title must be set", (Object[])new Object[0]);
        Checks.checkArgument((stage.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Stage title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!stage.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
        if (optionalPosition.isDefined()) {
            int position = BoxesRunTime.unboxToInt((Object)optionalPosition.get());
            Checks.checkArgument((position >= 0 && position <= stages.size() ? 1 : 0) != 0, (String)"Stage index out of bounds", (Object[])new Object[0]);
        }
        Checks.checkArgument((stages.count((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$validateStage$1(stage, x$2))) == 0 ? 1 : 0) != 0, (String)"Stage title already exists in delivery pattern", (Object[])new Object[0]);
    }

    private Option<Object> validateStage$default$3() {
        return None$.MODULE$;
    }

    private void validateTransition(Delivery pattern, Transition transition) {
        Checks.checkNotNull((Object)((Object)transition), (String)"Transition");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)transition.getTitle()), (String)"Transition title must be set", (Object[])new Object[0]);
        Checks.checkArgument((transition.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Transition title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!transition.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
        Checks.checkNotNull((Object)transition.getFromStageId(), (String)"fromStageId");
        Optional<Stage> stage = pattern.findStageByIdOrTitle(transition.getFromStageId());
        Checks.checkArgument((boolean)stage.isPresent(), (String)"From stage '%s' not found in release delivery '%s'", (Object[])new Object[]{transition.getFromStageId(), pattern.getTitle()});
        Optional<Transition> maybeExistingTransition = pattern.findTransitionFrom(stage.get());
        maybeExistingTransition.ifPresent(existingTransition -> {
            String string = existingTransition.getId();
            String string2 = transition.getId();
            Checks.checkArgument((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)"There is already a transition named '%s' associated with stage '%s'", (Object[])new Object[]{existingTransition.getTitle(), ((Stage)((Object)((Object)stage.get()))).getTitle()});
        });
        Checks.checkArgument((!pattern.isLastStage(stage.get()) ? 1 : 0) != 0, (String)"Transition can not be added to the last stage", (Object[])new Object[0]);
        transition.validate(pattern);
    }

    private void resetDelivery(Delivery delivery) {
        Date resetDate = new Date();
        String oldDeliveryId = delivery.getId();
        String newDeliveryId = this.generateId(Delivery.class, "Deliveries");
        delivery.setId(newDeliveryId);
        delivery.getTransitions().forEach(transition -> transition.setId(transition.getId().replace(oldDeliveryId, newDeliveryId)));
        delivery.getStages().forEach(stage -> {
            String newStageId = stage.getId().replace(oldDeliveryId, newDeliveryId);
            delivery.findTransitionFrom((Stage)((Object)stage)).ifPresent(transition -> transition.setFromStageId(newStageId));
            stage.setId(newStageId);
        });
        delivery.getTrackedItems().forEach(item -> {
            item.setId(this.generateId(TrackedItem.class, newDeliveryId));
            item.setCreatedDate(resetDate);
            item.setModifiedDate(resetDate);
        });
    }

    private boolean alreadyExistsByTitle(String patternTitle, String patternId) {
        DeliveryPatternFilters filters = new DeliveryPatternFilters();
        filters.withTitle(patternTitle);
        filters.withStrictTitleMatch(true);
        return this.deliveryRepository().searchIds(filters).exists((Function1 & Serializable & scala.Serializable)deliveryId -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$alreadyExistsByTitle$1(patternId, deliveryId)));
    }

    private String alreadyExistsByTitle$default$2() {
        return null;
    }

    private String generateId(Class<? extends ConfigurationItem> ciClass, String parentId) {
        return this.ciIdService().getUniqueId(Type.valueOf(ciClass), parentId);
    }

    @Override
    public void checkIsUpdatable(Delivery existingDelivery, String action) {
        existingDelivery.isTemplate();
    }

    public static final /* synthetic */ void $anonfun$createDeliveryFromPattern$2(DeliveryPatternService $this, XLReleaseEvent x$1) {
        $this.eventBus().publish(x$1);
    }

    public static final /* synthetic */ void $anonfun$deleteStage$3(Delivery pattern$2, Stage x$1) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(pattern$2.findTransitionFrom(x$1)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Transition transition = (Transition)((Object)some.value());
            pattern$2.removeTransition(transition);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateStage$1(Stage stage$2, Stage x$2) {
        String string = x$2.getTitle();
        String string2 = stage$2.getTitle();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$alreadyExistsByTitle$1(String patternId$10, String deliveryId) {
        String string = Ids.getName((String)deliveryId);
        String string2 = Ids.getName((String)patternId$10);
        return string == null ? string2 != null : !string.equals(string2);
    }

    @Autowired
    public DeliveryPatternService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        DeliveryServiceUtils.$init$(this);
    }
}

