/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.ApiService;
import com.xebialabs.xlrelease.api.v1.forms.CreateDelivery;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryPatternFilters;
import com.xebialabs.xlrelease.api.v1.forms.ValidatePattern;
import com.xebialabs.xlrelease.delivery.DeliveryUtils;
import com.xebialabs.xlrelease.delivery.actors.DeliveryActorService;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.domain.Stage;
import com.xebialabs.xlrelease.delivery.domain.TrackedItem;
import com.xebialabs.xlrelease.delivery.domain.Transition;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissionChecker;
import com.xebialabs.xlrelease.delivery.service.DeliveryPatternService;
import com.xebialabs.xlrelease.delivery.service.DeliveryTrackingService;
import com.xebialabs.xlrelease.repository.Page;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/api/v1/delivery-patterns")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Controller
@ShowOnlyPublicApiMembers
public class DeliveryPatternApi
implements ApiService {
    private final DeliveryActorService deliveryActorService;
    private final DeliveryPatternService deliveryPatternService;
    private final DeliveryTrackingService deliveryTrackingService;
    private final DeliveryPermissionChecker permissions;

    @Autowired
    public DeliveryPatternApi(DeliveryActorService deliveryActorService, DeliveryPatternService deliveryPatternService, DeliveryTrackingService deliveryTrackingService, DeliveryPermissionChecker permissions) {
        this.deliveryActorService = deliveryActorService;
        this.deliveryPatternService = deliveryPatternService;
        this.deliveryTrackingService = deliveryTrackingService;
        this.permissions = permissions;
    }

    public String serviceName() {
        return "deliveryPatternApi";
    }

    @GET
    @Path(value="/{patternId:.*Delivery[^/]*}")
    @Timed
    public Delivery getPattern(@PathParam(value="patternId") String patternId) {
        this.permissions.checkViewDeliveryPattern(patternId);
        return this.deliveryPatternService.getPattern(patternId);
    }

    @GET
    @Path(value="/{patternIdOrTitle}")
    @PublicApiMember
    @Timed
    public Delivery getPatternByIdOrTitle(@PathParam(value="patternIdOrTitle") String patternIdOrTitle) {
        Delivery pattern = this.deliveryPatternService.getPatternByIdOrTitle(patternIdOrTitle);
        this.permissions.checkViewDeliveryPattern(pattern.getId());
        return pattern;
    }

    @POST
    @Path(value="/checkTitle")
    @PublicApiMember
    @Timed
    public boolean checkTitleUnique(ValidatePattern validation) {
        return !this.deliveryPatternService.existsPatternWithTitle(validation.getId(), validation.getTitle());
    }

    @POST
    @Timed
    public Delivery createPattern(Delivery pattern) {
        Checks.checkNotNull((Object)((Object)pattern), (String)"pattern");
        Checks.checkNotNull((Object)pattern.getFolderId(), (String)"pattern.folderId");
        this.permissions.checkEditDeliveryPattern(pattern);
        return this.deliveryPatternService.createDeliveryPattern(pattern);
    }

    @PUT
    @Path(value="/{patternId:.*Delivery[^/]*}")
    @Timed
    public Delivery updatePattern(@PathParam(value="patternId") String patternId, Delivery pattern) {
        this.permissions.checkEditDeliveryPattern(patternId);
        return this.deliveryActorService.updatePattern(pattern);
    }

    @DELETE
    @Path(value="/{patternId:.*Delivery[^/]*}")
    @Timed
    public void deletePattern(@PathParam(value="patternId") String patternId) {
        this.permissions.checkEditDeliveryPattern(patternId);
        this.deliveryActorService.deletePattern(patternId);
    }

    @POST
    @Path(value="/{patternId:.*Delivery[^/]*}/duplicate")
    @Timed
    public Delivery duplicatePattern(@PathParam(value="patternId") String patternId) {
        this.permissions.checkEditDeliveryPattern(patternId);
        return this.deliveryActorService.duplicatePattern(patternId);
    }

    @POST
    @Path(value="/{patternId:.*Delivery[^/]*}/create")
    @Timed
    public Delivery createDeliveryFromPattern(@PathParam(value="patternId") String patternId, CreateDelivery createDelivery) {
        Checks.checkNotNull((Object)createDelivery, (String)"createDelivery");
        Checks.checkNotNull((Object)createDelivery.getFolderId(), (String)"createDelivery.folderId");
        this.permissions.checkEditDelivery(patternId);
        return this.deliveryActorService.createDeliveryFromPattern(patternId, createDelivery);
    }

    @POST
    @Path(value="search")
    @PublicApiMember
    @Timed
    public List<Delivery> searchPatterns(DeliveryPatternFilters filters, @DefaultValue(value="0") @QueryParam(value="page") Long page, @DefaultValue(value="100") @QueryParam(value="resultsPerPage") Long resultsPerPage) {
        Checks.checkArgument((resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than 100", (Object[])new Object[0]);
        if (null == filters) {
            filters = new DeliveryPatternFilters();
        }
        return this.deliveryPatternService.searchPatterns(filters, Page.parse(Optional.ofNullable(page), Optional.ofNullable(resultsPerPage), Optional.empty()));
    }

    @GET
    @Path(value="/{patternId:.*Delivery[^/]*}/stages")
    @PublicApiMember
    @Timed
    public List<Stage> getStages(@PathParam(value="patternId") String patternId) {
        this.permissions.checkViewDeliveryPattern(patternId);
        return this.deliveryPatternService.getStages(patternId);
    }

    @POST
    @Path(value="/{patternId:.*Delivery[^/]*}/stages")
    @PublicApiMember
    @Timed
    public Stage addStage(@PathParam(value="patternId") String patternId, Stage stage, @QueryParam(value="position") Integer position) {
        this.permissions.checkEditDeliveryPattern(patternId);
        return this.deliveryActorService.addStage(patternId, stage, position);
    }

    @PUT
    @Path(value="/{stageId:.*Stage[^/]*}")
    @PublicApiMember
    @Timed
    public Stage updateStage(@PathParam(value="stageId") String stageId, Stage stage) {
        stage.setId(stageId);
        String patternId = DeliveryUtils.deliveryIdFrom(stageId);
        this.permissions.checkEditDeliveryPattern(patternId);
        return this.deliveryActorService.updateStage(patternId, stage);
    }

    @DELETE
    @Path(value="/{stageId:.*Stage[^/]*}")
    @PublicApiMember
    @Timed
    public void deleteStage(@PathParam(value="stageId") String stageId) {
        String patternId = DeliveryUtils.deliveryIdFrom(stageId);
        this.permissions.checkEditDeliveryPattern(patternId);
        this.deliveryActorService.deleteStage(patternId, stageId);
    }

    @GET
    @Path(value="/{patternId:.*Delivery[^/]*}/transitions")
    @PublicApiMember
    @Timed
    public List<Transition> getTransitions(@PathParam(value="patternId") String patternId) {
        this.permissions.checkViewDeliveryPattern(patternId);
        return this.deliveryPatternService.getTransitions(patternId);
    }

    @POST
    @Path(value="/{patternId:.*Delivery[^/]*}/transitions")
    @PublicApiMember
    @Timed
    public Transition addTransition(@PathParam(value="patternId") String patternId, Transition transition) {
        this.permissions.checkEditDeliveryPattern(patternId);
        return this.deliveryActorService.addTransition(patternId, transition);
    }

    @PUT
    @Path(value="/{transitionId:.*Transition[^/]*}")
    @PublicApiMember
    @Timed
    public Transition updateTransition(@PathParam(value="transitionId") String transitionId, Transition transition) {
        transition.setId(transitionId);
        String patternId = DeliveryUtils.deliveryIdFrom(transitionId);
        this.permissions.checkEditDeliveryPattern(patternId);
        return this.deliveryActorService.updateTransition(patternId, transition);
    }

    @DELETE
    @Path(value="/{transitionId:.*Transition[^/]*}")
    @PublicApiMember
    @Timed
    public void deleteTransition(@PathParam(value="transitionId") String transitionId) {
        String patternId = DeliveryUtils.deliveryIdFrom(transitionId);
        this.permissions.checkEditDeliveryPattern(patternId);
        this.deliveryActorService.deleteTransition(patternId, transitionId);
    }

    @GET
    @Path(value="/{patternId:.*Delivery[^/]*}/tracked-items")
    @PublicApiMember
    @Timed
    public List<TrackedItem> getTrackedItems(@PathParam(value="patternId") String patternId) {
        this.permissions.checkViewDeliveryPattern(patternId);
        return this.deliveryTrackingService.getTrackedItems(patternId);
    }

    @POST
    @Path(value="/{patternId:.*Delivery[^/]*}/tracked-items")
    @PublicApiMember
    @Timed
    public TrackedItem createTrackedItem(@PathParam(value="patternId") String patternId, TrackedItem item) {
        this.permissions.checkEditDeliveryPattern(patternId);
        return this.deliveryActorService.createTrackedItem(patternId, item);
    }

    @PUT
    @Path(value="/{itemId:.*TrackedItem[^/]*}")
    @PublicApiMember
    @Timed
    public TrackedItem updateTrackedItem(@PathParam(value="itemId") String itemId, TrackedItem item) {
        item.setId(itemId);
        String patternId = DeliveryUtils.deliveryIdFrom(itemId);
        this.permissions.checkEditDeliveryPattern(patternId);
        return this.deliveryActorService.updateTrackedItem(patternId, item);
    }

    @DELETE
    @Path(value="/{itemId:.*TrackedItem[^/]*}")
    @PublicApiMember
    @Timed
    public void deleteTrackedItem(@PathParam(value="itemId") String itemId) {
        String patternId = DeliveryUtils.deliveryIdFrom(itemId);
        this.permissions.checkEditDeliveryPattern(patternId);
        this.deliveryActorService.deleteTrackedItem(patternId, itemId);
    }
}

