/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.actors;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.cluster.sharding.ClusterSharding;
import akka.cluster.sharding.ClusterSharding$;
import akka.cluster.sharding.ClusterShardingSettings;
import akka.cluster.sharding.ClusterShardingSettings$;
import akka.cluster.sharding.ShardRegion;
import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.delivery.actors.DeliveryActor;
import com.xebialabs.xlrelease.delivery.actors.DeliveryActor$;
import com.xebialabs.xlrelease.delivery.actors.DeliveryActorHolder;
import com.xebialabs.xlrelease.delivery.actors.DeliveryActorInitializer;
import com.xebialabs.xlrelease.delivery.actors.package$;
import com.xebialabs.xlrelease.delivery.service.DeliveryPatternService;
import com.xebialabs.xlrelease.delivery.service.DeliveryService;
import com.xebialabs.xlrelease.delivery.service.DeliveryTrackingService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@Profile(value={"full"})
@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001\u0002\n\u0014\u0001yA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0011!\t\u0005A!A!\u0002\u0013\u0011\u0005\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u000b%\u0003A\u0011\u0001&\t\u000b\u0005\u0004A\u0011\u00022\t\u000f-\u0004!\u0019!C\u0005Y\"1\u0001\u000f\u0001Q\u0001\n5Dq!\u001d\u0001C\u0002\u0013%!\u000f\u0003\u0004|\u0001\u0001\u0006Ia\u001d\u0005\u0006y\u0002!\t! \u0005\b\u0003\u0007\u0001A\u0011BA\u0003\u0011\u001d\t)\u0002\u0001C\u0005\u0003/Aq!a\b\u0001\t\u0013\t\t\u0003C\u0004\u0002>\u0001!\t%a\u0010\u0003W\rcWo\u001d;fe\u0016$G)\u001a7jm\u0016\u0014\u0018\u0010\u0015:pG\u0016\u001c8/\u001b8h\u0003\u000e$xN]%oSRL\u0017\r\\5{KJT!\u0001F\u000b\u0002\r\u0005\u001cGo\u001c:t\u0015\t1r#\u0001\u0005eK2Lg/\u001a:z\u0015\tA\u0012$A\u0005yYJ,G.Z1tK*\u0011!dG\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001H\u0001\u0004G>l7\u0001A\n\u0004\u0001})\u0003C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g\r\u0005\u0002'O5\t1#\u0003\u0002)'\tAB)\u001a7jm\u0016\u0014\u00180Q2u_JLe.\u001b;jC2L'0\u001a:\u0002\u0013ad'oQ8oM&<\u0007CA\u0016/\u001b\u0005a#BA\u0017\u0018\u0003\u0019\u0019wN\u001c4jO&\u0011q\u0006\f\u0002\n12\u00148i\u001c8gS\u001e\fAb]=ti\u0016l\u0007j\u001c7eKJ\u0004\"A\r\u001b\u000e\u0003MR!\u0001F\f\n\u0005U\u001a$!E!di>\u00148+_:uK6Du\u000e\u001c3fe\u0006yA-\u001a7jm\u0016\u0014\u0018pU3sm&\u001cW\r\u0005\u00029w5\t\u0011H\u0003\u0002;+\u000591/\u001a:wS\u000e,\u0017B\u0001\u001f:\u0005=!U\r\\5wKJL8+\u001a:wS\u000e,\u0017A\u00063fY&4XM]=QCR$XM\u001d8TKJ4\u0018nY3\u0011\u0005az\u0014B\u0001!:\u0005Y!U\r\\5wKJL\b+\u0019;uKJt7+\u001a:wS\u000e,\u0017a\u00063fY&4XM]=Ue\u0006\u001c7.\u001b8h'\u0016\u0014h/[2f!\tA4)\u0003\u0002Es\t9B)\u001a7jm\u0016\u0014\u0018\u0010\u0016:bG.LgnZ*feZL7-Z\u0001\u0014I\u0016d\u0017N^3ss\u0006\u001bGo\u001c:I_2$WM\u001d\t\u0003M\u001dK!\u0001S\n\u0003'\u0011+G.\u001b<fef\f5\r^8s\u0011>dG-\u001a:\u0002\rqJg.\u001b;?)\u001dYE*\u0014(P!F\u0003\"A\n\u0001\t\u000b%:\u0001\u0019\u0001\u0016\t\u000bA:\u0001\u0019A\u0019\t\u000bY:\u0001\u0019A\u001c\t\u000bu:\u0001\u0019\u0001 \t\u000b\u0005;\u0001\u0019\u0001\"\t\u000b\u0015;\u0001\u0019\u0001$)\u0005\u001d\u0019\u0006C\u0001+`\u001b\u0005)&B\u0001,X\u0003)\tgN\\8uCRLwN\u001c\u0006\u00031f\u000bqAZ1di>\u0014\u0018P\u0003\u0002[7\u0006)!-Z1og*\u0011A,X\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\ta,A\u0002pe\u001eL!\u0001Y+\u0003\u0013\u0005+Ho\\<je\u0016$\u0017AB:zgR,W.F\u0001d!\t!\u0017.D\u0001f\u0015\t1w-A\u0003bGR|'OC\u0001i\u0003\u0011\t7n[1\n\u0005),'aC!di>\u00148+_:uK6\faB\\;nE\u0016\u0014xJZ*iCJ$7/F\u0001n!\t\u0001c.\u0003\u0002pC\t\u0019\u0011J\u001c;\u0002\u001f9,XNY3s\u001f\u001a\u001c\u0006.\u0019:eg\u0002\n\u0001c\u001d5be\u0012LgnZ*fiRLgnZ:\u0016\u0003M\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\u0011MD\u0017M\u001d3j]\u001eT!\u0001_4\u0002\u000f\rdWo\u001d;fe&\u0011!0\u001e\u0002\u0018\u00072,8\u000f^3s'\"\f'\u000fZ5oON+G\u000f^5oON\f\u0011c\u001d5be\u0012LgnZ*fiRLgnZ:!\u0003U\u0019H/\u0019:u\t\u0016d\u0017N^3ssNC\u0017M\u001d3j]\u001e$\u0012A \t\u0003I~L1!!\u0001f\u0005!\t5\r^8s%\u00164\u0017!E3yiJ\f7\r\u001e#fY&4XM]=JIV\u0011\u0011q\u0001\t\u0005\u0003\u0013\tyAD\u0002u\u0003\u0017I1!!\u0004v\u0003-\u0019\u0006.\u0019:e%\u0016<\u0017n\u001c8\n\t\u0005E\u00111\u0003\u0002\u0010\u000bb$(/Y2u\u000b:$\u0018\u000e^=JI*\u0019\u0011QB;\u0002-\u0015DHO]1di\u0012+G.\u001b<fef\u001c\u0006.\u0019:e\u0013\u0012,\"!!\u0007\u0011\t\u0005%\u00111D\u0005\u0005\u0003;\t\u0019B\u0001\bFqR\u0014\u0018m\u0019;TQ\u0006\u0014H-\u00133\u0002\u001d\u0015DHO]1diNC\u0017M\u001d3JIR!\u00111EA\u001d!\u0011\t)#a\r\u000f\t\u0005\u001d\u0012q\u0006\t\u0004\u0003S\tSBAA\u0016\u0015\r\ti#H\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005E\u0012%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003k\t9D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003c\t\u0003bBA\u001e!\u0001\u0007\u00111E\u0001\u0003S\u0012\f!\"\u001b8ji&\fG.\u001b>f)\t\t\t\u0005E\u0002!\u0003\u0007J1!!\u0012\"\u0005\u0011)f.\u001b;)\u000f\u0001\tI%a\u0016\u0002ZA!\u00111JA*\u001b\t\tiEC\u0002W\u0003\u001fR1!!\u0015\\\u0003\u001d\u0019wN\u001c;fqRLA!!\u0016\u0002N\t9\u0001K]8gS2,\u0017!\u0002<bYV,GFAA.C\t\ti&\u0001\u0003gk2d\u0007f\u0001\u0001\u0002bA!\u00111MA5\u001b\t\t)GC\u0002\u0002hm\u000b!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\tY'!\u001a\u0003\u0013\r{W\u000e]8oK:$\b")
public class ClusteredDeliveryProcessingActorInitializer
implements DeliveryActorInitializer {
    private final ActorSystemHolder systemHolder;
    private final DeliveryService deliveryService;
    private final DeliveryPatternService deliveryPatternService;
    private final DeliveryTrackingService deliveryTrackingService;
    private final DeliveryActorHolder deliveryActorHolder;
    private final int numberOfShards;
    private final ClusterShardingSettings shardingSettings;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ClusteredDeliveryProcessingActorInitializer clusteredDeliveryProcessingActorInitializer = this;
        synchronized (clusteredDeliveryProcessingActorInitializer) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    private ActorSystem system() {
        return this.systemHolder.actorSystem();
    }

    private int numberOfShards() {
        return this.numberOfShards;
    }

    private ClusterShardingSettings shardingSettings() {
        return this.shardingSettings;
    }

    public ActorRef startDeliverySharding() {
        return ((ClusterSharding)ClusterSharding$.MODULE$.apply(this.system())).start("Delivery", DeliveryActor$.MODULE$.props(true, this.deliveryService, this.deliveryPatternService, this.deliveryTrackingService), this.shardingSettings(), this.extractDeliveryId(), this.extractDeliveryShardId());
    }

    private PartialFunction<Object, Tuple2<String, Object>> extractDeliveryId() {
        return new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof DeliveryActor.DeliveryAction) {
                    DeliveryActor.DeliveryAction deliveryAction = (DeliveryActor.DeliveryAction)A1;
                    object = new Tuple2((Object)package$.MODULE$.DeliveryIdExtensions(deliveryAction.deliveryId()).deliveryActorName(), (Object)deliveryAction);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof DeliveryActor.DeliveryAction;
                return bl;
            }
        };
    }

    private Function1<Object, String> extractDeliveryShardId() {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            Object object = x0$1;
            if (object instanceof DeliveryActor.DeliveryAction) {
                DeliveryActor.DeliveryAction deliveryAction = (DeliveryActor.DeliveryAction)object;
                string = this.extractShardId(deliveryAction.deliveryId());
            } else if (object instanceof ShardRegion.StartEntity) {
                ShardRegion.StartEntity startEntity = (ShardRegion.StartEntity)object;
                String id = startEntity.entityId();
                string = this.extractShardId(id);
            } else {
                throw new MatchError(object);
            }
            return string;
        };
    }

    private String extractShardId(String id) {
        return ((Object)BoxesRunTime.boxToInteger((int)(scala.math.package$.MODULE$.abs(package$.MODULE$.DeliveryIdExtensions(id).deliveryActorName().hashCode()) % this.numberOfShards()))).toString();
    }

    public void initialize() {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> "Initializing clustered delivery processing actor...");
        ActorRef shardRegion = this.startDeliverySharding();
        this.deliveryActorHolder.resolveActorRef(shardRegion);
    }

    @Autowired
    public ClusteredDeliveryProcessingActorInitializer(XlrConfig xlrConfig, ActorSystemHolder systemHolder, DeliveryService deliveryService, DeliveryPatternService deliveryPatternService, DeliveryTrackingService deliveryTrackingService, DeliveryActorHolder deliveryActorHolder) {
        this.systemHolder = systemHolder;
        this.deliveryService = deliveryService;
        this.deliveryPatternService = deliveryPatternService;
        this.deliveryTrackingService = deliveryTrackingService;
        this.deliveryActorHolder = deliveryActorHolder;
        Logging.$init$((Logging)this);
        this.numberOfShards = xlrConfig.sharding().numberOfReleaseShards();
        this.shardingSettings = ClusterShardingSettings$.MODULE$.apply(this.system());
    }
}

