/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.events.DeliveryDeletedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryUpdatedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ega\u0002\u000e\u001c!\u0003\r\tA\n\u0005\u0006k\u0001!\tA\u000e\u0005\bu\u0001\u0011\rQ\"\u0001<\u0011\u001d\u0011\u0005A1A\u0007\u0002\rCqA\u0013\u0001C\u0002\u001b\u00051\nC\u0004R\u0001\t\u0007i\u0011\u0001*\t\u000fe\u0003!\u0019!D\u00015\"9a\f\u0001b\u0001\u000e\u0003y\u0006\"\u00025\u0001\r#I\u0007\u0002C@\u0001#\u0003%\t\"!\u0001\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0002bBA\u001e\u0001\u0011E\u0011Q\b\u0005\b\u0003\u0007\u0002A\u0011CA#\u0011\u001d\tI\u0005\u0001C\t\u0003\u0017Bq!a\u0014\u0001\t#\t\t\u0006C\u0004\u0002V\u0001!\t\"a\u0016\t\u000f\u0005m\u0003\u0001\"\u0005\u0002^!9\u0011\u0011\u000f\u0001\u0005\u0012\u0005M\u0004bBAC\u0001\u0011E\u0011q\u0011\u0005\n\u0003[\u0003\u0011\u0013!C\t\u0003_C\u0011\"a-\u0001#\u0003%\t\"!.\t\u0013\u0005e\u0006!%A\u0005\u0012\u0005U\u0006bBA^\u0001\u0011%\u0011Q\u0018\u0005\n\u0003\u0017\u0004\u0011\u0013!C\u0005\u0003_Cq!!4\u0001\t\u0013\tyM\u0001\u000bEK2Lg/\u001a:z'\u0016\u0014h/[2f+RLGn\u001d\u0006\u00039u\tqa]3sm&\u001cWM\u0003\u0002\u001f?\u0005AA-\u001a7jm\u0016\u0014\u0018P\u0003\u0002!C\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003E\r\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0011\n1aY8n\u0007\u0001\u00192\u0001A\u0014.!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fMB\u0011afM\u0007\u0002_)\u0011\u0001'M\u0001\u0006g24GG\u001b\u0006\u0002e\u0005AqM]5{u2,G-\u0003\u00025_\t9Aj\\4hS:<\u0017A\u0002\u0013j]&$H\u0005F\u00018!\tA\u0003(\u0003\u0002:S\t!QK\\5u\u0003I!W\r\\5wKJL(+\u001a9pg&$xN]=\u0016\u0003q\u0002\"!\u0010!\u000e\u0003yR!aP\u000f\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002B}\t\u0011B)\u001a7jm\u0016\u0014\u0018PU3q_NLGo\u001c:z\u0003!)g/\u001a8u\u0005V\u001cX#\u0001#\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d{\u0012AB3wK:$8/\u0003\u0002J\r\n\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\u0002\u001dI,G.Z1tKN+'O^5dKV\tA\n\u0005\u0002N\u001f6\taJ\u0003\u0002\u001d?%\u0011\u0001K\u0014\u0002\u000f%\u0016dW-Y:f'\u0016\u0014h/[2f\u0003A\t'o\u00195jm\u0016$'+\u001a7fCN,7/F\u0001T!\t!v+D\u0001V\u0015\t1v$\u0001\u0002eE&\u0011\u0001,\u0016\u0002\u0011\u0003J\u001c\u0007.\u001b<fIJ+G.Z1tKN\fQBZ8mI\u0016\u00148+\u001a:wS\u000e,W#A.\u0011\u00055c\u0016BA/O\u000551u\u000e\u001c3feN+'O^5dK\u0006Y!o\u001c7f'\u0016\u0014h/[2f+\u0005\u0001\u0007CA1g\u001b\u0005\u0011'BA2e\u0003!\u0019XmY;sSRL(BA3\"\u0003!!W\r\u001d7ps&$\u0018BA4c\u0005-\u0011v\u000e\\3TKJ4\u0018nY3\u0002!\rDWmY6JgV\u0003H-\u0019;bE2,GcA\u001cke\")1\u000e\u0003a\u0001Y\u0006\u0001R\r_5ti&tw\rR3mSZ,'/\u001f\t\u0003[Bl\u0011A\u001c\u0006\u0003_v\ta\u0001Z8nC&t\u0017BA9o\u0005!!U\r\\5wKJL\bbB:\t!\u0003\u0005\r\u0001^\u0001\u0007C\u000e$\u0018n\u001c8\u0011\u0005UdhB\u0001<{!\t9\u0018&D\u0001y\u0015\tIX%\u0001\u0004=e>|GOP\u0005\u0003w&\na\u0001\u0015:fI\u00164\u0017BA?\u007f\u0005\u0019\u0019FO]5oO*\u001110K\u0001\u001bG\",7m[%t+B$\u0017\r^1cY\u0016$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0007Q3\u0001^A\u0003W\t\t9\u0001\u0005\u0003\u0002\n\u0005MQBAA\u0006\u0015\u0011\ti!a\u0004\u0002\u0013Ut7\r[3dW\u0016$'bAA\tS\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00111\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001F4fi\u0012+G.\u001b<fef|%\u000fU1ui\u0016\u0014h\u000eF\u0002m\u00037Aa!!\b\u000b\u0001\u0004!\u0018A\u00033fY&4XM]=JI\"\u001a!\"!\t\u0011\t\u0005\r\u0012qF\u0007\u0003\u0003KQA!!\u0005\u0002()!\u0011\u0011FA\u0016\u0003\u001diW\r\u001e:jGNT1!!\f$\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA\u0019\u0003K\u0011Q\u0001V5nK\u0012\f1bZ3u\r>dG-\u001a:JIR\u0019A/a\u000e\t\r\u0005u1\u00021\u0001uQ\rY\u0011\u0011E\u0001\tI>,\u0006\u000fZ1uKR\u0019A.a\u0010\t\r\u0005\u0005C\u00021\u0001m\u0003\u001d)\b\u000fZ1uK\u0012\f\u0001\u0002Z8EK2,G/\u001a\u000b\u0004o\u0005\u001d\u0003BBA\u000f\u001b\u0001\u0007A/\u0001\u0005wC2LG-\u0019;f)\r9\u0014Q\n\u0005\u0006=9\u0001\r\u0001\\\u0001\u0011m\u0006d\u0017\u000eZ1uK\u0012+G.\u001b<fef$2aNA*\u0011\u0015qr\u00021\u0001m\u0003=\u0019\u0007.Z2l\u0013N$U\r\\5wKJLHcA\u001c\u0002Z!)a\u0004\u0005a\u0001Y\u0006\t2-\u001e:sK:$\bK]5oG&\u0004\u0018\r\\:\u0016\u0005\u0005}\u0003#BA1\u0003W\"h\u0002BA2\u0003Or1a^A3\u0013\u0005Q\u0013bAA5S\u00059\u0001/Y2lC\u001e,\u0017\u0002BA7\u0003_\u0012\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003SJ\u0013AD2veJ,g\u000e\u001e*pY\u0016LEm]\u000b\u0003\u0003k\u0002R!a\u001e\u0002\u0002Rl!!!\u001f\u000b\t\u0005m\u0014QP\u0001\b[V$\u0018M\u00197f\u0015\r\ty(K\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAB\u0003s\u0012aAQ;gM\u0016\u0014\u0018!F2p[B,H/Z!oIV\u0003H-\u0019;f\t\u0006$Xm\u001d\u000b\no\u0005%\u00151RAK\u0003SCQAH\nA\u00021D\u0011\"!$\u0014!\u0003\u0005\r!a$\u0002\u0017\u0011,(/\u0019;j_:|\u0005\u000f\u001e\t\u0004Q\u0005E\u0015bAAJS\t\u0019\u0011J\u001c;\t\u0013\u0005]5\u0003%AA\u0002\u0005e\u0015\u0001D:uCJ$H)\u0019;f\u001fB$\b\u0003BAN\u0003Kk!!!(\u000b\t\u0005}\u0015\u0011U\u0001\u0005kRLGN\u0003\u0002\u0002$\u0006!!.\u0019<b\u0013\u0011\t9+!(\u0003\t\u0011\u000bG/\u001a\u0005\n\u0003W\u001b\u0002\u0013!a\u0001\u00033\u000b!\"\u001a8e\t\u0006$Xm\u00149u\u0003}\u0019w.\u001c9vi\u0016\fe\u000eZ+qI\u0006$X\rR1uKN$C-\u001a4bk2$HEM\u000b\u0003\u0003cSC!a$\u0002\u0006\u0005y2m\\7qkR,\u0017I\u001c3Va\u0012\fG/\u001a#bi\u0016\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005]&\u0006BAM\u0003\u000b\tqdY8naV$X-\u00118e+B$\u0017\r^3ECR,7\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003I\u0019\u0017\r\\2vY\u0006$Xm\u0014;iKJ$\u0015\r^3\u0015\u0011\u0005e\u0015qXAb\u0003\u000fDq!!1\u0018\u0001\u0004\tI*\u0001\u0003eCR,\u0007bBAc/\u0001\u0007\u0011qR\u0001\tIV\u0014\u0018\r^5p]\"I\u0011\u0011Z\f\u0011\u0002\u0003\u0007\u0011qR\u0001\tC\u0012$\u0017\u000e^5p]\u0006a2-\u00197dk2\fG/Z(uQ\u0016\u0014H)\u0019;fI\u0011,g-Y;mi\u0012\u001a\u0014!E2bY\u000e,H.\u0019;f\tV\u0014\u0018\r^5p]R1\u0011qRAi\u0003+Dq!a5\u001a\u0001\u0004\tI*A\u0005ti\u0006\u0014H\u000fR1uK\"9\u0011q[\rA\u0002\u0005e\u0015aB3oI\u0012\u000bG/\u001a")
public interface DeliveryServiceUtils
extends Logging {
    public DeliveryRepository deliveryRepository();

    public XLReleaseEventBus eventBus();

    public ReleaseService releaseService();

    public ArchivedReleases archivedReleases();

    public FolderService folderService();

    public RoleService roleService();

    public void checkIsUpdatable(Delivery var1, String var2);

    public static /* synthetic */ String checkIsUpdatable$default$2$(DeliveryServiceUtils $this) {
        return $this.checkIsUpdatable$default$2();
    }

    default public String checkIsUpdatable$default$2() {
        return "update";
    }

    public static /* synthetic */ Delivery getDeliveryOrPattern$(DeliveryServiceUtils $this, String deliveryId) {
        return $this.getDeliveryOrPattern(deliveryId);
    }

    @Timed
    default public Delivery getDeliveryOrPattern(String deliveryId) {
        return this.deliveryRepository().read(deliveryId);
    }

    public static /* synthetic */ String getFolderId$(DeliveryServiceUtils $this, String deliveryId) {
        return $this.getFolderId(deliveryId);
    }

    @Timed
    default public String getFolderId(String deliveryId) {
        return this.deliveryRepository().findFolderId(deliveryId);
    }

    public static /* synthetic */ Delivery doUpdate$(DeliveryServiceUtils $this, Delivery updated) {
        return $this.doUpdate(updated);
    }

    /*
     * WARNING - void declaration
     */
    default public Delivery doUpdate(Delivery updated) {
        void var2_2;
        Delivery original = this.deliveryRepository().read(updated.getId());
        this.checkIsUpdatable(original, this.checkIsUpdatable$default$2());
        original.setTitle(updated.getTitle());
        original.setDescription(updated.getDescription());
        this.computeAndUpdateDates(original, Predef$.MODULE$.Integer2int(updated.getPlannedDuration()), updated.getStartDate(), updated.getEndDate());
        if (Strings.isNotBlank((String)updated.getFolderId())) {
            original.setFolderId(updated.getFolderId());
        }
        this.deliveryRepository().update(original);
        this.eventBus().publish((XLReleaseEvent)new DeliveryUpdatedEvent(original));
        return var2_2;
    }

    public static /* synthetic */ void doDelete$(DeliveryServiceUtils $this, String deliveryId) {
        $this.doDelete(deliveryId);
    }

    default public void doDelete(String deliveryId) {
        if (this.deliveryRepository().exists(deliveryId)) {
            Delivery delivery = this.deliveryRepository().read(deliveryId);
            this.checkIsUpdatable(delivery, "delete");
            this.deliveryRepository().delete(deliveryId);
            this.eventBus().publish((XLReleaseEvent)new DeliveryDeletedEvent(delivery));
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Release delivery [").append(deliveryId).append("] already deleted").toString());
        }
    }

    public static /* synthetic */ void validate$(DeliveryServiceUtils $this, Delivery delivery) {
        $this.validate(delivery);
    }

    default public void validate(Delivery delivery) {
        block0: {
            Checks.checkNotNull((Object)((Object)delivery), (String)"Release delivery");
            Checks.checkArgument((boolean)Strings.isNotBlank((String)delivery.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
            Checks.checkArgument((delivery.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Title must be 255 characters or less", (Object[])new Object[0]);
            Checks.checkArgument((!delivery.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
            Checks.checkArgument((boolean)Strings.isNotBlank((String)delivery.getFolderId()), (String)"Folder ID must be set", (Object[])new Object[0]);
            Checks.checkArgument((!Ids.isRoot((String)delivery.getFolderId()) ? 1 : 0) != 0, (String)new StringBuilder(47).append("Provided folder ID '").append(delivery.getFolderId()).append("' must not be a root folder").toString(), (Object[])new Object[0]);
            Checks.checkArgument((boolean)this.folderService().exists(delivery.getFolderId()), (String)new StringBuilder(48).append("Provided folder ID '").append(delivery.getFolderId()).append("' must exist in the database").toString(), (Object[])new Object[0]);
            if (!Strings.isNotEmpty((String)delivery.getDescription())) break block0;
            Checks.checkArgument((delivery.getDescription().length() < 1024 ? 1 : 0) != 0, (String)"Description must be 1024 characters or less", (Object[])new Object[0]);
        }
    }

    public static /* synthetic */ void validateDelivery$(DeliveryServiceUtils $this, Delivery delivery) {
        $this.validateDelivery(delivery);
    }

    default public void validateDelivery(Delivery delivery) {
        this.validate(delivery);
        this.checkIsDelivery(delivery);
        Checks.checkArgument((delivery.getStartDate() != null ? 1 : 0) != 0, (String)"Start date must be set", (Object[])new Object[0]);
        Checks.checkArgument((delivery.getEndDate() != null ? 1 : 0) != 0, (String)"End date must be set", (Object[])new Object[0]);
        Checks.checkArgument((boolean)delivery.getEndDate().after(delivery.getStartDate()), (String)"End date must be after start date", (Object[])new Object[0]);
    }

    public static /* synthetic */ void checkIsDelivery$(DeliveryServiceUtils $this, Delivery delivery) {
        $this.checkIsDelivery(delivery);
    }

    default public void checkIsDelivery(Delivery delivery) {
        Checks.checkArgument((!delivery.isTemplate() ? 1 : 0) != 0, (String)new StringBuilder(19).append(delivery.getId()).append(" must be a Delivery").toString(), (Object[])new Object[0]);
    }

    public static /* synthetic */ Iterable currentPrincipals$(DeliveryServiceUtils $this) {
        return $this.currentPrincipals();
    }

    default public Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    public static /* synthetic */ Buffer currentRoleIds$(DeliveryServiceUtils $this) {
        return $this.currentRoleIds();
    }

    default public Buffer<String> currentRoleIds() {
        return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService().getRolesFor(Permissions.getAuthentication())).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Buffer$.MODULE$.canBuildFrom());
    }

    public static /* synthetic */ void computeAndUpdateDates$(DeliveryServiceUtils $this, Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        $this.computeAndUpdateDates(delivery, durationOpt, startDateOpt, endDateOpt);
    }

    default public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        Tuple3 tuple3;
        Tuple3 tuple32;
        Function1 & Serializable & scala.Serializable isNotEmptyDate = (Function1 & Serializable & scala.Serializable)date -> BoxesRunTime.boxToBoolean((boolean)DeliveryServiceUtils.$anonfun$computeAndUpdateDates$1(date));
        int plannedDuration = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)durationOpt)).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> x$3 > 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Integer2int(delivery.getPlannedDuration())));
        if (BoxesRunTime.unboxToBoolean((Object)isNotEmptyDate.apply((Object)startDateOpt)) && BoxesRunTime.unboxToBoolean((Object)isNotEmptyDate.apply((Object)endDateOpt))) {
            tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.calculateDuration(startDateOpt, endDateOpt)), (Object)startDateOpt, (Object)endDateOpt);
        } else if (BoxesRunTime.unboxToBoolean((Object)isNotEmptyDate.apply((Object)startDateOpt))) {
            tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)plannedDuration), (Object)startDateOpt, (Object)this.calculateOtherDate(startDateOpt, plannedDuration, this.calculateOtherDate$default$3()));
        } else if (BoxesRunTime.unboxToBoolean((Object)isNotEmptyDate.apply((Object)endDateOpt))) {
            tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)plannedDuration), (Object)this.calculateOtherDate(endDateOpt, plannedDuration, -1), (Object)endDateOpt);
        } else {
            Date startDate = Date.from(Instant.now());
            tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)plannedDuration), (Object)startDate, (Object)this.calculateOtherDate(startDate, plannedDuration, this.calculateOtherDate$default$3()));
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int duration = BoxesRunTime.unboxToInt((Object)tuple3._1());
        Date startDate = (Date)tuple3._2();
        Date endDate = (Date)tuple3._3();
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)duration), (Object)startDate, (Object)endDate);
        Tuple3 tuple34 = tuple33;
        int duration2 = BoxesRunTime.unboxToInt((Object)tuple34._1());
        Date startDate2 = (Date)tuple34._2();
        Date endDate2 = (Date)tuple34._3();
        delivery.setPlannedDuration(Predef$.MODULE$.int2Integer(duration2));
        delivery.setStartDate(startDate2);
        delivery.setEndDate(endDate2);
    }

    public static /* synthetic */ int computeAndUpdateDates$default$2$(DeliveryServiceUtils $this) {
        return $this.computeAndUpdateDates$default$2();
    }

    default public int computeAndUpdateDates$default$2() {
        return 0;
    }

    public static /* synthetic */ Date computeAndUpdateDates$default$3$(DeliveryServiceUtils $this) {
        return $this.computeAndUpdateDates$default$3();
    }

    default public Date computeAndUpdateDates$default$3() {
        return null;
    }

    public static /* synthetic */ Date computeAndUpdateDates$default$4$(DeliveryServiceUtils $this) {
        return $this.computeAndUpdateDates$default$4();
    }

    default public Date computeAndUpdateDates$default$4() {
        return null;
    }

    private Date calculateOtherDate(Date date, int duration, int addition) {
        return duration > 0 ? DateUtils.addHours((Date)date, (int)(duration * addition)) : DateUtils.addMonths((Date)date, (int)(1 * addition));
    }

    private int calculateOtherDate$default$3() {
        return 1;
    }

    private int calculateDuration(Date startDate, Date endDate) {
        LocalDateTime localScheduledStartDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(startDate.getTime()), ZoneId.systemDefault());
        LocalDateTime localDueDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(endDate.getTime()), ZoneId.systemDefault());
        return (int)localScheduledStartDate.until(localDueDate, ChronoUnit.HOURS);
    }

    public static /* synthetic */ boolean $anonfun$computeAndUpdateDates$2(Date x$2) {
        return x$2.getTime() != 0L;
    }

    public static /* synthetic */ boolean $anonfun$computeAndUpdateDates$1(Date date) {
        return Option$.MODULE$.apply((Object)date).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeliveryServiceUtils.$anonfun$computeAndUpdateDates$2(x$2)));
    }

    public static void $init$(DeliveryServiceUtils $this) {
    }
}

