/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.api.v1.forms.CompleteTransition;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.domain.ManualTransitionTrigger;
import com.xebialabs.xlrelease.delivery.domain.Stage;
import com.xebialabs.xlrelease.delivery.domain.Subscriber;
import com.xebialabs.xlrelease.delivery.domain.SubscriptionResult;
import com.xebialabs.xlrelease.delivery.domain.TrackedItem;
import com.xebialabs.xlrelease.delivery.domain.TrackedItemStatus;
import com.xebialabs.xlrelease.delivery.domain.Transition;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.delivery.service.DeliveryTransitionHandler;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

@Service
@ScalaSignature(bytes="\u0006\u0001\tMf\u0001\u0002\u0010 \u0001)B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\"Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011!\u0001\u0006A!A!\u0002\u0013\t\u0006\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011y\u0003!\u0011!Q\u0001\n}CQa\u0019\u0001\u0005\u0002\u0011DQ\u0001 \u0001\u0005\u0002uDq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002l\u0001!\t!!\u001c\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000!9\u0011Q\u0013\u0001\u0005\u0002\u0005]\u0005bBAQ\u0001\u0011\u0005\u00111\u0015\u0005\b\u0003W\u0003A\u0011AAW\u0011\u001d\t9\f\u0001C\u0001\u0003sCq!!1\u0001\t\u0003\t\u0019\rC\u0004\u0002L\u0002!\t!!4\t\u000f\u00055\b\u0001\"\u0001\u0002p\"I!\u0011\u0003\u0001\u0012\u0002\u0013\u0005!1\u0003\u0005\b\u0005O\u0001A\u0011\u0001B\u0015\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0005kAqA!\u0010\u0001\t\u0003\u0011y\u0004C\u0004\u0003H\u0001!IA!\u0013\t\u000f\t\u0015\u0004\u0001\"\u0003\u0003h!9!Q\u000e\u0001\u0005\n\t=\u0004b\u0002BF\u0001\u0011%!Q\u0012\u0005\b\u0005+\u0003A\u0011\u0002BL\u0011\u001d\u0011i\n\u0001C\u0005\u0005?\u0013q\u0003R3mSZ,'/\u001f+sC\u000e\\\u0017N\\4TKJ4\u0018nY3\u000b\u0005\u0001\n\u0013aB:feZL7-\u001a\u0006\u0003E\r\n\u0001\u0002Z3mSZ,'/\u001f\u0006\u0003I\u0015\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005\u0019:\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005A\u0013aA2p[\u000e\u00011c\u0001\u0001,cA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1\u0011I\\=SK\u001a\u0004\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\u000bMdg\r\u000e6\u000b\u0003Y\n\u0001b\u001a:jujdW\rZ\u0005\u0003qM\u0012q\u0001T8hO&tw-\u0001\neK2Lg/\u001a:z%\u0016\u0004xn]5u_JL\bCA\u001e?\u001b\u0005a$BA\u001f\"\u0003)\u0011X\r]8tSR|'/_\u0005\u0003\u007fq\u0012!\u0003R3mSZ,'/\u001f*fa>\u001c\u0018\u000e^8ss\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0005\t#U\"A\"\u000b\u0005u\u001a\u0013BA#D\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\u000fi\u0006\u001c8NU3q_NLGo\u001c:z!\t\u0011\u0005*\u0003\u0002J\u0007\nqA+Y:l%\u0016\u0004xn]5u_JL\u0018aC2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\"\u0001\u0014(\u000e\u00035S!\u0001I\u0012\n\u0005=k%aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\f\u0001\"\u001a<f]R\u0014Uo\u001d\t\u0003%Vk\u0011a\u0015\u0006\u0003)\u000e\na!\u001a<f]R\u001c\u0018B\u0001,T\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\u0014e\u0016dW-Y:f\u0003\u000e$xN]*feZL7-\u001a\t\u00033rk\u0011A\u0017\u0006\u00037\u000e\na!Y2u_J\u001c\u0018BA/[\u0005M\u0011V\r\\3bg\u0016\f5\r^8s'\u0016\u0014h/[2f\u0003e!W\r\\5wKJLHK]1og&$\u0018n\u001c8IC:$G.\u001a:\u0011\u0005\u0001\fW\"A\u0010\n\u0005\t|\"!\u0007#fY&4XM]=Ue\u0006t7/\u001b;j_:D\u0015M\u001c3mKJ\fa\u0001P5oSRtD\u0003C3gO\"L'n\u001b7\u0011\u0005\u0001\u0004\u0001\"B\u001d\t\u0001\u0004Q\u0004\"\u0002!\t\u0001\u0004\t\u0005\"\u0002$\t\u0001\u00049\u0005\"\u0002&\t\u0001\u0004Y\u0005\"\u0002)\t\u0001\u0004\t\u0006\"B,\t\u0001\u0004A\u0006\"\u00020\t\u0001\u0004y\u0006F\u0001\u0005o!\ty'0D\u0001q\u0015\t\t(/\u0001\u0006b]:|G/\u0019;j_:T!a\u001d;\u0002\u000f\u0019\f7\r^8ss*\u0011QO^\u0001\u0006E\u0016\fgn\u001d\u0006\u0003ob\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002s\u0006\u0019qN]4\n\u0005m\u0004(!C!vi><\u0018N]3e\u0003ai\u0017M\\;bY\u000e{W\u000e\u001d7fi\u0016$&/\u00198tSRLwN\u001c\u000b\b}\u0006\r\u0011QDA\u0011!\tas0C\u0002\u0002\u00025\u0012A!\u00168ji\"9\u0011QA\u0005A\u0002\u0005\u001d\u0011A\u00033fY&4XM]=JIB!\u0011\u0011BA\f\u001d\u0011\tY!a\u0005\u0011\u0007\u00055Q&\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C\u0015\u0002\rq\u0012xn\u001c;?\u0013\r\t)\"L\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00111\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005UQ\u0006C\u0004\u0002 %\u0001\r!a\u0002\u0002\u0019Q\u0014\u0018M\\:ji&|g.\u00133\t\u000f\u0005\r\u0012\u00021\u0001\u0002&\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0011\t\u0005\u001d\u0012QG\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005)am\u001c:ng*!\u0011qFA\u0019\u0003\t1\u0018GC\u0002\u00024\r\n1!\u00199j\u0013\u0011\t9$!\u000b\u0003%\r{W\u000e\u001d7fi\u0016$&/\u00198tSRLwN\u001c\u0015\u0004\u0013\u0005m\u0002\u0003BA\u001f\u0003\u0013j!!a\u0010\u000b\u0007E\f\tE\u0003\u0003\u0002D\u0005\u0015\u0013aB7fiJL7m\u001d\u0006\u0004\u0003\u000f:\u0013\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005-\u0013q\b\u0002\u0006)&lW\rZ\u0001\u0013e\u0016<\u0017n\u001d;feN+(m]2sS\n,'\u000f\u0006\u0004\u0002R\u0005u\u0013q\f\t\u0005\u0003'\nI&\u0004\u0002\u0002V)\u0019\u0011qK\u0011\u0002\r\u0011|W.Y5o\u0013\u0011\tY&!\u0016\u0003%M+(m]2sSB$\u0018n\u001c8SKN,H\u000e\u001e\u0005\b\u0003\u000bQ\u0001\u0019AA\u0004\u0011\u001d\t\tG\u0003a\u0001\u0003G\n!b];cg\u000e\u0014\u0018NY3s!\u0011\t\u0019&!\u001a\n\t\u0005\u001d\u0014Q\u000b\u0002\u000b'V\u00147o\u0019:jE\u0016\u0014\bf\u0001\u0006\u0002<\u0005)r-\u001a;Ue\u0006\u001c7.\u001a3Ji\u0016l')\u001f+ji2,GCBA8\u0003k\n9\b\u0005\u0003\u0002T\u0005E\u0014\u0002BA:\u0003+\u00121\u0002\u0016:bG.,G-\u0013;f[\"9\u0011QA\u0006A\u0002\u0005\u001d\u0001bBA=\u0017\u0001\u0007\u0011qA\u0001\nSR,W\u000eV5uY\u0016D3aCA\u001e\u0003=9W\r\u001e+sC\u000e\\W\rZ%uK6\u001cH\u0003BAA\u0003#\u0003b!a!\u0002\u000e\u0006=TBAAC\u0015\u0011\t9)!#\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u0017\u000bAA[1wC&!\u0011qRAC\u0005\u0011a\u0015n\u001d;\t\u000f\u0005\u0015A\u00021\u0001\u0002\b!\u001aA\"a\u000f\u0002#\r\u0014X-\u0019;f)J\f7m[3e\u0013R,W\u000e\u0006\u0004\u0002p\u0005e\u00151\u0014\u0005\b\u0003\u000bi\u0001\u0019AA\u0004\u0011\u001d\ti*\u0004a\u0001\u0003_\nA!\u001b;f[\"\u001aQ\"a\u000f\u0002#U\u0004H-\u0019;f)J\f7m[3e\u0013R,W\u000e\u0006\u0004\u0002p\u0005\u0015\u0016q\u0015\u0005\b\u0003\u000bq\u0001\u0019AA\u0004\u0011\u001d\tiJ\u0004a\u0001\u0003_B3ADA\u001e\u0003E!W\r\\3uKR\u0013\u0018mY6fI&#X-\u001c\u000b\u0006}\u0006=\u0016\u0011\u0017\u0005\b\u0003\u000by\u0001\u0019AA\u0004\u0011\u001d\t\u0019l\u0004a\u0001\u0003\u000f\ta!\u001b;f[&#\u0007fA\b\u0002<\u0005\u0011B-Z:d_B,GK]1dW\u0016$\u0017\n^3n)\u0015q\u00181XA_\u0011\u001d\t)\u0001\u0005a\u0001\u0003\u000fAq!a-\u0011\u0001\u0004\t9\u0001K\u0002\u0011\u0003w\t!C]3tG>\u0004X\r\u0016:bG.,G-\u0013;f[R)a0!2\u0002H\"9\u0011QA\tA\u0002\u0005\u001d\u0001bBAZ#\u0001\u0007\u0011q\u0001\u0015\u0004#\u0005m\u0012\u0001\u0006:fO&\u001cH/\u001a:Ue\u0006\u001c7.\u001a3Ji\u0016l7\u000fF\u0004\u007f\u0003\u001f\f\t.a:\t\u000f\u0005\u0015!\u00031\u0001\u0002\b!9\u00111\u001b\nA\u0002\u0005U\u0017!B5uK6\u001c\bCBAl\u0003C\f9A\u0004\u0003\u0002Z\u0006ug\u0002BA\u0007\u00037L\u0011AL\u0005\u0004\u0003?l\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003G\f)OA\u0002TKFT1!a8.\u0011\u001d\tIO\u0005a\u0001\u0003\u000f\tQB\u001a:p[J+G.Z1tK&#\u0007f\u0001\n\u0002<\u00059R.\u0019:l)J\f7m[3e\u0013R,Wn]%o'R\fw-\u001a\u000b\u000f\u0003\u0003\u000b\t0a=\u0002x\u0006e(1\u0001B\u0003\u0011\u001d\t)a\u0005a\u0001\u0003\u000fAq!!>\u0014\u0001\u0004\t9!A\u0004ti\u0006<W-\u00133\t\u000f\u0005M7\u00031\u0001\u0002V\"9\u00111`\nA\u0002\u0005u\u0018AB:uCR,8\u000f\u0005\u0003\u0002T\u0005}\u0018\u0002\u0002B\u0001\u0003+\u0012\u0011\u0003\u0016:bG.,G-\u0013;f[N#\u0018\r^;t\u0011\u001d\tIo\u0005a\u0001\u0003\u000fA\u0011Ba\u0002\u0014!\u0003\u0005\rA!\u0003\u0002\u001fA\u0014XmY3eS:<7\u000b^1hKN\u00042\u0001\fB\u0006\u0013\r\u0011i!\f\u0002\b\u0005>|G.Z1oQ\r\u0019\u00121H\u0001\"[\u0006\u00148\u000e\u0016:bG.,G-\u0013;f[NLen\u0015;bO\u0016$C-\u001a4bk2$HEN\u000b\u0003\u0005+QCA!\u0003\u0003\u0018-\u0012!\u0011\u0004\t\u0005\u00057\u0011\u0019#\u0004\u0002\u0003\u001e)!!q\u0004B\u0011\u0003%)hn\u00195fG.,GM\u0003\u0002r[%!!Q\u0005B\u000f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0017g.L\u0007\u000f\u0016:bG.,G-\u0013;f[&s7\u000b^1hKR9aPa\u000b\u0003.\t=\u0002bBA\u0003+\u0001\u0007\u0011q\u0001\u0005\b\u0003k,\u0002\u0019AA\u0004\u0011\u001d\t\u0019,\u0006a\u0001\u0003\u000fA3!FA\u001e\u00035\u0019w.\u001c9mKR,7\u000b^1hKR)aPa\u000e\u0003:!9\u0011Q\u0001\fA\u0002\u0005\u001d\u0001bBA{-\u0001\u0007\u0011q\u0001\u0015\u0004-\u0005m\u0012a\u0003:f_B,gn\u0015;bO\u0016$RA B!\u0005\u0007Bq!!\u0002\u0018\u0001\u0004\t9\u0001C\u0004\u0002v^\u0001\r!a\u0002)\u0007]\tY$A\u0006e_^KG\u000f[*uC\u001e,Gc\u0002@\u0003L\t5#q\n\u0005\b\u0003\u000bA\u0002\u0019AA\u0004\u0011\u001d\t)\u0010\u0007a\u0001\u0003\u000fAqA!\u0015\u0019\u0001\u0004\u0011\u0019&\u0001\u0002g]BAAF!\u0016\u0003Z\t}c0C\u0002\u0003X5\u0012\u0011BR;oGRLwN\u001c\u001a\u0011\u0007\u0001\u0014Y&C\u0002\u0003^}\u0011A\u0003R3mSZ,'/_*uCR,W*\u00198bO\u0016\u0014\b\u0003BA*\u0005CJAAa\u0019\u0002V\t)1\u000b^1hK\u0006q\u0001O]8dKN\u001c8\t[1oO\u0016\u001cHc\u0001@\u0003j!9!1N\rA\u0002\te\u0013aB7b]\u0006<WM]\u0001\u001fa\u0006\u0014H/\u001b;j_:LE/Z7t\u0005f,\u00050[:uS:<\u0017I\u001c3OK^$bA!\u001d\u0003z\t\u0005\u0005c\u0002\u0017\u0003t\t]$qO\u0005\u0004\u0005kj#A\u0002+va2,'\u0007\u0005\u0004\u0002X\u0006\u0005\u0018q\u000e\u0005\u0007Ei\u0001\rAa\u001f\u0011\t\u0005M#QP\u0005\u0005\u0005\u007f\n)F\u0001\u0005EK2Lg/\u001a:z\u0011\u001d\u0011\u0019I\u0007a\u0001\u0005\u000b\u000ba\"\u001b;f[&#wJ\u001d+ji2,7\u000f\u0005\u0004\u0002\n\t\u001d\u0015qA\u0005\u0005\u0005\u0013\u000bYBA\u0002TKR\fAB^1mS\u0012\fG/Z%uK6$RA BH\u0005#CaAI\u000eA\u0002\tm\u0004b\u0002BJ7\u0001\u0007\u0011qN\u0001\fiJ\f7m[3e\u0013R,W.\u0001\bwC2LG-\u0019;f\u001b\u0016l'-\u001a:\u0015\u0007y\u0014I\nC\u0004\u0003\u001cr\u0001\r!a\u0002\u0002\u0013I,G.Z1tK&#\u0017\u0001\u0004<bY&$\u0017\r^3UCN\\Gc\u0001@\u0003\"\"9!1U\u000fA\u0002\u0005\u001d\u0011A\u0002;bg.LE\rK\u0002\u0001\u0005O\u0003BA!+\u000306\u0011!1\u0016\u0006\u0004\u0005[3\u0018AC:uKJ,w\u000e^=qK&!!\u0011\u0017BV\u0005\u001d\u0019VM\u001d<jG\u0016\u0004")
public class DeliveryTrackingService
implements Logging {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final TaskRepository taskRepository;
    private final CiIdService ciIdService;
    private final XLReleaseEventBus eventBus;
    private final DeliveryTransitionHandler deliveryTransitionHandler;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryTrackingService deliveryTrackingService = this;
        synchronized (deliveryTrackingService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public void manualCompleteTransition(String deliveryId, String transitionId, CompleteTransition parameters) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Manual transition '").append(transitionId).append("' on delivery '").append(deliveryId).append("' with params '").append(parameters).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Transition transition = delivery.getTransitionByIdOrTitle(transitionId);
        Stage stage = delivery.getStageByIdOrTitle(transition.getFromStageId());
        Checks.checkArgument((boolean)stage.isOpen(), (String)new StringBuilder(40).append("Transition already completed on stage '").append(stage.getTitle()).append("'").toString(), (Object[])new Object[0]);
        Checks.checkNotNull(parameters.getTransitionItems(), (String)"Transition items");
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(parameters.getTransitionItems()).asScala()).foreach((Function1 & Serializable & scala.Serializable)itemId -> {
            DeliveryTrackingService.$anonfun$manualCompleteTransition$2(delivery, stage, itemId);
            return BoxedUnit.UNIT;
        });
        ManualTransitionTrigger trigger = new ManualTransitionTrigger(delivery, stage, (Set<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(parameters.getTransitionItems()).asScala()).toSet(), parameters.isCloseStages());
        this.deliveryTransitionHandler.handle(transition, trigger).foreach((Function1 & Serializable & scala.Serializable)manager -> {
            this.processChanges(manager);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public SubscriptionResult registerSubscriber(String deliveryId, Subscriber subscriber) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Registering subscriber '").append((Object)subscriber).append("' to delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateTask(subscriber.sourceId());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        SubscriptionResult result = manager.registerSubscriber(subscriber);
        this.processChanges(manager);
        return result;
    }

    @Timed
    public TrackedItem getTrackedItemByTitle(String deliveryId, String itemTitle) {
        return this.deliveryRepository.read(deliveryId).getItemByIdOrTitle(itemTitle);
    }

    @Timed
    public List<TrackedItem> getTrackedItems(String deliveryId) {
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        return delivery.getTrackedItems();
    }

    @Timed
    public TrackedItem createTrackedItem(String deliveryId, TrackedItem item) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Creating new tracked item '").append(item.getTitle()).append("' on delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateItem(delivery, item);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        TrackedItem addedItem = manager.addTrackedItem(item);
        this.processChanges(manager);
        return addedItem;
    }

    @Timed
    public TrackedItem updateTrackedItem(String deliveryId, TrackedItem item) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Updating tracked item with id '").append(item.getId()).append("' on delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        this.validateItem(delivery, item);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        TrackedItem updatedItem = manager.updateTrackedItem(item);
        this.processChanges(manager);
        return updatedItem;
    }

    @Timed
    public void deleteTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Removing tracked item '").append(itemId).append("' from delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.deleteTrackedItem(itemId);
        this.processChanges(manager);
    }

    @Timed
    public void descopeTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Descoping tracked item '").append(itemId).append("' from delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.descopeItems((Seq<TrackedItem>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrackedItem[]{delivery.getItemByIdOrTitle(itemId)}))));
        this.processChanges(manager);
    }

    @Timed
    public void rescopeTrackedItem(String deliveryId, String itemId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Rescoping tracked item '").append(itemId).append("' from delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.rescopeItems((Seq<TrackedItem>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TrackedItem[]{delivery.getItemByIdOrTitle(itemId)}))));
        this.processChanges(manager);
    }

    @Timed
    public void registerTrackedItems(String deliveryId, Seq<String> items, String fromReleaseId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Registering new tracked items [").append(items.mkString(", ")).append("] on delivery '").append(deliveryId).append("' from release '").append(fromReleaseId).append("'").toString());
        this.validateMember(fromReleaseId);
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Tuple2<Seq<TrackedItem>, Seq<TrackedItem>> tuple2 = this.partitionItemsByExistingAndNew(delivery, (Set<String>)items.toSet());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq existingItems = (Seq)tuple2._1();
        Seq newItems = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)existingItems, (Object)newItems);
        Tuple2 tuple23 = tuple22;
        Seq existingItems2 = (Seq)tuple23._1();
        Seq newItems2 = (Seq)tuple23._2();
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        existingItems2.foreach((Function1 & Serializable & scala.Serializable)item -> {
            manager.addReleaseToItem(item, fromReleaseId);
            return BoxedUnit.UNIT;
        });
        this.processChanges(manager);
        newItems2.foreach((Function1 & Serializable & scala.Serializable)item -> {
            item.addReleaseId(fromReleaseId);
            return this.createTrackedItem(deliveryId, (TrackedItem)((Object)item));
        });
    }

    @Timed
    public List<TrackedItem> markTrackedItemsInStage(String deliveryId, String stageId, Seq<String> items, TrackedItemStatus status, String fromReleaseId, boolean precedingStages) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Marking tracked items [").append(items.mkString(", ")).append("] as completed on stage '").append(stageId).append("' on delivery '").append(deliveryId).append("'").append(String.valueOf(fromReleaseId != null ? new StringBuilder(7).append("from '").append(fromReleaseId).append("'").toString() : "")).toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        Seq existingItems = (Seq)((TraversableLike)items.distinct()).map((Function1 & Serializable & scala.Serializable)idOrTitle -> {
            LazyRef lowercaseTitle$lzy = new LazyRef();
            return (TrackedItem)((Object)((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala()).find((Function1 & Serializable & scala.Serializable)trackedItem -> BoxesRunTime.boxToBoolean((boolean)DeliveryTrackingService.$anonfun$markTrackedItemsInStage$3(idOrTitle, lowercaseTitle$lzy, trackedItem))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new LogFriendlyNotFoundException(new StringBuilder(45).append("Tracked item '").append((String)idOrTitle).append("' does not exist in delivery '").append(delivery.getTitle()).append("'").toString(), new Object[0]);
            })));
        }, Seq$.MODULE$.canBuildFrom());
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        if (fromReleaseId != null) {
            this.validateMember(fromReleaseId);
            existingItems.foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                manager.addReleaseToItem(x$4, fromReleaseId);
                return BoxedUnit.UNIT;
            });
        }
        Seq<TrackedItem> markedItems = manager.markTrackedItemsInStage((Seq<TrackedItem>)existingItems, stage, status, precedingStages, fromReleaseId);
        this.processChanges(manager);
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(markedItems).asJava();
    }

    public boolean markTrackedItemsInStage$default$6() {
        return false;
    }

    @Timed
    public void skipTrackedItemInStage(String deliveryId, String stageId, String itemId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Skipping tracked item '").append(itemId).append("' on stage '").append(stageId).append("' in delivery '").append(deliveryId).append("'").toString());
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        TrackedItem trackedItem = delivery.getItemByIdOrTitle(itemId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        manager.skipTrackedItemInStage(trackedItem, stage);
        this.processChanges(manager);
    }

    @Timed
    public void completeStage(String deliveryId, String stageId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Marking stage '").append(stageId).append("' as completed").toString());
        this.doWithStage(deliveryId, stageId, (Function2<DeliveryStateManager, Stage, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(manager, stage) -> {
            manager.completeStage(stage);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void reopenStage(String deliveryId, String stageId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Marking stage '").append(stageId).append("' as open again").toString());
        this.doWithStage(deliveryId, stageId, (Function2<DeliveryStateManager, Stage, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(manager, stage) -> {
            manager.reopenStage(stage);
            return BoxedUnit.UNIT;
        });
    }

    private void doWithStage(String deliveryId, String stageId, Function2<DeliveryStateManager, Stage, BoxedUnit> fn) {
        Delivery delivery = this.deliveryRepository.read(deliveryId);
        Stage stage = delivery.getStageByIdOrTitle(stageId);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService);
        fn.apply((Object)manager, (Object)stage);
        this.processChanges(manager);
    }

    private void processChanges(DeliveryStateManager manager) {
        this.deliveryRepository.update(manager.delivery());
        manager.getMessages().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            DeliveryTrackingService.$anonfun$processChanges$1(this, x$5);
            return BoxedUnit.UNIT;
        });
        manager.getEvents().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            this.eventBus.publish(x$1);
            return BoxedUnit.UNIT;
        });
    }

    private Tuple2<Seq<TrackedItem>, Seq<TrackedItem>> partitionItemsByExistingAndNew(Delivery delivery, Set<String> itemIdOrTitles) {
        Map idsByTitles = (Map)Predef$.MODULE$.Map().apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> new Tuple2((Object)i.getTitle().toLowerCase(), (Object)Ids.getName((String)i.getId())), Buffer$.MODULE$.canBuildFrom()));
        Map itemsByIds = (Map)Predef$.MODULE$.Map().apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala()).map((Function1 & Serializable & scala.Serializable)i -> new Tuple2((Object)Ids.getName((String)i.getId()), (Object)i), Buffer$.MODULE$.canBuildFrom()));
        return (Tuple2)itemIdOrTitles.foldRight((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Seq$.MODULE$.empty()), (Object)Seq$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            String idOrTitle;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    idOrTitle = (String)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Seq existingAcc = (Seq)tuple2._1();
            Seq newAcc = (Seq)tuple2._2();
            Tuple2 tuple23 = (Tuple2)itemsByIds.get((Object)Ids.getName((String)idOrTitle)).orElse((Function0 & Serializable & scala.Serializable)() -> idsByTitles.get((Object)idOrTitle.toLowerCase()).flatMap((Function1 & Serializable & scala.Serializable)key -> itemsByIds.get(key))).fold((Function0 & Serializable & scala.Serializable)() -> {
                TrackedItem trackedItem = new TrackedItem(idOrTitle);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingAcc), newAcc.$plus$colon((Object)trackedItem, Seq$.MODULE$.canBuildFrom()));
            }, (Function1 & Serializable & scala.Serializable)item -> {
                TrackedItem trackedItem = item;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(existingAcc.$plus$colon((Object)trackedItem, Seq$.MODULE$.canBuildFrom())), (Object)newAcc);
            });
            return tuple23;
        });
    }

    private void validateItem(Delivery delivery, TrackedItem trackedItem) {
        LazyRef lowerCaseTitle$lzy = new LazyRef();
        Checks.checkNotNull((Object)((Object)trackedItem), (String)"Tracked item");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)trackedItem.getTitle()), (String)"Tracked item title must be set", (Object[])new Object[0]);
        Checks.checkArgument((trackedItem.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!trackedItem.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
        Checks.checkArgument((!((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala()).exists((Function1 & Serializable & scala.Serializable)existing -> BoxesRunTime.boxToBoolean((boolean)DeliveryTrackingService.$anonfun$validateItem$1(trackedItem, lowerCaseTitle$lzy, existing))) ? 1 : 0) != 0, (String)new StringBuilder(43).append("A tracked item with title '").append(trackedItem.getTitle()).append("' already exists").toString(), (Object[])new Object[0]);
        if (trackedItem.getReleaseIds() == null) {
            trackedItem.setReleaseIds(new HashSet<String>());
        }
        trackedItem.getReleaseIds().forEach(releaseId -> this.validateMember((String)releaseId));
    }

    private void validateMember(String releaseId) {
        Checks.checkArgument((Ids.isDomainId((String)releaseId) && Ids.isReleaseId((String)releaseId) ? 1 : 0) != 0, (String)new StringBuilder(41).append("Provided ID '").append(releaseId).append("' must be a valid release ID").toString(), (Object[])new Object[0]);
        ReleaseStatus releaseStatus = this.releaseRepository.getStatus(releaseId);
        Checks.checkArgument((releaseStatus != null ? 1 : 0) != 0, (String)new StringBuilder(41).append("Provided ID '").append(releaseId).append("' must exist in the database").toString(), (Object[])new Object[0]);
        ReleaseStatus releaseStatus2 = releaseStatus;
        ReleaseStatus releaseStatus3 = ReleaseStatus.TEMPLATE;
        Checks.checkArgument(((releaseStatus2 == null ? releaseStatus3 != null : !releaseStatus2.equals(releaseStatus3)) ? 1 : 0) != 0, (String)new StringBuilder(36).append("Provided entity '").append(releaseId).append("' must be a release").toString(), (Object[])new Object[0]);
    }

    private void validateTask(String taskId) {
        Checks.checkArgument((boolean)Ids.isTaskId((String)taskId), (String)new StringBuilder(38).append("Provided ID '").append(taskId).append("' must be a valid task ID").toString(), (Object[])new Object[0]);
        Checks.checkArgument((boolean)this.taskRepository.exists(taskId), (String)new StringBuilder(46).append("Provided task ID '").append(taskId).append("' must exist in the database").toString(), (Object[])new Object[0]);
    }

    public static final /* synthetic */ boolean $anonfun$manualCompleteTransition$3(String itemId$1, Stage x$1) {
        return x$1.getItemById(itemId$1).getStatus().isDone();
    }

    public static final /* synthetic */ void $anonfun$manualCompleteTransition$2(Delivery delivery$1, Stage stage$1, String itemId) {
        TrackedItem trackedItem = delivery$1.getItemByIdOrTitle(itemId);
        Checks.checkArgument((!trackedItem.isDescoped() ? 1 : 0) != 0, (String)new StringBuilder(49).append("De-scoped tracked item '").append(trackedItem.getTitle()).append("' can not be transitioned").toString(), (Object[])new Object[0]);
        Buffer notDoneInStages = (Buffer)((TraversableLike)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(delivery$1.getStagesBefore(stage$1)).asScala()).$colon$plus((Object)stage$1, Buffer$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeliveryTrackingService.$anonfun$manualCompleteTransition$3(itemId, x$1)));
        Checks.checkArgument((boolean)notDoneInStages.isEmpty(), (String)new StringBuilder(44).append("Tracked item '").append(trackedItem.getTitle()).append("' must be completed or skipped").append(new StringBuilder(53).append(" in stage '").append(((TraversableOnce)notDoneInStages.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getTitle(), Buffer$.MODULE$.canBuildFrom())).mkString("', '")).append("' in order to transition to the next stage").toString()).toString(), (Object[])new Object[0]);
    }

    private static final /* synthetic */ String lowercaseTitle$lzycompute$1(LazyRef lowercaseTitle$lzy$1, String idOrTitle$1) {
        String string;
        LazyRef lazyRef = lowercaseTitle$lzy$1;
        synchronized (lazyRef) {
            string = lowercaseTitle$lzy$1.initialized() ? (String)lowercaseTitle$lzy$1.value() : (String)lowercaseTitle$lzy$1.initialize((Object)idOrTitle$1.toLowerCase());
        }
        return string;
    }

    private static final String lowercaseTitle$1(LazyRef lowercaseTitle$lzy$1, String idOrTitle$1) {
        return lowercaseTitle$lzy$1.initialized() ? (String)lowercaseTitle$lzy$1.value() : DeliveryTrackingService.lowercaseTitle$lzycompute$1(lowercaseTitle$lzy$1, idOrTitle$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$markTrackedItemsInStage$3(String idOrTitle$1, LazyRef lowercaseTitle$lzy$1, TrackedItem trackedItem) {
        String string = Ids.getName((String)trackedItem.getId());
        String string2 = Ids.getName((String)idOrTitle$1);
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = trackedItem.getTitle().toLowerCase();
        String string4 = DeliveryTrackingService.lowercaseTitle$1(lowercaseTitle$lzy$1, idOrTitle$1);
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$processChanges$1(DeliveryTrackingService $this, String x$5) {
        $this.logger().info((Function0 & Serializable & scala.Serializable)() -> x$5);
    }

    private static final /* synthetic */ String lowerCaseTitle$lzycompute$1(LazyRef lowerCaseTitle$lzy$1, TrackedItem trackedItem$1) {
        String string;
        LazyRef lazyRef = lowerCaseTitle$lzy$1;
        synchronized (lazyRef) {
            string = lowerCaseTitle$lzy$1.initialized() ? (String)lowerCaseTitle$lzy$1.value() : (String)lowerCaseTitle$lzy$1.initialize((Object)trackedItem$1.getTitle().toLowerCase());
        }
        return string;
    }

    private static final String lowerCaseTitle$1(LazyRef lowerCaseTitle$lzy$1, TrackedItem trackedItem$1) {
        return lowerCaseTitle$lzy$1.initialized() ? (String)lowerCaseTitle$lzy$1.value() : DeliveryTrackingService.lowerCaseTitle$lzycompute$1(lowerCaseTitle$lzy$1, trackedItem$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$validateItem$1(TrackedItem trackedItem$1, LazyRef lowerCaseTitle$lzy$1, TrackedItem existing) {
        String string = existing.getTitle().toLowerCase();
        String string2 = DeliveryTrackingService.lowerCaseTitle$1(lowerCaseTitle$lzy$1, trackedItem$1);
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = existing.getId();
        String string4 = trackedItem$1.getId();
        if (string3 == null) {
            if (string4 == null) return false;
            return true;
        } else if (string3.equals(string4)) return false;
        return true;
    }

    @Autowired
    public DeliveryTrackingService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, TaskRepository taskRepository, CiIdService ciIdService, XLReleaseEventBus eventBus, ReleaseActorService releaseActorService, DeliveryTransitionHandler deliveryTransitionHandler) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.taskRepository = taskRepository;
        this.ciIdService = ciIdService;
        this.eventBus = eventBus;
        this.deliveryTransitionHandler = deliveryTransitionHandler;
        Logging.$init$((Logging)this);
    }
}

