/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.repository.sql;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.api.v1.forms.AbstractDeliveryFilters;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryOrderMode;
import com.xebialabs.xlrelease.api.v1.views.DeliveryFlowReleaseInfo;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.domain.DeliveryStatus;
import com.xebialabs.xlrelease.delivery.domain.TrackedItem;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryMemberPersistence;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryPersistence;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliveryRow;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.DeliverySqlBuilder;
import com.xebialabs.xlrelease.delivery.repository.sql.persistence.TrackedItemPersistence;
import com.xebialabs.xlrelease.delivery.service.DeliveryDetailsDecorator$;
import com.xebialabs.xlrelease.domain.utils.Diff;
import com.xebialabs.xlrelease.domain.utils.Diff$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderId$;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@Repository
@ScalaSignature(bytes="\u0006\u0001\tUe\u0001B\u000f\u001f\u0001-B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0011!a\u0005A!b\u0001\n\u0007i\u0005\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011]\u0003!Q1A\u0005\u0004aC\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\tc\u0002\u0011)\u0019!C\u0001e\"A1\u0010\u0001B\u0001B\u0003%1\u000fC\u0003}\u0001\u0011\u0005Q\u0010C\u0004\u00024\u0001!\t%!\u000e\t\u000f\u0005\u0015\u0004\u0001\"\u0011\u0002h!9\u0011q\u000e\u0001\u0005B\u0005E\u0004bBA>\u0001\u0011\u0005\u0013Q\u0010\u0005\b\u0003\u0003\u0003A\u0011IAB\u0011\u001d\ty\t\u0001C!\u0003#Cq!!&\u0001\t\u0003\n9\nC\u0004\u0002x\u0002!\t%!?\t\u000f\t\u0005\u0001\u0001\"\u0011\u0003\u0004!9!\u0011\u0002\u0001\u0005B\t-\u0001b\u0002B\u000e\u0001\u0011\u0005#Q\u0004\u0005\b\u0005c\u0001A\u0011\u0002B\u001a\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007BqA!\u0014\u0001\t\u0003\u0012y\u0005C\u0004\u0003V\u0001!IAa\u0016\t\u000f\tu\u0003\u0001\"\u0003\u0003`!9!Q\u000e\u0001\u0005\n\t=$!F*rY\u0012+G.\u001b<fef\u0014V\r]8tSR|'/\u001f\u0006\u0003?\u0001\n1a]9m\u0015\t\t#%\u0001\u0006sKB|7/\u001b;pefT!a\t\u0013\u0002\u0011\u0011,G.\u001b<fefT!!\n\u0014\u0002\u0013ad'/\u001a7fCN,'BA\u0014)\u0003%AXMY5bY\u0006\u00147OC\u0001*\u0003\r\u0019w.\\\u0002\u0001'\r\u0001AF\r\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M\"T\"\u0001\u0011\n\u0005U\u0002#A\u0005#fY&4XM]=SKB|7/\u001b;pef\f1\u0003Z3mSZ,'/\u001f)feNL7\u000f^3oG\u0016\u0004\"\u0001O\u001e\u000e\u0003eR!A\u000f\u0010\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003ye\u00121\u0003R3mSZ,'/\u001f)feNL7\u000f^3oG\u0016\f\u0011\u0004Z3mSZ,'/_'f[\n,'\u000fU3sg&\u001cH/\u001a8dKB\u0011\u0001hP\u0005\u0003\u0001f\u0012\u0011\u0004R3mSZ,'/_'f[\n,'\u000fU3sg&\u001cH/\u001a8dK\u00061BO]1dW\u0016$\u0017\n^3n!\u0016\u00148/[:uK:\u001cW\r\u0005\u00029\u0007&\u0011A)\u000f\u0002\u0017)J\f7m[3e\u0013R,W\u000eU3sg&\u001cH/\u001a8dK\u0006!2/\u001d7SKB|7/\u001b;pef\fE-\u00199uKJ\u0004\"a\u0012&\u000e\u0003!S!aH%\u000b\u0005\u0005\"\u0013BA&I\u0005Q\u0019\u0016\u000f\u001c*fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0006\u0011\u0002/\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3s+\u0005q\u0005CA(U\u001b\u0005\u0001&BA)S\u0003!\u0019XmY;sSRL(BA*'\u0003!!W\r\u001d7ps&$\u0018BA+Q\u0005I\u0001VM]7jgNLwN\\#oM>\u00148-\u001a:\u0002'A,'/\\5tg&|g.\u00128g_J\u001cWM\u001d\u0011\u0002\u000f\u0011L\u0017\r\\3diV\t\u0011\f\u0005\u0002[[:\u00111L\u001b\b\u00039\"t!!\u00184\u000f\u0005y+gBA0e\u001d\t\u00017-D\u0001b\u0015\t\u0011'&\u0001\u0004=e>|GOP\u0005\u0002S%\u0011q\u0005K\u0005\u0003K\u0019J!a\u001a\u0013\u0002\u0005\u0011\u0014\u0017BA\u0010j\u0015\t9G%\u0003\u0002lY\u0006Q1+\u001d7Ck&dG-\u001a:\u000b\u0005}I\u0017B\u00018p\u0005\u001d!\u0015.\u00197fGRT!a\u001b7\u0002\u0011\u0011L\u0017\r\\3di\u0002\n\u0001\u0003Z3d_J\fGo\u001c:TKJ4\u0018nY3\u0016\u0003M\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\u0011%tG/\u001a:oC2T!\u0001\u001f\u0013\u0002\u0007\u0005\u0004\u0018.\u0003\u0002{k\n\u0001\u0013J\u001c;fe:\fG.T3uC\u0012\fG/\u0019#fG>\u0014\u0018\r^8s'\u0016\u0014h/[2f\u0003E!WmY8sCR|'oU3sm&\u001cW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001fy\f\t!a\u0001\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0003c\u0001\"a \u0001\u000e\u0003yAQAN\u0006A\u0002]BQ!P\u0006A\u0002yBQ!Q\u0006A\u0002\tCQ!R\u0006A\u0002\u0019CQ\u0001T\u0006A\u00049CQaV\u0006A\u0004eC\u0003\"a\u0003\u0002\u0010\u0005-\u0012Q\u0006\t\u0005\u0003#\t9#\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003)\tgN\\8uCRLwN\u001c\u0006\u0005\u00033\tY\"A\u0004gC\u000e$xN]=\u000b\t\u0005u\u0011qD\u0001\u0006E\u0016\fgn\u001d\u0006\u0005\u0003C\t\u0019#A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\t)#A\u0002pe\u001eLA!!\u000b\u0002\u0014\tI\u0011+^1mS\u001aLWM]\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003_\tq\u0003\u001f7s%\u0016\u0004xn]5u_JL8+\u001d7ES\u0006dWm\u0019;\t\u000bE\\\u0001\u0019A:\u0002\tI,\u0017\r\u001a\u000b\u0005\u0003o\t\u0019\u0005\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\r\tiDI\u0001\u0007I>l\u0017-\u001b8\n\t\u0005\u0005\u00131\b\u0002\t\t\u0016d\u0017N^3ss\"9\u0011Q\t\u0007A\u0002\u0005\u001d\u0013A\u00033fY&4XM]=JIB!\u0011\u0011JA)\u001d\u0011\tY%!\u0014\u0011\u0005\u0001t\u0013bAA(]\u00051\u0001K]3eK\u001aLA!a\u0015\u0002V\t11\u000b\u001e:j]\u001eT1!a\u0014/Q\ra\u0011\u0011\f\t\u0005\u00037\n\t'\u0004\u0002\u0002^)\u0019\u0011q\f7\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003G\niF\u0001\u0006JgJ+\u0017\rZ(oYf\fabZ3u\u0005fLEm\u0014:USRdW\r\u0006\u0003\u00028\u0005%\u0004bBA6\u001b\u0001\u0007\u0011qI\u0001\u0012I\u0016d\u0017N^3ss&#wJ\u001d+ji2,\u0007fA\u0007\u0002Z\u000511M]3bi\u0016$B!a\u001d\u0002zA\u0019Q&!\u001e\n\u0007\u0005]dF\u0001\u0003V]&$\bBB\u0012\u000f\u0001\u0004\t9$\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0003g\ny\b\u0003\u0004$\u001f\u0001\u0007\u0011qG\u0001\u0007KbL7\u000f^:\u0015\t\u0005\u0015\u00151\u0012\t\u0004[\u0005\u001d\u0015bAAE]\t9!i\\8mK\u0006t\u0007bBA#!\u0001\u0007\u0011q\t\u0015\u0004!\u0005e\u0013A\u00023fY\u0016$X\r\u0006\u0003\u0002t\u0005M\u0005bBA##\u0001\u0007\u0011qI\u0001\u0007g\u0016\f'o\u00195\u0015\u001d\u0005e\u00151VA`\u0003\u0017\f).a8\u0002dB1\u00111TAS\u0003oqA!!(\u0002\":\u0019\u0001-a(\n\u0003=J1!a)/\u0003\u001d\u0001\u0018mY6bO\u0016LA!a*\u0002*\n\u00191+Z9\u000b\u0007\u0005\rf\u0006C\u0004\u0002.J\u0001\r!a,\u0002\u000f\u0019LG\u000e^3sgB!\u0011\u0011WA^\u001b\t\t\u0019L\u0003\u0003\u00026\u0006]\u0016!\u00024pe6\u001c(bAA]o\u0006\u0011a/M\u0005\u0005\u0003{\u000b\u0019LA\fBEN$(/Y2u\t\u0016d\u0017N^3ss\u001aKG\u000e^3sg\"9\u0011\u0011\u0019\nA\u0002\u0005\r\u0017\u0001\u00029bO\u0016\u0004B!!2\u0002H6\t\u0011*C\u0002\u0002J&\u0013A\u0001U1hK\"9\u0011Q\u001a\nA\u0002\u0005=\u0017aB8sI\u0016\u0014()\u001f\t\u0005\u0003c\u000b\t.\u0003\u0003\u0002T\u0006M&!\u0005#fY&4XM]=Pe\u0012,'/T8eK\"9\u0011q\u001b\nA\u0002\u0005e\u0017A\u00039sS:\u001c\u0017\u000e]1mgB1\u00111TAn\u0003\u000fJA!!8\u0002*\nA\u0011\n^3sC\ndW\rC\u0004\u0002bJ\u0001\r!!7\u0002\u000fI|G.Z%eg\"9\u0011Q\u001d\nA\u0002\u0005\u001d\u0018\u0001E1os>3\u0007+\u001a:nSN\u001c\u0018n\u001c8t!\u0019\tY*!*\u0002jB!\u00111^Ay\u001b\t\tiOC\u0002\u0002pB\u000b!\u0002]3s[&\u001c8/[8o\u0013\u0011\t\u00190!<\u0003\u0015A+'/\\5tg&|g\u000eK\u0002\u0013\u00033\n\u0011b]3be\u000eD\u0017\nZ:\u0015\t\u0005m\u0018Q \t\u0007\u00037\u000b)+a\u0012\t\u000f\u000556\u00031\u0001\u00020\"\u001a1#!\u0017\u0002E\u0019Lg\u000e\u001a#fY&4XM]5fgJ+g-\u001a:f]\u000eLgn\u001a*fY\u0016\f7/Z%e)\u0011\tYP!\u0002\t\u000f\t\u001dA\u00031\u0001\u0002H\u0005I!/\u001a7fCN,\u0017\nZ\u0001(M&tG-Q2uSZ,G)\u001a7jm\u0016\u0014\u0018.Z:SK\u001a,'/\u001a8dS:<gi\u001c7eKJLE\r\u0006\u0003\u0003\u000e\tU\u0001CBAN\u0003K\u0013y\u0001E\u00029\u0005#I1Aa\u0005:\u00055\u0019\u0015.\u00133XSRDG+\u001b;mK\"9!qC\u000bA\u0002\u0005\u001d\u0013\u0001\u00034pY\u0012,'/\u00133)\u0007U\tI&\u0001\rgS:$'+\u001a7fCN,7OQ=EK2Lg/\u001a:z\u0013\u0012$BAa\b\u0003.A1\u00111TAS\u0005C\u0001BAa\t\u0003*5\u0011!Q\u0005\u0006\u0005\u0005O\t9,A\u0003wS\u0016<8/\u0003\u0003\u0003,\t\u0015\"a\u0006#fY&4XM]=GY><(+\u001a7fCN,\u0017J\u001c4p\u0011\u001d\t)E\u0006a\u0001\u0003\u000fB3AFA-\u00031!x\u000eR3mSZ,'/[3t)\u0011\tIJ!\u000e\t\u000f\t]r\u00031\u0001\u0003:\u0005!!o\\<t!\u0019\tY*!*\u0003<A\u0019\u0001H!\u0010\n\u0007\t}\u0012HA\u0006EK2Lg/\u001a:z%><\u0018A\u0003;p\t\u0016d\u0017N^3ssR1\u0011q\u0007B#\u0005\u0013BqAa\u0012\u0019\u0001\u0004\u0011Y$A\u0002s_^DqAa\u0013\u0019\u0001\u0004\tY0A\u0007oK^\u0014V\r\\3bg\u0016LEm]\u0001\rM&tGMR8mI\u0016\u0014\u0018\n\u001a\u000b\u0005\u0003\u000f\u0012\t\u0006C\u0004\u0002Fe\u0001\r!a\u0012)\u0007e\tI&\u0001\u0018eK\u000e|'/\u0019;f/&$\b.\u00124gK\u000e$\u0018N^3TK\u000e,(/\u001b;z\u0003:$\u0007+\u0019;uKJtG)\u001a;bS2\u001cH\u0003BAM\u00053BqAa\u0017\u001b\u0001\u0004\tI*\u0001\u0006eK2Lg/\u001a:jKN\fQ\"\\1q)>$U\r\\5wKJLH\u0003\u0002B1\u0005O\u0002R!\fB2\u0003oI1A!\u001a/\u0005\u0019y\u0005\u000f^5p]\"9!\u0011N\u000eA\u0002\t-\u0014A\u00043fY&4XM]=S_^|\u0005\u000f\u001e\t\u0006[\t\r$1H\u0001\u0015CJ,\u0017\n^3ng&sG+\u00192mK\u0016\u000bX/\u00197\u0015\r\u0005\u0015%\u0011\u000fB>\u0011\u001d\u0011\u0019\b\ba\u0001\u0005k\nqa\u001c7e\u0013R,W\u000e\u0005\u0003\u0002:\t]\u0014\u0002\u0002B=\u0003w\u00111\u0002\u0016:bG.,G-\u0013;f[\"9!Q\u0010\u000fA\u0002\tU\u0014a\u00028fo&#X-\u001c\u0015\u0004\u0001\t\u0005\u0005\u0003\u0002BB\u0005\u0013k!A!\"\u000b\t\t\u001d\u0015qD\u0001\u000bgR,'/Z8usB,\u0017\u0002\u0002BF\u0005\u000b\u0013!BU3q_NLGo\u001c:zQ\r\u0001!q\u0012\t\u0005\u00037\u0012\t*\u0003\u0003\u0003\u0014\u0006u#aD%t)J\fgn]1di&|g.\u00197")
public class SqlDeliveryRepository
implements DeliveryRepository {
    private final DeliveryPersistence deliveryPersistence;
    private final DeliveryMemberPersistence deliveryMemberPersistence;
    private final TrackedItemPersistence trackedItemPersistence;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final PermissionEnforcer permissionEnforcer;
    private final SqlBuilder.Dialect dialect;
    private final InternalMetadataDecoratorService decoratorService;

    @Override
    public void createOrUpdate(Delivery delivery) {
        DeliveryRepository.createOrUpdate$(this, delivery);
    }

    public PermissionEnforcer permissionEnforcer() {
        return this.permissionEnforcer;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    public InternalMetadataDecoratorService decoratorService() {
        return this.decoratorService;
    }

    @Override
    @IsReadOnly
    public Delivery read(String deliveryId) {
        return (Delivery)((Object)this.mapToDelivery(this.deliveryPersistence.findById(deliveryId)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(27).append("Release delivery ").append(deliveryId).append(" not found").toString(), new Object[0]);
        }));
    }

    @Override
    @IsReadOnly
    public Delivery getByIdOrTitle(String deliveryIdOrTitle) {
        return (Delivery)((Object)this.mapToDelivery((Option<DeliveryRow>)this.deliveryPersistence.findById(deliveryIdOrTitle).orElse((Function0 & Serializable & scala.Serializable)() -> $this.deliveryPersistence.findByTitle(deliveryIdOrTitle))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(27).append("Release delivery ").append(deliveryIdOrTitle).append(" not found").toString(), new Object[0]);
        }));
    }

    @Override
    public void create(Delivery delivery) {
        Integer deliveryUid = this.deliveryPersistence.insert(delivery);
        this.deliveryMemberPersistence.insertMembers(deliveryUid, (scala.collection.immutable.Set<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(delivery.getReleaseIds()).asScala()).toSet());
        this.trackedItemPersistence.insertItems(deliveryUid, (scala.collection.immutable.Set<TrackedItem>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala()).toSet());
    }

    @Override
    public void update(Delivery delivery) {
        Delivery originalDelivery = this.read(delivery.getId());
        Integer deliveryUid = (Integer)this.deliveryPersistence.getUid(delivery.getId()).get();
        JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala();
        Diff itemDiff = Diff$.MODULE$.applyWithKeyMappingAndComparator((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(originalDelivery.getTrackedItems()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(delivery.getTrackedItems()).asScala(), (Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), (Function2 & Serializable & scala.Serializable)(oldItem, newItem) -> BoxesRunTime.boxToBoolean((boolean)this.areItemsInTableEqual(oldItem, newItem)));
        itemDiff.updatedValues().foreach((Function1 & Serializable & scala.Serializable)item -> {
            this.trackedItemPersistence.updateTrackedItem(item.getId(), item);
            return BoxedUnit.UNIT;
        });
        this.trackedItemPersistence.insertItems(deliveryUid, (scala.collection.immutable.Set<TrackedItem>)itemDiff.newValues().toSet());
        this.trackedItemPersistence.deleteItems(deliveryUid, (scala.collection.immutable.Set<String>)itemDiff.deletedKeys());
        delivery.computeReleasesFromTrackedItems();
        Diff membersDiff = Diff$.MODULE$.apply((Iterable)JavaConverters$.MODULE$.asScalaSetConverter(originalDelivery.getReleaseIds()).asScala(), (Iterable)JavaConverters$.MODULE$.asScalaSetConverter(delivery.getReleaseIds()).asScala());
        this.deliveryMemberPersistence.deleteMembers(deliveryUid, (scala.collection.immutable.Set<String>)membersDiff.deletedKeys());
        this.deliveryMemberPersistence.insertMembers(deliveryUid, (scala.collection.immutable.Set<String>)membersDiff.newKeys());
        this.deliveryPersistence.update(delivery);
    }

    @Override
    @IsReadOnly
    public boolean exists(String deliveryId) {
        return this.deliveryPersistence.exists(deliveryId);
    }

    @Override
    public void delete(String deliveryId) {
        this.deliveryPersistence.delete(deliveryId);
    }

    @Override
    @IsReadOnly
    public Seq<Delivery> search(AbstractDeliveryFilters filters, Page page, DeliveryOrderMode orderBy, Iterable<String> principals, Iterable<String> roleIds, Seq<Permission> anyOfPermissions) {
        Seq<DeliveryRow> seq;
        if (filters.hasStatuses()) {
            Tuple2 sqlWithParams = new DeliverySqlBuilder(this.dialect()).select().withTitleLike(filters.getTitle(), filters.isStrictTitleMatch()).withOneOfStatuses((Seq<DeliveryStatus>)((Seq)Option$.MODULE$.apply(filters.getStatuses()).map((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$2).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty()))).withFolder(filters.getFolderId()).withPermissions((Seq<Permission>)(this.permissionEnforcer().isCurrentUserAdmin() ? (Seq)Seq$.MODULE$.empty() : anyOfPermissions), principals, roleIds).withOriginPatternId(filters.getOriginPatternId()).orderBy(orderBy).limitAndOffset(page.resultsPerPage(), page.resultsPerPage() * page.page()).build();
            seq = this.deliveryPersistence.findByQuery((Tuple2<String, Seq<Object>>)sqlWithParams);
        } else {
            seq = (Seq<DeliveryRow>)Seq$.MODULE$.empty();
        }
        Seq<DeliveryRow> deliveryRows = seq;
        Seq<Delivery> deliveries = this.toDeliveries(deliveryRows);
        return this.permissionEnforcer().isCurrentUserAdmin() ? deliveries : this.decorateWithEffectiveSecurityAndPatternDetails(deliveries);
    }

    @Override
    @IsReadOnly
    public Seq<String> searchIds(AbstractDeliveryFilters filters) {
        Tuple2 sqlWithParams = new DeliverySqlBuilder(this.dialect()).select().withTitle(filters.getTitle()).withOneOfStatuses((Seq<DeliveryStatus>)((Seq)Option$.MODULE$.apply(filters.getStatuses()).map((Function1 & Serializable & scala.Serializable)x$3 -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x$3).asScala()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty()))).withFolder(filters.getFolderId()).build();
        return (Seq)this.deliveryPersistence.findByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.deliveryId(), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Seq<String> findDeliveriesReferencingReleaseId(String releaseId) {
        return this.deliveryMemberPersistence.findDeliveriesReferencingReleaseId(releaseId);
    }

    @Override
    @IsReadOnly
    public Seq<CiIdWithTitle> findActiveDeliveriesReferencingFolderId(String folderId) {
        return this.deliveryMemberPersistence.findActiveDeliveriesReferencingFolderId(folderId);
    }

    @Override
    @IsReadOnly
    public Seq<DeliveryFlowReleaseInfo> findReleasesByDeliveryId(String deliveryId) {
        return (Seq)this.deliveryPersistence.findReleasesByDeliveryId(deliveryId).map((Function1 & Serializable & scala.Serializable)row -> new DeliveryFlowReleaseInfo(row.id(), row.title(), row.status(), row.startDate(), row.endDate(), false), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<Delivery> toDeliveries(Seq<DeliveryRow> rows) {
        Map<Object, Seq<String>> releaseIdsByDelivery = this.deliveryMemberPersistence.findMembersByDeliveryUids((Seq<Object>)((Seq)rows.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.ciUid()), Seq$.MODULE$.canBuildFrom())));
        return (Seq)rows.map((Function1 & Serializable & scala.Serializable)row -> this.toDelivery((DeliveryRow)row, (Seq<String>)((Seq)releaseIdsByDelivery.getOrElse((Object)BoxesRunTime.boxToInteger((int)row.ciUid()), (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty()))), Seq$.MODULE$.canBuildFrom());
    }

    private Delivery toDelivery(DeliveryRow row, Seq<String> newReleaseIds) {
        Option deliveryOption = this.sqlRepositoryAdapter.deserialize(row.content(), new ResolveOptionsBuilder().withEverything().build());
        Option option = deliveryOption;
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new LogFriendlyNotFoundException(new StringBuilder(58).append("Error reading release delivery ").append(row.ciUid()).append(", see logs for more details").toString(), new Object[0]);
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Delivery delivery = (Delivery)((Object)some.value());
        delivery.setFolderId(FolderId$.MODULE$.absolute$extension(row.folderId()));
        Set mergedReleaseIds = (Set)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(delivery.getReleaseIds()).asScala()).map((Function1 & Serializable & scala.Serializable)oldId -> (String)newReleaseIds.find((Function1 & Serializable & scala.Serializable)newId -> BoxesRunTime.boxToBoolean((boolean)SqlDeliveryRepository.$anonfun$toDelivery$2(oldId, newId))).getOrElse((Function0 & Serializable & scala.Serializable)() -> oldId), Set$.MODULE$.canBuildFrom());
        delivery.setReleaseIds(new HashSet<String>((Collection)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(mergedReleaseIds).asJava()));
        Delivery delivery2 = delivery;
        return delivery2;
    }

    @Override
    @IsReadOnly
    public String findFolderId(String deliveryId) {
        return FolderId$.MODULE$.absolute$extension(this.deliveryPersistence.findFolderId(deliveryId));
    }

    private Seq<Delivery> decorateWithEffectiveSecurityAndPatternDetails(Seq<Delivery> deliveries) {
        return (Seq)deliveries.map((Function1 & Serializable & scala.Serializable)delivery -> {
            this.decoratorService().decorate((ConfigurationItem)delivery, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), DeliveryDetailsDecorator$.MODULE$.DELIVERY_DETAILS()}))).asJava(), DecoratorsCache$.MODULE$.NO_CACHE());
            return delivery;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private Option<Delivery> mapToDelivery(Option<DeliveryRow> deliveryRowOpt) {
        return deliveryRowOpt.map((Function1 & Serializable & scala.Serializable)row -> this.toDelivery((DeliveryRow)row, $this.deliveryMemberPersistence.findMembersByDeliveryUid(Predef$.MODULE$.int2Integer(row.ciUid())))).map((Function1 & Serializable & scala.Serializable)delivery -> (Delivery)((Object)((Object)this.decorateWithEffectiveSecurityAndPatternDetails((Seq<Delivery>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Delivery[]{delivery})))).head())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean areItemsInTableEqual(TrackedItem oldItem, TrackedItem newItem) {
        String string = oldItem.getTitle();
        String string2 = newItem.getTitle();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (oldItem.isDescoped() != newItem.isDescoped()) return false;
        Date date = oldItem.getModifiedDate();
        Date date2 = newItem.getModifiedDate();
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$toDelivery$2(String oldId$1, String newId) {
        String string = Ids.getName((String)newId);
        String string2 = Ids.getName((String)oldId$1);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlDeliveryRepository(DeliveryPersistence deliveryPersistence, DeliveryMemberPersistence deliveryMemberPersistence, TrackedItemPersistence trackedItemPersistence, SqlRepositoryAdapter sqlRepositoryAdapter, PermissionEnforcer permissionEnforcer, @Qualifier(value="xlrRepositorySqlDialect") SqlBuilder.Dialect dialect, InternalMetadataDecoratorService decoratorService) {
        this.deliveryPersistence = deliveryPersistence;
        this.deliveryMemberPersistence = deliveryMemberPersistence;
        this.trackedItemPersistence = trackedItemPersistence;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        this.permissionEnforcer = permissionEnforcer;
        this.dialect = dialect;
        this.decoratorService = decoratorService;
        DeliveryRepository.$init$(this);
    }
}

