/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.v1.forms.CreateDelivery;
import com.xebialabs.xlrelease.api.v1.forms.DeliveryPatternFilters;
import com.xebialabs.xlrelease.api.v1.forms.DuplicateDeliveryPattern;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.domain.DeliveryStatus;
import com.xebialabs.xlrelease.delivery.domain.Stage;
import com.xebialabs.xlrelease.delivery.domain.StageStatus;
import com.xebialabs.xlrelease.delivery.domain.TrackedItem;
import com.xebialabs.xlrelease.delivery.domain.Transition;
import com.xebialabs.xlrelease.delivery.events.DeliveryCreatedEvent;
import com.xebialabs.xlrelease.delivery.events.StageCreated;
import com.xebialabs.xlrelease.delivery.events.StageRemoved;
import com.xebialabs.xlrelease.delivery.events.StageUpdated;
import com.xebialabs.xlrelease.delivery.events.TransitionCreated;
import com.xebialabs.xlrelease.delivery.events.TransitionRemoved;
import com.xebialabs.xlrelease.delivery.events.TransitionUpdated;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.security.DeliveryPermissions$;
import com.xebialabs.xlrelease.delivery.service.DeliveryServiceUtils;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager;
import com.xebialabs.xlrelease.delivery.service.DeliveryStateManager$;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.Buffer;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@Service
@ScalaSignature(bytes="\u0006\u0001\rMc\u0001B\u00193\u0001uB\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t!\u0013\u0005\t!\u0002\u0011\t\u0011)A\u0005\u0015\"A\u0011\u000b\u0001BC\u0002\u0013\u0005!\u000b\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003T\u0011!I\u0006A!b\u0001\n\u0003Q\u0006\u0002\u00031\u0001\u0005\u0003\u0005\u000b\u0011B.\t\u0011\u0005\u0004!Q1A\u0005\u0002\tD\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u0019\u0005\tO\u0002\u0011)\u0019!C\u0001Q\"Aq\u000e\u0001B\u0001B\u0003%\u0011\u000e\u0003\u0005q\u0001\t\u0015\r\u0011\"\u0001r\u0011!)\bA!A!\u0002\u0013\u0011\b\u0002\u0003<\u0001\u0005\u000b\u0007I\u0011A<\t\u0013\u0005\u0005\u0001A!A!\u0002\u0013A\bBCA\u0002\u0001\t\u0015\r\u0011\"\u0001\u0002\u0006!Q\u00111\u0003\u0001\u0003\u0002\u0003\u0006I!a\u0002\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018!I\u0011\u0011\n\u0001C\u0002\u0013\u0015\u00111\n\u0005\t\u0003'\u0002\u0001\u0015!\u0004\u0002N!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003bBAJ\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0003;\u0003A\u0011AAP\u0011\u001d\t\t\f\u0001C\u0001\u0003gCq!a/\u0001\t\u0003\ti\fC\u0004\u0002F\u0002!\t!a2\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\"9\u0011Q\u001c\u0001\u0005\u0002\u0005}\u0007bBA\u007f\u0001\u0011\u0005\u0011q \u0005\b\u0005\u001f\u0001A\u0011\u0001B\t\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005wAqA!\u0013\u0001\t\u0003\u0011Y\u0005C\u0004\u0003J\u0001!\tA!\u0016\t\u000f\tu\u0003\u0001\"\u0001\u0003`!9!q\r\u0001\u0005\u0002\t%\u0004b\u0002B:\u0001\u0011\u0005!Q\u000f\u0005\b\u0005\u0007\u0003A\u0011\u0001BC\u0011\u001d\u0011y\t\u0001C\u0001\u0005#CqA!'\u0001\t\u0003\u0011Y\nC\u0004\u0003&\u0002!IAa*\t\u000f\t\u0005\u0007\u0001\"\u0003\u0003D\"9!q\u0019\u0001\u0005\n\t%\u0007b\u0002Bg\u0001\u0011%!q\u001a\u0005\b\u0005+\u0004A\u0011\u0002Bl\u0011\u001d\u0011i\u000e\u0001C\u0005\u0005?DqAa9\u0001\t\u0013\u0011)\u000fC\u0005\u0003n\u0002\t\n\u0011\"\u0003\u0003p\"911\u0001\u0001\u0005\n\r\u0015\u0001bBB\u001d\u0001\u0011E31\b\u0002\u0017\t\u0016d\u0017N^3ssB\u000bG\u000f^3s]N+'O^5dK*\u00111\u0007N\u0001\bg\u0016\u0014h/[2f\u0015\t)d'\u0001\u0005eK2Lg/\u001a:z\u0015\t9\u0004(A\u0005yYJ,G.Z1tK*\u0011\u0011HO\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aO\u0001\u0004G>l7\u0001A\n\u0004\u0001y\"\u0005CA C\u001b\u0005\u0001%\"A!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0003%AB!osJ+g\r\u0005\u0002F\r6\t!'\u0003\u0002He\t!B)\u001a7jm\u0016\u0014\u0018pU3sm&\u001cW-\u0016;jYN\f!\u0003Z3mSZ,'/\u001f*fa>\u001c\u0018\u000e^8ssV\t!\n\u0005\u0002L\u001d6\tAJ\u0003\u0002Ni\u0005Q!/\u001a9pg&$xN]=\n\u0005=c%A\u0005#fY&4XM]=SKB|7/\u001b;pef\f1\u0003Z3mSZ,'/\u001f*fa>\u001c\u0018\u000e^8ss\u0002\n\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z+\u0005\u0019\u0006C\u0001+W\u001b\u0005)&BA'7\u0013\t9VKA\tSK2,\u0017m]3SKB|7/\u001b;pef\f!C]3mK\u0006\u001cXMU3q_NLGo\u001c:zA\u0005q!/\u001a7fCN,7+\u001a:wS\u000e,W#A.\u0011\u0005qsV\"A/\u000b\u0005M2\u0014BA0^\u00059\u0011V\r\\3bg\u0016\u001cVM\u001d<jG\u0016\fqB]3mK\u0006\u001cXmU3sm&\u001cW\rI\u0001\fG&LEmU3sm&\u001cW-F\u0001d!\taF-\u0003\u0002f;\nY1)[%e'\u0016\u0014h/[2f\u00031\u0019\u0017.\u00133TKJ4\u0018nY3!\u0003A\t'o\u00195jm\u0016$'+\u001a7fCN,7/F\u0001j!\tQW.D\u0001l\u0015\tag'\u0001\u0002eE&\u0011an\u001b\u0002\u0011\u0003J\u001c\u0007.\u001b<fIJ+G.Z1tKN\f\u0011#\u0019:dQ&4X\r\u001a*fY\u0016\f7/Z:!\u000351w\u000e\u001c3feN+'O^5dKV\t!\u000f\u0005\u0002]g&\u0011A/\u0018\u0002\u000e\r>dG-\u001a:TKJ4\u0018nY3\u0002\u001d\u0019|G\u000eZ3s'\u0016\u0014h/[2fA\u0005Y!o\u001c7f'\u0016\u0014h/[2f+\u0005A\bCA=\u007f\u001b\u0005Q(BA>}\u0003!\u0019XmY;sSRL(BA?9\u0003!!W\r\u001d7ps&$\u0018BA@{\u0005-\u0011v\u000e\\3TKJ4\u0018nY3\u0002\u0019I|G.Z*feZL7-\u001a\u0011\u0002\u0011\u00154XM\u001c;CkN,\"!a\u0002\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u00047\u0003\u0019)g/\u001a8ug&!\u0011\u0011CA\u0006\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\nKZ,g\u000e\u001e\"vg\u0002\na\u0001P5oSRtDCEA\r\u00037\ti\"a\b\u0002\"\u0005\r\u0012QEA\u0014\u0003S\u0001\"!\u0012\u0001\t\u000b!\u000b\u0002\u0019\u0001&\t\u000bE\u000b\u0002\u0019A*\t\u000be\u000b\u0002\u0019A.\t\u000b\u0005\f\u0002\u0019A2\t\u000b\u001d\f\u0002\u0019A5\t\u000bA\f\u0002\u0019\u0001:\t\u000bY\f\u0002\u0019\u0001=\t\u000f\u0005\r\u0011\u00031\u0001\u0002\b!\u001a\u0011#!\f\u0011\t\u0005=\u0012QI\u0007\u0003\u0003cQA!a\r\u00026\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\u0005]\u0012\u0011H\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\tY$!\u0010\u0002\u000b\t,\u0017M\\:\u000b\t\u0005}\u0012\u0011I\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u00111I\u0001\u0004_J<\u0017\u0002BA$\u0003c\u0011\u0011\"Q;u_^L'/\u001a3\u0002'\u0011+e)Q+M)~\u001bF+Q$F?RKE\u000bT#\u0016\u0005\u00055sBAA(C\t\t\t&A\u0005OK^\u00043\u000b^1hK\u0006!B)\u0012$B+2#vl\u0015+B\u000f\u0016{F+\u0013+M\u000b\u0002\n!bZ3u!\u0006$H/\u001a:o)\u0011\tI&!\u001a\u0011\t\u0005m\u0013\u0011M\u0007\u0003\u0003;R1!a\u00185\u0003\u0019!w.\\1j]&!\u00111MA/\u0005!!U\r\\5wKJL\bbBA4)\u0001\u0007\u0011\u0011N\u0001\na\u0006$H/\u001a:o\u0013\u0012\u0004B!a\u001b\u0002z9!\u0011QNA;!\r\ty\u0007Q\u0007\u0003\u0003cR1!a\u001d=\u0003\u0019a$o\\8u}%\u0019\u0011q\u000f!\u0002\rA\u0013X\rZ3g\u0013\u0011\tY(! \u0003\rM#(/\u001b8h\u0015\r\t9\b\u0011\u0015\u0004)\u0005\u0005\u0005\u0003BAB\u0003\u001fk!!!\"\u000b\t\u0005M\u0012q\u0011\u0006\u0005\u0003\u0013\u000bY)A\u0004nKR\u0014\u0018nY:\u000b\u0007\u00055%(\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\u0011\t\t*!\"\u0003\u000bQKW.\u001a3\u0002+\u001d,G\u000fU1ui\u0016\u0014hNQ=JI>\u0013H+\u001b;mKR!\u0011\u0011LAL\u0011\u001d\tI*\u0006a\u0001\u0003S\n\u0001\u0003]1ui\u0016\u0014h.\u00133PeRKG\u000f\\3)\u0007U\t\t)\u0001\ffq&\u001cHo\u001d)biR,'O\\,ji\"$\u0016\u000e\u001e7f)\u0019\t\t+a*\u0002,B\u0019q(a)\n\u0007\u0005\u0015\u0006IA\u0004C_>dW-\u00198\t\u000f\u0005%f\u00031\u0001\u0002j\u0005\u0011\u0011\u000e\u001a\u0005\b\u0003[3\u0002\u0019AA5\u0003\u0015!\u0018\u000e\u001e7fQ\r1\u0012\u0011Q\u0001\u000eKbL7\u000f^:QCR$XM\u001d8\u0015\t\u0005\u0005\u0016Q\u0017\u0005\b\u0003o;\u0002\u0019AA5\u0003)!W\r\\5wKJL\u0018\n\u001a\u0015\u0004/\u0005\u0005\u0015!F2sK\u0006$X\rR3mSZ,'/\u001f)biR,'O\u001c\u000b\u0005\u00033\ny\fC\u0004\u0002Bb\u0001\r!!\u0017\u0002\u000fA\fG\u000f^3s]\"\u001a\u0001$!!\u0002+U\u0004H-\u0019;f\t\u0016d\u0017N^3ssB\u000bG\u000f^3s]R!\u0011\u0011LAe\u0011\u001d\tY-\u0007a\u0001\u00033\nq!\u001e9eCR,G\rK\u0002\u001a\u0003\u0003\u000bQ\u0003Z3mKR,G)\u001a7jm\u0016\u0014\u0018\u0010U1ui\u0016\u0014h\u000e\u0006\u0003\u0002T\u0006e\u0007cA \u0002V&\u0019\u0011q\u001b!\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003OR\u0002\u0019AA5Q\rQ\u0012\u0011Q\u0001\u0019IV\u0004H.[2bi\u0016$U\r\\5wKJL\b+\u0019;uKJtGCBA-\u0003C\f\u0019\u000fC\u0004\u0002hm\u0001\r!!\u001b\t\u000f\u0005\u00158\u00041\u0001\u0002h\u00061\u0001/\u0019:b[N\u0004B!!;\u0002x6\u0011\u00111\u001e\u0006\u0005\u0003[\fy/A\u0003g_Jl7O\u0003\u0003\u0002r\u0006M\u0018A\u0001<2\u0015\r\t)PN\u0001\u0004CBL\u0017\u0002BA}\u0003W\u0014\u0001\u0004R;qY&\u001c\u0017\r^3EK2Lg/\u001a:z!\u0006$H/\u001a:oQ\rY\u0012\u0011Q\u0001\u001aGJ,\u0017\r^3EK2Lg/\u001a:z\rJ|W\u000eU1ui\u0016\u0014h\u000e\u0006\u0004\u0002Z\t\u0005!1\u0001\u0005\b\u0003Ob\u0002\u0019AA5\u0011\u001d\u0011)\u0001\ba\u0001\u0005\u000f\t!\u0002]1sC6,G/\u001a:t!\u0011\tIO!\u0003\n\t\t-\u00111\u001e\u0002\u000f\u0007J,\u0017\r^3EK2Lg/\u001a:zQ\ra\u0012\u0011Q\u0001\u000fg\u0016\f'o\u00195QCR$XM\u001d8t)\u0019\u0011\u0019Ba\t\u0003.A1!Q\u0003B\u0010\u00033j!Aa\u0006\u000b\t\te!1D\u0001\u0005kRLGN\u0003\u0002\u0003\u001e\u0005!!.\u0019<b\u0013\u0011\u0011\tCa\u0006\u0003\t1K7\u000f\u001e\u0005\b\u0005Ki\u0002\u0019\u0001B\u0014\u0003\u001d1\u0017\u000e\u001c;feN\u0004B!!;\u0003*%!!1FAv\u0005Y!U\r\\5wKJL\b+\u0019;uKJtg)\u001b7uKJ\u001c\bb\u0002B\u0018;\u0001\u0007!\u0011G\u0001\u0005a\u0006<W\rE\u0002U\u0005gI1A!\u000eV\u0005\u0011\u0001\u0016mZ3)\u0007u\t\t)A\u0005hKR\u001cF/Y4fgR!!Q\bB#!\u0019\u0011)Ba\b\u0003@A!\u00111\fB!\u0013\u0011\u0011\u0019%!\u0018\u0003\u000bM#\u0018mZ3\t\u000f\u0005\u001dd\u00041\u0001\u0002j!\u001aa$!!\u0002\u0011\u0005$Gm\u0015;bO\u0016$bAa\u0010\u0003N\t=\u0003bBA4?\u0001\u0007\u0011\u0011\u000e\u0005\b\u0005#z\u0002\u0019\u0001B \u0003\u0015\u0019H/Y4fQ\ry\u0012\u0011\u0011\u000b\u0007\u0005\u007f\u00119F!\u0017\t\u000f\u0005\u0005\u0007\u00051\u0001\u0002Z!9!\u0011\u000b\u0011A\u0002\t}\u0002f\u0001\u0011\u0002\u0002\u0006YQ\u000f\u001d3bi\u0016\u001cF/Y4f)\u0019\u0011yD!\u0019\u0003d!9\u0011qM\u0011A\u0002\u0005%\u0004bBAfC\u0001\u0007!q\b\u0015\u0004C\u0005\u0005\u0015a\u00033fY\u0016$Xm\u0015;bO\u0016$b!a5\u0003l\t5\u0004bBA4E\u0001\u0007\u0011\u0011\u000e\u0005\b\u0005_\u0012\u0003\u0019AA5\u0003\u001d\u0019H/Y4f\u0013\u0012D3AIAA\u000399W\r\u001e+sC:\u001c\u0018\u000e^5p]N$BAa\u001e\u0003\u0000A1!Q\u0003B\u0010\u0005s\u0002B!a\u0017\u0003|%!!QPA/\u0005)!&/\u00198tSRLwN\u001c\u0005\b\u0003O\u001a\u0003\u0019AA5Q\r\u0019\u0013\u0011Q\u0001\u000eC\u0012$GK]1og&$\u0018n\u001c8\u0015\r\te$q\u0011BE\u0011\u001d\t9\u0007\na\u0001\u0003SBqAa#%\u0001\u0004\u0011I(\u0001\u0006ue\u0006t7/\u001b;j_:D3\u0001JAA\u0003A)\b\u000fZ1uKR\u0013\u0018M\\:ji&|g\u000e\u0006\u0004\u0003z\tM%Q\u0013\u0005\b\u0003O*\u0003\u0019AA5\u0011\u001d\tY-\na\u0001\u0005sB3!JAA\u0003A!W\r\\3uKR\u0013\u0018M\\:ji&|g\u000e\u0006\u0004\u0002T\nu%q\u0014\u0005\b\u0003O2\u0003\u0019AA5\u0011\u001d\u0011\tK\na\u0001\u0003S\nA\u0002\u001e:b]NLG/[8o\u0013\u0012D3AJAA\u0003a9WM\\3sCR,G+\u001b;mK&3g*Z2fgN\f'/\u001f\u000b\u0007\u0003'\u0014IKa+\t\u000f\tEs\u00051\u0001\u0003@!9!QV\u0014A\u0002\t=\u0016AB:uC\u001e,7\u000f\u0005\u0004\u00032\nm&q\b\b\u0005\u0005g\u00139L\u0004\u0003\u0002p\tU\u0016\"A!\n\u0007\te\u0006)A\u0004qC\u000e\\\u0017mZ3\n\t\tu&q\u0018\u0002\u0004'\u0016\f(b\u0001B]\u0001\u0006q1\r[3dW&\u001b\b+\u0019;uKJtG\u0003BAj\u0005\u000bDa!\u000e\u0015A\u0002\u0005e\u0013a\u0004<bY&$\u0017\r^3QCR$XM\u001d8\u0015\t\u0005M'1\u001a\u0005\u0007k%\u0002\r!!\u0017\u0002\u001bY\fG.\u001b3bi\u0016\u001cF/Y4f)\u0019\t\u0019N!5\u0003T\"9!\u0011\u000b\u0016A\u0002\t}\u0002b\u0002BWU\u0001\u0007!qV\u0001\u0013m\u0006d\u0017\u000eZ1uKR\u0013\u0018M\\:ji&|g\u000e\u0006\u0004\u0002T\ne'1\u001c\u0005\b\u0003\u0003\\\u0003\u0019AA-\u0011\u001d\u0011Yi\u000ba\u0001\u0005s\nQB]3tKR$U\r\\5wKJLH\u0003BAj\u0005CDa!\u000e\u0017A\u0002\u0005e\u0013\u0001F1me\u0016\fG-_#ySN$8OQ=USRdW\r\u0006\u0004\u0002\"\n\u001d(1\u001e\u0005\b\u0005Sl\u0003\u0019AA5\u00031\u0001\u0018\r\u001e;fe:$\u0016\u000e\u001e7f\u0011%\t9'\fI\u0001\u0002\u0004\tI'\u0001\u0010bYJ,\u0017\rZ=Fq&\u001cHo\u001d\"z)&$H.\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\u001f\u0016\u0005\u0003S\u0012\u0019p\u000b\u0002\u0003vB!!q\u001fB\u0000\u001b\t\u0011IP\u0003\u0003\u0003|\nu\u0018!C;oG\",7m[3e\u0015\r\t\u0019\u0004Q\u0005\u0005\u0007\u0003\u0011IPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!bZ3oKJ\fG/Z%e)\u0019\tIga\u0002\u00046!91\u0011B\u0018A\u0002\r-\u0011aB2j\u00072\f7o\u001d\u0019\u0005\u0007\u001b\u00199\u0002\u0005\u0004\u0002l\r=11C\u0005\u0005\u0007#\tiHA\u0003DY\u0006\u001c8\u000f\u0005\u0003\u0004\u0016\r]A\u0002\u0001\u0003\r\u00073\u00199!!A\u0001\u0002\u000b\u000511\u0004\u0002\u0004?\u0012\n\u0014\u0003BB\u000f\u0007G\u00012aPB\u0010\u0013\r\u0019\t\u0003\u0011\u0002\b\u001d>$\b.\u001b8h!\u0011\u0019)c!\r\u000e\u0005\r\u001d\"\u0002BB\u0015\u0007W\t1!\u001e3n\u0015\u0011\t)p!\f\u000b\u0007\r=B0\u0001\u0004qYV<\u0017N\\\u0005\u0005\u0007g\u00199CA\tD_:4\u0017nZ;sCRLwN\\%uK6Dqaa\u000e0\u0001\u0004\tI'\u0001\u0005qCJ,g\u000e^%e\u0003A\u0019\u0007.Z2l\u0013N,\u0006\u000fZ1uC\ndW\r\u0006\u0004\u0002T\u000eu2\u0011\t\u0005\b\u0007\u007f\u0001\u0004\u0019AA-\u0003A)\u00070[:uS:<G)\u001a7jm\u0016\u0014\u0018\u0010C\u0005\u0004DA\u0002\n\u00111\u0001\u0002j\u00051\u0011m\u0019;j_:D3\u0001AB$!\u0011\u0019Iea\u0014\u000e\u0005\r-#\u0002BB'\u0003{\t!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\u0019\tfa\u0013\u0003\u000fM+'O^5dK\u0002")
public class DeliveryPatternService
implements DeliveryServiceUtils {
    private final DeliveryRepository deliveryRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public String checkIsUpdatable$default$2() {
        return DeliveryServiceUtils.checkIsUpdatable$default$2$(this);
    }

    @Override
    @Timed
    public Delivery getDeliveryOrPattern(String deliveryId) {
        return DeliveryServiceUtils.getDeliveryOrPattern$(this, deliveryId);
    }

    @Override
    @Timed
    public String getFolderId(String deliveryId) {
        return DeliveryServiceUtils.getFolderId$(this, deliveryId);
    }

    @Override
    public Delivery doUpdate(Delivery updated) {
        return DeliveryServiceUtils.doUpdate$(this, updated);
    }

    @Override
    public void doDelete(String deliveryId) {
        DeliveryServiceUtils.doDelete$(this, deliveryId);
    }

    @Override
    public void validate(Delivery delivery) {
        DeliveryServiceUtils.validate$(this, delivery);
    }

    @Override
    public void validateDelivery(Delivery delivery) {
        DeliveryServiceUtils.validateDelivery$(this, delivery);
    }

    @Override
    public void checkIsDelivery(Delivery delivery) {
        DeliveryServiceUtils.checkIsDelivery$(this, delivery);
    }

    @Override
    public Iterable<String> currentPrincipals() {
        return DeliveryServiceUtils.currentPrincipals$(this);
    }

    @Override
    public Buffer<String> currentRoleIds() {
        return DeliveryServiceUtils.currentRoleIds$(this);
    }

    @Override
    public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        DeliveryServiceUtils.computeAndUpdateDates$(this, delivery, durationOpt, startDateOpt, endDateOpt);
    }

    @Override
    public int computeAndUpdateDates$default$2() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$2$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$3() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$3$(this);
    }

    @Override
    public Date computeAndUpdateDates$default$4() {
        return DeliveryServiceUtils.computeAndUpdateDates$default$4$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DeliveryPatternService deliveryPatternService = this;
        synchronized (deliveryPatternService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public DeliveryRepository deliveryRepository() {
        return this.deliveryRepository;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    public CiIdService ciIdService() {
        return this.ciIdService;
    }

    @Override
    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    @Override
    public FolderService folderService() {
        return this.folderService;
    }

    @Override
    public RoleService roleService() {
        return this.roleService;
    }

    @Override
    public XLReleaseEventBus eventBus() {
        return this.eventBus;
    }

    public final String DEFAULT_STAGE_TITLE() {
        return "New Stage";
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPattern(String patternId) {
        void var2_2;
        Delivery pattern = this.getDeliveryOrPattern(patternId);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Delivery getPatternByIdOrTitle(String patternIdOrTitle) {
        void var2_2;
        Delivery pattern = this.deliveryRepository().getByIdOrTitle(patternIdOrTitle);
        this.checkIsPattern(pattern);
        return var2_2;
    }

    @Timed
    public boolean existsPatternWithTitle(String id, String title) {
        return this.alreadyExistsByTitle(title, id);
    }

    @Timed
    public boolean existsPattern(String deliveryId) {
        return this.deliveryRepository().exists(deliveryId);
    }

    @Timed
    public Delivery createDeliveryPattern(Delivery pattern) {
        Checks.checkNotNull((Object)((Object)pattern), (String)"Release delivery");
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Creating new delivery pattern '").append((Object)pattern).append("'").toString());
        pattern.setStatus(DeliveryStatus.TEMPLATE);
        this.validatePattern(pattern);
        this.resetDelivery(pattern);
        if (pattern.getStages().isEmpty()) {
            Stage defaultStage = new Stage("New Stage");
            defaultStage.setId(this.generateId(Stage.class, pattern.getId()));
            pattern.addStage(defaultStage);
        }
        this.deliveryRepository().create(pattern);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(pattern));
        return pattern;
    }

    @Timed
    public Delivery updateDeliveryPattern(Delivery updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Updating delivery pattern '").append((Object)updated).append("'").toString());
        this.validatePattern(updated);
        return this.doUpdate(updated);
    }

    @Timed
    public void deleteDeliveryPattern(String patternId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Deleting release delivery pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.deliveryRepository().read(patternId);
        this.checkIsPattern(pattern);
        this.doDelete(patternId);
    }

    @Timed
    public Delivery duplicateDeliveryPattern(String patternId, DuplicateDeliveryPattern params) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Duplicating delivery pattern '").append(patternId).append("' with parameters '").append(params).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.resetDelivery(pattern);
        if (params.hasDescription()) {
            pattern.setDescription(params.getDescription());
        }
        if (params.hasTitle()) {
            pattern.setTitle(params.getTitle());
        } else {
            int counter = 100;
            do {
                pattern.setTitle(new StringBuilder(7).append(pattern.getTitle()).append(" (Copy)").toString());
            } while (this.alreadyExistsByTitle(pattern.getTitle(), pattern.getId()) && --counter > 0);
        }
        this.deliveryRepository().create(pattern);
        Delivery duplicatedPattern = this.deliveryRepository().read(pattern.getId());
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(duplicatedPattern));
        return duplicatedPattern;
    }

    @Timed
    public Delivery createDeliveryFromPattern(String patternId, CreateDelivery parameters) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Creating new delivery from pattern '").append(patternId).append("' with parameters '").append(parameters).append("'").toString());
        Delivery delivery = this.getPattern(patternId);
        this.resetDelivery(delivery);
        delivery.setTitle(parameters.getTitle());
        delivery.setDescription(parameters.getDescription());
        delivery.setOriginPatternId(patternId);
        this.computeAndUpdateDates(delivery, parameters.getDuration(), parameters.getStartDate(), parameters.getEndDate());
        Checks.checkArgument((delivery.getStages() != null && !delivery.getStages().isEmpty() ? 1 : 0) != 0, (String)"Cannot create delivery from pattern without stages", (Object[])new Object[0]);
        DeliveryStateManager manager = DeliveryStateManager$.MODULE$.apply(delivery, this.ciIdService());
        Delivery startedDelivery = manager.start();
        this.validateDelivery(delivery);
        this.deliveryRepository().create(delivery);
        this.eventBus().publish((XLReleaseEvent)new DeliveryCreatedEvent(delivery));
        manager.getEvents().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            DeliveryPatternService.$anonfun$createDeliveryFromPattern$2(this, x$1);
            return BoxedUnit.UNIT;
        });
        return startedDelivery;
    }

    @Timed
    public List<Delivery> searchPatterns(DeliveryPatternFilters filters, Page page) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.deliveryRepository().search(filters, page, null, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds(), (Seq<Permission>)((Seq)Seq$.MODULE$.apply(DeliveryPermissions$.MODULE$.VIEW_DELIVERY_PATTERN_PERMISSION_SET())))).asJava();
    }

    @Timed
    public List<Stage> getStages(String patternId) {
        return this.getPattern(patternId).getStages();
    }

    @Timed
    public Stage addStage(String patternId, Stage stage) {
        return this.addStage(this.getPattern(patternId), stage);
    }

    @Timed
    public Stage addStage(Delivery pattern, Stage stage) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Adding new stage '").append((Object)stage).append("' to pattern '").append(pattern.getId()).append("'").toString());
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Buffer stages = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala();
        this.generateTitleIfNecessary(stage, (Seq<Stage>)stages);
        this.validateStage(stage, (Seq<Stage>)stages);
        stage.setId(this.generateId(Stage.class, pattern.getId()));
        stage.setStatus(StageStatus.OPEN);
        pattern.addStage(stage, stages.size());
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageCreated(stage, pattern));
        return stage;
    }

    @Timed
    public Stage updateStage(String patternId, Stage updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Updating stage '").append((Object)updated).append("' on pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        this.validateStage(updated, (Seq<Stage>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(pattern.getStages()).asScala()));
        Stage original = pattern.getStageByIdOrTitle(updated.getId());
        original.setTitle(updated.getTitle());
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageUpdated(updated, pattern));
        return original;
    }

    @Timed
    public void deleteStage(String patternId, String stageId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Removing stage '").append(stageId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Function1 & Serializable & scala.Serializable removeTransition = (Function1 & Serializable & scala.Serializable)stage -> {
            stage.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                DeliveryPatternService.$anonfun$deleteStage$3(pattern$3, x$1);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        };
        Stage stage2 = pattern.getStageByIdOrTitle(stageId);
        removeTransition.apply((Object)new Some((Object)stage2));
        Object object = pattern.isLastStage(stage2) ? removeTransition.apply((Object)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(pattern.findPreviousStage(stage2)))) : BoxedUnit.UNIT;
        pattern.removeStage(stage2);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new StageRemoved(stage2, pattern));
    }

    @Timed
    public List<Transition> getTransitions(String patternId) {
        return this.getPattern(patternId).getTransitions();
    }

    @Timed
    public Transition addTransition(String patternId, Transition transition) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Adding new transition '").append((Object)transition).append("' to pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        this.validateTransition(pattern, transition);
        transition.setId(this.generateId(Transition.class, pattern.getId()));
        pattern.addTransition(transition);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionCreated(transition, pattern));
        return transition;
    }

    @Timed
    public Transition updateTransition(String patternId, Transition updated) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Updating transition '").append((Object)updated).append("' on pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        this.validateTransition(pattern, updated);
        Transition original = pattern.getTransitionByIdOrTitle(updated.getId());
        pattern.removeTransition(original);
        pattern.addTransition(updated);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionUpdated(updated, pattern));
        return updated;
    }

    @Timed
    public void deleteTransition(String patternId, String transitionId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Removing transition '").append(transitionId).append("' from pattern '").append(patternId).append("'").toString());
        Delivery pattern = this.getPattern(patternId);
        this.checkIsUpdatable(pattern, this.checkIsUpdatable$default$2());
        Transition transition = pattern.getTransitionByIdOrTitle(transitionId);
        pattern.removeTransition(transition);
        this.deliveryRepository().update(pattern);
        this.eventBus().publish((XLReleaseEvent)new TransitionRemoved(transition, pattern));
    }

    private void generateTitleIfNecessary(Stage stage, Seq<Stage> stages) {
        block1: {
            Checks.checkNotNull((Object)((Object)stage), (String)"Stage");
            if (stage.getTitle() != null) break block1;
            IntRef index = IntRef.create((int)0);
            while (stages.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$generateTitleIfNecessary$1(index, x$2)))) {
                ++index.elem;
            }
            stage.setTitle(DeliveryPatternService.title$1(index));
        }
    }

    private void checkIsPattern(Delivery delivery) {
        Checks.checkArgument((boolean)delivery.isTemplate(), (String)new StringBuilder(27).append(delivery.getId()).append(" must be a Delivery Pattern").toString(), (Object[])new Object[0]);
    }

    private void validatePattern(Delivery delivery) {
        this.validate(delivery);
        this.checkIsPattern(delivery);
        Checks.checkArgument((!this.alreadyExistsByTitle(delivery.getTitle(), delivery.getId()) ? 1 : 0) != 0, (String)new StringBuilder(36).append("Pattern with title '").append(delivery.getTitle()).append("' already exists").toString(), (Object[])new Object[0]);
    }

    private void validateStage(Stage stage, Seq<Stage> stages) {
        Checks.checkNotNull((Object)((Object)stage), (String)"Stage");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)stage.getTitle()), (String)"Stage title must be set", (Object[])new Object[0]);
        Checks.checkArgument((stage.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Stage title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!stage.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
        Checks.checkArgument((stages.count((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$validateStage$1(stage, x$3))) == 0 ? 1 : 0) != 0, (String)"Stage title already exists in delivery pattern", (Object[])new Object[0]);
    }

    private void validateTransition(Delivery pattern, Transition transition) {
        Checks.checkNotNull((Object)((Object)transition), (String)"Transition");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)transition.getTitle()), (String)"Transition title must be set", (Object[])new Object[0]);
        Checks.checkArgument((transition.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Transition title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!transition.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
        Checks.checkNotNull((Object)transition.getFromStageId(), (String)"fromStageId");
        Optional<Stage> stage = pattern.findStageByIdOrTitle(transition.getFromStageId());
        Checks.checkArgument((boolean)stage.isPresent(), (String)"From stage '%s' not found in release delivery '%s'", (Object[])new Object[]{transition.getFromStageId(), pattern.getTitle()});
        Optional<Transition> maybeExistingTransition = pattern.findTransitionFrom(stage.get());
        maybeExistingTransition.ifPresent(existingTransition -> {
            String string = existingTransition.getId();
            String string2 = transition.getId();
            Checks.checkArgument((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)"There is already a transition named '%s' associated with stage '%s'", (Object[])new Object[]{existingTransition.getTitle(), ((Stage)((Object)((Object)stage.get()))).getTitle()});
        });
        Checks.checkArgument((!pattern.isLastStage(stage.get()) ? 1 : 0) != 0, (String)"Transition can not be added to the last stage", (Object[])new Object[0]);
        transition.validate(pattern);
    }

    private void resetDelivery(Delivery delivery) {
        Date resetDate = new Date();
        String oldDeliveryId = delivery.getId();
        String newDeliveryId = this.generateId(Delivery.class, "Deliveries");
        delivery.setId(newDeliveryId);
        delivery.getTransitions().forEach(transition -> transition.setId(transition.getId().replace(oldDeliveryId, newDeliveryId)));
        delivery.getStages().forEach(stage -> {
            String newStageId = stage.getId().replace(oldDeliveryId, newDeliveryId);
            delivery.findTransitionFrom((Stage)((Object)stage)).ifPresent(transition -> transition.setFromStageId(newStageId));
            stage.setId(newStageId);
        });
        delivery.getTrackedItems().forEach(item -> {
            item.setId(this.generateId(TrackedItem.class, newDeliveryId));
            item.setCreatedDate(resetDate);
            item.setModifiedDate(resetDate);
        });
    }

    private boolean alreadyExistsByTitle(String patternTitle, String patternId) {
        DeliveryPatternFilters filters = new DeliveryPatternFilters();
        filters.withTitle(patternTitle);
        filters.withStrictTitleMatch(true);
        return this.deliveryRepository().searchIds(filters).exists((Function1 & Serializable & scala.Serializable)deliveryId -> BoxesRunTime.boxToBoolean((boolean)DeliveryPatternService.$anonfun$alreadyExistsByTitle$1(patternId, deliveryId)));
    }

    private String alreadyExistsByTitle$default$2() {
        return null;
    }

    private String generateId(Class<? extends ConfigurationItem> ciClass, String parentId) {
        return this.ciIdService().getUniqueId(Type.valueOf(ciClass), parentId);
    }

    @Override
    public void checkIsUpdatable(Delivery existingDelivery, String action) {
        existingDelivery.isTemplate();
    }

    public static final /* synthetic */ void $anonfun$createDeliveryFromPattern$2(DeliveryPatternService $this, XLReleaseEvent x$1) {
        $this.eventBus().publish(x$1);
    }

    public static final /* synthetic */ void $anonfun$deleteStage$3(Delivery pattern$3, Stage x$1) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(pattern$3.findTransitionFrom(x$1)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Transition transition = (Transition)((Object)some.value());
            pattern$3.removeTransition(transition);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final String title$1(IntRef index$1) {
        return index$1.elem > 0 ? new StringBuilder(12).append("New Stage").append(" (").append(index$1.elem).append(")").toString() : "New Stage";
    }

    public static final /* synthetic */ boolean $anonfun$generateTitleIfNecessary$1(IntRef index$1, Stage x$2) {
        String string = x$2.getTitle().trim().toLowerCase();
        String string2 = DeliveryPatternService.title$1(index$1).toLowerCase();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$validateStage$1(Stage stage$2, Stage x$3) {
        String string = x$3.getTitle();
        String string2 = stage$2.getTitle();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$alreadyExistsByTitle$1(String patternId$9, String deliveryId) {
        String string = Ids.getName((String)deliveryId);
        String string2 = Ids.getName((String)patternId$9);
        return string == null ? string2 != null : !string.equals(string2);
    }

    @Autowired
    public DeliveryPatternService(DeliveryRepository deliveryRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService, XLReleaseEventBus eventBus) {
        this.deliveryRepository = deliveryRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        DeliveryServiceUtils.$init$(this);
    }
}

