/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.delivery.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.db.DbConstants$;
import com.xebialabs.xlrelease.delivery.domain.Delivery;
import com.xebialabs.xlrelease.delivery.domain.Stage;
import com.xebialabs.xlrelease.delivery.domain.Transition;
import com.xebialabs.xlrelease.delivery.events.DeliveryDeletedEvent;
import com.xebialabs.xlrelease.delivery.events.DeliveryUpdatedEvent;
import com.xebialabs.xlrelease.delivery.repository.DeliveryRepository;
import com.xebialabs.xlrelease.delivery.util.DeliveryObjectFactory;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tEaaB\u000f\u001f!\u0003\r\t!\u000b\u0005\u0006q\u0001!\t!\u000f\u0005\b{\u0001\u0011\rQ\"\u0001?\u0011\u001d)\u0005A1A\u0007\u0002\u0019Cq!\u0014\u0001C\u0002\u001b\u0005a\nC\u0004U\u0001\t\u0007i\u0011A+\t\u000fq\u0003!\u0019!D\u0001;\"9\u0011\r\u0001b\u0001\u000e\u0003\u0011\u0007bB6\u0001\u0005\u00045\t\u0001\u001c\u0005\ba\u0002\u0011\r\u0011\"\u0005r\u0011\u0015A\bA\"\u0005z\u0011%\ty\u0002AI\u0001\n#\t\t\u0003C\u0004\u00028\u0001!\t!!\u000f\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V!9\u00111\f\u0001\u0005\u0012\u0005u\u0003bBA2\u0001\u0011E\u0011Q\r\u0005\b\u0003S\u0002A\u0011CA6\u0011\u001d\ty\u0007\u0001C\t\u0003cBq!!\u001e\u0001\t#\t9\bC\u0004\u0002\u0010\u0002!\t\"!%\t\u000f\u0005U\u0005\u0001\"\u0005\u0002\u0018\"9\u00111\u0016\u0001\u0005\u0012\u00055\u0006bBA`\u0001\u0011E\u0011\u0011\u0019\u0005\n\u0003K\u0004\u0011\u0013!C\t\u0003OD\u0011\"a;\u0001#\u0003%\t\"!<\t\u0013\u0005E\b!%A\u0005\u0012\u00055\bbBAz\u0001\u0011%\u0011Q\u001f\u0005\n\u0005\u0007\u0001\u0011\u0013!C\u0005\u0003ODqA!\u0002\u0001\t\u0013\u00119A\u0001\u000bEK2Lg/\u001a:z'\u0016\u0014h/[2f+RLGn\u001d\u0006\u0003?\u0001\nqa]3sm&\u001cWM\u0003\u0002\"E\u0005AA-\u001a7jm\u0016\u0014\u0018P\u0003\u0002$I\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003K\u0019\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u001d\n1aY8n\u0007\u0001\u00192\u0001\u0001\u00161!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fMB\u0011\u0011GN\u0007\u0002e)\u00111\u0007N\u0001\u0006g24GG\u001b\u0006\u0002k\u0005AqM]5{u2,G-\u0003\u00028e\t9Aj\\4hS:<\u0017A\u0002\u0013j]&$H\u0005F\u0001;!\tY3(\u0003\u0002=Y\t!QK\\5u\u0003I!W\r\\5wKJL(+\u001a9pg&$xN]=\u0016\u0003}\u0002\"\u0001Q\"\u000e\u0003\u0005S!A\u0011\u0011\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002E\u0003\n\u0011B)\u001a7jm\u0016\u0014\u0018PU3q_NLGo\u001c:z\u0003!)g/\u001a8u\u0005V\u001cX#A$\u0011\u0005![U\"A%\u000b\u0005)\u0013\u0013AB3wK:$8/\u0003\u0002M\u0013\n\t\u0002\f\u0014*fY\u0016\f7/Z#wK:$()^:\u0002\u001dI,G.Z1tKN+'O^5dKV\tq\n\u0005\u0002Q%6\t\u0011K\u0003\u0002 E%\u00111+\u0015\u0002\u000f%\u0016dW-Y:f'\u0016\u0014h/[2f\u0003A\t'o\u00195jm\u0016$'+\u001a7fCN,7/F\u0001W!\t9&,D\u0001Y\u0015\tI&%\u0001\u0002eE&\u00111\f\u0017\u0002\u0011\u0003J\u001c\u0007.\u001b<fIJ+G.Z1tKN\fQBZ8mI\u0016\u00148+\u001a:wS\u000e,W#\u00010\u0011\u0005A{\u0016B\u00011R\u000551u\u000e\u001c3feN+'O^5dK\u0006Y!o\u001c7f'\u0016\u0014h/[2f+\u0005\u0019\u0007C\u00013j\u001b\u0005)'B\u00014h\u0003!\u0019XmY;sSRL(B\u00015%\u0003!!W\r\u001d7ps&$\u0018B\u00016f\u0005-\u0011v\u000e\\3TKJ4\u0018nY3\u0002\u0017\rL\u0017\nZ*feZL7-Z\u000b\u0002[B\u0011\u0001K\\\u0005\u0003_F\u00131bQ5JIN+'O^5dK\u00069a-Y2u_JLX#\u0001:\u0011\u0005M4X\"\u0001;\u000b\u0005U\u0004\u0013\u0001B;uS2L!a\u001e;\u0003+\u0011+G.\u001b<fef|%M[3di\u001a\u000b7\r^8ss\u0006\u00012\r[3dW&\u001bX\u000b\u001d3bi\u0006\u0014G.\u001a\u000b\u0005ui\f)\u0001C\u0003|\u0015\u0001\u0007A0\u0001\tfq&\u001cH/\u001b8h\t\u0016d\u0017N^3ssB\u0019Q0!\u0001\u000e\u0003yT!a \u0011\u0002\r\u0011|W.Y5o\u0013\r\t\u0019A \u0002\t\t\u0016d\u0017N^3ss\"I\u0011q\u0001\u0006\u0011\u0002\u0003\u0007\u0011\u0011B\u0001\u0007C\u000e$\u0018n\u001c8\u0011\t\u0005-\u0011\u0011\u0004\b\u0005\u0003\u001b\t)\u0002E\u0002\u0002\u00101j!!!\u0005\u000b\u0007\u0005M\u0001&\u0001\u0004=e>|GOP\u0005\u0004\u0003/a\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001c\u0005u!AB*ue&twMC\u0002\u0002\u00181\n!d\u00195fG.L5/\u00169eCR\f'\r\\3%I\u00164\u0017-\u001e7uII*\"!a\t+\t\u0005%\u0011QE\u0016\u0003\u0003O\u0001B!!\u000b\u000245\u0011\u00111\u0006\u0006\u0005\u0003[\ty#A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0007\u0017\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00026\u0005-\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!r-\u001a;EK2Lg/\u001a:z\u001fJ\u0004\u0016\r\u001e;fe:$2\u0001`A\u001e\u0011\u001d\ti\u0004\u0004a\u0001\u0003\u0013\t!\u0002Z3mSZ,'/_%eQ\ra\u0011\u0011\t\t\u0005\u0003\u0007\ny%\u0004\u0002\u0002F)!\u0011\u0011GA$\u0015\u0011\tI%a\u0013\u0002\u000f5,GO]5dg*\u0019\u0011Q\n\u0014\u0002\u0011\r|G-\u00195bY\u0016LA!!\u0015\u0002F\t)A+[7fI\u0006Yq-\u001a;G_2$WM]%e)\u0011\tI!a\u0016\t\u000f\u0005uR\u00021\u0001\u0002\n!\u001aQ\"!\u0011\u0002\u0011\u0011|W\u000b\u001d3bi\u0016$2\u0001`A0\u0011\u0019\t\tG\u0004a\u0001y\u00069Q\u000f\u001d3bi\u0016$\u0017\u0001\u00033p\t\u0016dW\r^3\u0015\u0007i\n9\u0007C\u0004\u0002>=\u0001\r!!\u0003\u0002\u0011Y\fG.\u001b3bi\u0016$2AOA7\u0011\u0015\t\u0003\u00031\u0001}\u0003A1\u0018\r\\5eCR,G)\u001a7jm\u0016\u0014\u0018\u0010F\u0002;\u0003gBQ!I\tA\u0002q\f!C^1mS\u0012\fG/\u001a+sC:\u001c\u0018\u000e^5p]R9!(!\u001f\u0002|\u0005\u0015\u0005\"B\u0011\u0013\u0001\u0004a\bbBA?%\u0001\u0007\u0011qP\u0001\u0006gR\fw-\u001a\t\u0004{\u0006\u0005\u0015bAAB}\n)1\u000b^1hK\"9\u0011q\u0011\nA\u0002\u0005%\u0015A\u0003;sC:\u001c\u0018\u000e^5p]B\u0019Q0a#\n\u0007\u00055eP\u0001\u0006Ue\u0006t7/\u001b;j_:\fqb\u00195fG.L5\u000fR3mSZ,'/\u001f\u000b\u0004u\u0005M\u0005\"B\u0011\u0014\u0001\u0004a\u0018!E2veJ,g\u000e\u001e)sS:\u001c\u0017\u000e]1mgV\u0011\u0011\u0011\u0014\t\u0007\u00037\u000b)+!\u0003\u000f\t\u0005u\u0015\u0011\u0015\b\u0005\u0003\u001f\ty*C\u0001.\u0013\r\t\u0019\u000bL\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9+!+\u0003\u0011%#XM]1cY\u0016T1!a)-\u00039\u0019WO\u001d:f]R\u0014v\u000e\\3JIN,\"!a,\u0011\r\u0005E\u00161XA\u0005\u001b\t\t\u0019L\u0003\u0003\u00026\u0006]\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003sc\u0013AC2pY2,7\r^5p]&!\u0011QXAZ\u0005\u0019\u0011UO\u001a4fe\u0006)2m\\7qkR,\u0017I\u001c3Va\u0012\fG/\u001a#bi\u0016\u001cH#\u0003\u001e\u0002D\u0006\u0015\u0017qZAq\u0011\u0015\tc\u00031\u0001}\u0011%\t9M\u0006I\u0001\u0002\u0004\tI-A\u0006ekJ\fG/[8o\u001fB$\bcA\u0016\u0002L&\u0019\u0011Q\u001a\u0017\u0003\u0007%sG\u000fC\u0005\u0002RZ\u0001\n\u00111\u0001\u0002T\u0006a1\u000f^1si\u0012\u000bG/Z(qiB!\u0011Q[Ao\u001b\t\t9NC\u0002v\u00033T!!a7\u0002\t)\fg/Y\u0005\u0005\u0003?\f9N\u0001\u0003ECR,\u0007\"CAr-A\u0005\t\u0019AAj\u0003))g\u000e\u001a#bi\u0016|\u0005\u000f^\u0001 G>l\u0007/\u001e;f\u0003:$W\u000b\u001d3bi\u0016$\u0015\r^3tI\u0011,g-Y;mi\u0012\u0012TCAAuU\u0011\tI-!\n\u0002?\r|W\u000e];uK\u0006sG-\u00169eCR,G)\u0019;fg\u0012\"WMZ1vYR$3'\u0006\u0002\u0002p*\"\u00111[A\u0013\u0003}\u0019w.\u001c9vi\u0016\fe\u000eZ+qI\u0006$X\rR1uKN$C-\u001a4bk2$H\u0005N\u0001\u0013G\u0006d7-\u001e7bi\u0016|E\u000f[3s\t\u0006$X\r\u0006\u0005\u0002T\u0006]\u00181`A\u0000\u0011\u001d\tIP\u0007a\u0001\u0003'\fA\u0001Z1uK\"9\u0011Q \u000eA\u0002\u0005%\u0017\u0001\u00033ve\u0006$\u0018n\u001c8\t\u0013\t\u0005!\u0004%AA\u0002\u0005%\u0017\u0001C1eI&$\u0018n\u001c8\u00029\r\fGnY;mCR,w\n\u001e5fe\u0012\u000bG/\u001a\u0013eK\u001a\fW\u000f\u001c;%g\u0005\t2-\u00197dk2\fG/\u001a#ve\u0006$\u0018n\u001c8\u0015\r\u0005%'\u0011\u0002B\u0007\u0011\u001d\u0011Y\u0001\ba\u0001\u0003'\f\u0011b\u001d;beR$\u0015\r^3\t\u000f\t=A\u00041\u0001\u0002T\u00069QM\u001c3ECR,\u0007")
public interface DeliveryServiceUtils
extends Logging {
    public void com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(DeliveryObjectFactory var1);

    public DeliveryRepository deliveryRepository();

    public XLReleaseEventBus eventBus();

    public ReleaseService releaseService();

    public ArchivedReleases archivedReleases();

    public FolderService folderService();

    public RoleService roleService();

    public CiIdService ciIdService();

    public DeliveryObjectFactory factory();

    public void checkIsUpdatable(Delivery var1, String var2);

    public static /* synthetic */ String checkIsUpdatable$default$2$(DeliveryServiceUtils $this) {
        return $this.checkIsUpdatable$default$2();
    }

    default public String checkIsUpdatable$default$2() {
        return "update";
    }

    public static /* synthetic */ Delivery getDeliveryOrPattern$(DeliveryServiceUtils $this, String deliveryId) {
        return $this.getDeliveryOrPattern(deliveryId);
    }

    @Timed
    default public Delivery getDeliveryOrPattern(String deliveryId) {
        return this.deliveryRepository().read(deliveryId);
    }

    public static /* synthetic */ String getFolderId$(DeliveryServiceUtils $this, String deliveryId) {
        return $this.getFolderId(deliveryId);
    }

    @Timed
    default public String getFolderId(String deliveryId) {
        return this.deliveryRepository().findFolderId(deliveryId);
    }

    public static /* synthetic */ Delivery doUpdate$(DeliveryServiceUtils $this, Delivery updated) {
        return $this.doUpdate(updated);
    }

    /*
     * WARNING - void declaration
     */
    default public Delivery doUpdate(Delivery updated) {
        void var2_2;
        Delivery original = this.deliveryRepository().read(updated.getId());
        this.checkIsUpdatable(original, this.checkIsUpdatable$default$2());
        original.setTitle(updated.getTitle());
        original.setDescription(updated.getDescription());
        this.computeAndUpdateDates(original, Predef$.MODULE$.Integer2int(updated.getPlannedDuration()), updated.getStartDate(), updated.getEndDate());
        if (Strings.isNotBlank((String)updated.getFolderId())) {
            original.setFolderId(updated.getFolderId());
        }
        this.deliveryRepository().update(original);
        this.eventBus().publish((XLReleaseEvent)new DeliveryUpdatedEvent(original));
        return var2_2;
    }

    public static /* synthetic */ void doDelete$(DeliveryServiceUtils $this, String deliveryId) {
        $this.doDelete(deliveryId);
    }

    default public void doDelete(String deliveryId) {
        if (this.deliveryRepository().exists(deliveryId)) {
            Delivery delivery = this.deliveryRepository().read(deliveryId);
            this.checkIsUpdatable(delivery, "delete");
            this.deliveryRepository().delete(deliveryId);
            this.eventBus().publish((XLReleaseEvent)new DeliveryDeletedEvent(delivery));
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Release delivery [").append(deliveryId).append("] already deleted").toString());
        }
    }

    public static /* synthetic */ void validate$(DeliveryServiceUtils $this, Delivery delivery) {
        $this.validate(delivery);
    }

    default public void validate(Delivery delivery) {
        block0: {
            Checks.checkNotNull((Object)((Object)delivery), (String)"Release delivery");
            Checks.checkArgument((boolean)Strings.isNotBlank((String)delivery.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
            Checks.checkArgument((delivery.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Title must be 255 characters or less", (Object[])new Object[0]);
            Checks.checkArgument((!delivery.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
            Checks.checkArgument((boolean)Strings.isNotBlank((String)delivery.getFolderId()), (String)"Folder ID must be set", (Object[])new Object[0]);
            Checks.checkArgument((!Ids.isRoot((String)delivery.getFolderId()) ? 1 : 0) != 0, (String)new StringBuilder(47).append("Provided folder ID '").append(delivery.getFolderId()).append("' must not be a root folder").toString(), (Object[])new Object[0]);
            Checks.checkArgument((boolean)this.folderService().exists(delivery.getFolderId()), (String)new StringBuilder(48).append("Provided folder ID '").append(delivery.getFolderId()).append("' must exist in the database").toString(), (Object[])new Object[0]);
            if (!Strings.isNotEmpty((String)delivery.getDescription())) break block0;
            Checks.checkArgument((delivery.getDescription().length() < 1024 ? 1 : 0) != 0, (String)"Description must be 1024 characters or less", (Object[])new Object[0]);
        }
    }

    public static /* synthetic */ void validateDelivery$(DeliveryServiceUtils $this, Delivery delivery) {
        $this.validateDelivery(delivery);
    }

    default public void validateDelivery(Delivery delivery) {
        this.validate(delivery);
        this.checkIsDelivery(delivery);
        Checks.checkArgument((delivery.getStartDate() != null ? 1 : 0) != 0, (String)"Start date must be set", (Object[])new Object[0]);
        Checks.checkArgument((delivery.getEndDate() != null ? 1 : 0) != 0, (String)"End date must be set", (Object[])new Object[0]);
        Checks.checkArgument((boolean)delivery.getEndDate().after(delivery.getStartDate()), (String)"End date must be after start date", (Object[])new Object[0]);
    }

    public static /* synthetic */ void validateTransition$(DeliveryServiceUtils $this, Delivery delivery, Stage stage, Transition transition) {
        $this.validateTransition(delivery, stage, transition);
    }

    default public void validateTransition(Delivery delivery, Stage stage, Transition transition) {
        Checks.checkNotNull((Object)((Object)transition), (String)"Transition");
        Checks.checkArgument((boolean)Strings.isNotBlank((String)transition.getTitle()), (String)"Transition title must be set", (Object[])new Object[0]);
        Checks.checkArgument((transition.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Transition title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((!transition.getTitle().contains(DbConstants$.MODULE$.ESCAPE_CHAR()) ? 1 : 0) != 0, (String)new StringBuilder(42).append("Title must not contain reserved character ").append(DbConstants$.MODULE$.ESCAPE_CHAR()).toString(), (Object[])new Object[0]);
        Checks.checkArgument((!delivery.isLastStage(stage) ? 1 : 0) != 0, (String)"Transition can not be added to the last stage", (Object[])new Object[0]);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(transition.getAllConditions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.validate(delivery);
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void checkIsDelivery$(DeliveryServiceUtils $this, Delivery delivery) {
        $this.checkIsDelivery(delivery);
    }

    default public void checkIsDelivery(Delivery delivery) {
        Checks.checkArgument((!delivery.isTemplate() ? 1 : 0) != 0, (String)new StringBuilder(19).append(delivery.getId()).append(" must be a Delivery").toString(), (Object[])new Object[0]);
    }

    public static /* synthetic */ Iterable currentPrincipals$(DeliveryServiceUtils $this) {
        return $this.currentPrincipals();
    }

    default public Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    public static /* synthetic */ Buffer currentRoleIds$(DeliveryServiceUtils $this) {
        return $this.currentRoleIds();
    }

    default public Buffer<String> currentRoleIds() {
        return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService().getRolesFor(Permissions.getAuthentication())).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getId(), Buffer$.MODULE$.canBuildFrom());
    }

    public static /* synthetic */ void computeAndUpdateDates$(DeliveryServiceUtils $this, Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        $this.computeAndUpdateDates(delivery, durationOpt, startDateOpt, endDateOpt);
    }

    default public void computeAndUpdateDates(Delivery delivery, int durationOpt, Date startDateOpt, Date endDateOpt) {
        Tuple3 tuple3;
        Tuple3 tuple32;
        Function1 & Serializable & scala.Serializable isNotEmptyDate = (Function1 & Serializable & scala.Serializable)date -> BoxesRunTime.boxToBoolean((boolean)DeliveryServiceUtils.$anonfun$computeAndUpdateDates$1(date));
        int plannedDuration = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)durationOpt)).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 > 0).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Predef$.MODULE$.Integer2int(delivery.getPlannedDuration())));
        if (BoxesRunTime.unboxToBoolean((Object)isNotEmptyDate.apply((Object)startDateOpt)) && BoxesRunTime.unboxToBoolean((Object)isNotEmptyDate.apply((Object)endDateOpt))) {
            tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.calculateDuration(startDateOpt, endDateOpt)), (Object)startDateOpt, (Object)endDateOpt);
        } else if (BoxesRunTime.unboxToBoolean((Object)isNotEmptyDate.apply((Object)startDateOpt))) {
            tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)plannedDuration), (Object)startDateOpt, (Object)this.calculateOtherDate(startDateOpt, plannedDuration, this.calculateOtherDate$default$3()));
        } else if (BoxesRunTime.unboxToBoolean((Object)isNotEmptyDate.apply((Object)endDateOpt))) {
            tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)plannedDuration), (Object)this.calculateOtherDate(endDateOpt, plannedDuration, -1), (Object)endDateOpt);
        } else {
            Date startDate = Date.from(Instant.now());
            tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)plannedDuration), (Object)startDate, (Object)this.calculateOtherDate(startDate, plannedDuration, this.calculateOtherDate$default$3()));
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int duration = BoxesRunTime.unboxToInt((Object)tuple3._1());
        Date startDate = (Date)tuple3._2();
        Date endDate = (Date)tuple3._3();
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)duration), (Object)startDate, (Object)endDate);
        Tuple3 tuple34 = tuple33;
        int duration2 = BoxesRunTime.unboxToInt((Object)tuple34._1());
        Date startDate2 = (Date)tuple34._2();
        Date endDate2 = (Date)tuple34._3();
        delivery.setPlannedDuration(Predef$.MODULE$.int2Integer(duration2));
        delivery.setStartDate(startDate2);
        delivery.setEndDate(endDate2);
    }

    public static /* synthetic */ int computeAndUpdateDates$default$2$(DeliveryServiceUtils $this) {
        return $this.computeAndUpdateDates$default$2();
    }

    default public int computeAndUpdateDates$default$2() {
        return 0;
    }

    public static /* synthetic */ Date computeAndUpdateDates$default$3$(DeliveryServiceUtils $this) {
        return $this.computeAndUpdateDates$default$3();
    }

    default public Date computeAndUpdateDates$default$3() {
        return null;
    }

    public static /* synthetic */ Date computeAndUpdateDates$default$4$(DeliveryServiceUtils $this) {
        return $this.computeAndUpdateDates$default$4();
    }

    default public Date computeAndUpdateDates$default$4() {
        return null;
    }

    private Date calculateOtherDate(Date date, int duration, int addition) {
        return duration > 0 ? DateUtils.addHours((Date)date, (int)(duration * addition)) : DateUtils.addMonths((Date)date, (int)(1 * addition));
    }

    private int calculateOtherDate$default$3() {
        return 1;
    }

    private int calculateDuration(Date startDate, Date endDate) {
        LocalDateTime localScheduledStartDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(startDate.getTime()), ZoneId.systemDefault());
        LocalDateTime localDueDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(endDate.getTime()), ZoneId.systemDefault());
        return (int)localScheduledStartDate.until(localDueDate, ChronoUnit.HOURS);
    }

    public static /* synthetic */ boolean $anonfun$computeAndUpdateDates$2(Date x$3) {
        return x$3.getTime() != 0L;
    }

    public static /* synthetic */ boolean $anonfun$computeAndUpdateDates$1(Date date) {
        return Option$.MODULE$.apply((Object)date).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DeliveryServiceUtils.$anonfun$computeAndUpdateDates$2(x$3)));
    }

    public static void $init$(DeliveryServiceUtils $this) {
        $this.com$xebialabs$xlrelease$delivery$service$DeliveryServiceUtils$_setter_$factory_$eq(new DeliveryObjectFactory($this.ciIdService()));
    }
}

