/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupFilters;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupOrderMode;
import com.xebialabs.xlrelease.api.v1.views.ReleaseGroupTimeline;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.domain.group.ReleaseGroup;
import com.xebialabs.xlrelease.domain.group.ReleaseGroupStatus;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseGroupRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseGroupTimelineCalculator;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.SetLike;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0001\tuh\u0001B\u0001\u0003\u0001-\u00111CU3mK\u0006\u001cXm\u0012:pkB\u001cVM\u001d<jG\u0016T!a\u0001\u0003\u0002\u000fM,'O^5dK*\u0011QAB\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0002\u0005\u0002\u0013a,'-[1mC\n\u001c(\"A\u0005\u0002\u0007\r|Wn\u0001\u0001\u0014\t\u0001a!C\u0007\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012!B:mMRR'\"A\f\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\u0007\u000b\u0003\u000f1{wmZ5oOB\u00111\u0004H\u0007\u0002\u0005%\u0011QD\u0001\u0002\u001f%\u0016dW-Y:f\u000fJ|W\u000f\u001d+j[\u0016d\u0017N\\3DC2\u001cW\u000f\\1u_JD\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0017e\u0016dW-Y:f\u000fJ|W\u000f\u001d*fa>\u001c\u0018\u000e^8ssB\u0011\u0011\u0005J\u0007\u0002E)\u00111\u0005B\u0001\u000be\u0016\u0004xn]5u_JL\u0018BA\u0013#\u0005Y\u0011V\r\\3bg\u0016<%o\\;q%\u0016\u0004xn]5u_JL\b\u0002C\u0014\u0001\u0005\u000b\u0007I\u0011\u0001\u0015\u0002#I,G.Z1tKJ+\u0007o\\:ji>\u0014\u00180F\u0001*!\t\t#&\u0003\u0002,E\t\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\t\u00115\u0002!\u0011!Q\u0001\n%\n!C]3mK\u0006\u001cXMU3q_NLGo\u001c:zA!Aq\u0006\u0001BC\u0002\u0013\u0005\u0001'\u0001\bsK2,\u0017m]3TKJ4\u0018nY3\u0016\u0003E\u0002\"a\u0007\u001a\n\u0005M\u0012!A\u0004*fY\u0016\f7/Z*feZL7-\u001a\u0005\tk\u0001\u0011\t\u0011)A\u0005c\u0005y!/\u001a7fCN,7+\u001a:wS\u000e,\u0007\u0005\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0011\u0005mI\u0014B\u0001\u001e\u0003\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\t\u0011q\u0002!\u0011!Q\u0001\nu\n\u0001#\u0019:dQ&4X\r\u001a*fY\u0016\f7/Z:\u0011\u0005y\nU\"A \u000b\u0005\u0001#\u0011A\u00013c\u0013\t\u0011uH\u0001\tBe\u000eD\u0017N^3e%\u0016dW-Y:fg\"AA\t\u0001B\u0001B\u0003%Q)A\u0007g_2$WM]*feZL7-\u001a\t\u00037\u0019K!a\u0012\u0002\u0003\u001b\u0019{G\u000eZ3s'\u0016\u0014h/[2f\u0011!I\u0005A!A!\u0002\u0013Q\u0015a\u0003:pY\u0016\u001cVM\u001d<jG\u0016\u0004\"a\u0013)\u000e\u00031S!!\u0014(\u0002\u0011M,7-\u001e:jifT!a\u0014\u0004\u0002\u0011\u0011,\u0007\u000f\\8zSRL!!\u0015'\u0003\u0017I{G.Z*feZL7-\u001a\u0005\u0006'\u0002!\t\u0001V\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011U3v\u000bW-[7r\u0003\"a\u0007\u0001\t\u000b}\u0011\u0006\u0019\u0001\u0011\t\u000b\u001d\u0012\u0006\u0019A\u0015\t\u000b=\u0012\u0006\u0019A\u0019\t\u000b]\u0012\u0006\u0019\u0001\u001d\t\u000bq\u0012\u0006\u0019A\u001f\t\u000b\u0011\u0013\u0006\u0019A#\t\u000b%\u0013\u0006\u0019\u0001&)\u0005Is\u0006CA0k\u001b\u0005\u0001'BA1c\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003G\u0012\fqAZ1di>\u0014\u0018P\u0003\u0002fM\u0006)!-Z1og*\u0011q\r[\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\t\u0011.A\u0002pe\u001eL!a\u001b1\u0003\u0013\u0005+Ho\\<je\u0016$\u0007\"B7\u0001\t\u0003q\u0017\u0001C4fi\u001e\u0013x.\u001e9\u0015\u0005=<\bC\u00019v\u001b\u0005\t(B\u0001:t\u0003\u00159'o\\;q\u0015\t!H!\u0001\u0004e_6\f\u0017N\\\u0005\u0003mF\u0014ABU3mK\u0006\u001cXm\u0012:pkBDQ\u0001\u001f7A\u0002e\fqa\u001a:pkBLE\rE\u0002{\u0003\u0007q!a_@\u0011\u0005qtQ\"A?\u000b\u0005yT\u0011A\u0002\u001fs_>$h(C\u0002\u0002\u00029\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0003\u0003\u000f\u0011aa\u0015;sS:<'bAA\u0001\u001d!\u001aA.a\u0003\u0011\t\u00055\u0011\u0011D\u0007\u0003\u0003\u001fQ1!YA\t\u0015\u0011\t\u0019\"!\u0006\u0002\u000f5,GO]5dg*\u0019\u0011q\u0003\u0005\u0002\u0011\r|G-\u00195bY\u0016LA!a\u0007\u0002\u0010\t)A+[7fI\"9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0012aC3ySN$8o\u0012:pkB$B!a\t\u0002*A\u0019Q\"!\n\n\u0007\u0005\u001dbBA\u0004C_>dW-\u00198\t\ra\fi\u00021\u0001zQ\u0011\ti\"a\u0003\t\u000f\u0005=\u0002\u0001\"\u0001\u00022\u0005Y1M]3bi\u0016<%o\\;q)\ry\u00171\u0007\u0005\b\u0003k\ti\u00031\u0001p\u00031\u0011X\r\\3bg\u0016<%o\\;qQ\u0011\ti#a\u0003\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>\u0005YQ\u000f\u001d3bi\u0016<%o\\;q)\ry\u0017q\b\u0005\b\u0003k\tI\u00041\u0001pQ\u0011\tI$a\u0003\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H\u0005YA-\u001a7fi\u0016<%o\\;q)\u0011\tI%a\u0014\u0011\u00075\tY%C\u0002\u0002N9\u0011A!\u00168ji\"1\u00010a\u0011A\u0002eDC!a\u0011\u0002\f!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0013!E1eI6+WNY3sgR{wI]8vaR1\u0011\u0011JA-\u00037Ba\u0001_A*\u0001\u0004I\b\u0002CA/\u0003'\u0002\r!a\u0018\u0002\u00135,WNY3s\u0013\u0012\u001c\b#BA1\u0003WJh\u0002BA2\u0003Or1\u0001`A3\u0013\u0005y\u0011bAA5\u001d\u00059\u0001/Y2lC\u001e,\u0017\u0002BA7\u0003_\u00121aU3r\u0015\r\tIG\u0004\u0015\u0005\u0003'\nY\u0001C\u0004\u0002v\u0001!\t!a\u001e\u0002-I,Wn\u001c<f\u001b\u0016l'-\u001a:t\rJ|Wn\u0012:pkB$b!!\u0013\u0002z\u0005m\u0004B\u0002=\u0002t\u0001\u0007\u0011\u0010\u0003\u0005\u0002^\u0005M\u0004\u0019AA0Q\u0011\t\u0019(a\u0003\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\u000611/Z1sG\"$\u0002\"!\"\u0002\u0016\u00065\u0016q\u0017\t\u0006\u0003\u000f\u000b\tj\\\u0007\u0003\u0003\u0013SA!a#\u0002\u000e\u0006!Q\u000f^5m\u0015\t\ty)\u0001\u0003kCZ\f\u0017\u0002BAJ\u0003\u0013\u0013A\u0001T5ti\"A\u0011qSA@\u0001\u0004\tI*A\u0004gS2$XM]:\u0011\t\u0005m\u0015\u0011V\u0007\u0003\u0003;SA!a(\u0002\"\u0006)am\u001c:ng*!\u00111UAS\u0003\t1\u0018GC\u0002\u0002(\u0012\t1!\u00199j\u0013\u0011\tY+!(\u0003'I+G.Z1tK\u001e\u0013x.\u001e9GS2$XM]:\t\u0011\u0005=\u0016q\u0010a\u0001\u0003c\u000bA\u0001]1hKB\u0019\u0011%a-\n\u0007\u0005U&E\u0001\u0003QC\u001e,\u0007\u0002CA]\u0003\u007f\u0002\r!a/\u0002\u000f=\u0014H-\u001a:CsB!\u00111TA_\u0013\u0011\ty,!(\u0003+I+G.Z1tK\u001e\u0013x.\u001e9Pe\u0012,'/T8eK\"\"\u0011qPA\u0006\u0011\u001d\t)\r\u0001C\u0001\u0003\u000f\f1bZ3u)&lW\r\\5oKR1\u0011\u0011ZAk\u0003/\u0004B!a3\u0002R6\u0011\u0011Q\u001a\u0006\u0005\u0003\u001f\f\t+A\u0003wS\u0016<8/\u0003\u0003\u0002T\u00065'\u0001\u0006*fY\u0016\f7/Z$s_V\u0004H+[7fY&tW\r\u0003\u0004y\u0003\u0007\u0004\r!\u001f\u0005\t\u00033\f\u0019\r1\u0001\u0002\\\u0006\u0019an\\<\u0011\t\u0005u\u0017q]\u0007\u0003\u0003?TA!!9\u0002d\u0006!A/[7f\u0015\r\t)\u000f[\u0001\u0005U>$\u0017-\u0003\u0003\u0002j\u0006}'\u0001\u0003#bi\u0016$\u0016.\\3)\t\u0005\r\u00171\u0002\u0005\b\u0003_\u0004A\u0011AAy\u0003E)\b\u000fZ1uK\u001e\u0013x.\u001e9Ti\u0006$Xo\u001d\u000b\u0005\u0003\u0013\n\u0019\u0010\u0003\u0004y\u0003[\u0004\r!\u001f\u0015\u0005\u0003[\fY\u0001C\u0004\u0002z\u0002!\t!a?\u0002\u001fU\u0004H-\u0019;f\u000fJ|W\u000f\u001d*jg.$B!!\u0013\u0002~\"1\u00010a>A\u0002eDC!a>\u0002\f!9!1\u0001\u0001\u0005\n\t\u0015\u0011\u0001\u0006:fG\u0006d7-\u001e7bi\u0016\u0014\u0016n]6TG>\u0014X\r\u0006\u0003\u0002J\t\u001d\u0001bBA\u001b\u0005\u0003\u0001\ra\u001c\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u0003Q9W\r\u001e*fY\u0016\f7/\u001a*jg.\u001c6m\u001c:fgR!!q\u0002B\f!\u0019\t\t'a\u001b\u0003\u0012A\u0019QBa\u0005\n\u0007\tUaBA\u0002J]RD\u0001B!\u0007\u0003\n\u0001\u0007\u0011qL\u0001\u000be\u0016dW-Y:f\u0013\u0012\u001c\bb\u0002B\u000f\u0001\u0011\u0005!qD\u0001\fO\u0016$hi\u001c7eKJLE\rF\u0002z\u0005CAa\u0001\u001fB\u000e\u0001\u0004I\bb\u0002B\u0013\u0001\u0011\u0005!qE\u0001\u001dM&tGm\u0012:pkB\u001c(+\u001a4fe\u0016t7-\u001b8h%\u0016dW-Y:f)\u0011\tyF!\u000b\t\u000f\t-\"1\u0005a\u0001s\u0006I!/\u001a7fCN,\u0017\n\u001a\u0015\u0005\u0005G\tY\u0001C\u0004\u00032\u0001!\tAa\r\u0002C\u0019Lg\u000eZ!di&4Xm\u0012:pkB\u001c(+\u001a4fe\u0016t7-\u001b8h\r>dG-\u001a:\u0015\t\tU\"q\t\t\u0007\u0003C\nYGa\u000e\u0011\t\te\"1I\u0007\u0003\u0005wQAA!\u0010\u0003@\u0005Y\u0001/\u001a:tSN$XM\\2f\u0015\r\u0011\tEI\u0001\u0004gFd\u0017\u0002\u0002B#\u0005w\u0011QbQ5JI^KG\u000f\u001b+ji2,\u0007b\u0002B%\u0005_\u0001\r!_\u0001\tM>dG-\u001a:JI\"\"!qFA\u0006\u0011\u001d\u0011y\u0005\u0001C\u0005\u0005#\nAD]3dC2\u001cW\u000f\\1uKN#\u0018\r^;t\u0003:$\u0007K]8he\u0016\u001c8\u000f\u0006\u0003\u0002J\tM\u0003bBA\u001b\u0005\u001b\u0002\ra\u001c\u0005\b\u0005/\u0002A\u0011\u0002B-\u0003I9W\r\u001e*fY\u0016\f7/Z*uCR,8/Z:\u0015\t\tm#\u0011\u000e\t\u0007\u0003C\nYG!\u0018\u0011\t\t}#QM\u0007\u0003\u0005CR1Aa\u0019t\u0003\u0019\u0019H/\u0019;vg&!!q\rB1\u00055\u0011V\r\\3bg\u0016\u001cF/\u0019;vg\"A!\u0011\u0004B+\u0001\u0004\ty\u0006C\u0004\u0003n\u0001!IAa\u001c\u0002-\r\fGnY;mCR,wI]8vaB\u0013xn\u001a:fgN$BA!\u001d\u0003~A!!1\u000fB=\u001b\t\u0011)H\u0003\u0003\u0003x\u00055\u0015\u0001\u00027b]\u001eLAAa\u001f\u0003v\t9\u0011J\u001c;fO\u0016\u0014\b\u0002\u0003B@\u0005W\u0002\rAa\u0017\u0002\u0011M$\u0018\r^;tKNDqAa!\u0001\t\u0013\u0011))\u0001\u000bdC2\u001cW\u000f\\1uK\u001e\u0013x.\u001e9Ti\u0006$Xo\u001d\u000b\u0007\u0005\u000f\u0013iIa$\u0011\u0007A\u0014I)C\u0002\u0003\fF\u0014!CU3mK\u0006\u001cXm\u0012:pkB\u001cF/\u0019;vg\"9\u0011Q\u0007BA\u0001\u0004y\u0007\u0002\u0003B@\u0005\u0003\u0003\rAa\u0017\t\u000f\tM\u0005\u0001\"\u0003\u0003\u0016\u0006\u00012\r[3dW&\u001bX\u000b\u001d3bi\u0006\u0014G.\u001a\u000b\u0007\u0003\u0013\u00129Ja'\t\u000f\te%\u0011\u0013a\u0001_\u0006iQ\r_5ti&twm\u0012:pkBD\u0011B!(\u0003\u0012B\u0005\t\u0019A=\u0002\r\u0005\u001cG/[8o\u0011\u001d\u0011\t\u000b\u0001C\u0005\u0005G\u000b\u0001B^1mS\u0012\fG/\u001a\u000b\u0005\u0003\u0013\u0012)\u000bC\u0004\u00026\t}\u0005\u0019A8\t\u000f\t%\u0006\u0001\"\u0003\u0003,\u0006qa/\u00197jI\u0006$X-T3nE\u0016\u0014H\u0003BA%\u0005[CqAa\u000b\u0003(\u0002\u0007\u0011\u0010C\u0004\u00032\u0002!IAa-\u0002#\r,(O]3oiB\u0013\u0018N\\2ja\u0006d7/\u0006\u0002\u00036B1!q\u0017B_\u0005\u0003l!A!/\u000b\u0007\tmf\"\u0001\u0006d_2dWm\u0019;j_:LAAa0\u0003:\nA\u0011\n^3sC\ndW\r\u0005\u0003\u0003t\t\r\u0017\u0002BA\u0003\u0005kBqAa2\u0001\t\u0013\u0011I-\u0001\bdkJ\u0014XM\u001c;S_2,\u0017\nZ:\u0016\u0005\t-\u0007C\u0002Bg\u0005'\u0014\t-\u0004\u0002\u0003P*!!\u0011\u001bB]\u0003\u001diW\u000f^1cY\u0016LAA!6\u0003P\n1!)\u001e4gKJD\u0011B!7\u0001#\u0003%IAa7\u00025\rDWmY6JgV\u0003H-\u0019;bE2,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tu'fA=\u0003`.\u0012!\u0011\u001d\t\u0005\u0005G\u0014Y/\u0004\u0002\u0003f*!!q\u001dBu\u0003%)hn\u00195fG.,GM\u0003\u0002b\u001d%!!Q\u001eBs\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\u0004\u0001\tE\b\u0003\u0002Bz\u0005sl!A!>\u000b\u0007\t]h-\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LAAa?\u0003v\n91+\u001a:wS\u000e,\u0007")
public class ReleaseGroupService
implements ReleaseGroupTimelineCalculator {
    private final ReleaseGroupRepository releaseGroupRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    @Override
    public ReleaseGroupTimeline calculateTimeline(ReleaseGroup releaseGroup, DateTime now) {
        return ReleaseGroupTimelineCalculator.calculateTimeline$(this, releaseGroup, now);
    }

    @Override
    public <A extends DateTime> Ordering<A> dateOrdering() {
        return ReleaseGroupTimelineCalculator.dateOrdering$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleaseGroupService releaseGroupService = this;
        synchronized (releaseGroupService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    @Timed
    public ReleaseGroup getGroup(String groupId) {
        return this.releaseGroupRepository.read(groupId);
    }

    @Timed
    public boolean existsGroup(String groupId) {
        return this.releaseGroupRepository.exists(groupId);
    }

    @Timed
    public ReleaseGroup createGroup(ReleaseGroup releaseGroup) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating new release group [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseGroup})));
        this.validate(releaseGroup);
        releaseGroup.setId(this.ciIdService.getUniqueId(Type.valueOf(ReleaseGroup.class), ReleaseGroup.GROUP_ROOT));
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.create(releaseGroup);
        return releaseGroup;
    }

    @Timed
    public ReleaseGroup updateGroup(ReleaseGroup releaseGroup) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating release group [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseGroup})));
        this.validate(releaseGroup);
        this.checkIsUpdatable(this.releaseGroupRepository.read(releaseGroup.getId()), this.checkIsUpdatable$default$2());
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
        return releaseGroup;
    }

    @Timed
    public void deleteGroup(String groupId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting release group [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{groupId})));
        if (this.releaseGroupRepository.exists(groupId)) {
            ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
            this.checkIsUpdatable(releaseGroup, "delete");
            this.releaseGroupRepository.delete(groupId);
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Release group [", "] already deleted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{groupId})));
        }
    }

    @Timed
    public void addMembersToGroup(String groupId, Seq<String> memberIds) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding members ", " to release group [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{memberIds, groupId})));
        memberIds.foreach((Function1 & Serializable & scala.Serializable)releaseId -> {
            this.validateMember(releaseId);
            return BoxedUnit.UNIT;
        });
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.checkIsUpdatable(releaseGroup, this.checkIsUpdatable$default$2());
        releaseGroup.getReleaseIds().addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(memberIds).asJava());
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
    }

    @Timed
    public void removeMembersFromGroup(String groupId, Seq<String> memberIds) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing members ", " from release group [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{memberIds, groupId})));
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.checkIsUpdatable(releaseGroup, this.checkIsUpdatable$default$2());
        releaseGroup.removeReleaseIds((List)JavaConverters$.MODULE$.seqAsJavaListConverter(memberIds).asJava());
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
    }

    @Timed
    public List<ReleaseGroup> search(ReleaseGroupFilters filters, Page page, ReleaseGroupOrderMode orderBy) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.releaseGroupRepository.search(filters, page, orderBy, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds())).asJava();
    }

    @Timed
    public ReleaseGroupTimeline getTimeline(String groupId, DateTime now) {
        ReleaseGroup releaseGroup = this.getGroup(groupId);
        return this.calculateTimeline(releaseGroup, now);
    }

    @Timed
    public void updateGroupStatus(String groupId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recalculating status for release group [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{groupId})));
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.recalculateStatusAndProgress(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
    }

    @Timed
    public void updateGroupRisk(String groupId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recalculating risk for release group [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{groupId})));
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
    }

    private void recalculateRiskScore(ReleaseGroup releaseGroup) {
        Seq releaseIds = ((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(releaseGroup.getReleaseIds()).asScala()).toSeq();
        Seq<Object> riskScores = this.getReleaseRiskScores((Seq<String>)releaseIds);
        releaseGroup.setRiskScore(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)riskScores.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / riskScores.length()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0))));
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Release group [", "] risk score is now: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseGroup.getId(), releaseGroup.getRiskScore()})));
    }

    public Seq<Object> getReleaseRiskScores(Seq<String> releaseIds) {
        return releaseIds.nonEmpty() ? (Seq)this.releaseRepository().getRiskScores(releaseIds).padTo(releaseIds.size(), (Object)BoxesRunTime.boxToInteger((int)0), Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.empty();
    }

    public String getFolderId(String groupId) {
        return this.releaseGroupRepository.findFolderId(groupId);
    }

    @Timed
    public Seq<String> findGroupsReferencingRelease(String releaseId) {
        return this.releaseGroupRepository.findGroupsReferencingReleaseId(releaseId);
    }

    @Timed
    public Seq<CiIdWithTitle> findActiveGroupsReferencingFolder(String folderId) {
        return this.releaseGroupRepository.findActiveGroupsReferencingFolderId(folderId);
    }

    private void recalculateStatusAndProgress(ReleaseGroup releaseGroup) {
        Seq releaseIds = ((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(releaseGroup.getReleaseIds()).asScala()).toSeq();
        Seq<ReleaseStatus> statuses = this.getReleaseStatuses((Seq<String>)releaseIds);
        releaseGroup.setStatus(this.calculateGroupStatus(releaseGroup, statuses));
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Release group [", "] status is now: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseGroup.getId(), releaseGroup.getStatus()})));
        releaseGroup.setProgress(this.calculateGroupProgress(statuses));
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Release group [", "] progress is now: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseGroup.getId(), releaseGroup.getProgress()})));
    }

    private Seq<ReleaseStatus> getReleaseStatuses(Seq<String> releaseIds) {
        return releaseIds.nonEmpty() ? (Seq)this.releaseRepository().getStatuses(releaseIds).padTo(releaseIds.size(), (Object)ReleaseStatus.COMPLETED, Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.empty();
    }

    private Integer calculateGroupProgress(Seq<ReleaseStatus> statuses) {
        return statuses.isEmpty() ? Predef$.MODULE$.int2Integer(0) : Predef$.MODULE$.int2Integer((int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper((double)statuses.count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isInactive())) / (double)statuses.size() * (double)100)));
    }

    private ReleaseGroupStatus calculateGroupStatus(ReleaseGroup releaseGroup, Seq<ReleaseStatus> statuses) {
        return statuses.isEmpty() ? ReleaseGroupStatus.PLANNED : (statuses.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReleaseGroupService.$anonfun$calculateGroupStatus$1(statuses, x$2))) ? ReleaseGroupStatus.fromRelease((ReleaseStatus)statuses.head()) : (statuses.contains((Object)ReleaseStatus.FAILING) || statuses.contains((Object)ReleaseStatus.FAILED) ? ReleaseGroupStatus.FAILING : (statuses.contains((Object)ReleaseStatus.IN_PROGRESS) || statuses.contains((Object)ReleaseStatus.PLANNED) || statuses.contains((Object)ReleaseStatus.PAUSED) ? ReleaseGroupStatus.IN_PROGRESS : (!statuses.exists((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)ReleaseGroupService.$anonfun$calculateGroupStatus$2(status))) ? ReleaseGroupStatus.COMPLETED : releaseGroup.getStatus()))));
    }

    private void checkIsUpdatable(ReleaseGroup existingGroup, String action) {
        Checks.checkArgument((boolean)existingGroup.isUpdatable(), (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot ", " release group '", "' because it is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, existingGroup.getTitle(), existingGroup.getStatus()})), (Object[])new Object[0]);
    }

    private String checkIsUpdatable$default$2() {
        return "update";
    }

    private void validate(ReleaseGroup releaseGroup) {
        Checks.checkNotNull((Object)((Object)releaseGroup), (String)"Release group");
        Checks.checkArgument((releaseGroup.getStartDate() != null ? 1 : 0) != 0, (String)"Start date must be set", (Object[])new Object[0]);
        Checks.checkArgument((releaseGroup.getEndDate() != null ? 1 : 0) != 0, (String)"End date must be set", (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)releaseGroup.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
        Checks.checkArgument((releaseGroup.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((boolean)releaseGroup.getEndDate().after(releaseGroup.getStartDate()), (String)"End date must be after start date", (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)releaseGroup.getFolderId()), (String)"Folder ID must be set", (Object[])new Object[0]);
        Checks.checkArgument((!Ids.isRoot((String)releaseGroup.getFolderId()) ? 1 : 0) != 0, (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Provided folder ID '", "' must not be a root folder"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseGroup.getFolderId()})), (Object[])new Object[0]);
        if (releaseGroup.getReleaseIds() == null) {
            releaseGroup.setReleaseIds(new HashSet<String>());
        }
        releaseGroup.getReleaseIds().forEach(releaseId -> this.validateMember((String)releaseId));
        Checks.checkArgument((boolean)this.folderService.exists(releaseGroup.getFolderId()), (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Provided folder ID '", "' must exist in the database"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseGroup.getFolderId()})), (Object[])new Object[0]);
    }

    private void validateMember(String releaseId) {
        Checks.checkArgument((Ids.isDomainId((String)releaseId) && Ids.isReleaseId((String)releaseId) ? 1 : 0) != 0, (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Provided ID '", "' must be a valid release ID"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})), (Object[])new Object[0]);
        Checks.checkArgument((this.releaseRepository().exists(releaseId) || this.archivedReleases.exists(releaseId) ? 1 : 0) != 0, (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Provided ID '", "' must exist in the database"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{releaseId})), (Object[])new Object[0]);
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<String> currentRoleIds() {
        return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Buffer$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$calculateGroupStatus$1(Seq statuses$1, ReleaseStatus x$2) {
        ReleaseStatus releaseStatus = x$2;
        Object object = statuses$1.head();
        return !(releaseStatus != null ? !releaseStatus.equals(object) : object != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$calculateGroupStatus$2(ReleaseStatus status) {
        ReleaseStatus releaseStatus = status;
        ReleaseStatus releaseStatus2 = ReleaseStatus.COMPLETED;
        if (releaseStatus == null) {
            if (releaseStatus2 == null) return false;
        } else if (releaseStatus.equals(releaseStatus2)) return false;
        ReleaseStatus releaseStatus3 = status;
        ReleaseStatus releaseStatus4 = ReleaseStatus.ABORTED;
        if (releaseStatus3 == null) {
            if (releaseStatus4 == null) return false;
            return true;
        } else if (releaseStatus3.equals(releaseStatus4)) return false;
        return true;
    }

    @Autowired
    public ReleaseGroupService(ReleaseGroupRepository releaseGroupRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService) {
        this.releaseGroupRepository = releaseGroupRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        Logging.$init$((Logging)this);
        ReleaseGroupTimelineCalculator.$init$(this);
    }
}

