/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupFilters;
import com.xebialabs.xlrelease.api.v1.forms.ReleaseGroupOrderMode;
import com.xebialabs.xlrelease.api.v1.views.ReleaseGroupTimeline;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.domain.group.ReleaseGroup;
import com.xebialabs.xlrelease.domain.group.ReleaseGroupStatus;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.ReleaseGroupRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.ReleaseGroupTimelineCalculator;
import com.xebialabs.xlrelease.service.ReleaseService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.SetLike;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@Service
@ScalaSignature(bytes="\u0006\u0001\tuh\u0001B\u0013'\u0001=B\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u0013\u0002\u0011)\u0019!C\u0001\u0015\"Aa\n\u0001B\u0001B\u0003%1\n\u0003\u0005P\u0001\t\u0015\r\u0011\"\u0001Q\u0011!!\u0006A!A!\u0002\u0013\t\u0006\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011e\u0003!\u0011!Q\u0001\niC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0019\u0005\tI\u0002\u0011\t\u0011)A\u0005K\")Q\u000e\u0001C\u0001]\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0001bBA(\u0001\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003;\u0002A\u0011AA0\u0011\u001d\t9\u0007\u0001C\u0001\u0003SBq!a\u001c\u0001\t\u0003\t\t\bC\u0004\u0002~\u0001!\t!a \t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\"9\u0011Q\u0015\u0001\u0005\u0002\u0005\u001d\u0006bBAt\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0005\u001f\u0001A\u0011\u0001B\t\u0011\u001d\u00119\u0002\u0001C\u0001\u00053AqAa\b\u0001\t\u0013\u0011\t\u0003C\u0004\u0003&\u0001!\tAa\n\t\u000f\tU\u0002\u0001\"\u0001\u00038!9!1\b\u0001\u0005\u0002\tu\u0002b\u0002B#\u0001\u0011\u0005!q\t\u0005\b\u0005C\u0002A\u0011\u0002B2\u0011\u001d\u00119\u0007\u0001C\u0005\u0005SBqAa\u001f\u0001\t\u0013\u0011i\bC\u0004\u0003\u0010\u0002!IA!%\t\u000f\tu\u0005\u0001\"\u0003\u0003 \"I!\u0011\u0016\u0001\u0012\u0002\u0013%!1\u0016\u0005\b\u0005\u007f\u0003A\u0011\u0002Ba\u0011\u001d\u0011)\r\u0001C\u0005\u0005\u000fDqAa3\u0001\t\u0013\u0011i\rC\u0004\u0003`\u0002!IA!9\u0003'I+G.Z1tK\u001e\u0013x.\u001e9TKJ4\u0018nY3\u000b\u0005\u001dB\u0013aB:feZL7-\u001a\u0006\u0003S)\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005-b\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005i\u0013aA2p[\u000e\u00011\u0003\u0002\u00011my\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012a!\u00118z%\u00164\u0007CA\u001c=\u001b\u0005A$BA\u001d;\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005Y\u0014\u0001C4sSjTH.\u001a3\n\u0005uB$a\u0002'pO\u001eLgn\u001a\t\u0003\u007f\u0001k\u0011AJ\u0005\u0003\u0003\u001a\u0012aDU3mK\u0006\u001cXm\u0012:pkB$\u0016.\\3mS:,7)\u00197dk2\fGo\u001c:\u0002-I,G.Z1tK\u001e\u0013x.\u001e9SKB|7/\u001b;pef\u0004\"\u0001R$\u000e\u0003\u0015S!A\u0012\u0015\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002I\u000b\n1\"+\u001a7fCN,wI]8vaJ+\u0007o\\:ji>\u0014\u00180A\tsK2,\u0017m]3SKB|7/\u001b;pef,\u0012a\u0013\t\u0003\t2K!!T#\u0003#I+G.Z1tKJ+\u0007o\\:ji>\u0014\u00180\u0001\nsK2,\u0017m]3SKB|7/\u001b;pef\u0004\u0013A\u0004:fY\u0016\f7/Z*feZL7-Z\u000b\u0002#B\u0011qHU\u0005\u0003'\u001a\u0012aBU3mK\u0006\u001cXmU3sm&\u001cW-A\bsK2,\u0017m]3TKJ4\u0018nY3!\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0011\u0005}:\u0016B\u0001-'\u0005-\u0019\u0015.\u00133TKJ4\u0018nY3\u0002!\u0005\u00148\r[5wK\u0012\u0014V\r\\3bg\u0016\u001c\bCA._\u001b\u0005a&BA/)\u0003\t!'-\u0003\u0002`9\n\u0001\u0012I]2iSZ,GMU3mK\u0006\u001cXm]\u0001\u000eM>dG-\u001a:TKJ4\u0018nY3\u0011\u0005}\u0012\u0017BA2'\u000551u\u000e\u001c3feN+'O^5dK\u0006Y!o\u001c7f'\u0016\u0014h/[2f!\t17.D\u0001h\u0015\tA\u0017.\u0001\u0005tK\u000e,(/\u001b;z\u0015\tQ'&\u0001\u0005eKBdw._5u\u0013\tawMA\u0006S_2,7+\u001a:wS\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0005paF\u00148\u000f^;w!\ty\u0004\u0001C\u0003C\u0015\u0001\u00071\tC\u0003J\u0015\u0001\u00071\nC\u0003P\u0015\u0001\u0007\u0011\u000bC\u0003V\u0015\u0001\u0007a\u000bC\u0003Z\u0015\u0001\u0007!\fC\u0003a\u0015\u0001\u0007\u0011\rC\u0003e\u0015\u0001\u0007Q\r\u000b\u0002\u000bqB\u0019\u00110!\u0003\u000e\u0003iT!a\u001f?\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002~}\u00069a-Y2u_JL(bA@\u0002\u0002\u0005)!-Z1og*!\u00111AA\u0003\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA\u0004\u0003\ry'oZ\u0005\u0004\u0003\u0017Q(!C!vi><\u0018N]3e\u0003!9W\r^$s_V\u0004H\u0003BA\t\u0003C\u0001B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"A\u0003he>,\bOC\u0002\u0002\u001c!\na\u0001Z8nC&t\u0017\u0002BA\u0010\u0003+\u0011ABU3mK\u0006\u001cXm\u0012:pkBDq!a\t\f\u0001\u0004\t)#A\u0004he>,\b/\u00133\u0011\t\u0005\u001d\u0012Q\u0007\b\u0005\u0003S\t\t\u0004E\u0002\u0002,Ij!!!\f\u000b\u0007\u0005=b&\u0001\u0004=e>|GOP\u0005\u0004\u0003g\u0011\u0014A\u0002)sK\u0012,g-\u0003\u0003\u00028\u0005e\"AB*ue&twMC\u0002\u00024IB3aCA\u001f!\u0011\ty$a\u0013\u000e\u0005\u0005\u0005#bA>\u0002D)!\u0011QIA$\u0003\u001diW\r\u001e:jGNT1!!\u0013-\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BA'\u0003\u0003\u0012Q\u0001V5nK\u0012\f1\"\u001a=jgR\u001cxI]8vaR!\u00111KA-!\r\t\u0014QK\u0005\u0004\u0003/\u0012$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003Ga\u0001\u0019AA\u0013Q\ra\u0011QH\u0001\fGJ,\u0017\r^3He>,\b\u000f\u0006\u0003\u0002\u0012\u0005\u0005\u0004bBA2\u001b\u0001\u0007\u0011\u0011C\u0001\re\u0016dW-Y:f\u000fJ|W\u000f\u001d\u0015\u0004\u001b\u0005u\u0012aC;qI\u0006$Xm\u0012:pkB$B!!\u0005\u0002l!9\u00111\r\bA\u0002\u0005E\u0001f\u0001\b\u0002>\u0005YA-\u001a7fi\u0016<%o\\;q)\u0011\t\u0019(!\u001f\u0011\u0007E\n)(C\u0002\u0002xI\u0012A!\u00168ji\"9\u00111E\bA\u0002\u0005\u0015\u0002fA\b\u0002>\u0005\t\u0012\r\u001a3NK6\u0014WM]:U_\u001e\u0013x.\u001e9\u0015\r\u0005M\u0014\u0011QAB\u0011\u001d\t\u0019\u0003\u0005a\u0001\u0003KAq!!\"\u0011\u0001\u0004\t9)A\u0005nK6\u0014WM]%egB1\u0011\u0011RAJ\u0003KqA!a#\u0002\u0010:!\u00111FAG\u0013\u0005\u0019\u0014bAAIe\u00059\u0001/Y2lC\u001e,\u0017\u0002BAK\u0003/\u00131aU3r\u0015\r\t\tJ\r\u0015\u0004!\u0005u\u0012A\u0006:f[>4X-T3nE\u0016\u00148O\u0012:p[\u001e\u0013x.\u001e9\u0015\r\u0005M\u0014qTAQ\u0011\u001d\t\u0019#\u0005a\u0001\u0003KAq!!\"\u0012\u0001\u0004\t9\tK\u0002\u0012\u0003{\taa]3be\u000eDG\u0003CAU\u0003s\u000b\t.a7\u0011\r\u0005-\u0016QWA\t\u001b\t\tiK\u0003\u0003\u00020\u0006E\u0016\u0001B;uS2T!!a-\u0002\t)\fg/Y\u0005\u0005\u0003o\u000biK\u0001\u0003MSN$\bbBA^%\u0001\u0007\u0011QX\u0001\bM&dG/\u001a:t!\u0011\ty,!4\u000e\u0005\u0005\u0005'\u0002BAb\u0003\u000b\fQAZ8s[NTA!a2\u0002J\u0006\u0011a/\r\u0006\u0004\u0003\u0017D\u0013aA1qS&!\u0011qZAa\u0005M\u0011V\r\\3bg\u0016<%o\\;q\r&dG/\u001a:t\u0011\u001d\t\u0019N\u0005a\u0001\u0003+\fA\u0001]1hKB\u0019A)a6\n\u0007\u0005eWI\u0001\u0003QC\u001e,\u0007bBAo%\u0001\u0007\u0011q\\\u0001\b_J$WM\u001d\"z!\u0011\ty,!9\n\t\u0005\r\u0018\u0011\u0019\u0002\u0016%\u0016dW-Y:f\u000fJ|W\u000f](sI\u0016\u0014Xj\u001c3fQ\r\u0011\u0012QH\u0001\fO\u0016$H+[7fY&tW\r\u0006\u0004\u0002l\u0006]\u0018\u0011 \t\u0005\u0003[\f\u00190\u0004\u0002\u0002p*!\u0011\u0011_Ac\u0003\u00151\u0018.Z<t\u0013\u0011\t)0a<\u0003)I+G.Z1tK\u001e\u0013x.\u001e9US6,G.\u001b8f\u0011\u001d\t\u0019c\u0005a\u0001\u0003KAq!a?\u0014\u0001\u0004\ti0A\u0002o_^\u0004B!a@\u0003\n5\u0011!\u0011\u0001\u0006\u0005\u0005\u0007\u0011)!\u0001\u0003uS6,'\u0002\u0002B\u0004\u0003\u000b\tAA[8eC&!!1\u0002B\u0001\u0005!!\u0015\r^3US6,\u0007fA\n\u0002>\u0005\tR\u000f\u001d3bi\u0016<%o\\;q'R\fG/^:\u0015\t\u0005M$1\u0003\u0005\b\u0003G!\u0002\u0019AA\u0013Q\r!\u0012QH\u0001\u0010kB$\u0017\r^3He>,\bOU5tWR!\u00111\u000fB\u000e\u0011\u001d\t\u0019#\u0006a\u0001\u0003KA3!FA\u001f\u0003Q\u0011XmY1mGVd\u0017\r^3SSN\\7kY8sKR!\u00111\u000fB\u0012\u0011\u001d\t\u0019G\u0006a\u0001\u0003#\tAcZ3u%\u0016dW-Y:f%&\u001c8nU2pe\u0016\u001cH\u0003\u0002B\u0015\u0005c\u0001b!!#\u0002\u0014\n-\u0002cA\u0019\u0003.%\u0019!q\u0006\u001a\u0003\u0007%sG\u000fC\u0004\u00034]\u0001\r!a\"\u0002\u0015I,G.Z1tK&#7/A\u0006hKR4u\u000e\u001c3fe&#G\u0003BA\u0013\u0005sAq!a\t\u0019\u0001\u0004\t)#\u0001\u000fgS:$wI]8vaN\u0014VMZ3sK:\u001c\u0017N\\4SK2,\u0017m]3\u0015\t\u0005\u001d%q\b\u0005\b\u0005\u0003J\u0002\u0019AA\u0013\u0003%\u0011X\r\\3bg\u0016LE\rK\u0002\u001a\u0003{\t\u0011EZ5oI\u0006\u001bG/\u001b<f\u000fJ|W\u000f]:SK\u001a,'/\u001a8dS:<gi\u001c7eKJ$BA!\u0013\u0003\\A1\u0011\u0011RAJ\u0005\u0017\u0002BA!\u0014\u0003X5\u0011!q\n\u0006\u0005\u0005#\u0012\u0019&A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'b\u0001B+\u000b\u0006\u00191/\u001d7\n\t\te#q\n\u0002\u000e\u0007&LEmV5uQRKG\u000f\\3\t\u000f\tu#\u00041\u0001\u0002&\u0005Aam\u001c7eKJLE\rK\u0002\u001b\u0003{\tAD]3dC2\u001cW\u000f\\1uKN#\u0018\r^;t\u0003:$\u0007K]8he\u0016\u001c8\u000f\u0006\u0003\u0002t\t\u0015\u0004bBA27\u0001\u0007\u0011\u0011C\u0001\u0013O\u0016$(+\u001a7fCN,7\u000b^1ukN,7\u000f\u0006\u0003\u0003l\te\u0004CBAE\u0003'\u0013i\u0007\u0005\u0003\u0003p\tUTB\u0001B9\u0015\u0011\u0011\u0019(!\u0007\u0002\rM$\u0018\r^;t\u0013\u0011\u00119H!\u001d\u0003\u001bI+G.Z1tKN#\u0018\r^;t\u0011\u001d\u0011\u0019\u0004\ba\u0001\u0003\u000f\u000bacY1mGVd\u0017\r^3He>,\b\u000f\u0015:pOJ,7o\u001d\u000b\u0005\u0005\u007f\u0012Y\t\u0005\u0003\u0003\u0002\n\u001dUB\u0001BB\u0015\u0011\u0011))!-\u0002\t1\fgnZ\u0005\u0005\u0005\u0013\u0013\u0019IA\u0004J]R,w-\u001a:\t\u000f\t5U\u00041\u0001\u0003l\u0005A1\u000f^1ukN,7/\u0001\u000bdC2\u001cW\u000f\\1uK\u001e\u0013x.\u001e9Ti\u0006$Xo\u001d\u000b\u0007\u0005'\u0013IJa'\u0011\t\u0005M!QS\u0005\u0005\u0005/\u000b)B\u0001\nSK2,\u0017m]3He>,\bo\u0015;biV\u001c\bbBA2=\u0001\u0007\u0011\u0011\u0003\u0005\b\u0005\u001bs\u0002\u0019\u0001B6\u0003A\u0019\u0007.Z2l\u0013N,\u0006\u000fZ1uC\ndW\r\u0006\u0004\u0002t\t\u0005&Q\u0015\u0005\b\u0005G{\u0002\u0019AA\t\u00035)\u00070[:uS:<wI]8va\"I!qU\u0010\u0011\u0002\u0003\u0007\u0011QE\u0001\u0007C\u000e$\u0018n\u001c8\u00025\rDWmY6JgV\u0003H-\u0019;bE2,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t5&\u0006BA\u0013\u0005_[#A!-\u0011\t\tM&1X\u0007\u0003\u0005kSAAa.\u0003:\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003wJJAA!0\u00036\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0011Y\fG.\u001b3bi\u0016$B!a\u001d\u0003D\"9\u00111M\u0011A\u0002\u0005E\u0011A\u0004<bY&$\u0017\r^3NK6\u0014WM\u001d\u000b\u0005\u0003g\u0012I\rC\u0004\u0003B\t\u0002\r!!\n\u0002#\r,(O]3oiB\u0013\u0018N\\2ja\u0006d7/\u0006\u0002\u0003PB1!\u0011\u001bBl\u00057l!Aa5\u000b\u0007\tU''\u0001\u0006d_2dWm\u0019;j_:LAA!7\u0003T\nA\u0011\n^3sC\ndW\r\u0005\u0003\u0003\u0002\nu\u0017\u0002BA\u001c\u0005\u0007\u000babY;se\u0016tGOU8mK&#7/\u0006\u0002\u0003dB1!Q\u001dBv\u00057l!Aa:\u000b\t\t%(1[\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0011iOa:\u0003\r\t+hMZ3sQ\r\u0001!\u0011\u001f\t\u0005\u0005g\u0014I0\u0004\u0002\u0003v*!!q_A\u0001\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005w\u0014)PA\u0004TKJ4\u0018nY3")
public class ReleaseGroupService
implements ReleaseGroupTimelineCalculator {
    private final ReleaseGroupRepository releaseGroupRepository;
    private final ReleaseRepository releaseRepository;
    private final ReleaseService releaseService;
    private final CiIdService ciIdService;
    private final ArchivedReleases archivedReleases;
    private final FolderService folderService;
    private final RoleService roleService;
    private Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;

    @Override
    public ReleaseGroupTimeline calculateTimeline(ReleaseGroup releaseGroup, DateTime now) {
        return ReleaseGroupTimelineCalculator.calculateTimeline$(this, releaseGroup, now);
    }

    @Override
    public <A extends DateTime> Ordering<A> dateOrdering() {
        return ReleaseGroupTimelineCalculator.dateOrdering$(this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReleaseGroupService releaseGroupService = this;
        synchronized (releaseGroupService) {
            if (!this.bitmap$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    @Override
    public ReleaseService releaseService() {
        return this.releaseService;
    }

    @Timed
    public ReleaseGroup getGroup(String groupId) {
        return this.releaseGroupRepository.read(groupId);
    }

    @Timed
    public boolean existsGroup(String groupId) {
        return this.releaseGroupRepository.exists(groupId);
    }

    @Timed
    public ReleaseGroup createGroup(ReleaseGroup releaseGroup) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Creating new release group [").append((Object)releaseGroup).append("]").toString());
        this.validate(releaseGroup);
        releaseGroup.setId(this.ciIdService.getUniqueId(Type.valueOf(ReleaseGroup.class), ReleaseGroup.GROUP_ROOT));
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.create(releaseGroup);
        return releaseGroup;
    }

    @Timed
    public ReleaseGroup updateGroup(ReleaseGroup releaseGroup) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Updating release group [").append((Object)releaseGroup).append("]").toString());
        this.validate(releaseGroup);
        this.checkIsUpdatable(this.releaseGroupRepository.read(releaseGroup.getId()), this.checkIsUpdatable$default$2());
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
        return releaseGroup;
    }

    @Timed
    public void deleteGroup(String groupId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Deleting release group [").append(groupId).append("]").toString());
        if (this.releaseGroupRepository.exists(groupId)) {
            ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
            this.checkIsUpdatable(releaseGroup, "delete");
            this.releaseGroupRepository.delete(groupId);
        } else {
            this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Release group [").append(groupId).append("] already deleted").toString());
        }
    }

    @Timed
    public void addMembersToGroup(String groupId, Seq<String> memberIds) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Adding members ").append(memberIds).append(" to release group [").append(groupId).append("]").toString());
        memberIds.foreach((Function1 & Serializable & scala.Serializable)releaseId -> {
            this.validateMember(releaseId);
            return BoxedUnit.UNIT;
        });
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.checkIsUpdatable(releaseGroup, this.checkIsUpdatable$default$2());
        releaseGroup.getReleaseIds().addAll((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(memberIds).asJava());
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
    }

    @Timed
    public void removeMembersFromGroup(String groupId, Seq<String> memberIds) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Removing members ").append(memberIds).append(" from release group [").append(groupId).append("]").toString());
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.checkIsUpdatable(releaseGroup, this.checkIsUpdatable$default$2());
        releaseGroup.removeReleaseIds((List)JavaConverters$.MODULE$.seqAsJavaListConverter(memberIds).asJava());
        this.recalculateStatusAndProgress(releaseGroup);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
    }

    @Timed
    public List<ReleaseGroup> search(ReleaseGroupFilters filters, Page page, ReleaseGroupOrderMode orderBy) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.releaseGroupRepository.search(filters, page, orderBy, this.currentPrincipals(), (Iterable<String>)this.currentRoleIds())).asJava();
    }

    @Timed
    public ReleaseGroupTimeline getTimeline(String groupId, DateTime now) {
        ReleaseGroup releaseGroup = this.getGroup(groupId);
        return this.calculateTimeline(releaseGroup, now);
    }

    @Timed
    public void updateGroupStatus(String groupId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Recalculating status for release group [").append(groupId).append("]").toString());
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.recalculateStatusAndProgress(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
    }

    @Timed
    public void updateGroupRisk(String groupId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Recalculating risk for release group [").append(groupId).append("]").toString());
        ReleaseGroup releaseGroup = this.releaseGroupRepository.read(groupId);
        this.recalculateRiskScore(releaseGroup);
        this.releaseGroupRepository.update(releaseGroup);
    }

    private void recalculateRiskScore(ReleaseGroup releaseGroup) {
        Seq releaseIds = ((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(releaseGroup.getReleaseIds()).asScala()).toSeq();
        Seq<Object> riskScores = this.getReleaseRiskScores((Seq<String>)releaseIds);
        releaseGroup.setRiskScore(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)riskScores.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / riskScores.length()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0))));
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Release group [").append(releaseGroup.getId()).append("] risk score is now: ").append(releaseGroup.getRiskScore()).toString());
    }

    public Seq<Object> getReleaseRiskScores(Seq<String> releaseIds) {
        return releaseIds.nonEmpty() ? (Seq)this.releaseRepository().getRiskScores(releaseIds).padTo(releaseIds.size(), (Object)BoxesRunTime.boxToInteger((int)0), Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.empty();
    }

    public String getFolderId(String groupId) {
        return this.releaseGroupRepository.findFolderId(groupId);
    }

    @Timed
    public Seq<String> findGroupsReferencingRelease(String releaseId) {
        return this.releaseGroupRepository.findGroupsReferencingReleaseId(releaseId);
    }

    @Timed
    public Seq<CiIdWithTitle> findActiveGroupsReferencingFolder(String folderId) {
        return this.releaseGroupRepository.findActiveGroupsReferencingFolderId(folderId);
    }

    private void recalculateStatusAndProgress(ReleaseGroup releaseGroup) {
        Seq releaseIds = ((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(releaseGroup.getReleaseIds()).asScala()).toSeq();
        Seq<ReleaseStatus> statuses = this.getReleaseStatuses((Seq<String>)releaseIds);
        releaseGroup.setStatus(this.calculateGroupStatus(releaseGroup, statuses));
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Release group [").append(releaseGroup.getId()).append("] status is now: ").append((Object)releaseGroup.getStatus()).toString());
        releaseGroup.setProgress(this.calculateGroupProgress(statuses));
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Release group [").append(releaseGroup.getId()).append("] progress is now: ").append(releaseGroup.getProgress()).toString());
    }

    private Seq<ReleaseStatus> getReleaseStatuses(Seq<String> releaseIds) {
        return releaseIds.nonEmpty() ? (Seq)this.releaseRepository().getStatuses(releaseIds).padTo(releaseIds.size(), (Object)ReleaseStatus.COMPLETED, Seq$.MODULE$.canBuildFrom()) : (Seq)Seq$.MODULE$.empty();
    }

    private Integer calculateGroupProgress(Seq<ReleaseStatus> statuses) {
        return statuses.isEmpty() ? Predef$.MODULE$.int2Integer(0) : Predef$.MODULE$.int2Integer((int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper((double)statuses.count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isInactive())) / (double)statuses.size() * (double)100)));
    }

    private ReleaseGroupStatus calculateGroupStatus(ReleaseGroup releaseGroup, Seq<ReleaseStatus> statuses) {
        return statuses.isEmpty() ? ReleaseGroupStatus.PLANNED : (statuses.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReleaseGroupService.$anonfun$calculateGroupStatus$1(statuses, x$2))) ? ReleaseGroupStatus.fromRelease((ReleaseStatus)statuses.head()) : (statuses.contains((Object)ReleaseStatus.FAILING) || statuses.contains((Object)ReleaseStatus.FAILED) ? ReleaseGroupStatus.FAILING : (statuses.contains((Object)ReleaseStatus.IN_PROGRESS) || statuses.contains((Object)ReleaseStatus.PLANNED) || statuses.contains((Object)ReleaseStatus.PAUSED) ? ReleaseGroupStatus.IN_PROGRESS : (!statuses.exists((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)ReleaseGroupService.$anonfun$calculateGroupStatus$2(status))) ? ReleaseGroupStatus.COMPLETED : releaseGroup.getStatus()))));
    }

    private void checkIsUpdatable(ReleaseGroup existingGroup, String action) {
        Checks.checkArgument((boolean)existingGroup.isUpdatable(), (String)new StringBuilder(39).append("Cannot ").append(action).append(" release group '").append(existingGroup.getTitle()).append("' because it is ").append((Object)existingGroup.getStatus()).toString(), (Object[])new Object[0]);
    }

    private String checkIsUpdatable$default$2() {
        return "update";
    }

    private void validate(ReleaseGroup releaseGroup) {
        Checks.checkNotNull((Object)((Object)releaseGroup), (String)"Release group");
        Checks.checkArgument((releaseGroup.getStartDate() != null ? 1 : 0) != 0, (String)"Start date must be set", (Object[])new Object[0]);
        Checks.checkArgument((releaseGroup.getEndDate() != null ? 1 : 0) != 0, (String)"End date must be set", (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)releaseGroup.getTitle()), (String)"Title must be set", (Object[])new Object[0]);
        Checks.checkArgument((releaseGroup.getTitle().length() < 256 ? 1 : 0) != 0, (String)"Title must be 255 characters or less", (Object[])new Object[0]);
        Checks.checkArgument((boolean)releaseGroup.getEndDate().after(releaseGroup.getStartDate()), (String)"End date must be after start date", (Object[])new Object[0]);
        Checks.checkArgument((boolean)Strings.isNotBlank((String)releaseGroup.getFolderId()), (String)"Folder ID must be set", (Object[])new Object[0]);
        Checks.checkArgument((!Ids.isRoot((String)releaseGroup.getFolderId()) ? 1 : 0) != 0, (String)new StringBuilder(47).append("Provided folder ID '").append(releaseGroup.getFolderId()).append("' must not be a root folder").toString(), (Object[])new Object[0]);
        if (releaseGroup.getReleaseIds() == null) {
            releaseGroup.setReleaseIds(new HashSet<String>());
        }
        releaseGroup.getReleaseIds().forEach(releaseId -> this.validateMember((String)releaseId));
        Checks.checkArgument((boolean)this.folderService.exists(releaseGroup.getFolderId()), (String)new StringBuilder(48).append("Provided folder ID '").append(releaseGroup.getFolderId()).append("' must exist in the database").toString(), (Object[])new Object[0]);
    }

    private void validateMember(String releaseId) {
        Checks.checkArgument((Ids.isDomainId((String)releaseId) && Ids.isReleaseId((String)releaseId) ? 1 : 0) != 0, (String)new StringBuilder(41).append("Provided ID '").append(releaseId).append("' must be a valid release ID").toString(), (Object[])new Object[0]);
        Checks.checkArgument((this.releaseRepository().exists(releaseId) || this.archivedReleases.exists(releaseId) ? 1 : 0) != 0, (String)new StringBuilder(41).append("Provided ID '").append(releaseId).append("' must exist in the database").toString(), (Object[])new Object[0]);
    }

    private Iterable<String> currentPrincipals() {
        return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala();
    }

    private Buffer<String> currentRoleIds() {
        return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getId(), Buffer$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$calculateGroupStatus$1(Seq statuses$1, ReleaseStatus x$2) {
        ReleaseStatus releaseStatus = x$2;
        Object object = statuses$1.head();
        return !(releaseStatus != null ? !releaseStatus.equals(object) : object != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$calculateGroupStatus$2(ReleaseStatus status) {
        ReleaseStatus releaseStatus = status;
        ReleaseStatus releaseStatus2 = ReleaseStatus.COMPLETED;
        if (releaseStatus == null) {
            if (releaseStatus2 == null) return false;
        } else if (releaseStatus.equals(releaseStatus2)) return false;
        ReleaseStatus releaseStatus3 = status;
        ReleaseStatus releaseStatus4 = ReleaseStatus.ABORTED;
        if (releaseStatus3 == null) {
            if (releaseStatus4 == null) return false;
            return true;
        } else if (releaseStatus3.equals(releaseStatus4)) return false;
        return true;
    }

    @Autowired
    public ReleaseGroupService(ReleaseGroupRepository releaseGroupRepository, ReleaseRepository releaseRepository, ReleaseService releaseService, CiIdService ciIdService, ArchivedReleases archivedReleases, FolderService folderService, RoleService roleService) {
        this.releaseGroupRepository = releaseGroupRepository;
        this.releaseRepository = releaseRepository;
        this.releaseService = releaseService;
        this.ciIdService = ciIdService;
        this.archivedReleases = archivedReleases;
        this.folderService = folderService;
        this.roleService = roleService;
        Logging.$init$((Logging)this);
        ReleaseGroupTimelineCalculator.$init$(this);
    }
}

