/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.events.handler;

import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.actors.ReleaseGroupActorService;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.FolderDeletingAction;
import com.xebialabs.xlrelease.domain.events.ReleaseExecutionEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.SynchronizedSubscribe;
import com.xebialabs.xlrelease.repository.sql.persistence.CiIdWithTitle;
import com.xebialabs.xlrelease.risk.domain.events.RiskScoreUpdated;
import com.xebialabs.xlrelease.service.ReleaseGroupService;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Component
@EventListener
@ScalaSignature(bytes="\u0006\u0001a4A\u0001C\u0005\u0001)!A1\u0004\u0001B\u0001B\u0003%A\u0004\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0011\u0015I\u0003\u0001\"\u0001+\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u0015)\u0007\u0001\"\u0003g\u0005a\u0011V\r\\3bg\u0016<%o\\;q\u000bZ,g\u000e\u001e%b]\u0012dWM\u001d\u0006\u0003\u0015-\tq\u0001[1oI2,'O\u0003\u0002\r\u001b\u00051QM^3oiNT!AD\b\u0002\u0013ad'/\u001a7fCN,'B\u0001\t\u0012\u0003%AXMY5bY\u0006\u00147OC\u0001\u0013\u0003\r\u0019w.\\\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VMZ\u0001\u0019e\u0016dW-Y:f\u000fJ|W\u000f]!di>\u00148+\u001a:wS\u000e,\u0007CA\u000f!\u001b\u0005q\"BA\u0010\u000e\u0003\u0019\t7\r^8sg&\u0011\u0011E\b\u0002\u0019%\u0016dW-Y:f\u000fJ|W\u000f]!di>\u00148+\u001a:wS\u000e,\u0017a\u0005:fY\u0016\f7/Z$s_V\u00048+\u001a:wS\u000e,\u0007C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u000e\u0003\u001d\u0019XM\u001d<jG\u0016L!\u0001K\u0013\u0003'I+G.Z1tK\u001e\u0013x.\u001e9TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\rYSF\f\t\u0003Y\u0001i\u0011!\u0003\u0005\u00067\r\u0001\r\u0001\b\u0005\u0006E\r\u0001\ra\t\u0015\u0003\u0007A\u0002\"!\r\u001f\u000e\u0003IR!a\r\u001b\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u00026m\u00059a-Y2u_JL(BA\u001c9\u0003\u0015\u0011W-\u00198t\u0015\tI$(A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005Y\u0014aA8sO&\u0011QH\r\u0002\n\u0003V$xn^5sK\u0012\f!c\u001c8SK2,\u0017m]3Fq\u0016\u001cW\u000f^5p]R\u0011\u0001i\u0011\t\u0003-\u0005K!AQ\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006\t\u0012\u0001\r!R\u0001\u0006KZ,g\u000e\u001e\t\u0003\r*k\u0011a\u0012\u0006\u0003\u0019!S!!S\u0007\u0002\r\u0011|W.Y5o\u0013\tYuIA\u000bSK2,\u0017m]3Fq\u0016\u001cW\u000f^5p]\u00163XM\u001c;)\u0005\u0011i\u0005C\u0001(P\u001b\u0005Y\u0011B\u0001)\f\u0005U\u0019\u0016P\\2ie>t\u0017N_3e'V\u00147o\u0019:jE\u0016\f!c\u001c8SSN\\7kY8sKV\u0003H-\u0019;fIR\u0011\u0001i\u0015\u0005\u0006\t\u0016\u0001\r\u0001\u0016\t\u0003+jk\u0011A\u0016\u0006\u0003\u0019]S!!\u0013-\u000b\u0005ek\u0011\u0001\u0002:jg.L!a\u0017,\u0003!IK7o[*d_J,W\u000b\u001d3bi\u0016$\u0007FA\u0003N\u0003AygNR8mI\u0016\u0014H)\u001a7fi&tw\r\u0006\u0002A?\")\u0001M\u0002a\u0001C\u00061\u0011m\u0019;j_:\u0004\"A\u00122\n\u0005\r<%\u0001\u0006$pY\u0012,'\u000fR3mKRLgnZ!di&|g\u000e\u000b\u0002\u0007\u001b\u0006ABO]5hO\u0016\u00148\u000b^1ukN\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8\u0015\u0005\u0001;\u0007\"\u00025\b\u0001\u0004I\u0017a\u0002:fY\u0016\f7/\u001a\t\u0003U.l\u0011\u0001S\u0005\u0003Y\"\u0013qAU3mK\u0006\u001cX\r\u000b\u0002\u0001]B\u0011aj\\\u0005\u0003a.\u0011Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\bF\u0001\u0001s!\t\u0019h/D\u0001u\u0015\t)\b(\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016L!a\u001e;\u0003\u0013\r{W\u000e]8oK:$\b")
public class ReleaseGroupEventHandler {
    private final ReleaseGroupActorService releaseGroupActorService;
    private final ReleaseGroupService releaseGroupService;

    @SynchronizedSubscribe
    public void onReleaseExecution(ReleaseExecutionEvent event) {
        this.triggerStatusCalculation(event.release());
    }

    @SynchronizedSubscribe
    public void onRiskScoreUpdated(RiskScoreUpdated event) {
        this.releaseGroupService.findGroupsReferencingRelease(event.releaseId()).foreach((Function1 & Serializable & scala.Serializable)groupId -> {
            this.releaseGroupActorService.updateGroupRisk(groupId);
            return BoxedUnit.UNIT;
        });
    }

    @SynchronizedSubscribe
    public void onFolderDeleting(FolderDeletingAction action) {
        Seq<CiIdWithTitle> groups = this.releaseGroupService.findActiveGroupsReferencingFolder(action.folderId());
        if (groups.nonEmpty()) {
            throw new ItemInUseException(new StringBuilder(107).append("You cannot delete this folder. The folder or its subfolders contain releases referenced by active groups: ").append(((TraversableOnce)((SeqLike)((TraversableLike)groups.take(20)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.title(), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\"", "\", \"", "\"")).append(".").toString(), new Object[0]);
        }
    }

    private void triggerStatusCalculation(Release release) {
        this.releaseGroupService.findGroupsReferencingRelease(release.getId()).foreach((Function1 & Serializable & scala.Serializable)groupId -> {
            this.releaseGroupActorService.updateGroupStatus(groupId);
            return BoxedUnit.UNIT;
        });
    }

    @Autowired
    public ReleaseGroupEventHandler(ReleaseGroupActorService releaseGroupActorService, ReleaseGroupService releaseGroupService) {
        this.releaseGroupActorService = releaseGroupActorService;
        this.releaseGroupService = releaseGroupService;
    }
}

