/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.excel;

import com.xebialabs.xlrelease.excel.Export;
import com.xebialabs.xlrelease.reports.dto.PhaseDuration;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;

public class TopLongestPhaseExport
extends Export {
    private List<PhaseDuration> topLongestPhases;
    public static final int TITLE_COLUMN = 0;
    public static final int DURATION_COLUMN = 1;
    public static final int RELEASE_COLUMN = 2;
    private static final String TITLE_HEADER = "Phase";
    private static final String DURATION_HEADER = "Duration";
    private static final String RELEASE_HEADER = "Release";

    public TopLongestPhaseExport(List<PhaseDuration> topLongestPhases) {
        this.topLongestPhases = topLongestPhases;
    }

    public void addContent() {
        for (PhaseDuration phaseDuration : this.topLongestPhases) {
            XSSFRow row = this.sheet.createRow(this.rowIndex++);
            CellUtil.createCell((Row)row, (int)0, (String)phaseDuration.getTitle());
            XSSFCell duration = row.createCell(1);
            duration.setCellValue((double)phaseDuration.getDuration());
            CellUtil.createCell((Row)row, (int)2, (String)phaseDuration.getRelease());
        }
    }

    protected void setColumnsWidth() {
        this.sheet.setColumnWidth(0, TopLongestPhaseExport.numberOfCharacter((int)30));
        this.sheet.setColumnWidth(1, TopLongestPhaseExport.numberOfCharacter((int)15));
        this.sheet.setColumnWidth(2, TopLongestPhaseExport.numberOfCharacter((int)20));
    }

    protected void addHeaderRow() {
        XSSFRow row = this.sheet.createRow(this.rowIndex++);
        CellUtil.createCell((Row)row, (int)0, (String)TITLE_HEADER);
        CellUtil.createCell((Row)row, (int)1, (String)DURATION_HEADER);
        CellUtil.createCell((Row)row, (int)2, (String)RELEASE_HEADER);
        this.sheet.createRow(this.rowIndex++);
    }
}

