/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.excel;

import com.xebialabs.xlrelease.reports.domain.ReportCellError;
import com.xebialabs.xlrelease.reports.domain.ReportSheetError;
import com.xebialabs.xlrelease.reports.excel.ErrorSheet$;
import com.xebialabs.xlrelease.reports.excel.ExcelHeaderColumn;
import com.xebialabs.xlrelease.reports.excel.ExcelSheetWriter;
import com.xebialabs.xlrelease.reports.excel.ExcelStyles;
import java.awt.Color;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;
import scala.Function1;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005m;Q!\u0005\n\t\u0002u1Qa\b\n\t\u0002\u0001BQaJ\u0001\u0005\u0002!Bq!K\u0001C\u0002\u0013\u0005!\u0006\u0003\u0004/\u0003\u0001\u0006Ia\u000b\u0005\b_\u0005\u0011\r\u0011\"\u0001+\u0011\u0019\u0001\u0014\u0001)A\u0005W!9\u0011'\u0001b\u0001\n\u0003Q\u0003B\u0002\u001a\u0002A\u0003%1F\u0002\u0003 %\u0001\u0019\u0004\u0002\u0003\u001b\n\u0005\u000b\u0007I\u0011A\u001b\t\u0011eJ!\u0011!Q\u0001\nYBQaJ\u0005\u0005\u0002iBQ!P\u0005\u0005\u0002yBQaR\u0005\u0005\n!CQAS\u0005\u0005\u0012-CQ\u0001V\u0005\u0005\u0012U\u000b!\"\u0012:s_J\u001c\u0006.Z3u\u0015\t\u0019B#A\u0003fq\u000e,GN\u0003\u0002\u0016-\u00059!/\u001a9peR\u001c(BA\f\u0019\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001a5\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u00027\u0005\u00191m\\7\u0004\u0001A\u0011a$A\u0007\u0002%\tQQI\u001d:peNCW-\u001a;\u0014\u0005\u0005\t\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;\u0005a1\u000bS#F)~\u001bu\nT+N\u001dV\t1\u0006\u0005\u0002\u001fY%\u0011QF\u0005\u0002\u0012\u000bb\u001cW\r\u001c%fC\u0012,'oQ8mk6t\u0017!D*I\u000b\u0016#vlQ(M+6s\u0005%A\u0006D\u000b2culQ(M+6s\u0015\u0001D\"F\u00192{6i\u0014'V\u001b:\u0003\u0013\u0001D#S%>\u0013vlQ(M+6s\u0015!D#S%>\u0013vlQ(M+6s\u0005e\u0005\u0002\nC\u0005Y1\u000f[3fi^\u0013\u0018\u000e^3s+\u00051\u0004C\u0001\u00108\u0013\tA$C\u0001\tFq\u000e,Gn\u00155fKR<&/\u001b;fe\u0006a1\u000f[3fi^\u0013\u0018\u000e^3sAQ\u00111\b\u0010\t\u0003=%AQ\u0001\u000e\u0007A\u0002Y\n!\"\u00193e\u0007>tG/\u001a8u)\ty$\t\u0005\u0002#\u0001&\u0011\u0011i\t\u0002\u0005+:LG\u000fC\u0003D\u001b\u0001\u0007A)\u0001\u0004tifdWm\u001d\t\u0003=\u0015K!A\u0012\n\u0003\u0017\u0015C8-\u001a7TifdWm]\u0001\nC\u0012$\u0007*Z1eKJ$\"AN%\t\u000b\rs\u0001\u0019\u0001#\u0002\u0011\u0005$G-\u0012:s_J$\"a\u0010'\t\u000b5{\u0001\u0019\u0001(\u0002\u0017I,\u0007o\u001c:u\u000bJ\u0014xN\u001d\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#R\ta\u0001Z8nC&t\u0017BA*Q\u0005=\u0011V\r]8si\u000e+G\u000e\\#se>\u0014\u0018!D1eINCW-\u001a;FeJ|'\u000f\u0006\u0002@-\")q\u000b\u0005a\u00011\u0006\u0001\"/\u001a9peR\u001c\u0006.Z3u\u000bJ\u0014xN\u001d\t\u0003\u001ffK!A\u0017)\u0003!I+\u0007o\u001c:u'\",W\r^#se>\u0014\b")
public class ErrorSheet {
    private final ExcelSheetWriter sheetWriter;

    public static ExcelHeaderColumn ERROR_COLUMN() {
        return ErrorSheet$.MODULE$.ERROR_COLUMN();
    }

    public static ExcelHeaderColumn CELL_COLUMN() {
        return ErrorSheet$.MODULE$.CELL_COLUMN();
    }

    public static ExcelHeaderColumn SHEET_COLUMN() {
        return ErrorSheet$.MODULE$.SHEET_COLUMN();
    }

    public ExcelSheetWriter sheetWriter() {
        return this.sheetWriter;
    }

    public void addContent(ExcelStyles styles) {
        this.addHeader(styles);
        CollectionConverters$.MODULE$.ListHasAsScala(this.sheetWriter().getReportWorkbook().getSheetErrors()).asScala().foreach((Function1 & Serializable)e -> {
            this.addSheetError(e);
            return BoxedUnit.UNIT;
        });
        CollectionConverters$.MODULE$.ListHasAsScala(this.sheetWriter().getReportWorkbook().getCellErrors()).asScala().foreach((Function1 & Serializable)e -> {
            this.addError(e);
            return BoxedUnit.UNIT;
        });
    }

    private ExcelSheetWriter addHeader(ExcelStyles styles) {
        return this.sheetWriter().newRow().addCell("Note, that links may point to wrong cell if you make any changes", styles.addBackgroundColor(styles.bold(), Color.YELLOW)).mergeCells(new CellRangeAddress(this.sheetWriter().rowIndex - 1, this.sheetWriter().rowIndex - 1, this.sheetWriter().columnIndex - 1, this.sheetWriter().columnIndex)).newRow().addCell("(for example change order of rows in tables by using sort feature)", styles.addBackgroundColor(styles.bold(), Color.YELLOW)).mergeCells(new CellRangeAddress(this.sheetWriter().rowIndex - 1, this.sheetWriter().rowIndex - 1, this.sheetWriter().columnIndex - 1, this.sheetWriter().columnIndex)).newRow().newRow().addHeaderCell(ErrorSheet$.MODULE$.SHEET_COLUMN(), styles.whiteOnGreen()).addHeaderCell(ErrorSheet$.MODULE$.CELL_COLUMN(), styles.whiteOnGreen()).addHeaderCell(ErrorSheet$.MODULE$.ERROR_COLUMN(), styles.whiteOnGreen());
    }

    public void addError(ReportCellError reportError) {
        block1: {
            this.sheetWriter().newRow();
            String humanReadableAddressOfCellWithData = new StringBuilder(0).append(CellReference.convertNumToColString((int)reportError.col())).append(reportError.row()).toString();
            String addressOfCellWithData = new StringBuilder(3).append("'").append(reportError.sheet().getSheetName()).append("'!").append(humanReadableAddressOfCellWithData).toString();
            XSSFHyperlink linkFromErrorSheetToReportSheetForSheetNameCell = this.sheetWriter().getWorkbook().getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
            linkFromErrorSheetToReportSheetForSheetNameCell.setAddress(addressOfCellWithData);
            XSSFHyperlink linkFromErrorSheetToReportSheetForAddressCell = this.sheetWriter().getWorkbook().getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
            linkFromErrorSheetToReportSheetForAddressCell.setAddress(addressOfCellWithData);
            this.sheetWriter().addCell(reportError.sheet().getSheetName());
            this.sheetWriter().getSheet().getRow(this.sheetWriter().rowIndex - 1).getCell(this.sheetWriter().columnIndex - 1).setHyperlink((Hyperlink)linkFromErrorSheetToReportSheetForSheetNameCell);
            this.sheetWriter().addCell(humanReadableAddressOfCellWithData);
            this.sheetWriter().getSheet().getRow(this.sheetWriter().rowIndex - 1).getCell(this.sheetWriter().columnIndex - 1).setHyperlink((Hyperlink)linkFromErrorSheetToReportSheetForAddressCell);
            this.sheetWriter().addCell(reportError.throwable().getMessage());
            String addressOfCellWithErrorDescription = new StringBuilder(3).append("'").append(this.sheetWriter().getSheet().getSheetName()).append("'!").append(CellReference.convertNumToColString((int)(this.sheetWriter().columnIndex - 1))).append(this.sheetWriter().rowIndex).toString();
            XSSFHyperlink linkFromReportSheetToErrorSheet = this.sheetWriter().getWorkbook().getCreationHelper().createHyperlink(HyperlinkType.DOCUMENT);
            linkFromReportSheetToErrorSheet.setAddress(addressOfCellWithErrorDescription);
            XSSFCell targetCell = reportError.sheet().getRow(reportError.row() - 1).getCell(reportError.col());
            targetCell.setHyperlink((Hyperlink)linkFromReportSheetToErrorSheet);
            CellType cellType = targetCell.getCellTypeEnum();
            CellType cellType2 = CellType.STRING;
            if (cellType != null ? !cellType.equals(cellType2) : cellType2 != null) break block1;
            if (targetCell.getStringCellValue() == null || targetCell.getStringCellValue().isEmpty()) {
                targetCell.setCellValue(StringUtils.repeat((String)"\u00a0", (int)255));
            }
        }
    }

    public void addSheetError(ReportSheetError reportSheetError) {
        this.sheetWriter().newRow();
        this.sheetWriter().addCell(reportSheetError.sheetName());
        this.sheetWriter().addCell("");
        this.sheetWriter().addCell(reportSheetError.throwable().getMessage());
    }

    public ErrorSheet(ExcelSheetWriter sheetWriter) {
        this.sheetWriter = sheetWriter;
    }
}

