/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.job.impl.cleanup;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.configuration.AuditReportSettings;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.reports.job.domain.ReportJob;
import com.xebialabs.xlrelease.reports.job.domain.ReportJobStatus;
import com.xebialabs.xlrelease.reports.job.events.ReportJobDeletedEvent;
import com.xebialabs.xlrelease.reports.job.impl.GlobalReportStorage;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobInstance;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobInstanceFactory;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobFilters;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.threeten.extra.Interval;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ub\u0001B\t\u0013\u0001\u0005B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!1\u0005A!A!\u0002\u00139\u0005\"B'\u0001\t\u0003q\u0005b\u0002,\u0001\u0005\u0004%\ta\u0016\u0005\u0007A\u0002\u0001\u000b\u0011\u0002-\t\u000bM\u0001A\u0011A1\t\u000b\u0015\u0004A\u0011\u00014\t\rQ\u0004A\u0011\u0001\u000bb\u0011\u0015)\b\u0001\"\u0003b\u0011\u00151\b\u0001\"\u0003x\u0011\u001d\ty\u0002\u0001C\u0005\u0003CAq!!\n\u0001\t\u0013\t9\u0003C\u0004\u0002,\u0001!I!!\f\u0003/I+\u0007o\u001c:u\u00072,\u0017M\\3s\u001fB,'/\u0019;j_:\u001c(BA\n\u0015\u0003\u001d\u0019G.Z1okBT!!\u0006\f\u0002\t%l\u0007\u000f\u001c\u0006\u0003/a\t1A[8c\u0015\tI\"$A\u0004sKB|'\u000f^:\u000b\u0005ma\u0012!\u0003=me\u0016dW-Y:f\u0015\tib$A\u0005yK\nL\u0017\r\\1cg*\tq$A\u0002d_6\u001c\u0001aE\u0002\u0001E!\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0007CA\u0015/\u001b\u0005Q#BA\u0016-\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005i\u0013\u0001C4sSjTH.\u001a3\n\u0005=R#a\u0002'pO\u001eLgnZ\u0001\u0014e\u0016\u0004xN\u001d;K_\n\u0014V\r]8tSR|'/\u001f\t\u0003eUj\u0011a\r\u0006\u0003iY\t!B]3q_NLGo\u001c:z\u0013\t14GA\nSKB|'\u000f\u001e&pEJ+\u0007o\\:ji>\u0014\u00180\u0001\rsKB|'\u000f\u001e&pE&s7\u000f^1oG\u00164\u0015m\u0019;pef\u0004\"!\u000f\u001e\u000e\u0003QI!a\u000f\u000b\u00031I+\u0007o\u001c:u\u0015>\u0014\u0017J\\:uC:\u001cWMR1di>\u0014\u00180A\fd_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0011a\bQ\u0007\u0002\u007f)\u0011AGG\u0005\u0003\u0003~\u0012qcQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0002'\u001ddwNY1m%\u0016\u0004xN\u001d;Ti>\u0014\u0018mZ3\u0011\u0005e\"\u0015BA#\u0015\u0005M9En\u001c2bYJ+\u0007o\u001c:u'R|'/Y4f\u0003!)g/\u001a8u\u0005V\u001c\bC\u0001%L\u001b\u0005I%B\u0001&\u001b\u0003\u0019)g/\u001a8ug&\u0011A*\u0013\u0002\u001212\u0013V\r\\3bg\u0016,e/\u001a8u\u0005V\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0004P#J\u001bF+\u0016\t\u0003!\u0002i\u0011A\u0005\u0005\u0006a\u0019\u0001\r!\r\u0005\u0006o\u0019\u0001\r\u0001\u000f\u0005\u0006y\u0019\u0001\r!\u0010\u0005\u0006\u0005\u001a\u0001\ra\u0011\u0005\u0006\r\u001a\u0001\raR\u0001\u0013S:LG/[1mSj\fG/[8o)&lW-F\u0001Y!\tIf,D\u0001[\u0015\tYF,\u0001\u0003vi&d'\"A/\u0002\t)\fg/Y\u0005\u0003?j\u0013A\u0001R1uK\u0006\u0019\u0012N\\5uS\u0006d\u0017N_1uS>tG+[7fAQ\t!\r\u0005\u0002$G&\u0011A\r\n\u0002\u0005+:LG/A\u0006o_\u0012,7\t\\3b]V\u0004HC\u00012h\u0011\u0015A'\u00021\u0001j\u0003\u0011qw\u000eZ3\u0011\u0005)\fhBA6p!\taG%D\u0001n\u0015\tq\u0007%\u0001\u0004=e>|GOP\u0005\u0003a\u0012\na\u0001\u0015:fI\u00164\u0017B\u0001:t\u0005\u0019\u0019FO]5oO*\u0011\u0001\u000fJ\u0001\u000egR\fG/^:DY\u0016\fg.\u001e9\u0002\u001dM$xN]1hK\u000ecW-\u00198va\u0006Ya-Y5m\u001d>$WMS8c)\t\u0011\u0007\u0010C\u0003z\u001b\u0001\u0007!0A\u0003k_\nLE\rE\u0002|\u00033q1\u0001`A\n\u001d\ri\u0018q\u0002\b\u0004}\u00065abA@\u0002\f9!\u0011\u0011AA\u0005\u001d\u0011\t\u0019!a\u0002\u000f\u00071\f)!C\u0001 \u0013\tib$\u0003\u0002\u001c9%\u0011\u0011DG\u0005\u0003/aI1!!\u0005\u0017\u0003\r\t\u0007/[\u0005\u0005\u0003+\t9\"\u0001\fSKB|'\u000f^5oO\u0016sw-\u001b8f'\u0016\u0014h/[2f\u0015\r\t\tBF\u0005\u0005\u00037\tiBA\u0003K_\nLEM\u0003\u0003\u0002\u0016\u0005]\u0011a\u0002:fcV,W/\u001a\u000b\u0004E\u0006\r\u0002\"B=\u000f\u0001\u0004Q\u0018\u0001\u00044bS2\u001cF/\u00197f\u0015>\u0014Gc\u00012\u0002*!)\u0011p\u0004a\u0001u\u0006!a-Y5m)\u0015\u0011\u0017qFA\u0019\u0011\u0015I\b\u00031\u0001{\u0011\u0019\t\u0019\u0004\u0005a\u0001S\u0006\u0019Qn]4")
public class ReportCleanerOperations
implements Logging {
    private final ReportJobRepository reportJobRepository;
    private final ReportJobInstanceFactory reportJobInstanceFactory;
    private final ConfigurationRepository configurationRepository;
    private final GlobalReportStorage globalReportStorage;
    private final XLReleaseEventBus eventBus;
    private final Date initializationTime;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportCleanerOperations reportCleanerOperations = this;
        synchronized (reportCleanerOperations) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public Date initializationTime() {
        return this.initializationTime;
    }

    public void cleanup() {
        this.statusCleanup();
        this.storageCleanup();
    }

    public void nodeCleanup(String node) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(39).append("Report status cleanup for node ").append(node).append(" started").toString());
        if (Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.reportJobRepository.startedNodeJobIds(node).foreach((Function1 & Serializable)jobId -> {
            this.failNodeJob(jobId);
            return BoxedUnit.UNIT;
        })).isFailure()) {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(48).append("Report status cleanup failed for jobs on node '").append(node).append("'").toString());
        }
        if (Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.reportJobRepository.submittedNodeJobIds(node).foreach((Function1 & Serializable)jobId -> {
            this.requeue(jobId);
            return BoxedUnit.UNIT;
        })).isFailure()) {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(54).append("Requeue failed for jobs that were submitted on node '").append(node).append("'").toString());
        }
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(37).append("Report status cleanup for node ").append(node).append(" ended").toString());
    }

    public void statusCleanup() {
        this.logger().debug((Function0 & Serializable)() -> "Report status cleanup started");
        if (Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.reportJobRepository.startedStaleJobIds(this.initializationTime()).foreach((Function1 & Serializable)jobId -> {
            this.failStaleJob(jobId);
            return BoxedUnit.UNIT;
        })).isFailure()) {
            this.logger().warn((Function0 & Serializable)() -> "Report status cleanup failed for stale jobs");
        }
        if (Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.reportJobRepository.submittedStaleJobIds(this.initializationTime()).foreach((Function1 & Serializable)jobId -> {
            this.requeue(jobId);
            return BoxedUnit.UNIT;
        })).isFailure()) {
            this.logger().warn((Function0 & Serializable)() -> "Requeue failed for previously submitted jobs");
        }
        this.logger().debug((Function0 & Serializable)() -> "Report status cleanup ended");
    }

    private void storageCleanup() {
        this.logger().debug((Function0 & Serializable)() -> "Report storage cleanup started");
        AuditReportSettings reportSettings = (AuditReportSettings)this.configurationRepository.read("Configuration/settings/AuditReportSettings");
        ReportJobFilters filter = new ReportJobFilters();
        ZonedDateTime retentionCutOffDate = LocalDateTime.now().minusDays(Predef$.MODULE$.Integer2int(reportSettings.getReportsRetentionPeriod())).atZone(ZoneId.systemDefault());
        filter.endTime_$eq(Interval.of((Instant)Instant.MIN, (Instant)retentionCutOffDate.toInstant()));
        filter.statuses_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ReportJobStatus.ABORTED.name(), ReportJobStatus.FAILED.name(), ReportJobStatus.COMPLETED.name()}))).asJava());
        Page<ReportJob> result = this.reportJobRepository.query(filter, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
        ListBuffer events = ListBuffer$.MODULE$.empty();
        result.get().forEach(reportJob -> {
            try {
                if ($this.globalReportStorage.cleanup((ReportJob)((Object)reportJob))) {
                    reportJob.status_$eq(ReportJobStatus.DELETED);
                    events.$plus$eq((Object)new ReportJobDeletedEvent($this.reportJobRepository.update((ReportJob)((Object)reportJob))));
                }
            }
            catch (Exception e) {
                this.logger().warn((Function0 & Serializable)() -> e.getMessage());
            }
        });
        events.foreach((Function1 & Serializable)x$1 -> {
            this.eventBus.publish(x$1);
            return BoxedUnit.UNIT;
        });
        this.logger().debug((Function0 & Serializable)() -> "Report storage cleanup finished");
    }

    private void failNodeJob(Integer jobId) {
        this.fail(jobId, new StringBuilder(89).append("Job '").append(jobId).append("' marked as '").append((Object)ReportJobStatus.FAILED).append("' because it was executing on a node that was removed from XLR cluster.").toString());
    }

    private void requeue(Integer jobId) {
        ReportJobInstance reportJobInstance = (ReportJobInstance)this.reportJobRepository.findByJobId(jobId).map((Function1 & Serializable)reportJob -> $this.reportJobInstanceFactory.create((ReportJob)((Object)reportJob))).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(25).append("Job with id '").append(jobId).append("' not found.").toString(), new Object[0]);
        });
        reportJobInstance.enqueue();
    }

    private void failStaleJob(Integer jobId) {
        this.fail(jobId, new StringBuilder(44).append("Job '").append(jobId).append("' is a stale report job that should be ").append((Object)ReportJobStatus.FAILED).toString());
    }

    private void fail(Integer jobId, String msg) {
        this.reportJobRepository.findByJobId(jobId).foreach((Function1 & Serializable)reportJob -> {
            ReportCleanerOperations.$anonfun$fail$1(this, msg, reportJob);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$fail$1(ReportCleanerOperations $this, String msg$1, ReportJob reportJob) {
        new Some((Object)$this.reportJobInstanceFactory.create(reportJob)).foreach((Function1 & Serializable)jobInstance -> {
            jobInstance.fail(new IllegalStateException(msg$1));
            return BoxedUnit.UNIT;
        });
    }

    public ReportCleanerOperations(ReportJobRepository reportJobRepository, ReportJobInstanceFactory reportJobInstanceFactory, ConfigurationRepository configurationRepository, GlobalReportStorage globalReportStorage, XLReleaseEventBus eventBus) {
        this.reportJobRepository = reportJobRepository;
        this.reportJobInstanceFactory = reportJobInstanceFactory;
        this.configurationRepository = configurationRepository;
        this.globalReportStorage = globalReportStorage;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        this.initializationTime = Date.from(Instant.now());
    }
}

