/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.job.impl;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.reports.job.api.ReportDefinition;
import com.xebialabs.xlrelease.reports.job.api.ReportingEngineService;
import com.xebialabs.xlrelease.reports.job.api.StreamingReportResult;
import com.xebialabs.xlrelease.reports.job.domain.ReportJob;
import com.xebialabs.xlrelease.reports.job.domain.ReportJobStatus;
import com.xebialabs.xlrelease.reports.job.events.ReportJobDeletedEvent;
import com.xebialabs.xlrelease.reports.job.impl.AbortReportJob;
import com.xebialabs.xlrelease.reports.job.impl.GlobalReportStorage;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobInstance;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobInstanceFactory;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobFilters;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobRepository;
import com.xebialabs.xlrelease.service.BroadcastService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005mg\u0001\u0002\u000e\u001c\u0001!B\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"AQ\n\u0001B\u0001B\u0003%a\n\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003V\u0011!A\u0006A!A!\u0002\u0013I\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0011!\u0004!\u0011!Q\u0001\n%DQa\u001c\u0001\u0005\u0002ADQ!\u001f\u0001\u0005BiDq!a\r\u0001\t\u0003\n)\u0004C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V!9\u0011q\f\u0001\u0005B\u0005\u0005\u0004bBA3\u0001\u0011\u0005\u0013q\r\u0005\b\u0003K\u0002A\u0011IA9\u0011\u001d\t9\t\u0001C!\u0003\u0013Cq!a#\u0001\t\u0003\ni\tC\u0004\u0002\f\u0002!\t%!%\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\n\"9\u0011q\u0013\u0001\u0005B\u0005e\u0005bBA_\u0001\u0011%\u0011q\u0018\u0005\b\u0003K\u0002A\u0011BAb\u0011\u001d\tI\r\u0001C\u0005\u0003\u0017Dq!a4\u0001\t\u0013\t\t\u000eC\u0004\u0002V\u0002!I!a6\u0003;\u0011+g-Y;miJ+\u0007o\u001c:uS:<WI\\4j]\u0016\u001cVM\u001d<jG\u0016T!\u0001H\u000f\u0002\t%l\u0007\u000f\u001c\u0006\u0003=}\t1A[8c\u0015\t\u0001\u0013%A\u0004sKB|'\u000f^:\u000b\u0005\t\u001a\u0013!\u0003=me\u0016dW-Y:f\u0015\t!S%A\u0005yK\nL\u0017\r\\1cg*\ta%A\u0002d_6\u001c\u0001a\u0005\u0003\u0001S=*\u0004C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g\r\u0005\u00021g5\t\u0011G\u0003\u00023;\u0005\u0019\u0011\r]5\n\u0005Q\n$A\u0006*fa>\u0014H/\u001b8h\u000b:<\u0017N\\3TKJ4\u0018nY3\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014!B:mMRR'\"\u0001\u001e\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!\u0001P\u001c\u0003\u000f1{wmZ5oO\u0006\u0011\u0012\r\u001d9mS\u000e\fG/[8o\u0007>tG/\u001a=u!\tyd)D\u0001A\u0015\t\t%)A\u0004d_:$X\r\u001f;\u000b\u0005\r#\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\u0015\u000b1a\u001c:h\u0013\t9\u0005I\u0001\nBaBd\u0017nY1uS>t7i\u001c8uKb$\u0018\u0001\u0007:fa>\u0014HOS8c\u0013:\u001cH/\u00198dK\u001a\u000b7\r^8ssB\u0011!jS\u0007\u00027%\u0011Aj\u0007\u0002\u0019%\u0016\u0004xN\u001d;K_\nLen\u001d;b]\u000e,g)Y2u_JL\u0018a\u0005:fa>\u0014HOS8c%\u0016\u0004xn]5u_JL\bCA(S\u001b\u0005\u0001&BA)\u001e\u0003)\u0011X\r]8tSR|'/_\u0005\u0003'B\u00131CU3q_J$(j\u001c2SKB|7/\u001b;pef\f1c\u001a7pE\u0006d'+\u001a9peR\u001cFo\u001c:bO\u0016\u0004\"A\u0013,\n\u0005][\"aE$m_\n\fGNU3q_J$8\u000b^8sC\u001e,\u0017A\u00059fe6L7o]5p]\u0016sgm\u001c:dKJ\u0004\"AW0\u000e\u0003mS!\u0001X/\u0002\u0011M,7-\u001e:jifT!AX\u0012\u0002\u0011\u0011,\u0007\u000f\\8zSRL!\u0001Y.\u0003%A+'/\\5tg&|g.\u00128g_J\u001cWM]\u0001\tKZ,g\u000e\u001e\"vgB\u00111MZ\u0007\u0002I*\u0011Q-I\u0001\u0007KZ,g\u000e^:\n\u0005\u001d$'!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u0006\u0001\"M]8bI\u000e\f7\u000f^*feZL7-\u001a\t\u0003U6l\u0011a\u001b\u0006\u0003Y\u0006\nqa]3sm&\u001cW-\u0003\u0002oW\n\u0001\"I]8bI\u000e\f7\u000f^*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011E\u00148\u000f^;wob\u0004\"A\u0013\u0001\t\u000buB\u0001\u0019\u0001 \t\u000b!C\u0001\u0019A%\t\u000b5C\u0001\u0019\u0001(\t\u000bQC\u0001\u0019A+\t\u000baC\u0001\u0019A-\t\u000b\u0005D\u0001\u0019\u00012\t\u000b!D\u0001\u0019A5\u0002\rM$\u0018\r^;t)\rY\u00181\u0001\t\u0003y~l\u0011! \u0006\u0003}v\ta\u0001Z8nC&t\u0017bAA\u0001{\ny!+\u001a9peRTuNY*uCR,8\u000fC\u0004\u0002\u0006%\u0001\r!a\u0002\u0002\u000b)|'-\u00133\u0011\t\u0005%\u0011Q\u0006\b\u0005\u0003\u0017\tIC\u0004\u0003\u0002\u000e\u0005\u001db\u0002BA\b\u0003KqA!!\u0005\u0002$9!\u00111CA\u0011\u001d\u0011\t)\"a\b\u000f\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007(\u0003\u0019a$o\\8u}%\ta%\u0003\u0002%K%\u0011!eI\u0005\u0003A\u0005J!AH\u0010\n\u0005Ij\u0012bAA\u0016c\u00051\"+\u001a9peRLgnZ#oO&tWmU3sm&\u001cW-\u0003\u0003\u00020\u0005E\"!\u0002&pE&#'bAA\u0016c\u0005Iq-\u001a;SKN,H\u000e\u001e\u000b\u0005\u0003o\ti\u0004E\u00021\u0003sI1!a\u000f2\u0005U\u0019FO]3b[&twMU3q_J$(+Z:vYRDq!!\u0002\u000b\u0001\u0004\t9!A\u0004qe\u00164\u0018.Z<\u0015\t\u0005\r\u0013\u0011\n\t\u0004U\u0005\u0015\u0013bAA$W\t\u0019\u0011I\\=\t\u000f\u0005-3\u00021\u0001\u0002N\u0005\u0001\"/\u001a9peR$UMZ5oSRLwN\u001c\t\u0004a\u0005=\u0013bAA)c\t\u0001\"+\u001a9peR$UMZ5oSRLwN\\\u0001\u0004O\u0016$H\u0003BA,\u0003;\u00022\u0001`A-\u0013\r\tY& \u0002\n%\u0016\u0004xN\u001d;K_\nDq!!\u0002\r\u0001\u0004\t9!\u0001\u0004tk\nl\u0017\u000e\u001e\u000b\u0005\u0003\u000f\t\u0019\u0007C\u0004\u0002L5\u0001\r!!\u0014\u0002\u000b\u0005\u0014wN\u001d;\u0015\t\u0005%\u0014q\u000e\t\u0004U\u0005-\u0014bAA7W\t!QK\\5u\u0011\u001d\t)A\u0004a\u0001\u0003\u000f!B!a\u001d\u0002\u0004B1\u0011QOA@\u0003\u000fi!!a\u001e\u000b\t\u0005e\u00141P\u0001\u0005kRLGN\u0003\u0002\u0002~\u0005!!.\u0019<b\u0013\u0011\t\t)a\u001e\u0003\t1K7\u000f\u001e\u0005\b\u0003\u000b{\u0001\u0019AA:\u0003\u0019QwNY%eg\u0006A\u0011MY8si\u0006cG\u000e\u0006\u0002\u0002t\u00051A-\u001a7fi\u0016$B!!\u001b\u0002\u0010\"9\u0011QA\tA\u0002\u0005\u001dA\u0003BA:\u0003'Cq!!\"\u0013\u0001\u0004\t\u0019(A\u0005eK2,G/Z!mY\u00061a-\u001b8e\u0005f$b!a'\u0002*\u0006M\u0006CBAO\u0003K\u000b9&\u0004\u0002\u0002 *\u0019a0!)\u000b\u0007\u0005\r&)\u0001\u0003eCR\f\u0017\u0002BAT\u0003?\u0013A\u0001U1hK\"9\u00111\u0016\u000bA\u0002\u00055\u0016\u0001\u0005:fa>\u0014HOS8c\r&dG/\u001a:t!\ry\u0015qV\u0005\u0004\u0003c\u0003&\u0001\u0005*fa>\u0014HOS8c\r&dG/\u001a:t\u0011\u001d\t)\f\u0006a\u0001\u0003o\u000b\u0001\u0002]1hK\u0006\u0014G.\u001a\t\u0005\u0003;\u000bI,\u0003\u0003\u0002<\u0006}%\u0001\u0003)bO\u0016\f'\r\\3\u0002-\u0019Lg\u000eZ!oI\u0006\u0013wN\u001d;SKB|'\u000f\u001e&pEN$B!a\u001d\u0002B\"9\u00111V\u000bA\u0002\u00055F\u0003BA\u0004\u0003\u000bDq!a2\u0017\u0001\u0004\t9&A\u0005sKB|'\u000f\u001e&pE\u00069b-\u001b8e\u0003:$G)\u001a7fi\u0016\u0014V\r]8si*{'m\u001d\u000b\u0005\u0003g\ni\rC\u0004\u0002,^\u0001\r!!,\u0002\u001f\u0011,G.\u001a;f%\u0016\u0004xN\u001d;K_\n$B!a\u0016\u0002T\"9\u0011q\u0019\rA\u0002\u0005]\u0013\u0001E2iK\u000e\\'+\u001a9peR|uO\\3s)\u0011\tI'!7\t\u000f\u0005\u001d\u0017\u00041\u0001\u0002X\u0001")
public class DefaultReportingEngineService
implements ReportingEngineService,
Logging {
    private final ApplicationContext applicationContext;
    private final ReportJobInstanceFactory reportJobInstanceFactory;
    private final ReportJobRepository reportJobRepository;
    private final GlobalReportStorage globalReportStorage;
    private final PermissionEnforcer permissionEnforcer;
    private final XLReleaseEventBus eventBus;
    private final BroadcastService broadcastService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultReportingEngineService defaultReportingEngineService = this;
        synchronized (defaultReportingEngineService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public ReportJobStatus status(Integer jobId) {
        return (ReportJobStatus)((Object)this.reportJobRepository.findByJobId(jobId).map((Function1 & Serializable)reportJob -> {
            this.checkReportOwner((ReportJob)((Object)reportJob));
            return reportJob.getStatus();
        }).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(26).append("Job '").append(jobId).append("' could not be found.").toString(), new Object[0]);
        }));
    }

    @Override
    public StreamingReportResult getResult(Integer jobId) {
        Option<ReportJob> reportJobOption = this.reportJobRepository.findByJobId(jobId);
        return (StreamingReportResult)reportJobOption.map((Function1 & Serializable)reportJob -> {
            this.checkReportOwner((ReportJob)((Object)reportJob));
            return $this.globalReportStorage.resolve($this.globalReportStorage.reportResult((ReportJob)((Object)reportJob)));
        }).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(36).append("Result of job '").append(jobId).append("' could not be found.").toString(), new Object[0]);
        });
    }

    @Override
    public Object preview(ReportDefinition reportDefinition) {
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)reportDefinition);
        return reportDefinition.preview();
    }

    @Override
    public ReportJob get(Integer jobId) {
        Option<ReportJob> reportJobOption = this.reportJobRepository.findByJobId(jobId);
        return (ReportJob)((Object)reportJobOption.map((Function1 & Serializable)reportJob -> {
            this.checkReportOwner((ReportJob)((Object)reportJob));
            return reportJob;
        }).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(26).append("Job '").append(jobId).append("' could not be found.").toString(), new Object[0]);
        }));
    }

    @Override
    public Integer submit(ReportDefinition reportDefinition) {
        ReportJobInstance reportJobInstance = this.reportJobInstanceFactory.submit(reportDefinition);
        reportJobInstance.enqueue();
        int jobId = reportJobInstance.getJobId();
        return Predef$.MODULE$.int2Integer(jobId);
    }

    @Override
    public void abort(Integer jobId) {
        Option<ReportJob> reportJobOption = this.reportJobRepository.findByJobId(jobId);
        reportJobOption.map((Function1 & Serializable)reportJob -> this.abort((ReportJob)((Object)reportJob))).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(26).append("Job '").append(jobId).append("' could not be found.").toString(), new Object[0]);
        });
    }

    @Override
    public java.util.List<Integer> abort(java.util.List<Integer> jobIds) {
        java.util.List<Integer> list;
        if (jobIds.isEmpty()) {
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava();
        } else {
            ReportJobFilters reportJobFilters = new ReportJobFilters();
            reportJobFilters.setJobIds(jobIds);
            list = this.findAndAbortReportJobs(reportJobFilters);
        }
        return list;
    }

    @Override
    public java.util.List<Integer> abortAll() {
        ReportJobFilters reportJobFilters = new ReportJobFilters();
        return this.findAndAbortReportJobs(reportJobFilters);
    }

    @Override
    public void delete(Integer jobId) {
        Option<ReportJob> reportJobOption = this.reportJobRepository.findByJobId(jobId);
        reportJobOption.map((Function1 & Serializable)reportJob -> this.deleteReportJob((ReportJob)((Object)reportJob))).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(26).append("Job '").append(jobId).append("' could not be found.").toString(), new Object[0]);
        });
    }

    @Override
    public java.util.List<Integer> delete(java.util.List<Integer> jobIds) {
        java.util.List<Integer> list;
        if (jobIds.isEmpty()) {
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava();
        } else {
            ReportJobFilters reportJobFilters = new ReportJobFilters();
            reportJobFilters.setJobIds(jobIds);
            list = this.findAndDeleteReportJobs(reportJobFilters);
        }
        return list;
    }

    @Override
    public java.util.List<Integer> deleteAll() {
        ReportJobFilters reportJobFilters = new ReportJobFilters();
        reportJobFilters.statuses_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ReportJobStatus.ABORTED.name(), ReportJobStatus.FAILED.name(), ReportJobStatus.COMPLETED.name()}))).asJava());
        return this.findAndDeleteReportJobs(reportJobFilters);
    }

    @Override
    public Page<ReportJob> findBy(ReportJobFilters reportJobFilters, Pageable pageable) {
        block0: {
            if (this.permissionEnforcer.isCurrentUserAdmin()) break block0;
            reportJobFilters.username_$eq(Permissions.getAuthenticatedUserName());
        }
        return this.reportJobRepository.query(reportJobFilters, pageable);
    }

    private java.util.List<Integer> findAndAbortReportJobs(ReportJobFilters reportJobFilters) {
        ListBuffer abortRequestedJobIds = ListBuffer$.MODULE$.empty();
        reportJobFilters.statuses_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ReportJobStatus.SUBMITTED.name(), ReportJobStatus.STARTED.name()}))).asJava());
        Page<ReportJob> result = this.findBy(reportJobFilters, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
        result.forEach(reportJob -> {
            try {
                abortRequestedJobIds.$plus$eq((Object)this.abort((ReportJob)((Object)reportJob)));
            }
            catch (Exception e) {
                this.logger().warn((Function0 & Serializable)() -> "Error while aborting a list of jobs", (Function0 & Serializable)() -> e);
            }
        });
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)abortRequestedJobIds).asJava();
    }

    private Integer abort(ReportJob reportJob) {
        this.checkReportOwner(reportJob);
        Integer jobId = reportJob.getJobId();
        List validStatuses = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ReportJobStatus.SUBMITTED.name(), ReportJobStatus.STARTED.name()}));
        if (!validStatuses.contains((Object)reportJob.status().name())) {
            throw new IllegalStateException(new StringBuilder(43).append(new StringBuilder(29).append("Can not abort report job '").append(jobId).append("'. ").toString()).append("It is already completed, failed or aborted.").toString());
        }
        this.broadcastService.broadcast((XLReleaseEvent)new AbortReportJob(jobId), true);
        return jobId;
    }

    private java.util.List<Integer> findAndDeleteReportJobs(ReportJobFilters reportJobFilters) {
        ListBuffer deletedJobIds = ListBuffer$.MODULE$.empty();
        Page<ReportJob> result = this.findBy(reportJobFilters, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
        result.forEach(reportJob -> {
            try {
                deletedJobIds.$plus$eq((Object)this.deleteReportJob((ReportJob)((Object)reportJob)).getJobId());
            }
            catch (Exception e) {
                this.logger().warn((Function0 & Serializable)() -> "Error while deleting a list of jobs", (Function0 & Serializable)() -> e);
            }
        });
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)deletedJobIds).asJava();
    }

    /*
     * WARNING - void declaration
     */
    private ReportJob deleteReportJob(ReportJob reportJob) {
        void var3_3;
        this.checkReportOwner(reportJob);
        List validStatuses = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ReportJobStatus.ABORTED.name(), ReportJobStatus.FAILED.name(), ReportJobStatus.COMPLETED.name()}));
        if (!validStatuses.contains((Object)reportJob.status().name()) || !this.globalReportStorage.cleanup(reportJob)) {
            throw new IllegalStateException(new StringBuilder(0).append(new StringBuilder(30).append("Can not delete report job '").append(reportJob.getJobId()).append("'. ").toString()).append("It is either already deleted or Digital.ai Release does not have required access to the filesystem.").toString());
        }
        reportJob.status_$eq(ReportJobStatus.DELETED);
        ReportJob deletedReportJob = this.reportJobRepository.update(reportJob);
        this.eventBus.publish((XLReleaseEvent)new ReportJobDeletedEvent(deletedReportJob));
        return var3_3;
    }

    private void checkReportOwner(ReportJob reportJob) {
        if (!this.permissionEnforcer.isCurrentUserAdmin()) {
            String string = reportJob.username();
            String string2 = Permissions.getAuthenticatedUserName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw PermissionDeniedException.withMessage((String)new StringBuilder(85).append("You can not take action on report job '").append(reportJob.getJobId()).append("' as you are not the owner of this report job.").toString());
            }
        }
    }

    public DefaultReportingEngineService(ApplicationContext applicationContext, ReportJobInstanceFactory reportJobInstanceFactory, ReportJobRepository reportJobRepository, GlobalReportStorage globalReportStorage, PermissionEnforcer permissionEnforcer, XLReleaseEventBus eventBus, BroadcastService broadcastService) {
        this.applicationContext = applicationContext;
        this.reportJobInstanceFactory = reportJobInstanceFactory;
        this.reportJobRepository = reportJobRepository;
        this.globalReportStorage = globalReportStorage;
        this.permissionEnforcer = permissionEnforcer;
        this.eventBus = eventBus;
        this.broadcastService = broadcastService;
        Logging.$init$((Logging)this);
    }
}

