package com.xebialabs.xlrelease.reports.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;
import com.xebialabs.xlrelease.views.UserView;

public class TaskDuration {
    private String title;
    private UserView owner;
    private String team;
    private long duration;
    private String release;
    private String phase;
    private String taskType;

    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String releaseId;

    public TaskDuration(String owner, String title, long duration, String release, String phase, String team, String taskType, String releaseId) {
        this(new UserView(owner), title, duration, release, phase, team, taskType, releaseId);
    }

    public TaskDuration(UserView owner, String title, long duration, String release, String phase, String team, String taskType, String releaseId) {
        this.title = title;
        this.owner = owner;
        this.team = team;
        this.duration = duration;
        this.release = release;
        this.phase = phase;
        this.taskType = taskType;
        this.releaseId = releaseId;
    }

    public TaskDuration() {
    }

    public String getTitle() {
        return title;
    }

    public UserView getOwner() {
        return owner;
    }

    public String getTeam() {
        return team;
    }

    public long getDuration() {
        return duration;
    }

    public String getRelease() {
        return release;
    }

    public String getPhase() {
        return phase;
    }

    public String getTaskType() {
        return taskType;
    }

    public String getReleaseId() {
        return releaseId;
    }
}
