package com.xebialabs.xlrelease.reports.repository

import com.xebialabs.xlrelease.domain.udm.reporting.CodeComplianceRecord
import com.xebialabs.xlrelease.reports.repository.CommonRowAndParamsMapper._
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.{Archive, CodeComplianceTaskReportingRecordTable}
import com.xebialabs.xlrelease.repository.sql.persistence.Utils.RichStringAsTruncatable
import com.xebialabs.xlrelease.repository.sql.persistence.{CiUid, Schema}
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource

import java.sql.{ResultSet, Types}
import java.util.Date

package object codecompliance {

  val CODE_COMPLIANCE_TASK_REPORTING_RECORD_LIVE: Schema.CODE_COMPLIANCE_TASK_REPORTING_RECORD.type = Schema.CODE_COMPLIANCE_TASK_REPORTING_RECORD
  val CODE_COMPLIANCE_TASK_REPORTING_RECORD_ARCHIVE: Archive.CODE_COMPLIANCE_TASK_REPORTING_RECORD.type = Schema.Archive.CODE_COMPLIANCE_TASK_REPORTING_RECORD

  private[codecompliance] def asQueryParameters(record: CodeComplianceRecord, taskUid: CiUid): MapSqlParameterSource = {
    val params = new MapSqlParameterSource()
    mapCommonParams(record, taskUid).foreach {
      case (key: String, value) => params.addValue(key, value)
    }
    params.addValue("project", record.getProject.truncate(LONG_VARCHAR))
    params.addValue("projectUrl", record.getProject_url.truncate(URL_VARCHAR))
    params.addValue("analysisDate", record.getAnalysisDate)
    params.addValue("complianceData", createSqlLob(record.getComplianceData), Types.BLOB)
    params.addValue("outcome", record.getOutcome.truncate(LONG_VARCHAR))
    params
  }

  private[codecompliance] def codeComplianceItemRowMapper(rs: ResultSet,
                                                          codeComplianceRecord: CodeComplianceRecord,
                                                          targetId: String,
                                                          codeComplianceItemTable: CodeComplianceTaskReportingRecordTable
                                                         ): CodeComplianceRecord = {
    mapCommonFields(rs, codeComplianceRecord, targetId, codeComplianceItemTable)
    codeComplianceRecord.setProject(rs.getString(codeComplianceItemTable.PROJECT))
    codeComplianceRecord.setProject_url(rs.getString(codeComplianceItemTable.PROJECT_URL))
    codeComplianceRecord.setAnalysisDate(Date.from(rs.getTimestamp(codeComplianceItemTable.ANALYSIS_DATE).toInstant))
    codeComplianceRecord.setComplianceData(readBlobContent(rs, codeComplianceItemTable.COMPLIANCE_DATA))
    codeComplianceRecord.setOutcome(rs.getString(codeComplianceItemTable.OUTCOME))
    codeComplianceRecord
  }
}
