/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.job.impl;

import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.reports.job.api.ReportDefinition;
import com.xebialabs.xlrelease.reports.job.api.ReportJobProgressMonitor;
import com.xebialabs.xlrelease.reports.job.api.ReportJobRunContext;
import com.xebialabs.xlrelease.reports.job.api.ReportResult;
import com.xebialabs.xlrelease.reports.job.api.ReportStorage;
import com.xebialabs.xlrelease.reports.job.domain.ReportJob;
import com.xebialabs.xlrelease.reports.job.domain.ReportJobStatus;
import com.xebialabs.xlrelease.reports.job.events.ReportJobAbortedEvent;
import com.xebialabs.xlrelease.reports.job.events.ReportJobCompletedEvent;
import com.xebialabs.xlrelease.reports.job.events.ReportJobFailedEvent;
import com.xebialabs.xlrelease.reports.job.impl.GlobalReportStorage;
import com.xebialabs.xlrelease.reports.job.impl.ReportExecutorService;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobInstance$;
import com.xebialabs.xlrelease.reports.job.impl.ReportingEngineConfiguration;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.concurrent.Future;
import org.slf4j.Marker;
import org.springframework.context.ApplicationContext;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001\u0002\u0012$\u0001AB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"A\u0011\u000b\u0001B\u0001B\u0003%!\u000b\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003X\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0011\u0015\u0004!\u0011!Q\u0001\n\u0019DQ\u0001\u001c\u0001\u0005\u00025DqA\u001e\u0001A\u0002\u0013%q\u000fC\u0005\u0002\u001a\u0001\u0001\r\u0011\"\u0003\u0002\u001c!9\u0011q\u0005\u0001!B\u0013A\b\"CA\u0015\u0001\u0001\u0007I\u0011AA\u0016\u0011%\t\u0019\u0004\u0001a\u0001\n\u0003\t)\u0004\u0003\u0005\u0002:\u0001\u0001\u000b\u0015BA\u0017\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bBq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002R\u0001!\t!a\u0015\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!9\u0011Q\u000f\u0001\u0005\n\u0005]\u0004bBAC\u0001\u0011%\u0011q\u0011\u0005\b\u0003\u001b\u0003A\u0011BAH\u0011\u001d\t)\n\u0001C\u0001\u0003/Cq!!'\u0001\t\u0013\tY\nC\u0004\u0002\"\u0002!I!a&\b\u0011\u0005\r6\u0005#\u0001$\u0003K3qAI\u0012\t\u0002\r\n9\u000b\u0003\u0004m5\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003WSB\u0011BAW\r\u0019\t9L\u0007\u0003\u0002:\"I\u0011\u0011Y\u000f\u0003\u0002\u0003\u0006IA\u001c\u0005\u0007Yv!\t!a1\t\u000f\u0005\u0015U\u0004\"\u0011\u0002L\"9\u0011QR\u000f\u0005B\u0005='!\u0005*fa>\u0014HOS8c\u0013:\u001cH/\u00198dK*\u0011A%J\u0001\u0005S6\u0004HN\u0003\u0002'O\u0005\u0019!n\u001c2\u000b\u0005!J\u0013a\u0002:fa>\u0014Ho\u001d\u0006\u0003U-\n\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u00051j\u0013!\u0003=fE&\fG.\u00192t\u0015\u0005q\u0013aA2p[\u000e\u00011c\u0001\u00012oA\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t1\u0011I\\=SK\u001a\u0004\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\u000bMdg\r\u000e6\u000b\u0003q\n\u0001b\u001a:jujdW\rZ\u0005\u0003}e\u0012q\u0001T8hO&tw-A\u0005sKB|'\u000f\u001e&pEB\u0011\u0011\tR\u0007\u0002\u0005*\u00111)J\u0001\u0007I>l\u0017-\u001b8\n\u0005\u0015\u0013%!\u0003*fa>\u0014HOS8c\u0003I\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0011\u0005!{U\"A%\u000b\u0005)[\u0015aB2p]R,\u0007\u0010\u001e\u0006\u0003\u00196\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u001d\u0006\u0019qN]4\n\u0005AK%AE!qa2L7-\u0019;j_:\u001cuN\u001c;fqR\fAD]3q_J$\u0018N\\4F]\u001eLg.Z\"p]\u001aLw-\u001e:bi&|g\u000e\u0005\u0002T)6\t1%\u0003\u0002VG\ta\"+\u001a9peRLgnZ#oO&tWmQ8oM&<WO]1uS>t\u0017!\u0006:fa>\u0014H/\u0012=fGV$xN]*feZL7-\u001a\t\u0003'bK!!W\u0012\u0003+I+\u0007o\u001c:u\u000bb,7-\u001e;peN+'O^5dK\u0006\u0019\"/\u001a9peRTuN\u0019*fa>\u001c\u0018\u000e^8ssB\u0011AlX\u0007\u0002;*\u0011a,J\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u00011^\u0005M\u0011V\r]8si*{'MU3q_NLGo\u001c:z\u0003M9Gn\u001c2bYJ+\u0007o\u001c:u'R|'/Y4f!\t\u00196-\u0003\u0002eG\t\u0019r\t\\8cC2\u0014V\r]8siN#xN]1hK\u0006AQM^3oi\n+8\u000f\u0005\u0002hU6\t\u0001N\u0003\u0002jS\u00051QM^3oiNL!a\u001b5\u0003#ac%+\u001a7fCN,WI^3oi\n+8/\u0001\u0004=S:LGO\u0010\u000b\t]>\u0004\u0018O]:ukB\u00111\u000b\u0001\u0005\u0006\u007f!\u0001\r\u0001\u0011\u0005\u0006\r\"\u0001\ra\u0012\u0005\u0006#\"\u0001\rA\u0015\u0005\u0006-\"\u0001\ra\u0016\u0005\u00065\"\u0001\ra\u0017\u0005\u0006C\"\u0001\rA\u0019\u0005\u0006K\"\u0001\rAZ\u0001\u000feVtg.\u001b8h!J|W.[:f+\u0005A\bc\u0001\u001azw&\u0011!p\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bq\f9!a\u0003\u000e\u0003uT!A`@\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001B;uS2T!!!\u0002\u0002\t)\fg/Y\u0005\u0004\u0003\u0013i(A\u0002$viV\u0014X\r\u0005\u00033s\u00065\u0001\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005MQ%A\u0002ba&LA!a\u0006\u0002\u0012\ta!+\u001a9peR\u0014Vm];mi\u0006\u0011\"/\u001e8oS:<\u0007K]8nSN,w\fJ3r)\u0011\ti\"a\t\u0011\u0007I\ny\"C\u0002\u0002\"M\u0012A!\u00168ji\"A\u0011Q\u0005\u0006\u0002\u0002\u0003\u0007\u00010A\u0002yIE\nqB];o]&tw\r\u0015:p[&\u001cX\rI\u0001\nG\u0006t7-\u001a7mK\u0012,\"!!\f\u0011\u0007I\ny#C\u0002\u00022M\u0012qAQ8pY\u0016\fg.A\u0007dC:\u001cW\r\u001c7fI~#S-\u001d\u000b\u0005\u0003;\t9\u0004C\u0005\u0002&5\t\t\u00111\u0001\u0002.\u0005Q1-\u00198dK2dW\r\u001a\u0011)\u00079\ti\u0004E\u00023\u0003\u007fI1!!\u00114\u0005!1x\u000e\\1uS2,\u0017\u0001C4fi*{'-\u00133\u0016\u0005\u0005\u001d\u0003c\u0001\u001a\u0002J%\u0019\u00111J\u001a\u0003\u0007%sG/A\u0002sk:$\"!a\u0003\u0002\u000f\u0015t\u0017/^3vKR\t10\u0001\u0003gC&dG\u0003BA\u000f\u00033Bq!a\u0017\u0013\u0001\u0004\ti&A\u0005fq\u000e,\u0007\u000f^5p]B!\u0011qLA8\u001d\u0011\t\t'a\u001b\u000f\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001a0\u0003\u0019a$o\\8u}%\tA'C\u0002\u0002nM\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002r\u0005M$!\u0003+ie><\u0018M\u00197f\u0015\r\tigM\u0001\u0006I>\u0014VO\u001c\u000b\u0003\u0003s\u0002B!a\u001f\u0002\u00026\u0011\u0011Q\u0010\u0006\u0005\u0003\u007f\n\u0019!A\u0002oKRLA!a!\u0002~\t\u0019QKU%\u0002%M,g\u000e\u001a+pi\u0006dwk\u001c:l\u0013R,Wn\u001d\u000b\u0005\u0003;\tI\tC\u0004\u0002\fR\u0001\r!a\u0012\u0002\u0015Q|G/\u00197Ji\u0016l7/\u0001\ftK:$7i\\7qY\u0016$X\rZ,pe.LE/Z7t)\u0011\ti\"!%\t\u000f\u0005MU\u00031\u0001\u0002H\u0005q1m\\7qY\u0016$X\rZ%uK6\u001c\u0018!B1c_J$HCAA\u000f\u0003!\u0019w.\u001c9mKR,G\u0003BA\u0007\u0003;Cq!a(\u0018\u0001\u0004\tI(A\u0005sKN,H\u000e^+sS\u0006)1\u000f^1si\u0006\t\"+\u001a9peRTuNY%ogR\fgnY3\u0011\u0005MS2C\u0001\u000e2)\t\t)+A\u0006dkJ\u0014XM\u001c;US6,WCAAX!\u0011\t\t,a-\u000e\u0003}L1!!.\u0000\u0005\u0011!\u0015\r^3\u0003?\u0011+g-Y;miJ+\u0007o\u001c:u\u0015>\u0014\u0007K]8he\u0016\u001c8/T8oSR|'o\u0005\u0003\u001ec\u0005m\u0006\u0003BA\b\u0003{KA!a0\u0002\u0012\tA\"+\u001a9peRTuN\u0019)s_\u001e\u0014Xm]:N_:LGo\u001c:\u0002#I,\u0007o\u001c:u\u0015>\u0014\u0017J\\:uC:\u001cW\r\u0006\u0003\u0002F\u0006%\u0007cAAd;5\t!\u0004\u0003\u0004\u0002B~\u0001\rA\u001c\u000b\u0005\u0003;\ti\rC\u0004\u0002\f\u0002\u0002\r!a\u0012\u0015\t\u0005u\u0011\u0011\u001b\u0005\b\u0003'\u000b\u0003\u0019AA$\u0001")
public class ReportJobInstance
implements Logging {
    private final ReportJob reportJob;
    private final ApplicationContext applicationContext;
    private final ReportingEngineConfiguration reportingEngineConfiguration;
    private final ReportExecutorService reportExecutorService;
    private final ReportJobRepository reportJobRepository;
    private final GlobalReportStorage globalReportStorage;
    private final XLReleaseEventBus eventBus;
    private Option<Future<Option<ReportResult>>> runningPromise;
    private volatile boolean cancelled;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ReportJobInstance reportJobInstance = this;
        synchronized (reportJobInstance) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private Option<Future<Option<ReportResult>>> runningPromise() {
        return this.runningPromise;
    }

    private void runningPromise_$eq(Option<Future<Option<ReportResult>>> x$1) {
        this.runningPromise = x$1;
    }

    public boolean cancelled() {
        return this.cancelled;
    }

    public void cancelled_$eq(boolean x$1) {
        this.cancelled = x$1;
    }

    public int getJobId() {
        return Predef$.MODULE$.Integer2int(this.reportJob.getJobId());
    }

    public Option<ReportResult> run() {
        Some some;
        try {
            this.start();
            some = new Some((Object)this.complete(this.doRun()));
        }
        catch (Throwable e) {
            this.fail(e);
            some = None$.MODULE$;
        }
        return some;
    }

    public Future<Option<ReportResult>> enqueue() {
        this.logger().debug((Function0 & Serializable)() -> "Enqueued " + $this.reportJob.getJobId());
        this.runningPromise_$eq((Option<Future<Option<ReportResult>>>)Option$.MODULE$.apply(this.reportExecutorService.submit(() -> this.run())));
        return (Future)this.runningPromise().get();
    }

    public void fail(Throwable exception) {
        block6: {
            block5: {
                ReportJobStatus reportJobStatus = this.reportJob.getStatus();
                ReportJobStatus reportJobStatus2 = ReportJobStatus.ABORTED;
                if (!(reportJobStatus != null ? !((Object)((Object)reportJobStatus)).equals((Object)reportJobStatus2) : reportJobStatus2 != null)) {
                    this.logger().warn((Function0 & Serializable)() -> exception.getMessage());
                } else {
                    this.logger().error((Function0 & Serializable)() -> "Error while running report job [" + this.getJobId() + "]", (Function0 & Serializable)() -> exception);
                }
                ReportJobStatus reportJobStatus3 = this.reportJob.getStatus();
                ReportJobStatus reportJobStatus4 = ReportJobStatus.SUBMITTED;
                if (!(reportJobStatus3 == null ? reportJobStatus4 != null : !((Object)((Object)reportJobStatus3)).equals((Object)reportJobStatus4))) break block5;
                ReportJobStatus reportJobStatus5 = this.reportJob.getStatus();
                ReportJobStatus reportJobStatus6 = ReportJobStatus.STARTED;
                if (reportJobStatus5 != null ? !((Object)((Object)reportJobStatus5)).equals((Object)reportJobStatus6) : reportJobStatus6 != null) break block6;
            }
            this.reportJob.setEndTime(ReportJobInstance$.MODULE$.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$currentTime());
            this.reportJob.setStatus(ReportJobStatus.FAILED);
            this.reportJobRepository.update(this.reportJob);
            this.runningPromise_$eq((Option<Future<Option<ReportResult>>>)None$.MODULE$);
            this.eventBus.publish((XLReleaseEvent)new ReportJobFailedEvent(this.reportJob));
            return;
        }
    }

    private URI doRun() {
        ReportDefinition reportDefinition = this.reportJob.getReportDefinition();
        this.logger().info((Function0 & Serializable)() -> "Starting report job [" + reportDefinition.reportName() + "] from user [" + reportDefinition.getGeneratedBy() + "]");
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)reportDefinition);
        Integer jobId = this.reportJob.getJobId();
        ReportStorage reportStorage = this.globalReportStorage.reportStorage(jobId, reportDefinition.getGeneratedOn());
        DefaultReportJobProgressMonitor reportJobProgressMonitor = new DefaultReportJobProgressMonitor(this);
        ReportJobRunContext runContext = new ReportJobRunContext(jobId, reportJobProgressMonitor, reportStorage, this.reportJob.reportName());
        File resultFile = reportDefinition.run(runContext);
        URI contextUri = reportStorage.workdir().toURI();
        URI resultUri = contextUri.relativize(resultFile.toURI());
        this.logger().info((Function0 & Serializable)() -> "Finished report job [" + reportDefinition.reportName() + "] on [" + resultUri + "]");
        return resultUri;
    }

    public void com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$sendTotalWorkItems(int totalItems) {
        this.reportJob.setTotalWorkItems(Predef$.MODULE$.int2Integer(totalItems));
        this.reportJobRepository.updateProgress(this.reportJob);
    }

    public void com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$sendCompletedWorkItems(int completedItems) {
        this.reportJob.setCompletedWorkItems(Predef$.MODULE$.int2Integer(completedItems));
        this.reportJobRepository.updateProgress(this.reportJob);
    }

    public void abort() {
        block6: {
            block5: {
                this.logger().debug((Function0 & Serializable)() -> "Abort report job [" + this.getJobId() + "]");
                ReportJobStatus reportJobStatus = this.reportJob.getStatus();
                ReportJobStatus reportJobStatus2 = ReportJobStatus.SUBMITTED;
                if (!(reportJobStatus == null ? reportJobStatus2 != null : !((Object)((Object)reportJobStatus)).equals((Object)reportJobStatus2))) break block5;
                ReportJobStatus reportJobStatus3 = this.reportJob.getStatus();
                ReportJobStatus reportJobStatus4 = ReportJobStatus.STARTED;
                if (reportJobStatus3 != null ? !((Object)((Object)reportJobStatus3)).equals((Object)reportJobStatus4) : reportJobStatus4 != null) break block6;
            }
            this.cancelled_$eq(true);
            this.reportJob.setEndTime(ReportJobInstance$.MODULE$.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$currentTime());
            this.reportJob.setStatus(ReportJobStatus.ABORTED);
            this.reportJobRepository.update(this.reportJob);
            this.eventBus.publish((XLReleaseEvent)new ReportJobAbortedEvent(this.reportJob));
            Option<Future<Option<ReportResult>>> option = this.runningPromise();
            if (option instanceof Some) {
                Some some = (Some)option;
                Future future = (Future)some.value();
                future.cancel(true);
                this.runningPromise_$eq((Option<Future<Option<ReportResult>>>)None$.MODULE$);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                this.logger().warn((Function0 & Serializable)() -> "RunningPromise is none for report job [" + this.getJobId() + "]");
                return;
            }
            throw new MatchError(option);
        }
    }

    private ReportResult complete(URI resultUri) {
        this.reportJob.setResultUri(resultUri.toString());
        this.reportJob.setEndTime(ReportJobInstance$.MODULE$.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$currentTime());
        this.reportJob.setStatus(ReportJobStatus.COMPLETED);
        this.reportJobRepository.update(this.reportJob);
        this.runningPromise_$eq((Option<Future<Option<ReportResult>>>)None$.MODULE$);
        this.eventBus.publish((XLReleaseEvent)new ReportJobCompletedEvent(this.reportJob));
        return this.globalReportStorage.reportResult(this.reportJob);
    }

    private void start() {
        this.reportJob.setNode(this.reportingEngineConfiguration.node());
        this.reportJob.setStartTime(ReportJobInstance$.MODULE$.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$currentTime());
        this.reportJob.setStatus(ReportJobStatus.STARTED);
        this.reportJobRepository.update(this.reportJob);
    }

    public ReportJobInstance(ReportJob reportJob, ApplicationContext applicationContext, ReportingEngineConfiguration reportingEngineConfiguration, ReportExecutorService reportExecutorService, ReportJobRepository reportJobRepository, GlobalReportStorage globalReportStorage, XLReleaseEventBus eventBus) {
        this.reportJob = reportJob;
        this.applicationContext = applicationContext;
        this.reportingEngineConfiguration = reportingEngineConfiguration;
        this.reportExecutorService = reportExecutorService;
        this.reportJobRepository = reportJobRepository;
        this.globalReportStorage = globalReportStorage;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
        this.runningPromise = None$.MODULE$;
        this.cancelled = false;
    }

    private static class DefaultReportJobProgressMonitor
    implements ReportJobProgressMonitor {
        private final ReportJobInstance reportJobInstance;

        @Override
        public void sendTotalWorkItems(int totalItems) {
            this.reportJobInstance.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$sendTotalWorkItems(totalItems);
        }

        @Override
        public void sendCompletedWorkItems(int completedItems) {
            this.reportJobInstance.com$xebialabs$xlrelease$reports$job$impl$ReportJobInstance$$sendCompletedWorkItems(completedItems);
            if (this.reportJobInstance.cancelled() || Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Report job [" + this.reportJobInstance.getJobId() + "] was aborted");
            }
        }

        public DefaultReportJobProgressMonitor(ReportJobInstance reportJobInstance) {
            this.reportJobInstance = reportJobInstance;
        }
    }
}

