/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports.job.impl;

import akka.actor.ActorRef;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.reports.job.api.ReportDefinition;
import com.xebialabs.xlrelease.reports.job.api.ReportingEngineService;
import com.xebialabs.xlrelease.reports.job.api.StreamingReportResult;
import com.xebialabs.xlrelease.reports.job.domain.ReportJob;
import com.xebialabs.xlrelease.reports.job.domain.ReportJobStatus;
import com.xebialabs.xlrelease.reports.job.events.ReportJobDeletedEvent;
import com.xebialabs.xlrelease.reports.job.impl.GlobalReportStorage;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobDelegateActor;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobDelegateActorHolder;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobInstance;
import com.xebialabs.xlrelease.reports.job.impl.ReportJobInstanceFactory;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobFilters;
import com.xebialabs.xlrelease.reports.job.repository.ReportJobRepository;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005-h\u0001B\u000e\u001d\u0001%B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\"Aa\n\u0001B\u0001B\u0003%q\n\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011!I\u0006A!A!\u0002\u0013Q\u0006\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011B2\t\u0011\u0019\u0004!\u0011!Q\u0001\n\u001dDQ!\u001c\u0001\u0005\u00029D\u0001b\u001e\u0001\t\u0006\u0004%\t\u0001\u001f\u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\t\u0019\u0005\u0001C!\u0003\u000bBq!a\u0014\u0001\t\u0003\n\t\u0006C\u0004\u0002d\u0001!\t%!\u001a\t\u000f\u0005=\u0004\u0001\"\u0011\u0002r!9\u0011Q\u000f\u0001\u0005B\u0005]\u0004bBA;\u0001\u0011\u0005\u0013\u0011\u0011\u0005\b\u0003/\u0003A\u0011IAM\u0011\u001d\tY\n\u0001C!\u0003;Cq!a'\u0001\t\u0003\n\t\u000bC\u0004\u0002&\u0002!\t%!'\t\u000f\u0005\u001d\u0006\u0001\"\u0011\u0002*\"9\u0011Q\u001a\u0001\u0005\n\u0005=\u0007bBA;\u0001\u0011%\u00111\u001b\u0005\b\u00033\u0004A\u0011BAn\u0011\u001d\ty\u000e\u0001C\u0005\u0003CDq!!:\u0001\t\u0013\t9OA\u000fEK\u001a\fW\u000f\u001c;SKB|'\u000f^5oO\u0016sw-\u001b8f'\u0016\u0014h/[2f\u0015\tib$\u0001\u0003j[Bd'BA\u0010!\u0003\rQwN\u0019\u0006\u0003C\t\nqA]3q_J$8O\u0003\u0002$I\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003K\u0019\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u001d\n1aY8n\u0007\u0001\u0019B\u0001\u0001\u00161mA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t1\u0011I\\=SK\u001a\u0004\"!\r\u001b\u000e\u0003IR!a\r\u0010\u0002\u0007\u0005\u0004\u0018.\u0003\u00026e\t1\"+\u001a9peRLgnZ#oO&tWmU3sm&\u001cW\r\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005)1\u000f\u001c45U*\t1(\u0001\u0005he&T(\u0010\\3e\u0013\ti\u0004HA\u0004M_\u001e<\u0017N\\4\u0002%\u0005\u0004\b\u000f\\5dCRLwN\\\"p]R,\u0007\u0010\u001e\t\u0003\u0001\u001ek\u0011!\u0011\u0006\u0003\u0005\u000e\u000bqaY8oi\u0016DHO\u0003\u0002E\u000b\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001G\u0003\ry'oZ\u0005\u0003\u0011\u0006\u0013!#\u00119qY&\u001c\u0017\r^5p]\u000e{g\u000e^3yi\u0006A\"/\u001a9peRTuNY%ogR\fgnY3GC\u000e$xN]=\u0011\u0005-cU\"\u0001\u000f\n\u00055c\"\u0001\u0007*fa>\u0014HOS8c\u0013:\u001cH/\u00198dK\u001a\u000b7\r^8ss\u0006\u0019\"/\u001a9peRTuN\u0019*fa>\u001c\u0018\u000e^8ssB\u0011\u0001kU\u0007\u0002#*\u0011!KH\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001+R\u0005M\u0011V\r]8si*{'MU3q_NLGo\u001c:z\u0003M9Gn\u001c2bYJ+\u0007o\u001c:u'R|'/Y4f!\tYu+\u0003\u0002Y9\t\u0019r\t\\8cC2\u0014V\r]8siN#xN]1hK\u0006\u0011\u0002/\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3s!\tY\u0006-D\u0001]\u0015\tif,\u0001\u0005tK\u000e,(/\u001b;z\u0015\tyF%\u0001\u0005eKBdw._5u\u0013\t\tGL\u0001\nQKJl\u0017n]:j_:,eNZ8sG\u0016\u0014\u0018\u0001\b:fa>\u0014HOS8c\t\u0016dWmZ1uK\u0006\u001bGo\u001c:I_2$WM\u001d\t\u0003\u0017\u0012L!!\u001a\u000f\u00039I+\u0007o\u001c:u\u0015>\u0014G)\u001a7fO\u0006$X-Q2u_JDu\u000e\u001c3fe\u0006AQM^3oi\n+8\u000f\u0005\u0002iW6\t\u0011N\u0003\u0002kE\u00051QM^3oiNL!\u0001\\5\u0003#ac%+\u001a7fCN,WI^3oi\n+8/\u0001\u0004=S:LGO\u0010\u000b\t_B\f(o\u001d;vmB\u00111\n\u0001\u0005\u0006}!\u0001\ra\u0010\u0005\u0006\u0013\"\u0001\rA\u0013\u0005\u0006\u001d\"\u0001\ra\u0014\u0005\u0006+\"\u0001\rA\u0016\u0005\u00063\"\u0001\rA\u0017\u0005\u0006E\"\u0001\ra\u0019\u0005\u0006M\"\u0001\raZ\u0001\u0017e\u0016\u0004xN\u001d;K_\n$U\r\\3hCR,\u0017i\u0019;peV\t\u0011\u0010\u0005\u0002{\u007f6\t1P\u0003\u0002}{\u0006)\u0011m\u0019;pe*\ta0\u0001\u0003bW.\f\u0017bAA\u0001w\nA\u0011i\u0019;peJ+g-\u0001\u0004ti\u0006$Xo\u001d\u000b\u0005\u0003\u000f\t\u0019\u0002\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\tiAH\u0001\u0007I>l\u0017-\u001b8\n\t\u0005E\u00111\u0002\u0002\u0010%\u0016\u0004xN\u001d;K_\n\u001cF/\u0019;vg\"9\u0011Q\u0003\u0006A\u0002\u0005]\u0011!\u00026pE&#\u0007\u0003BA\r\u0003{qA!a\u0007\u0002:9!\u0011QDA\u001c\u001d\u0011\ty\"!\u000e\u000f\t\u0005\u0005\u00121\u0007\b\u0005\u0003G\t\tD\u0004\u0003\u0002&\u0005=b\u0002BA\u0014\u0003[i!!!\u000b\u000b\u0007\u0005-\u0002&\u0001\u0004=e>|GOP\u0005\u0002O%\u0011QEJ\u0005\u0003G\u0011J!!\t\u0012\n\u0005}\u0001\u0013BA\u001a\u001f\u0013\r\tYDM\u0001\u0017%\u0016\u0004xN\u001d;j]\u001e,enZ5oKN+'O^5dK&!\u0011qHA!\u0005-\u0011V\r]8si*{'-\u00133\u000b\u0007\u0005m\"'A\u0005hKR\u0014Vm];miR!\u0011qIA'!\r\t\u0014\u0011J\u0005\u0004\u0003\u0017\u0012$!F*ue\u0016\fW.\u001b8h%\u0016\u0004xN\u001d;SKN,H\u000e\u001e\u0005\b\u0003+Y\u0001\u0019AA\f\u0003\u001d\u0001(/\u001a<jK^$B!a\u0015\u0002ZA\u00191&!\u0016\n\u0007\u0005]CFA\u0002B]fDq!a\u0017\r\u0001\u0004\ti&\u0001\tsKB|'\u000f\u001e#fM&t\u0017\u000e^5p]B\u0019\u0011'a\u0018\n\u0007\u0005\u0005$G\u0001\tSKB|'\u000f\u001e#fM&t\u0017\u000e^5p]\u0006\u0019q-\u001a;\u0015\t\u0005\u001d\u0014Q\u000e\t\u0005\u0003\u0013\tI'\u0003\u0003\u0002l\u0005-!!\u0003*fa>\u0014HOS8c\u0011\u001d\t)\"\u0004a\u0001\u0003/\taa];c[&$H\u0003BA\f\u0003gBq!a\u0017\u000f\u0001\u0004\ti&A\u0003bE>\u0014H\u000f\u0006\u0003\u0002z\u0005}\u0004cA\u0016\u0002|%\u0019\u0011Q\u0010\u0017\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003+y\u0001\u0019AA\f)\u0011\t\u0019)a%\u0011\r\u0005\u0015\u0015qRA\f\u001b\t\t9I\u0003\u0003\u0002\n\u0006-\u0015\u0001B;uS2T!!!$\u0002\t)\fg/Y\u0005\u0005\u0003#\u000b9I\u0001\u0003MSN$\bbBAK!\u0001\u0007\u00111Q\u0001\u0007U>\u0014\u0017\nZ:\u0002\u0011\u0005\u0014wN\u001d;BY2$\"!a!\u0002\r\u0011,G.\u001a;f)\u0011\tI(a(\t\u000f\u0005U!\u00031\u0001\u0002\u0018Q!\u00111QAR\u0011\u001d\t)j\u0005a\u0001\u0003\u0007\u000b\u0011\u0002Z3mKR,\u0017\t\u001c7\u0002\r\u0019Lg\u000e\u001a\"z)\u0019\tY+!/\u0002DB1\u0011QVA[\u0003Oj!!a,\u000b\t\u00055\u0011\u0011\u0017\u0006\u0004\u0003g\u001b\u0015\u0001\u00023bi\u0006LA!a.\u00020\n!\u0001+Y4f\u0011\u001d\tY,\u0006a\u0001\u0003{\u000b\u0001C]3q_J$(j\u001c2GS2$XM]:\u0011\u0007A\u000by,C\u0002\u0002BF\u0013\u0001CU3q_J$(j\u001c2GS2$XM]:\t\u000f\u0005\u0015W\u00031\u0001\u0002H\u0006A\u0001/Y4fC\ndW\r\u0005\u0003\u0002.\u0006%\u0017\u0002BAf\u0003_\u0013\u0001\u0002U1hK\u0006\u0014G.Z\u0001\u0017M&tG-\u00118e\u0003\n|'\u000f\u001e*fa>\u0014HOS8cgR!\u00111QAi\u0011\u001d\tYL\u0006a\u0001\u0003{#B!a\u0006\u0002V\"9\u0011q[\fA\u0002\u0005\u001d\u0014!\u0003:fa>\u0014HOS8c\u0003]1\u0017N\u001c3B]\u0012$U\r\\3uKJ+\u0007o\u001c:u\u0015>\u00147\u000f\u0006\u0003\u0002\u0004\u0006u\u0007bBA^1\u0001\u0007\u0011QX\u0001\u0010I\u0016dW\r^3SKB|'\u000f\u001e&pER!\u0011qMAr\u0011\u001d\t9.\u0007a\u0001\u0003O\n\u0001c\u00195fG.\u0014V\r]8si>;h.\u001a:\u0015\t\u0005e\u0014\u0011\u001e\u0005\b\u0003/T\u0002\u0019AA4\u0001")
public class DefaultReportingEngineService
implements ReportingEngineService,
Logging {
    private ActorRef reportJobDelegateActor;
    private final ApplicationContext applicationContext;
    private final ReportJobInstanceFactory reportJobInstanceFactory;
    private final ReportJobRepository reportJobRepository;
    private final GlobalReportStorage globalReportStorage;
    private final PermissionEnforcer permissionEnforcer;
    private ReportJobDelegateActorHolder reportJobDelegateActorHolder;
    private final XLReleaseEventBus eventBus;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DefaultReportingEngineService defaultReportingEngineService = this;
        synchronized (defaultReportingEngineService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private ActorRef reportJobDelegateActor$lzycompute() {
        DefaultReportingEngineService defaultReportingEngineService = this;
        synchronized (defaultReportingEngineService) {
            if (!this.bitmap$0) {
                this.reportJobDelegateActor = this.reportJobDelegateActorHolder.actorRef();
                this.bitmap$0 = true;
            }
        }
        this.reportJobDelegateActorHolder = null;
        return this.reportJobDelegateActor;
    }

    public ActorRef reportJobDelegateActor() {
        if (!this.bitmap$0) {
            return this.reportJobDelegateActor$lzycompute();
        }
        return this.reportJobDelegateActor;
    }

    @Override
    public ReportJobStatus status(Integer jobId) {
        return (ReportJobStatus)((Object)this.reportJobRepository.findByJobId(jobId).map((Function1 & Serializable)reportJob -> {
            this.checkReportOwner((ReportJob)((Object)reportJob));
            return reportJob.getStatus();
        }).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Job '" + jobId + "' could not be found.", new Object[0]);
        }));
    }

    @Override
    public StreamingReportResult getResult(Integer jobId) {
        Option<ReportJob> reportJobOption = this.reportJobRepository.findByJobId(jobId);
        return (StreamingReportResult)reportJobOption.map((Function1 & Serializable)reportJob -> {
            this.checkReportOwner((ReportJob)((Object)reportJob));
            return $this.globalReportStorage.resolve($this.globalReportStorage.reportResult((ReportJob)((Object)reportJob)));
        }).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Result of job '" + jobId + "' could not be found.", new Object[0]);
        });
    }

    @Override
    public Object preview(ReportDefinition reportDefinition) {
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)reportDefinition);
        return reportDefinition.preview();
    }

    @Override
    public ReportJob get(Integer jobId) {
        Option<ReportJob> reportJobOption = this.reportJobRepository.findByJobId(jobId);
        return (ReportJob)((Object)reportJobOption.map((Function1 & Serializable)reportJob -> {
            this.checkReportOwner((ReportJob)((Object)reportJob));
            return reportJob;
        }).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Job '" + jobId + "' could not be found.", new Object[0]);
        }));
    }

    @Override
    public Integer submit(ReportDefinition reportDefinition) {
        ReportJobInstance reportJobInstance = this.reportJobInstanceFactory.submit(reportDefinition);
        reportJobInstance.enqueue();
        int jobId = reportJobInstance.getJobId();
        ReportJobDelegateActor.Enqueue x$1 = new ReportJobDelegateActor.Enqueue(Predef$.MODULE$.int2Integer(jobId), reportJobInstance);
        ActorRef x$2 = this.reportJobDelegateActor().$bang$default$2((Object)x$1);
        this.reportJobDelegateActor().$bang((Object)x$1, x$2);
        return Predef$.MODULE$.int2Integer(jobId);
    }

    @Override
    public void abort(Integer jobId) {
        Option<ReportJob> reportJobOption = this.reportJobRepository.findByJobId(jobId);
        reportJobOption.map((Function1 & Serializable)reportJob -> this.abort((ReportJob)((Object)reportJob))).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Job '" + jobId + "' could not be found.", new Object[0]);
        });
    }

    @Override
    public java.util.List<Integer> abort(java.util.List<Integer> jobIds) {
        if (jobIds.isEmpty()) {
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava();
        }
        ReportJobFilters reportJobFilters = new ReportJobFilters();
        reportJobFilters.setJobIds(jobIds);
        return this.findAndAbortReportJobs(reportJobFilters);
    }

    @Override
    public java.util.List<Integer> abortAll() {
        ReportJobFilters reportJobFilters = new ReportJobFilters();
        return this.findAndAbortReportJobs(reportJobFilters);
    }

    @Override
    public void delete(Integer jobId) {
        Option<ReportJob> reportJobOption = this.reportJobRepository.findByJobId(jobId);
        reportJobOption.map((Function1 & Serializable)reportJob -> this.deleteReportJob((ReportJob)((Object)reportJob))).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Job '" + jobId + "' could not be found.", new Object[0]);
        });
    }

    @Override
    public java.util.List<Integer> delete(java.util.List<Integer> jobIds) {
        if (jobIds.isEmpty()) {
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava();
        }
        ReportJobFilters reportJobFilters = new ReportJobFilters();
        reportJobFilters.setJobIds(jobIds);
        return this.findAndDeleteReportJobs(reportJobFilters);
    }

    @Override
    public java.util.List<Integer> deleteAll() {
        ReportJobFilters reportJobFilters = new ReportJobFilters();
        reportJobFilters.statuses_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ReportJobStatus.ABORTED.name(), (List)new .colon.colon((Object)ReportJobStatus.FAILED.name(), (List)new .colon.colon((Object)ReportJobStatus.COMPLETED.name(), (List)Nil$.MODULE$)))).asJava());
        return this.findAndDeleteReportJobs(reportJobFilters);
    }

    @Override
    public Page<ReportJob> findBy(ReportJobFilters reportJobFilters, Pageable pageable) {
        block0: {
            if (this.permissionEnforcer.isCurrentUserAdmin()) break block0;
            reportJobFilters.username_$eq(Permissions.getAuthenticatedUserName());
        }
        return this.reportJobRepository.query(reportJobFilters, pageable);
    }

    private java.util.List<Integer> findAndAbortReportJobs(ReportJobFilters reportJobFilters) {
        ListBuffer abortRequestedJobIds = ListBuffer$.MODULE$.empty();
        reportJobFilters.statuses_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)ReportJobStatus.SUBMITTED.name(), (List)new .colon.colon((Object)ReportJobStatus.STARTED.name(), (List)Nil$.MODULE$))).asJava());
        Page<ReportJob> result = this.findBy(reportJobFilters, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
        result.forEach(reportJob -> {
            try {
                abortRequestedJobIds.$plus$eq((Object)this.abort((ReportJob)((Object)reportJob)));
            }
            catch (Exception e) {
                this.logger().warn((Function0 & Serializable)() -> "Error while aborting a list of jobs", (Function0 & Serializable)() -> e);
            }
        });
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)abortRequestedJobIds).asJava();
    }

    private Integer abort(ReportJob reportJob) {
        this.checkReportOwner(reportJob);
        Integer jobId = reportJob.getJobId();
        .colon.colon validStatuses = new .colon.colon((Object)ReportJobStatus.SUBMITTED.name(), (List)new .colon.colon((Object)ReportJobStatus.STARTED.name(), (List)Nil$.MODULE$));
        if (validStatuses.contains((Object)reportJob.status().name())) {
            ReportJobDelegateActor.Abort x$1 = new ReportJobDelegateActor.Abort(jobId);
            ActorRef x$2 = this.reportJobDelegateActor().$bang$default$2((Object)x$1);
            this.reportJobDelegateActor().$bang((Object)x$1, x$2);
            return jobId;
        }
        throw new IllegalStateException("Can not abort report job '" + jobId + "'. It is already completed, failed or aborted.");
    }

    private java.util.List<Integer> findAndDeleteReportJobs(ReportJobFilters reportJobFilters) {
        ListBuffer deletedJobIds = ListBuffer$.MODULE$.empty();
        Page<ReportJob> result = this.findBy(reportJobFilters, (Pageable)PageRequest.of((int)0, (int)Integer.MAX_VALUE));
        result.forEach(reportJob -> {
            try {
                deletedJobIds.$plus$eq((Object)this.deleteReportJob((ReportJob)((Object)reportJob)).getJobId());
            }
            catch (Exception e) {
                this.logger().warn((Function0 & Serializable)() -> "Error while deleting a list of jobs", (Function0 & Serializable)() -> e);
            }
        });
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)deletedJobIds).asJava();
    }

    private ReportJob deleteReportJob(ReportJob reportJob) {
        this.checkReportOwner(reportJob);
        .colon.colon validStatuses = new .colon.colon((Object)ReportJobStatus.ABORTED.name(), (List)new .colon.colon((Object)ReportJobStatus.FAILED.name(), (List)new .colon.colon((Object)ReportJobStatus.COMPLETED.name(), (List)Nil$.MODULE$)));
        if (validStatuses.contains((Object)reportJob.status().name()) && this.globalReportStorage.cleanup(reportJob)) {
            reportJob.status_$eq(ReportJobStatus.DELETED);
            ReportJob deletedReportJob = this.reportJobRepository.update(reportJob);
            this.eventBus.publish((XLReleaseEvent)new ReportJobDeletedEvent(deletedReportJob));
            return deletedReportJob;
        }
        throw new IllegalStateException("Can not delete report job '" + reportJob.getJobId() + "'. It is either already deleted or Digital.ai Release does not have required access to the filesystem.");
    }

    private void checkReportOwner(ReportJob reportJob) {
        if (!this.permissionEnforcer.isCurrentUserAdmin()) {
            String string = reportJob.username();
            String string2 = Permissions.getAuthenticatedUserName();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw PermissionDeniedException.withMessage((String)("You can not take action on report job '" + reportJob.getJobId() + "' as you are not the owner of this report job."));
            }
        }
    }

    public DefaultReportingEngineService(ApplicationContext applicationContext, ReportJobInstanceFactory reportJobInstanceFactory, ReportJobRepository reportJobRepository, GlobalReportStorage globalReportStorage, PermissionEnforcer permissionEnforcer, ReportJobDelegateActorHolder reportJobDelegateActorHolder, XLReleaseEventBus eventBus) {
        this.applicationContext = applicationContext;
        this.reportJobInstanceFactory = reportJobInstanceFactory;
        this.reportJobRepository = reportJobRepository;
        this.globalReportStorage = globalReportStorage;
        this.permissionEnforcer = permissionEnforcer;
        this.reportJobDelegateActorHolder = reportJobDelegateActorHolder;
        this.eventBus = eventBus;
        Logging.$init$((Logging)this);
    }
}

