package com.xebialabs.xlrelease.reports.job.repository

import com.xebialabs.xlrelease.reports.job.api.ReportingEngineService.ReportJobId
import com.xebialabs.xlrelease.reports.job.domain.ReportJob
import org.springframework.data.domain.{Page, Pageable}

import java.util.Date

trait ReportJobRepository {
  def create(reportJob: ReportJob): ReportJob

  def findByJobId(jobId: ReportJobId): Option[ReportJob]

  def update(reportJob: ReportJob): ReportJob

  def delete(jobId: ReportJobId): Unit

  def submittedStaleJobIds(olderThan: Date): Seq[ReportJobId]

  def startedStaleJobIds(olderThan: Date): Seq[ReportJobId]

  def startedNodeJobIds(node: String): Seq[ReportJobId]

  def submittedNodeJobIds(node: String): Seq[ReportJobId]

  def query(reportJobFilter: ReportJobFilters, pageable: Pageable): Page[ReportJob]

  def updateProgress(reportJob: ReportJob): ReportJob
}
