package com.xebialabs.xlrelease.reports.job.api

import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, Metadata}

import java.io.File
import java.util.Date
import javax.ws.rs.core.StreamingOutput

@Metadata(virtual = true)
trait ReportDefinition extends ConfigurationItem {

  def reportName: String

  def contentType: String

  def run(runContext: ReportJobRunContext): File

  def preview(): Any

  def setGeneratedBy(username: String): Unit

  def getGeneratedBy(): String

  def setGeneratedOn(generatedOn: Date): Unit

  def getGeneratedOn(): Date

}

@Metadata(virtual = true)
trait StreamingReportDefinition extends ConfigurationItem {

  def reportName: String

  def contentType: String

  def run(): StreamingOutput

}
