package com.xebialabs.xlrelease.reports.job.impl.cleanup

import akka.actor.{Actor, ActorLogging, ActorRef, Props}
import akka.cluster.Cluster
import akka.cluster.ClusterEvent.{InitialStateAsSnapshot, MemberRemoved}
import com.xebialabs.xlrelease.reports.job.impl.cleanup.ReportCleanerActor.NodeCleanup

object NodeRemovalListenerActor {
  def props(reportingEngineActor: ActorRef): Props = Props(new NodeRemovalListenerActor(reportingEngineActor))
}

class NodeRemovalListenerActor(reportCleanerActor: ActorRef) extends Actor with ActorLogging {

  import context._

  private lazy val cluster: Cluster = Cluster(system)

  @scala.throws[Exception](classOf[Exception])
  override def preStart(): Unit = {
    super.preStart()
    cluster.subscribe(self, InitialStateAsSnapshot, classOf[MemberRemoved])
  }

  @scala.throws[Exception](classOf[Exception])
  override def postStop(): Unit = {
    cluster.unsubscribe(self)
    super.postStop()
  }

  override def receive: Receive = {
    case MemberRemoved(member, _) => reportCleanerActor ! NodeCleanup(member)
    case msg => log.warning(s"Received unexpected message: $msg")
  }
}
