package com.xebialabs.xlrelease.reports.excel;

import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

abstract public class Export {

    protected XSSFWorkbook workBook;
    protected XSSFSheet sheet;

    protected int rowIndex;

    public Export() {
        this.rowIndex = 0;
        workBook = new XSSFWorkbook();
        sheet = workBook.createSheet();
    }

    abstract protected void addContent();

    abstract protected void setColumnsWidth();

    abstract protected void addHeaderRow();

    public Workbook getWorkBook() {
        workBook = new XSSFWorkbook();
        sheet = workBook.createSheet();
        try {
            addHeaderRow();
            setColumnsWidth();
            addContent();
            preventDynamicDataExchangeAttack(workBook);
        } finally {
            rowIndex = 0;
        }
        return workBook;
    }

    /**
     * see XSSFSheet.setColumnWidth to understand the magic number 256
     */
    public static int numberOfCharacter(int number) {
        return number * 256;
    }

    /**
     * Prevent Dynamic Data Exchange Attack through excel export (https://www.owasp.org/index.php/CSV_Injection)
     */
    public static void preventDynamicDataExchangeAttack(XSSFWorkbook workBook) {
        String pattern = "^(=|@|-|\"|\\+).+$";
        for (Sheet sheet : workBook) {
            for (Row row : sheet) {
                for (Cell cell : row) {
                    XSSFCell xssfcell = (XSSFCell) cell;
                    if (xssfcell.getCellTypeEnum() == CellType.STRING && xssfcell.toString().trim().matches(pattern)) {
                        xssfcell.setCellValue("'" + xssfcell.getStringCellValue());
                    }
                }
            }
        }
    }
}
