package com.xebialabs.xlrelease.reports.domain.exceptions

case class MultipleExceptions(exceptions: Seq[Throwable])
  extends RuntimeException(s"Multiple exceptions: ${exceptions.map(_.getMessage).mkString("[", ", ", "]")}")

object MultipleExceptions {
  def apply(ex0: Throwable, exceptions: Throwable*): Throwable = {
    val uniqueExceptions = (ex0 +: exceptions.toSeq).distinct
    if (uniqueExceptions.tail.isEmpty) {
      ex0
    } else {
      new MultipleExceptions(uniqueExceptions)
    }
  }
}