package com.xebialabs.xlrelease.reports.dto;

import java.util.List;
import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.Months;

import com.xebialabs.xlrelease.views.Point;

import static com.google.common.collect.Lists.newArrayList;

public class AverageByMonthComputer {
    private List<Point> serie = newArrayList();
    private DateTime currentDate;
    private long total;
    private long sum;

    public AverageByMonthComputer(DateTime startDate) {
        this.currentDate = startDate;
    }

    public void add(DateTime date, float value) {
        if (isMonthChanged(date)) {
            addPoint(currentDate);
            fillMissingMonths(date);

            currentDate = date;
            resetAccumulators();
        }
        total++;
        sum += value;
    }

    public List<Point> completeSerie(DateTime lastDate) {
        addPoint(currentDate);
        fillMissingMonths(lastDate.plusMonths(1));
        return serie;
    }

    private void addPoint(DateTime date) {
        String pointTitle = date.toString("MMMM", Locale.ENGLISH);
        long middleOfMonth = new DateTime(date.getYear(), date.getMonthOfYear(), 15, 0, 0).getMillis();

        serie.add(new Point(pointTitle, middleOfMonth, getValue()));
    }

    private void fillMissingMonths(DateTime date) {
        int monthsDifference = Months.monthsBetween(currentDate, date).getMonths();
        if (monthsDifference > 1) {
            resetAccumulators();
            for (int monthToAdd = 1; monthToAdd < monthsDifference; monthToAdd++) {
                addPoint(currentDate.plusMonths(monthToAdd));
            }
        }
    }

    private boolean isMonthChanged(DateTime nextDate) {
        return currentDate.getMonthOfYear() != nextDate.getMonthOfYear() || currentDate.getYear() != nextDate.getYear();
    }

    private void resetAccumulators() {
        total = 0;
        sum = 0;
    }

    private float getValue() {
        return (total != 0) ? sum / total : 0;
    }
}
