package com.xebialabs.xlrelease.reports.job.impl.cleanup

import com.xebialabs.xlrelease.reports.job.impl.cleanup.ReportCleanerActor.NodeCleanup
import org.apache.pekko.actor.{Actor, ActorLogging, ActorRef, Props}
import org.apache.pekko.cluster.Cluster
import org.apache.pekko.cluster.ClusterEvent.{InitialStateAsSnapshot, MemberRemoved}

object NodeRemovalListenerActor {
  def props(reportingEngineActor: ActorRef): Props = Props(new NodeRemovalListenerActor(reportingEngineActor))
}

class NodeRemovalListenerActor(reportCleanerActor: ActorRef) extends Actor with ActorLogging {

  import context._

  private lazy val cluster: Cluster = Cluster(system)

  @scala.throws[Exception](classOf[Exception])
  override def preStart(): Unit = {
    super.preStart()
    cluster.subscribe(self, InitialStateAsSnapshot, classOf[MemberRemoved])
  }

  @scala.throws[Exception](classOf[Exception])
  override def postStop(): Unit = {
    cluster.unsubscribe(self)
    super.postStop()
  }

  override def receive: Receive = {
    case MemberRemoved(member, _) => reportCleanerActor ! NodeCleanup(member)
    case msg => log.warning(s"Received unexpected message: $msg")
  }
}
