package com.xebialabs.xlrelease.reports.job.spring

import com.xebialabs.deployit.security.PermissionEnforcer
import com.xebialabs.xlplatform.cluster.ClusterMode.FULL
import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.events.XLReleaseEventBus
import com.xebialabs.xlrelease.reports.job.api.ReportingEngineService
import com.xebialabs.xlrelease.reports.job.impl._
import com.xebialabs.xlrelease.reports.job.impl.cleanup.ReportCleanerActorInitializer._
import com.xebialabs.xlrelease.reports.job.impl.cleanup.{ReportCleanerActorInitializer, ReportCleanerOperations}
import com.xebialabs.xlrelease.reports.job.repository.ReportJobRepository
import com.xebialabs.xlrelease.reports.job.repository.sql.SqlReportJobRepository
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter
import com.xebialabs.xlrelease.service.BroadcastService
import io.micrometer.core.instrument.MeterRegistry
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.context.ApplicationContext
import org.springframework.context.annotation.{Bean, Configuration, Profile}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.scheduling.annotation.EnableAsync

@Configuration
@EnableAsync
class ReportingConfiguration {

  @Autowired
  var xlrConfig: XlrConfig = _

  @Autowired
  var applicationContext: ApplicationContext = _

  @Autowired
  var systemHolder: ActorSystemHolder = _

  @Autowired
  var sqlRepositoryAdapter: SqlRepositoryAdapter = _

  @Autowired
  @Qualifier("xlrRepositoryJdbcTemplate")
  var jdbcTemplate: JdbcTemplate = _

  @Autowired
  @Qualifier("xlrRepositorySqlDialect")
  var dialect: Dialect = _

  @Autowired
  var eventBus: XLReleaseEventBus = _

  @Autowired
  var configurationRepository: ConfigurationRepository = _

  @Autowired
  var permissionEnforcer: PermissionEnforcer = _

  @Autowired
  var broadcastService: BroadcastService = _

  @Autowired
  var meterRegistry: MeterRegistry = _

  @Bean
  def reportingEngineService: ReportingEngineService = {
    new DefaultReportingEngineService(applicationContext,
      reportJobInstanceFactory,
      reportJobRepository,
      reportStorage,
      permissionEnforcer,
      eventBus,
      broadcastService
    )
  }

  @Bean
  def reportStorage: GlobalReportStorage = {
    new GlobalReportStorage(xlrConfig.reporting.engine.location)
  }

  @Bean
  def reportJobRepository: ReportJobRepository = {
    new SqlReportJobRepository(jdbcTemplate, dialect, sqlRepositoryAdapter)
  }

  @Bean
  def reportJobInstanceFactory: ReportJobInstanceFactory = {
    new DefaultReportJobInstanceFactory(applicationContext, reportingEngineConfiguration, reportExecutorService, reportJobRepository, reportStorage, eventBus)
  }

  @Bean(destroyMethod = "shutdown")
  def reportExecutorService: ReportExecutorService = {
    new ReportExecutorService(xlrConfig, meterRegistry)
  }

  @Bean
  def reportingEngineConfiguration: ReportingEngineConfiguration = {
    new ReportingEngineConfiguration(systemHolder)
  }

  @Bean
  @Profile(Array(FULL))
  def clusteredReportCleanerActorInitializer: ReportCleanerActorInitializer = {
    new ClusteredReportCleanerActorInitializer(systemHolder, xlrConfig, reportCleanerOperations, reportExecutorService)
  }

  @Bean
  def reportCleanerOperations: ReportCleanerOperations = {
    new ReportCleanerOperations(reportJobRepository, reportJobInstanceFactory, configurationRepository, reportStorage, eventBus)
  }

}
