package com.xebialabs.xlrelease.reports.job.api

import com.xebialabs.xlrelease.reports.job.api.ReportingEngineService.ReportJobId

import java.io.OutputStream
import java.net.URI
import java.nio.file.Paths
import java.util.Date

trait ReportResult {
  def resultUri: String

  def generatedOn: Date

  def reportName: String

  def contentType: String

  def jobId: ReportJobId

  def fileName: String = {
    val uri = new URI(resultUri)
    val path = Paths.get(uri)
    path.getFileName.toString
  }
}

trait StreamingReportResult extends ReportResult {
  def write(outputStream: OutputStream): Unit
}
