package com.xebialabs.xlrelease.reports.excel;

import java.util.List;
import org.apache.poi.ss.util.CellUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;

import com.xebialabs.xlrelease.reports.dto.TaskDuration;

public class TopLongestTaskExport extends Export {
    private List<TaskDuration> topLongestTasks;

    public static final int TITLE_COLUMN = 0;
    public static final int DURATION_COLUMN = 1;
    public static final int RELEASE_COLUMN = 2;
    public static final int PHASE_COLUMN = 3;
    public static final int OWNER_COLUMN = 4;
    public static final int TEAM_COLUMN = 5;

    private static final String TITLE_HEADER = "Task";
    private static final String DURATION_HEADER = "Duration";
    private static final String RELEASE_HEADER = "Release";
    private static final String PHASE_HEADER = "Phase";
    private static final String OWNER_HEADER = "Owner";
    private static final String TEAM_HEADER = "Team";


    public TopLongestTaskExport(List<TaskDuration> topLongestTasks) {
        super();
        this.topLongestTasks = topLongestTasks;
    }

    @Override
    protected void addContent() {
        for (TaskDuration taskDuration : topLongestTasks) {
            XSSFRow row = sheet.createRow(rowIndex++);

            CellUtil.createCell(row, TITLE_COLUMN, taskDuration.getTitle());
            XSSFCell duration = row.createCell(DURATION_COLUMN);
            duration.setCellValue(taskDuration.getDuration());
            CellUtil.createCell(row, RELEASE_COLUMN, taskDuration.getRelease());
            CellUtil.createCell(row, PHASE_COLUMN, taskDuration.getPhase());

            String user = taskDuration.getOwner().getFullName();
            if (user == null) {
                user = taskDuration.getOwner().getUsername();
            }

            CellUtil.createCell(row, OWNER_COLUMN, user);
            CellUtil.createCell(row, TEAM_COLUMN, taskDuration.getTeam());
        }
    }

    @Override
    protected void setColumnsWidth() {
        sheet.setColumnWidth(TITLE_COLUMN, numberOfCharacter(30));
        sheet.setColumnWidth(DURATION_COLUMN, numberOfCharacter(10));
        sheet.setColumnWidth(RELEASE_COLUMN, numberOfCharacter(20));
        sheet.setColumnWidth(PHASE_COLUMN, numberOfCharacter(20));
        sheet.setColumnWidth(OWNER_COLUMN, numberOfCharacter(15));
        sheet.setColumnWidth(TEAM_COLUMN, numberOfCharacter(15));
    }

    @Override
    protected void addHeaderRow() {
        XSSFRow row = sheet.createRow(rowIndex++);
        CellUtil.createCell(row, TITLE_COLUMN, TITLE_HEADER);
        CellUtil.createCell(row, DURATION_COLUMN, DURATION_HEADER);
        CellUtil.createCell(row, RELEASE_COLUMN, RELEASE_HEADER);
        CellUtil.createCell(row, PHASE_COLUMN, PHASE_HEADER);
        CellUtil.createCell(row, OWNER_COLUMN, OWNER_HEADER);
        CellUtil.createCell(row, TEAM_COLUMN, TEAM_HEADER);
        sheet.createRow(rowIndex++);
    }
}
