package com.xebialabs.xlrelease.reports.job.impl.cleanup

import com.xebialabs.xlrelease.reports.job.impl.ReportExecutorService
import grizzled.slf4j.Logging
import org.quartz.{DisallowConcurrentExecution, Job, JobExecutionContext}
import org.springframework.beans.factory.annotation.Autowired

import scala.concurrent.{ExecutionContextExecutorService, Future}
import scala.util.{Failure, Success}

@DisallowConcurrentExecution
class ReportCleanerJob @Autowired()(reportCleanerOperations: ReportCleanerOperations, reportExecutor: ReportExecutorService) extends Job with Logging {
  implicit val ec: ExecutionContextExecutorService = reportExecutor.executionContext

  override def execute(context: JobExecutionContext): Unit = {
    logger.debug("Executing report cleaner job")
    Future {
      logger.debug("Cleanup started")
      reportCleanerOperations.cleanup()
      logger.debug("Cleanup ended")
    } onComplete {
      case Success(_) => logger.debug("Cleanup done")
      case Failure(ex) =>
        logger.error("Exception occurred while cleaning reports", ex)
    }
  }
}
