package com.xebialabs.xlrelease.reports

import com.xebialabs.xlrelease.db.sql.archiving.BaseSelectArchivedBuilder
import com.xebialabs.xlrelease.reports.filters.ReportFilter
import com.xebialabs.xlrelease.udm.reporting.filters.impl.DateFilter

import scala.collection.mutable
import scala.jdk.CollectionConverters._

package object db {

  implicit class BuilderExtensions[T <: BaseSelectArchivedBuilder[T]](builder: T) {
    def withFilters(filters: java.util.List[ReportFilter]): T = withFilters(filters.asScala)

    def withFilters(filters: mutable.Buffer[ReportFilter]): T = if (filters != null) withFilters(filters.toSeq) else withFilters(Seq())

    def withFilters(filters: Seq[ReportFilter]): T = {
      if (filters != null) {
        filters
          .filterNot(filter => filter.isInstanceOf[DateFilter]) // currently this is passed directly as arguments
          .foreach(_.apply(builder))
      }
      builder
    }
  }

}
