package com.xebialabs.xlrelease.reports.job.impl

import com.xebialabs.xlrelease.reports.job.api.ReportStorage.StreamingReportStorage
import com.xebialabs.xlrelease.reports.job.api.ReportingEngineService.ReportJobId
import com.xebialabs.xlrelease.reports.job.api.{ReportResult, ReportStorage, StreamingReportResult}
import com.xebialabs.xlrelease.reports.job.domain.ReportJob
import com.xebialabs.xlrelease.reports.job.impl.GlobalReportStorage.GlobalReportResult
import com.xebialabs.xlrelease.reports.job.impl.filesystem.FileSystemReportStorage
import com.xebialabs.xlrelease.reports.job.impl.s3.S3ReportStorage
import com.xebialabs.xlrelease.scheduler.storage.spring.StorageConfiguration.URI_SCHEME_S3_STORAGE
import com.xebialabs.xlrelease.storage.local.LocalStorageConfig
import com.xebialabs.xlrelease.storage.s3.S3StorageConfig
import grizzled.slf4j.Logging

import java.util.Date

class GlobalReportStorage(private val reportStorage: ReportStorage) extends Logging {

  def reportStorage(jobId: ReportJobId, generatedOn: Date): StreamingReportStorage = {
    reportStorage.reportStorage(jobId, generatedOn)
  }

  def resolve(reportResult: ReportResult): StreamingReportResult = {
    reportStorage.resolve(reportResult)
  }

  def cleanup(reportJob: ReportJob): Boolean = {
    reportStorage.cleanup(reportJob)
  }

  def reportResult(reportJob: ReportJob): ReportResult = {
    new GlobalReportResult(
      reportJob.getJobId(),
      reportJob.getReportName,
      reportJob.getEndTime,
      reportJob.getResultUri,
      reportJob.getReportDefinition.contentType
    )
  }
}

object GlobalReportStorage {

  def apply(storageType: String, localStorageConfig: LocalStorageConfig, s3StorageConfig: S3StorageConfig): GlobalReportStorage = {
    val storage = if (storageType == URI_SCHEME_S3_STORAGE) {
      new S3ReportStorage(
        localStorageConfig,
        s3StorageConfig,
      )
    } else {
      new FileSystemReportStorage(
        localStorageConfig
      )
    }
    new GlobalReportStorage(storage)
  }

  private class GlobalReportResult(override val jobId: ReportJobId,
                                   override val reportName: String,
                                   override val generatedOn: Date, // instant when report generation is completed ( = end time)
                                   override val resultUri: String,
                                   override val contentType: String)
    extends ReportResult
}
