package com.xebialabs.xlrelease.reports.job.impl

import com.xebialabs.xlplatform.cluster.ClusterMode.{Full, HotStandby, Standalone}
import com.xebialabs.xlrelease.actors.ActorSystemHolder
import com.xebialabs.xlrelease.config.XlrConfig
import org.apache.pekko.cluster.Cluster

import scala.beans.BeanProperty

class ReportingEngineConfiguration(actorSystemHolder: ActorSystemHolder) {

  @BeanProperty
  lazy val node: String = {
    XlrConfig.getInstance.clusterMode match {
      case Full | HotStandby => {
        val address = Cluster(actorSystemHolder.actorSystem).selfAddress
        val host = address.host.get
        val port = address.port.get
        s"$host:$port"
      }
      case Standalone => "default"
    }
  }

}
