package com.xebialabs.xlrelease.reports.job.repository.sql

import com.xebialabs.xlplatform.utils.ResourceManagement.using
import com.xebialabs.xlrelease.reports.job.api.ReportDefinition
import com.xebialabs.xlrelease.reports.job.domain.{ReportJob, ReportJobStatus}
import com.xebialabs.xlrelease.reports.job.repository.sql.ReportJobSchema.{REPORT_JOBS => RJ}
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter
import com.xebialabs.xlrelease.serialization.json.utils.CiSerializerHelper
import org.springframework.jdbc.core.RowMapper
import org.springframework.util.StreamUtils.copyToString

import java.nio.charset.StandardCharsets
import scala.util.{Failure, Success, Try}

trait ReportJobMapper {
  def sqlRepositoryAdapter: SqlRepositoryAdapter

  private[repository] def reportJobMapper: RowMapper[ReportJob] = (rs, _) => {
    val reportJob = new ReportJob()
    reportJob.setJobId(rs.getInt(RJ.JOB_ID))
    reportJob.setId(reportJob.getJobId.toString)
    reportJob.setReportType(rs.getString(RJ.REPORT_TYPE))
    reportJob.setReportName(rs.getString(RJ.REPORT_NAME))
    reportJob.setStatus(ReportJobStatus.valueOf(rs.getString(RJ.STATUS)))
    reportJob.setNode(rs.getString(RJ.NODE))
    reportJob.setTotalWorkItems(rs.getInt(RJ.TOTAL_WORK_ITEMS))
    reportJob.setCompletedWorkItems(rs.getInt(RJ.COMPLETED_WORK_ITEMS))
    reportJob.setSubmitTime(rs.getTimestamp(RJ.SUBMIT_TIME))
    reportJob.setStartTime(rs.getTimestamp(RJ.START_TIME))
    reportJob.setEndTime(rs.getTimestamp(RJ.END_TIME))
    reportJob.setUsername(rs.getString(RJ.USERNAME))
    reportJob.setResultUri(rs.getString(RJ.RESULT_URI))
    val reportDefinition = using(rs.getBinaryStream(RJ.REPORT_DEFINITION)) { is =>
      Try(copyToString(is, StandardCharsets.UTF_8)) match {
        case Success(json) => CiSerializerHelper.deserialize(json, sqlRepositoryAdapter).asInstanceOf[ReportDefinition]
        case Failure(ex) => throw new IllegalStateException("Failed to load report parameters", ex)
      }
    }
    reportJob.setReportDefinition(reportDefinition)
    reportJob
  }
}
