package com.xebialabs.xlrelease.reports.job.impl.filesystem

import com.xebialabs.xlrelease.reports.job.api.{AbstractStreamingReportResult, ReportResult}

import java.io.InputStream
import java.net.URI

private[filesystem] class FileSystemStreamingReportResult(contextUri: URI, reportResult: ReportResult)
  extends AbstractStreamingReportResult(reportResult) {

  override protected lazy val resolvedUri: URI = {
    val unresolvedUri = new URI(reportResult.resultUri)
    if (unresolvedUri.isAbsolute) {
      unresolvedUri
    } else {
      contextUri.resolve(unresolvedUri)
    }
  }

  override protected def inputStream(): InputStream = resolvedUri.toURL.openStream()
}
