package com.xebialabs.xlrelease.reports.domain

import com.xebialabs.xlrelease.domain.Trigger

import scala.util.Try

sealed trait ReleaseStartedBy

case class UserThatCreatedOrStartedRelease(username: String, fullName: Option[String])

case class StartedByUser(startedBy: Option[UserThatCreatedOrStartedRelease], createdBy: Option[UserThatCreatedOrStartedRelease]) extends ReleaseStartedBy
case class StartedByTrigger(trigger: Try[Trigger], triggerTag: Option[String]) extends ReleaseStartedBy
case class StartedByCreateReleaseTask(masterReleaseTitle: Try[String], masterReleaseId: String) extends ReleaseStartedBy

//case object StartedByScheduledStartDate extends ReleaseStartedBy