package com.xebialabs.xlrelease.reports.dto;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.joda.time.DateTime;

public class ReleaseAutomationComputer {
    private List<ReleaseAutomationData> releasesAutomationData;
    private ReleasesAutomation releasesAutomation;

    public ReleaseAutomationComputer(List<ReleaseAutomationData> releasesAutomationData, ReleaseEfficiency releaseEfficiency) {
        this.releasesAutomation = new ReleasesAutomation();
        this.releasesAutomation.setReleaseEfficiency(releaseEfficiency);
        this.releasesAutomationData = releasesAutomationData;
    }

    public ReleasesAutomation get() {
        if (releasesAutomationData.size() > 0) {
            Collections.sort(releasesAutomationData, new Comparator<ReleaseAutomationData>() {
                @Override
                public int compare(final ReleaseAutomationData o1, final ReleaseAutomationData o2) {
                    return o1.getEndDate().compareTo(o2.getEndDate());
                }
            });
            DateTime startDate = releasesAutomationData.get(0).getEndDate();
            AverageByMonthComputer averageAutomationComputer = new AverageByMonthComputer(startDate);
            for (ReleaseAutomationData releaseAutomationData : releasesAutomationData) {
                float automationPercentage = computePercentage(
                        releaseAutomationData.getNumberOfAutomatedTasks(), releaseAutomationData.getNumberOfTasks());

                averageAutomationComputer.add(releaseAutomationData.getEndDate(), automationPercentage);
            }
            DateTime endDate = releasesAutomationData.get(releasesAutomationData.size() - 1).getEndDate();
            releasesAutomation.setAverageAutomationPercentage(averageAutomationComputer.completeSerie(endDate));
        }

        return releasesAutomation;
    }

    private float computePercentage(float number, float total) {
        return number / total * 100;
    }
}
