package com.xebialabs.xlrelease.reports.job.impl

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.reports.job.impl.ReportExecutorService._
import com.xebialabs.xlrelease.scheduler.{RestartableExecutorService, XlrExecutors}
import grizzled.slf4j.Logging
import io.micrometer.core.instrument.MeterRegistry

import java.util.concurrent.{Callable, Future}
import scala.concurrent.{ExecutionContext, ExecutionContextExecutorService}

class ReportExecutorService(xlrConfig: XlrConfig, meterRegistry: MeterRegistry) extends Logging {

  private lazy val maxThreadCount: Int = xlrConfig.reporting.engine.maxThreadsCount
  private lazy val shutdownTimeout: Int = xlrConfig.reporting.engine.shutdownTimeout

  val executorService: RestartableExecutorService = XlrExecutors
    .newFixedThreadPool(REPORT_EXECUTOR, maxThreadCount, meterRegistry, shutdownTimeout)

  lazy val executionContext: ExecutionContextExecutorService = ExecutionContext.fromExecutorService(executorService)

  def submit[T](task: Callable[T]): Future[T] = executorService.submit(task)

  def shutdown(): Unit = executorService.shutdown()
}

object ReportExecutorService {
  final val REPORT_EXECUTOR = "report-executor"
}
