package com.xebialabs.xlrelease.reports.job.impl

import com.xebialabs.xlrelease.domain.management.{CompositeServiceStatus, ServiceStatus, SimpleServiceStatus}
import com.xebialabs.xlrelease.reports.job.impl.ReportExecutorService.REPORT_EXECUTOR
import com.xebialabs.xlrelease.service.{XlrServiceLifecycle, XlrServiceLifecycleOrder}

class ReportsLifecycleManager(reportExecutor: ReportExecutorService) extends XlrServiceLifecycle {
  override def getOrder: Int = XlrServiceLifecycleOrder.REPORTS

  override def doStop(): Unit = reportExecutor.executorService.disable()

  override def doStart(): Unit = {
    reportExecutor.executorService.enable()
  }

  override def serviceStatus(): ServiceStatus = {
    val executorStatus = SimpleServiceStatus(REPORT_EXECUTOR, reportExecutor.executorService.state)
    CompositeServiceStatus(serviceName(), state, List(executorStatus))
  }
}
