package com.xebialabs.xlrelease.reports.dto;

import org.joda.time.DateTime;

public class ReleaseAutomationData {

    private String releaseId;
    private String title;
    private DateTime endDate;
    private int numberOfTasks;
    private int numberOfAutomatedTasks;
    private long totalDuration;
    private long automatedDuration;

    public ReleaseAutomationData(String releaseId, String title, DateTime endDate,
                                 int numberOfTasks, int numberOfAutomatedTasks,
                                 long totalDuration, long automatedDuration) {
        this.releaseId = releaseId;
        this.title = title;
        this.endDate = endDate;
        this.numberOfTasks = numberOfTasks;
        this.numberOfAutomatedTasks = numberOfAutomatedTasks;
        this.totalDuration = totalDuration;
        this.automatedDuration = automatedDuration;
    }

    public String getTitle() {
        return title;
    }

    public DateTime getEndDate() {
        return endDate;
    }

    public String getReleaseId() {
        return releaseId;
    }

    public int getNumberOfAutomatedTasks() {
        return numberOfAutomatedTasks;
    }

    public int getNumberOfTasks() {
        return numberOfTasks;
    }

    public long getTotalDuration() {
        return totalDuration;
    }

    public long getAutomatedDuration() {
        return automatedDuration;
    }

    public void setNumberOfTasks(final int numberOfTasks) {
        this.numberOfTasks = numberOfTasks;
    }

    public void setNumberOfAutomatedTasks(final int numberOfAutomatedTasks) {
        this.numberOfAutomatedTasks = numberOfAutomatedTasks;
    }

    public void setTotalDuration(final long totalDuration) {
        this.totalDuration = totalDuration;
    }

    public void setAutomatedDuration(final long automatedDuration) {
        this.automatedDuration = automatedDuration;
    }
}
