package com.xebialabs.xlrelease.reports.repository

import com.xebialabs.xlrelease.domain.udm.reporting.PlanRecord
import com.xebialabs.xlrelease.reports.repository.CommonRowAndParamsMapper._
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.TaskRecordTable
import com.xebialabs.xlrelease.repository.sql.persistence.Utils.{RichStringAsTruncatable, params}
import com.xebialabs.xlrelease.repository.sql.persistence.{Table, TaskCiUid}
import java.sql.ResultSet
import java.util.Date

package object plan {

  class PlanTaskReportingRecordTable(tableName: String) extends Table(tableName)
    with TaskRecordTable {
    val TICKET = "TICKET"
    val TITLE = "TITLE"
    val TICKET_TYPE = "TICKET_TYPE"
    val STATUS = "STATUS"
    val UPDATED_DATE = "UPDATED_DATE"
    val UPDATED_BY = "UPDATED_BY"
    val TICKET_URL = "TICKET_URL"
  }

  case object PLAN_TASK_REPORTING_RECORD_LIVE extends PlanTaskReportingRecordTable("XLR_TASK_RECORD_PLAN")

  case object PLAN_TASK_REPORTING_RECORD_ARCHIVE extends PlanTaskReportingRecordTable("TASK_RECORD_PLAN")

  private[plan] def asQueryParameters(record: PlanRecord, taskUid: TaskCiUid): Map[String, Any] = {
    mapCommonParams(record, taskUid) ++ params(
      "ticket" -> record.getTicket.truncate(SHORT_VARCHAR),
      "title" -> record.getTitle.truncate(SHORT_VARCHAR),
      "ticketType" -> record.getTicketType.truncate(SHORT_VARCHAR),
      "status" -> record.getStatus.truncate(SHORT_VARCHAR),
      "updatedDate" -> record.getUpdatedDate,
      "updatedBy" -> record.getUpdatedBy.truncate(SHORT_VARCHAR),
      "ticketUrl" -> record.getTicket_url.truncate(URL_VARCHAR)
    )
  }

  private[plan] def planItemRowMapper(rs: ResultSet, planRecord: PlanRecord, targetId: String, planItemTable: PlanTaskReportingRecordTable): PlanRecord = {
    mapCommonFields(rs, planRecord, targetId, planItemTable)
    planRecord.setStatus(rs.getString(planItemTable.STATUS))
    planRecord.setTicket(rs.getString(planItemTable.TICKET))
    planRecord.setTicket_url(rs.getString(planItemTable.TICKET_URL))
    planRecord.setTicketType(rs.getString(planItemTable.TICKET_TYPE))
    planRecord.setTitle(rs.getString(planItemTable.TITLE))
    planRecord.setUpdatedBy(rs.getString(planItemTable.UPDATED_BY))
    Option(rs.getTimestamp(planItemTable.UPDATED_DATE)).foreach(ts => planRecord.setUpdatedDate(Date.from(ts.toInstant)))
    planRecord
  }

}
