package com.xebialabs.xlrelease.reports.db

import com.xebialabs.deployit.security.{PermissionEnforcer, RoleService}
import com.xebialabs.xlrelease.db.ArchivedReleases._
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.db.sql.archiving.SelectArchivedPhasesBuilder
import com.xebialabs.xlrelease.domain.status.PhaseStatus.COMPLETED
import com.xebialabs.xlrelease.reports.dto.PhaseDuration
import com.xebialabs.xlrelease.reports.service.{ReportParams, ReportService}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Repository

import java.sql.ResultSet
import java.util.{List => JList}

@Repository
class ArchivedPhasesReports @Autowired()(@Qualifier("reportingJdbcTemplate") jdbcTemplate: JdbcTemplate,
                                         @Qualifier("reportingSqlDialect") implicit val reportingSqlDialect: Dialect,
                                         implicit val permissionEnforcer: PermissionEnforcer,
                                         implicit val roleService: RoleService) extends Logging {

  def getTopLongestPhases(reportParams: ReportParams): JList[PhaseDuration] = {

    val sqlQuery: SelectArchivedPhasesBuilder = new SelectArchivedPhasesBuilder()
      .withOneOfStatuses(COMPLETED.value())
      .withDates(reportParams.timeFrame, reportParams.from, reportParams.to)
      .withTags(reportParams.tags)
      .withSecurity(reportParams.userSpecific)
      .withNotNull(REPORT_PHASES_DURATION_COLUMN)
      .withFilters(reportParams.filters)
      .orderBy(s"$REPORT_PHASES_TABLE_ALIAS.$REPORT_PHASES_DURATION_COLUMN DESC")
      .innerJoin(REPORT_RELEASES_TABLE_NAME, REPORT_RELEASES_TABLE_ALIAS, REPORT_PHASES_RELEASEID_COLUMN, COMMON_RELEASEID_COLUMN)
      .limit(ReportService.TOP_REPORT_SIZE)

    val (sql, params) = sqlQuery.build()
    jdbcTemplate.query(sql, (rs: ResultSet, _: Int) =>
      new PhaseDuration(
        rs.getString(REPORT_PHASES_TITLE_COLUMN),
        rs.getString(REPORT_PHASES_RELEASE_TITLE_COLUMN),
        rs.getLong(REPORT_PHASES_DURATION_COLUMN),
        rs.getString(REPORT_PHASES_RELEASEID_COLUMN)
      ), params: _*)
  }
}
